/*
 * Decompiled with CFR 0.152.
 */
package saccubus.net;

import java.util.Arrays;
import saccubus.net.Path;

public class BrowserInfo {
    private BrowserCookieKind validBrowser = BrowserCookieKind.NONE;
    private static final String NICOVIDEO_URL = "http://www.nicovideo.jp";

    public String getBrowserName() {
        if (this.validBrowser == BrowserCookieKind.NONE) {
            return "\u3055\u304d\u3085\u3070\u3059";
        }
        if (this.validBrowser == BrowserCookieKind.MSIE) {
            return "Internet Exploror";
        }
        return this.validBrowser.toString();
    }

    public String getUserSession(BrowserCookieKind browserKind) {
        String user_session = "";
        switch (browserKind) {
            case IE6: {
                user_session = this.getUserSessionFromIE6(NICOVIDEO_URL);
                break;
            }
            case MSIE: {
                user_session = this.getUserSessionFromMSIE();
                break;
            }
            case Firefox: {
                user_session = this.getUserSessionFromFilefox4();
                if (!user_session.isEmpty()) break;
            }
            case Firefox3: {
                user_session = this.getUserSessionFromFilefox3();
                break;
            }
            case Chrome: {
                user_session = this.getUserSesionChrome();
                break;
            }
            case Chromium: {
                user_session = this.getUserSesionChromium();
                break;
            }
            case Opera: {
                user_session = this.getUserSessionOpera();
            }
        }
        if (!user_session.isEmpty()) {
            this.validBrowser = browserKind;
        }
        return user_session;
    }

    public String getUserSessionOther(String fileOrDir) {
        String user_session = "";
        try {
            if (Path.isDirectory(fileOrDir)) {
                String string = user_session = this.getUserSessionFromDirectory(fileOrDir);
                return string;
            }
            if (Path.isFile(fileOrDir)) {
                String dataStr = Path.readAllText(fileOrDir, "UTF-8");
                String string = user_session = this.cutUserSession(dataStr, fileOrDir);
                return string;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        finally {
            if (!user_session.isEmpty()) {
                this.validBrowser = BrowserCookieKind.Other;
            }
        }
    }

    private String getUserSessionFromFilefox3() {
        String sqlist_filename;
        String user_session;
        block5: {
            String app_dir;
            block4: {
                user_session = "";
                try {
                    app_dir = System.getenv("APPDATA");
                    if (app_dir != null && !app_dir.isEmpty()) break block4;
                    return "";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return user_session;
                }
            }
            sqlist_filename = String.valueOf(app_dir) + "\\Mozilla\\Firefox\\Profiles\\cookies.sqlite";
            if (Path.isFile(sqlist_filename)) break block5;
            return "";
        }
        String dataStr = Path.readAllText(sqlist_filename, "US-ASCII");
        user_session = this.cutUserSession(dataStr, sqlist_filename);
        return user_session;
    }

    private String getUserSessionFromFilefox4() {
        String app_dir;
        String user_session;
        block5: {
            user_session = "";
            app_dir = System.getenv("APPDATA");
            if (app_dir != null && !app_dir.isEmpty()) break block5;
            return "";
        }
        try {
            String[] userLists;
            String[] stringArray = userLists = Path.getFiullnameList(String.valueOf(app_dir) + "\\Mozilla\\Firefox\\Profiles\\");
            int n = userLists.length;
            int n2 = 0;
            while (n2 < n) {
                String dataStr;
                String user_dir = stringArray[n2];
                String sqlist_filename = String.valueOf(user_dir) + "\\cookies.sqlite";
                if (Path.isFile(sqlist_filename) && !(user_session = this.cutUserSession(dataStr = Path.readAllText(sqlist_filename, "US-ASCII"), sqlist_filename)).isEmpty()) {
                    return user_session;
                }
                ++n2;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getUserSessionFromIE6(String url) {
        return this.cutUserSession(this.getCookieFromIE6(url), "");
    }

    private String getCookieFromIE6(String url) {
        int size = 4096;
        byte[] dummy = new byte[size];
        Arrays.fill(dummy, (byte)32);
        StringBuilder buff = new StringBuilder(new String(dummy));
        int[] ref_size = new int[]{size};
        return buff.toString().replace(';', ',');
    }

    private String getUserSessionFromMSIE() {
        String user_session = "";
        String profile_dir = System.getenv("USERPROFILE");
        if (profile_dir == null || profile_dir.isEmpty()) {
            return "";
        }
        String search_dir = String.valueOf(profile_dir) + "\\AppData\\Roaming\\Microsoft\\Windows\\Cookies\\Low\\";
        user_session = this.getUserSessionFromDirectory(search_dir);
        if (user_session.isEmpty()) {
            search_dir = String.valueOf(profile_dir) + "\\AppData\\Roaming\\Microsoft\\Windows\\Cookies\\";
            user_session = this.getUserSessionFromDirectory(search_dir);
        }
        if (user_session.isEmpty()) {
            search_dir = String.valueOf(profile_dir) + "\\Cookies\\";
            user_session = this.getUserSessionFromDirectory(search_dir);
        }
        return user_session;
    }

    private String getUserSessionFromDirectory(String dir_name) {
        String user_session = "";
        try {
            if (Path.isDirectory(dir_name)) {
                String[] files;
                String[] stringArray = files = Path.getFiullnameList(dir_name);
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String fullname = stringArray[n2];
                    user_session = this.cutUserSession(Path.readAllText(fullname, "MS932"), fullname);
                    if (!user_session.isEmpty()) {
                        return user_session;
                    }
                    ++n2;
                }
                return "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getUserSesionChrome() {
        String user_session = "";
        String cookie_file = "";
        String googleChrome = "\\Google\\Chrome\\User Data\\Default\\Cookies";
        try {
            String dataStr;
            String local_Appdir = System.getenv("LOCALAPPDATA");
            if (local_Appdir != null && !local_Appdir.isEmpty() && Path.isFile(cookie_file = String.valueOf(local_Appdir) + googleChrome) && !(user_session = this.cutUserSession(dataStr = Path.readAllText(cookie_file, "UTF-8"), cookie_file)).isEmpty()) {
                return user_session;
            }
            String profile_dir = System.getenv("USERPROFILE");
            if (profile_dir != null && !profile_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(profile_dir) + "\\Local Settings\\Application Data" + googleChrome)) {
                String dataStr2 = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr2, cookie_file);
                return user_session;
            }
            String app_dir = System.getenv("APPDATA");
            if (app_dir != null && !app_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(app_dir) + googleChrome)) {
                String dataStr3 = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr3, cookie_file);
                return user_session;
            }
            return user_session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return user_session;
        }
    }

    private String getUserSesionChromium() {
        String user_session = "";
        String cookie_file = "";
        String chromium = "\\Chromium\\User Data\\Default\\Cookies";
        try {
            String local_Appdir = System.getenv("LOCALAPPDATA");
            if (local_Appdir != null && !local_Appdir.isEmpty() && Path.isFile(cookie_file = String.valueOf(local_Appdir) + chromium)) {
                String dataStr = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr, cookie_file);
                return user_session;
            }
            String profile_dir = System.getenv("USERPROFILE");
            if (profile_dir != null && !profile_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(profile_dir) + "\\Local Settings\\Application Data" + chromium)) {
                String dataStr = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr, cookie_file);
                return user_session;
            }
            return user_session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return user_session;
        }
    }

    private String getUserSessionOpera() {
        String user_session = "";
        String cookie_file = "";
        try {
            String app_dir = System.getenv("APPDATA");
            if (app_dir != null && !app_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(app_dir) + "\\Opera\\Opera\\cookies4.dat")) {
                String dataStr = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr, cookie_file);
                return user_session;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String cutUserSession(String str, String filename) {
        String ret = "";
        int start = str.indexOf("user_session_");
        if (start >= 0) {
            int index = start + "user_session_".length();
            while (index < str.length() && ('0' <= str.charAt(index) && str.charAt(index) <= '9' || str.charAt(index) == '_')) {
                ++index;
            }
            ret = str.substring(start, index);
            if (!ret.isEmpty() && !filename.isEmpty()) {
                System.out.println("Cookie found: " + filename);
                return ret;
            }
        }
        return "";
    }

    public static enum BrowserCookieKind {
        NONE,
        MSIE,
        IE6,
        Firefox3,
        Firefox,
        Chrome,
        Opera,
        Chromium,
        Other;

    }
}

