/*
 * Copyright (c) 2007 Mockito contributors
 * This program is made available under the terms of the MIT License.
 */
package org.mockito.internal.stubbing;

import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.DeprecatedOngoingStubbing;
import org.mockito.stubbing.OngoingStubbing;

public abstract class BaseStubbing<T> implements OngoingStubbing<T>, DeprecatedOngoingStubbing<T> {
    public OngoingStubbing<T> thenReturn(T value) {
        return thenAnswer(new Returns(value));
    }

    public OngoingStubbing<T> thenReturn(byte value) {
        return thenAnswer(new Returns(value));
    }

    public OngoingStubbing<T> thenReturn(short value) {
        return thenAnswer(new Returns(value));
    }

    public OngoingStubbing<T> thenReturn(int value) {
        return thenAnswer(new Returns(value));
    }

    public OngoingStubbing<T> thenReturn(long value) {
        return thenAnswer(new Returns(value));
    }

    public OngoingStubbing<T> thenReturn(float value) {
        return thenAnswer(new Returns(value));
    }

    public OngoingStubbing<T> thenReturn(double value) {
        return thenAnswer(new Returns(value));
    }

    public OngoingStubbing<T> thenReturn(char value) {
        return thenAnswer(new Returns(value));
    }

    public OngoingStubbing<T> thenReturn(boolean value) {
        return thenAnswer(new Returns(value));
    }

    public OngoingStubbing<T> thenReturn(T value, T... values) {
    	return thenReturnImpl(value, values);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1) {
    	return thenReturnImpl(value0, value1);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2) {
    	return thenReturnImpl(value0, value1, value2);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3) {
    	return thenReturnImpl(value0, value1, value2, value3);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4) {
    	return thenReturnImpl(value0, value1, value2, value3, value4);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6, T value7) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6, T value7, T value8) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6, T value7, T value8, T value9) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6, T value7, T value8, T value9,
    		T value10) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value10);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6, T value7, T value8, T value9,
    		T value10, T value11) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6, T value7, T value8, T value9,
    		T value10, T value11, T value12) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6, T value7, T value8, T value9,
    		T value10, T value11, T value12, T value13) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6, T value7, T value8, T value9,
    		T value10, T value11, T value12, T value13, T value14) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14);
    }

    public OngoingStubbing<T> thenReturn(T value0, T value1, T value2, T value3, T value4, T value5, T value6, T value7, T value8, T value9,
    		T value10, T value11, T value12, T value13, T value14, T value15) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14, value15);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1) {
    	return thenReturnImpl(value0, value1);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2) {
    	return thenReturnImpl(value0, value1, value2);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3) {
    	return thenReturnImpl(value0, value1, value2, value3);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4) {
    	return thenReturnImpl(value0, value1, value2, value3, value4);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6, byte value7) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6, byte value7, byte value8) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6, byte value7, byte value8, byte value9) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6, byte value7, byte value8, byte value9,
    		byte value10) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value10);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6, byte value7, byte value8, byte value9,
    		byte value10, byte value11) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6, byte value7, byte value8, byte value9,
    		byte value10, byte value11, byte value12) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6, byte value7, byte value8, byte value9,
    		byte value10, byte value11, byte value12, byte value13) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6, byte value7, byte value8, byte value9,
    		byte value10, byte value11, byte value12, byte value13, byte value14) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14);
    }

    public OngoingStubbing<T> thenReturn(byte value0, byte value1, byte value2, byte value3, byte value4, byte value5, byte value6, byte value7, byte value8, byte value9,
    		byte value10, byte value11, byte value12, byte value13, byte value14, byte value15) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14, value15);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1) {
    	return thenReturnImpl(value0, value1);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2) {
    	return thenReturnImpl(value0, value1, value2);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3) {
    	return thenReturnImpl(value0, value1, value2, value3);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4) {
    	return thenReturnImpl(value0, value1, value2, value3, value4);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6, short value7) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6, short value7, short value8) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6, short value7, short value8, short value9) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6, short value7, short value8, short value9,
    		short value10) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value10);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6, short value7, short value8, short value9,
    		short value10, short value11) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6, short value7, short value8, short value9,
    		short value10, short value11, short value12) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6, short value7, short value8, short value9,
    		short value10, short value11, short value12, short value13) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6, short value7, short value8, short value9,
    		short value10, short value11, short value12, short value13, short value14) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14);
    }

    public OngoingStubbing<T> thenReturn(short value0, short value1, short value2, short value3, short value4, short value5, short value6, short value7, short value8, short value9,
    		short value10, short value11, short value12, short value13, short value14, short value15) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14, value15);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1) {
    	return thenReturnImpl(value0, value1);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2) {
    	return thenReturnImpl(value0, value1, value2);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3) {
    	return thenReturnImpl(value0, value1, value2, value3);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4) {
    	return thenReturnImpl(value0, value1, value2, value3, value4);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6, int value7) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9,
    		int value10) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value10);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9,
    		int value10, int value11) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9,
    		int value10, int value11, int value12) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9,
    		int value10, int value11, int value12, int value13) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9,
    		int value10, int value11, int value12, int value13, int value14) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14);
    }

    public OngoingStubbing<T> thenReturn(int value0, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9,
    		int value10, int value11, int value12, int value13, int value14, int value15) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14, value15);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1) {
    	return thenReturnImpl(value0, value1);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2) {
    	return thenReturnImpl(value0, value1, value2);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3) {
    	return thenReturnImpl(value0, value1, value2, value3);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4) {
    	return thenReturnImpl(value0, value1, value2, value3, value4);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8, long value9) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8, long value9,
    		long value10) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value10);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8, long value9,
    		long value10, long value11) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8, long value9,
    		long value10, long value11, long value12) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8, long value9,
    		long value10, long value11, long value12, long value13) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8, long value9,
    		long value10, long value11, long value12, long value13, long value14) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14);
    }

    public OngoingStubbing<T> thenReturn(long value0, long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8, long value9,
    		long value10, long value11, long value12, long value13, long value14, long value15) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14, value15);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1) {
    	return thenReturnImpl(value0, value1);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2) {
    	return thenReturnImpl(value0, value1, value2);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3) {
    	return thenReturnImpl(value0, value1, value2, value3);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4) {
    	return thenReturnImpl(value0, value1, value2, value3, value4);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6, float value7) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6, float value7, float value8) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6, float value7, float value8, float value9) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6, float value7, float value8, float value9,
    		float value10) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value10);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6, float value7, float value8, float value9,
    		float value10, float value11) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6, float value7, float value8, float value9,
    		float value10, float value11, float value12) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6, float value7, float value8, float value9,
    		float value10, float value11, float value12, float value13) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6, float value7, float value8, float value9,
    		float value10, float value11, float value12, float value13, float value14) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14);
    }

    public OngoingStubbing<T> thenReturn(float value0, float value1, float value2, float value3, float value4, float value5, float value6, float value7, float value8, float value9,
    		float value10, float value11, float value12, float value13, float value14, float value15) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14, value15);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1) {
    	return thenReturnImpl(value0, value1);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2) {
    	return thenReturnImpl(value0, value1, value2);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3) {
    	return thenReturnImpl(value0, value1, value2, value3);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4) {
    	return thenReturnImpl(value0, value1, value2, value3, value4);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6, double value7) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8, double value9) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8, double value9,
    		double value10) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value10);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8, double value9,
    		double value10, double value11) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8, double value9,
    		double value10, double value11, double value12) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8, double value9,
    		double value10, double value11, double value12, double value13) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8, double value9,
    		double value10, double value11, double value12, double value13, double value14) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14);
    }

    public OngoingStubbing<T> thenReturn(double value0, double value1, double value2, double value3, double value4, double value5, double value6, double value7, double value8, double value9,
    		double value10, double value11, double value12, double value13, double value14, double value15) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14, value15);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1) {
    	return thenReturnImpl(value0, value1);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2) {
    	return thenReturnImpl(value0, value1, value2);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3) {
    	return thenReturnImpl(value0, value1, value2, value3);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4) {
    	return thenReturnImpl(value0, value1, value2, value3, value4);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6, char value7) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6, char value7, char value8) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6, char value7, char value8, char value9) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6, char value7, char value8, char value9,
    		char value10) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value10);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6, char value7, char value8, char value9,
    		char value10, char value11) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6, char value7, char value8, char value9,
    		char value10, char value11, char value12) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6, char value7, char value8, char value9,
    		char value10, char value11, char value12, char value13) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6, char value7, char value8, char value9,
    		char value10, char value11, char value12, char value13, char value14) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14);
    }

    public OngoingStubbing<T> thenReturn(char value0, char value1, char value2, char value3, char value4, char value5, char value6, char value7, char value8, char value9,
    		char value10, char value11, char value12, char value13, char value14, char value15) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14, value15);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1) {
    	return thenReturnImpl(value0, value1);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2) {
    	return thenReturnImpl(value0, value1, value2);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3) {
    	return thenReturnImpl(value0, value1, value2, value3);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4) {
    	return thenReturnImpl(value0, value1, value2, value3, value4);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7, boolean value8) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7, boolean value8, boolean value9) {
    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7, boolean value8, boolean value9,
    		boolean value10) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value10);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7, boolean value8, boolean value9,
    		boolean value10, boolean value11) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7, boolean value8, boolean value9,
    		boolean value10, boolean value11, boolean value12) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7, boolean value8, boolean value9,
    		boolean value10, boolean value11, boolean value12, boolean value13) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7, boolean value8, boolean value9,
    		boolean value10, boolean value11, boolean value12, boolean value13, boolean value14) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14);
    }

    public OngoingStubbing<T> thenReturn(boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7, boolean value8, boolean value9,
    		boolean value10, boolean value11, boolean value12, boolean value13, boolean value14, boolean value15) {
    	    	return thenReturnImpl(value0, value1, value2, value3, value4, value5, value6, value7, value8, value9,
    	    			value11, value12, value13, value14, value15);
    }

    private OngoingStubbing<T> thenReturnImpl(Object value, Object... values) {
        OngoingStubbing stubbing = thenAnswer(new Returns(value));
        if (values == null) {
            return stubbing.thenReturn(null);
        }
        for (Object v: values) {
            stubbing = stubbing.thenReturn(v);
        }
        return stubbing;
    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0) {
        return thenAnswer(new ThrowsException(throwable0));
    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1) {
    	return thenThrowImpl(throwable0, throwable1);
    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2) {
    	return thenThrowImpl(throwable0, throwable1, throwable2);
    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3) {
    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3);
    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4) {
    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4);
    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6, Throwable throwable7) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6, throwable7);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6, Throwable throwable7, Throwable throwable8) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6, throwable7, throwable8);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6, Throwable throwable7, Throwable throwable8, Throwable throwable9) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6, throwable7, throwable8, throwable9);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6, Throwable throwable7, Throwable throwable8, Throwable throwable9,
    		Throwable throwable10) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6, throwable7, throwable8, throwable9,
    	    			throwable10);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6, Throwable throwable7, Throwable throwable8, Throwable throwable9,
    		Throwable throwable10, Throwable throwable11) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6, throwable7, throwable8, throwable9,
    	    			throwable10, throwable11);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6, Throwable throwable7, Throwable throwable8, Throwable throwable9,
    		Throwable throwable10, Throwable throwable11, Throwable throwable12) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6, throwable7, throwable8, throwable9,
    	    			throwable10, throwable11, throwable12);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6, Throwable throwable7, Throwable throwable8, Throwable throwable9,
    		Throwable throwable10, Throwable throwable11, Throwable throwable12, Throwable throwable13) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6, throwable7, throwable8, throwable9,
    	    			throwable10, throwable11, throwable12, throwable13);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6, Throwable throwable7, Throwable throwable8, Throwable throwable9,
    		Throwable throwable10, Throwable throwable11, Throwable throwable12, Throwable throwable13, Throwable throwable14) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6, throwable7, throwable8, throwable9,
    	    			throwable10, throwable11, throwable12, throwable13, throwable14);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable throwable0, Throwable throwable1, Throwable throwable2, Throwable throwable3, Throwable throwable4,
    		Throwable throwable5, Throwable throwable6, Throwable throwable7, Throwable throwable8, Throwable throwable9,
    		Throwable throwable10, Throwable throwable11, Throwable throwable12, Throwable throwable13, Throwable throwable14, Throwable throwable15) {
    	    	return thenThrowImpl(throwable0, throwable1, throwable2, throwable3, throwable4,
    	    			throwable5, throwable6, throwable7, throwable8, throwable9,
    	    			throwable10, throwable11, throwable12, throwable13, throwable14, throwable15);
    	    }

    public OngoingStubbing<T> thenThrow(Throwable... throwables) {
        return thenThrowImpl(throwables);
    }

    private OngoingStubbing<T> thenThrowImpl(Throwable... throwables) {
        if (throwables == null) {
            return thenThrow((Throwable) null);
        }
        OngoingStubbing<T> stubbing = null;
        for (Throwable t: throwables) {
            if (stubbing == null) {
                stubbing = thenThrow(t);
            } else {
                stubbing = stubbing.thenThrow(t);
            }
        }
        return stubbing;
    }

    public OngoingStubbing<T> thenCallRealMethod() {
        return thenAnswer(new CallsRealMethods());
    }

    public DeprecatedOngoingStubbing<T> toReturn(T value) {
        return toAnswer(new Returns(value));
    }

    public DeprecatedOngoingStubbing<T> toThrow(Throwable throwable) {
        return toAnswer(new ThrowsException(throwable));
    }
}