/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.keys;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Random;
import java.util.TimeZone;
import org.codehaus.plexus.digest.Hex;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.keys.KeyManager;
import org.codehaus.plexus.redback.keys.KeyManagerException;
import org.codehaus.plexus.redback.keys.KeyNotFoundException;

public abstract class AbstractKeyManager
extends AbstractLogEnabled
implements KeyManager {
    private static final int KEY_LENGTH = 16;
    private static final boolean SECURE = true;
    private boolean randomMode = true;
    private SecureRandom secureRandom;
    private Random random;

    protected String generateUUID() throws KeyManagerException {
        byte[] vfour = new byte[16];
        if (this.randomMode) {
            if (this.secureRandom == null) {
                try {
                    this.secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
                }
                catch (NoSuchAlgorithmException e) {
                    this.randomMode = false;
                    this.getLogger().warn("Unable to use SecureRandom", (Throwable)e);
                }
                catch (NoSuchProviderException e) {
                    this.randomMode = false;
                    this.getLogger().warn("Unable to use SecureRandom", (Throwable)e);
                }
            }
            if (this.randomMode) {
                this.secureRandom.nextBytes(vfour);
            }
        }
        if (!this.randomMode) {
            if (this.random == null) {
                this.random = new Random();
            }
            this.random.nextBytes(vfour);
        }
        vfour[6] = (byte)(vfour[6] & 0xF);
        vfour[6] = (byte)(vfour[6] | 0x40);
        vfour[8] = (byte)(vfour[8] & 0x3F);
        vfour[8] = (byte)(vfour[8] | 0x80);
        return Hex.encode((byte[])vfour);
    }

    protected void assertNotExpired(AuthenticationKey authkey) throws KeyNotFoundException, KeyManagerException {
        if (authkey.getDateExpires() == null) {
            return;
        }
        Calendar now = this.getNowGMT();
        Calendar expiration = this.getNowGMT();
        expiration.setTime(authkey.getDateExpires());
        if (now.after(expiration)) {
            this.deleteKey(authkey);
            throw new KeyNotFoundException("Key [" + authkey.getKey() + "] has expired.");
        }
    }

    protected Calendar getNowGMT() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }
}

