package org.apache.maven.archiva.dependency.graph;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.Dependency;
import org.apache.maven.archiva.model.VersionedReference;

/**
 * ArchivaWebappMemoryRepository
 * 
 * MemoryRepository for testing <code>org.apache.maven.archiva:archiva-webapp:1.0-alpha-2-SNAPSHOT</code>
 *
 * Generated by <code>archivadev:generate-dependency-tests</code> plugin
 * @version $Id: ArchivaWebappMemoryRepository.java 547277 2007-06-14 15:25:42Z joakime $
 */
public class ArchivaWebappMemoryRepository
   extends AbstractMemoryRepository
{
   public void initialize()
   {
      ArchivaProjectModel model;
      Dependency dep;

      model = toModel( "org.apache.maven.archiva:archiva-webapp:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-web:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-report-manager:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-scheduled:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-indexer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-proxy:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-database:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-security:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-core-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-database-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-lucene-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-signature-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-applet:1.0-alpha-2-SNAPSHOT::jar", "provided" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      model.addDependency( toDependency( "javax.servlet:jsp-api:2.0::jar", "provided" ) );
      model.addDependency( toDependency( "opensymphony:sitemesh:2.2.1::jar" ) );
      model.addDependency( toDependency( "taglibs:standard:1.1.2::jar" ) );
      model.addDependency( toDependency( "javax.servlet:jstl:1.1.2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.shared:maven-app-configuration-model:1.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.shared:maven-app-configuration-web:1.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-slf4j-logging:1.1-alpha-1::jar", "runtime" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-log4j12:1.2::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar", "runtime" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2::jar", "runtime" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-beta-2::jar", "runtime" ) );
      model.addDependency( toDependency( "opensymphony:webwork:2.2.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.cache:plexus-cache-api:1.0-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.cache:plexus-cache-ehcache:1.0-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-xwork-content:1.0-alpha-1::war", "runtime" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-xwork-integration:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-taglib:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.webdav:plexus-webdav-simple:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-xwork-integration:1.0-alpha-6::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.apache.derby:derby:10.1.3.1::jar", "provided" ) );
      model.addDependency( toDependency( "javax.mail:mail:1.4::jar", "provided" ) );
      model.addDependency( toDependency( "javax.activation:activation:1.1::jar", "provided" ) );
      model.addDependencyManagement( toDependency( "javax.activation:activation:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-applet:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-artifact-converter:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-artifact-reports:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-common:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-converter:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-core:1.0-alpha-2-SNAPSHOT-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-core-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-database:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-database-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-indexer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-lucene-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-model:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-plexus-application:1.0-alpha-2-SNAPSHOT::plexus-application" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-policies:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-proxy:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-report-manager:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-scheduled:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-security:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-signature-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-transaction:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-webapp:1.0-alpha-2-SNAPSHOT::war" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-xml-tools:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "commons-collections:commons-collections:3.2::jar" ) );
      model.addDependencyManagement( toDependency( "commons-io:commons-io:1.2::jar" ) );
      model.addDependencyManagement( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependencyManagement( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      model.addDependencyManagement( toDependency( "commons-logging:commons-logging-api:1.0.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.derby:derby:10.1.3.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.derby:derbytools:10.1.3.1::jar" ) );
      model.addDependencyManagement( toDependency( "dom4j:dom4j:1.6.1::jar" ) );
      model.addDependencyManagement( toDependency( "easymock:easymock:1.2_Java1.3::jar" ) );
      model.addDependencyManagement( toDependency( "hsqldb:hsqldb:1.8.0.7::jar" ) );
      model.addDependencyManagement( toDependency( "jaxen:jaxen:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "javax.jdo:jdo2-api:2.0::jar" ) );
      model.addDependencyManagement( toDependency( "jdom:jdom:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "jpox:jpox:1.1.7::jar" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:jsp-api:2.0::jar" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:jstl:1.1.2::jar" ) );
      model.addDependencyManagement( toDependency( "log4j:log4j:1.2.8::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.lucene:lucene-core:2.0.0::jar" ) );
      model.addDependencyManagement( toDependency( "javax.mail:mail:1.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-artifact:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-artifact-manager:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-model:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-project:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-repository-metadata:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.shared:maven-app-configuration-model:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.shared:maven-app-configuration-web:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.shared:maven-model-converter:2.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-appserver-host:2.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-appserver-service-jetty:2.0-alpha-8::plexus-service" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-cli:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-command-line:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-digest:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-expression-evaluator:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-i18n:1.0-beta-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-jdo2:1.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-naming:1.0-alpha-3::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-quartz:1.0-alpha-3::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-slf4j-logging:1.1-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-taskqueue:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-xwork-integration:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.cache:plexus-cache-api:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.cache:plexus-cache-ehcache:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-memory:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-role-manager:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-taglib:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-xwork-content:1.0-alpha-1::war" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-xwork-integration:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.webdav:plexus-webdav-simple:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:servlet-api:2.4::jar" ) );
      model.addDependencyManagement( toDependency( "opensymphony:sitemesh:2.2.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.slf4j:slf4j-log4j12:1.2::jar" ) );
      model.addDependencyManagement( toDependency( "taglibs:standard:1.1.2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-file:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "opensymphony:webwork:2.2.4::jar" ) );
      model.addDependencyManagement( toDependency( "xmlunit:xmlunit:1.0::jar" ) );
      model.addProperty( "wagon.version", "1.0-beta-2" );
      model.addProperty( "redback.version", "1.0-alpha-1" );
      model.addProperty( "maven.version", "2.0.5" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-web:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-parent:1.0-alpha-2-SNAPSHOT" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-parent:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:5" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "javax.activation:activation:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-applet:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-artifact-converter:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-artifact-reports:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-common:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-converter:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-core:1.0-alpha-2-SNAPSHOT-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-core-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-database:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-database-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-indexer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-lucene-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-model:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-plexus-application:1.0-alpha-2-SNAPSHOT::plexus-application" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-policies:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-proxy:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-report-manager:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-scheduled:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-security:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-signature-consumers:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-transaction:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-webapp:1.0-alpha-2-SNAPSHOT::war" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.archiva:archiva-xml-tools:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "commons-collections:commons-collections:3.2::jar" ) );
      model.addDependencyManagement( toDependency( "commons-io:commons-io:1.2::jar" ) );
      model.addDependencyManagement( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependencyManagement( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      model.addDependencyManagement( toDependency( "commons-logging:commons-logging-api:1.0.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.derby:derby:10.1.3.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.derby:derbytools:10.1.3.1::jar" ) );
      model.addDependencyManagement( toDependency( "dom4j:dom4j:1.6.1::jar" ) );
      model.addDependencyManagement( toDependency( "easymock:easymock:1.2_Java1.3::jar" ) );
      model.addDependencyManagement( toDependency( "hsqldb:hsqldb:1.8.0.7::jar" ) );
      model.addDependencyManagement( toDependency( "jaxen:jaxen:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "javax.jdo:jdo2-api:2.0::jar" ) );
      model.addDependencyManagement( toDependency( "jdom:jdom:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "jpox:jpox:1.1.7::jar" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:jsp-api:2.0::jar" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:jstl:1.1.2::jar" ) );
      model.addDependencyManagement( toDependency( "log4j:log4j:1.2.8::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.lucene:lucene-core:2.0.0::jar" ) );
      model.addDependencyManagement( toDependency( "javax.mail:mail:1.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-artifact:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-artifact-manager:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-model:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-project:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-repository-metadata:2.0.5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.shared:maven-app-configuration-model:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.shared:maven-app-configuration-web:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.shared:maven-model-converter:2.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-appserver-host:2.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-appserver-service-jetty:2.0-alpha-8::plexus-service" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-cli:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-command-line:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-digest:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-expression-evaluator:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-i18n:1.0-beta-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-jdo2:1.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-naming:1.0-alpha-3::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-quartz:1.0-alpha-3::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-slf4j-logging:1.1-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-taskqueue:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-xwork-integration:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.cache:plexus-cache-api:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.cache:plexus-cache-ehcache:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-memory:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-role-manager:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-taglib:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-xwork-content:1.0-alpha-1::war" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-xwork-integration:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.webdav:plexus-webdav-simple:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:servlet-api:2.4::jar" ) );
      model.addDependencyManagement( toDependency( "opensymphony:sitemesh:2.2.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.slf4j:slf4j-log4j12:1.2::jar" ) );
      model.addDependencyManagement( toDependency( "taglibs:standard:1.1.2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-file:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "opensymphony:webwork:2.2.4::jar" ) );
      model.addDependencyManagement( toDependency( "xmlunit:xmlunit:1.0::jar" ) );
      model.addProperty( "wagon.version", "1.0-beta-2" );
      model.addProperty( "maven.version", "2.0.5" );
      model.addProperty( "redback.version", "1.0-alpha-1" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-parent:5" );
      model.setParentProject( toParent( "org.apache:apache:3" ) );
      addModel( model );

      model = toModel( "org.apache:apache:3" );
      addModel( model );

      model = toModel( "junit:junit:3.8.1" );
      addModel( model );

      model = toModel( "javax.activation:activation:1.1" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-applet:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-web:1.0-alpha-2-SNAPSHOT" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-artifact-converter:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-repository-metadata:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-transaction:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.shared:maven-model-converter:2.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-parent:1.0-alpha-2-SNAPSHOT" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-repository-metadata:2.0.5" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.5" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven:2.0.5" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:5" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-external:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-file:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      model.addDependencyManagement( toDependency( "classworlds:classworlds:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0.3" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0.3" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.4" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.4" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.0.4" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "classworlds:classworlds:1.1-alpha-2" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.4" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:4" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-parent:4" );
      model.setParentProject( toParent( "org.apache:apache:3" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-test:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-beta-2" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-common-test:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-beta-2::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:1.0-beta-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-7::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-7" );
      model.setParentProject( toParent( "plexus:plexus-containers:1.0.2" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "plexus:plexus-containers:1.0.2" );
      model.setParentProject( toParent( "plexus:plexus-root:1.0.3" ) );
      addModel( model );

      model = toModel( "plexus:plexus-root:1.0.3" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "plexus:plexus-utils:1.0.2" );
      model.setParentProject( toParent( "plexus:plexus-root:1.0.3" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "com.jcraft:jsch:0.1.27::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:1.0-beta-2::jar", "test" ) );
      addModel( model );

      model = toModel( "com.jcraft:jsch:0.1.27" );
      dep = toDependency( "com.jcraft:jzlib:1.0.7::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "com.jcraft:jzlib:1.0.7" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-external:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:1.0-beta-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-file:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-http-shared:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:1.0.b2::jar" ) );
      dep = toDependency( "plexus:plexus-jetty-httpd:1.0-beta-1::jar", "test" );
      addExclusion( dep, "plexus:plexus-container-default" );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-shared:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "jtidy:jtidy:4aug2000r7-dev::jar" ) );
      addModel( model );

      model = toModel( "jtidy:jtidy:4aug2000r7-dev" );
      addModel( model );

      model = toModel( "xml-apis:xml-apis:1.0.b2" );
      addModel( model );

      model = toModel( "plexus:plexus-jetty-httpd:1.0-beta-1" );
      model.setParentProject( toParent( "plexus:plexus-components:1.0" ) );
      model.addDependency( toDependency( "jetty:jetty:4.2.10::jar" ) );
      model.addDependency( toDependency( "servletapi:servletapi:2.3::jar" ) );
      addModel( model );

      model = toModel( "plexus:plexus-components:1.0" );
      model.setParentProject( toParent( "plexus:plexus-root:1.0" ) );
      model.addDependency( toDependency( "plexus:plexus-container-default:1.0-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "plexus:plexus-root:1.0" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "plexus:plexus-container-default:1.0-alpha-2" );
      addModel( model );

      model = toModel( "jetty:jetty:4.2.10" );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar", "runtime" ) );
      addModel( model );

      model = toModel( "javax.servlet:servlet-api:2.3" );
      addModel( model );

      model = toModel( "servletapi:servletapi:2.3" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "javax.servlet" );
      model.getRelocation().setArtifactId( "servlet-api" );
      model.getRelocation().setVersion( "2.3" );
      addModel( model );

      model = toModel( "easymock:easymock:1.2_Java1.3" );
      addModel( model );

      model = toModel( "classworlds:classworlds:1.1" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-manager:2.0.5" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.5" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-repository-metadata:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-beta-2::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact:2.0.5" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.5" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-transaction:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-digest:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-digest:1.1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.12" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4.1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.12" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.10" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-20::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-20::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.10" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-component-api:1.0-alpha-20" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-20" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0-alpha-20" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.10" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-19::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.9" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-component-api:1.0-alpha-19" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-19" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0-alpha-19" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.10" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-19::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.3" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.8" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.8" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-20" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-20" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-19::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar", "test" ) );
      addModel( model );

      model = toModel( "jmock:jmock:1.0.1" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.4.1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.11" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.11" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.4" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-22" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-19::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0-alpha-22" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.10" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-19::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-model-converter:2.1" );
      model.setParentProject( toParent( "org.apache.maven.shared:maven-shared-components:7" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model-v3:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      model.addDependency( toDependency( "dom4j:dom4j:1.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-shared-components:7" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:5" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-model-v3:2.0" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-model:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven:2.0.4" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-external:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-alpha-6" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon:1.0-alpha-6" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-6" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-7" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" ) );
      model.addDependency( toDependency( "com.jcraft:jsch:0.1.24::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-alpha-6" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-6::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "com.jcraft:jsch:0.1.24" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-external:1.0-alpha-6" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-file:1.0-alpha-7" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-6" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" ) );
      dep = toDependency( "plexus:plexus-jetty-httpd:1.0-beta-1::jar", "test" );
      addExclusion( dep, "plexus:plexus-container-default" );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "dom4j:dom4j:1.4" );
      model.addDependency( toDependency( "xml-apis:xml-apis:1.0.b2::jar" ) );
      model.addDependency( toDependency( "jaxen:jaxen:1.0-FCS::jar" ) );
      model.addDependency( toDependency( "saxpath:saxpath:1.0-FCS::jar" ) );
      model.addDependency( toDependency( "msv:msv:20020414::jar" ) );
      model.addDependency( toDependency( "relaxngDatatype:relaxngDatatype:20020414::jar" ) );
      model.addDependency( toDependency( "isorelax:isorelax:20020414::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "junitperf:junitperf:1.8::jar", "test" ) );
      model.addDependency( toDependency( "xerces:xerces:2.0.2::jar", "test" ) );
      model.addDependency( toDependency( "xalan:xalan:2.3.1::jar", "test" ) );
      model.addDependency( toDependency( "jtidy:jtidy:4aug2000r7-dev::jar", "test" ) );
      model.addDependency( toDependency( "pull-parser:pull-parser:2::jar", "test" ) );
      addModel( model );

      model = toModel( "jaxen:jaxen:1.0-FCS" );
      addModel( model );

      model = toModel( "saxpath:saxpath:1.0-FCS" );
      addModel( model );

      model = toModel( "msv:msv:20020414" );
      addModel( model );

      model = toModel( "relaxngDatatype:relaxngDatatype:20020414" );
      addModel( model );

      model = toModel( "isorelax:isorelax:20020414" );
      addModel( model );

      model = toModel( "junitperf:junitperf:1.8" );
      addModel( model );

      model = toModel( "xerces:xerces:2.0.2" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "xerces" );
      model.getRelocation().setArtifactId( "xercesImpl" );
      addModel( model );

      model = toModel( "xerces:xercesImpl:2.0.2" );
      addModel( model );

      model = toModel( "xalan:xalan:2.3.1" );
      addModel( model );

      model = toModel( "pull-parser:pull-parser:2" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-artifact-reports:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-reporting:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-report-manager:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-database:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.7::jar", "test" ) );
      model.addDependency( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-slf4j-logging:1.1-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-log4j12:1.2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-reporting:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-parent:1.0-alpha-2-SNAPSHOT" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-report-manager:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-reporting:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-database:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "commons-io:commons-io:1.2::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-database:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-parent:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-model:1.0-alpha-2-SNAPSHOT::jar" ) );
      dep = toDependency( "org.codehaus.plexus:plexus-jdo2:1.0-alpha-8::jar" );
      addExclusion( dep, "xerces:xercesImpl" );
      addExclusion( dep, "xerces:xmlParserAPIs" );
      model.addDependency( dep );
      dep = toDependency( "jpox:jpox:1.1.7::jar", "compile" );
      addExclusion( dep, "javax.sql:jdbc-stdext" );
      model.addDependency( dep );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "commons-io:commons-io:1.2::jar" ) );
      dep = toDependency( "commons-logging:commons-logging:1.0.4::jar" );
      addExclusion( dep, "logkit:logkit" );
      model.addDependency( dep );
      model.addDependency( toDependency( "log4j:log4j:1.2.8::jar" ) );
      model.addDependency( toDependency( "org.apache.derby:derby:10.1.3.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar", "test" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.7::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.derby:derbytools:10.1.3.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-consumers:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-model:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.2::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-consumers:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-model:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-common:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "javax.jdo:jdo2-api:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.2::jar" ) );
      model.addDependency( toDependency( "commons-io:commons-io:1.2::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-common:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      addModel( model );

      model = toModel( "commons-lang:commons-lang:2.2" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-22" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      addModel( model );

      model = toModel( "javax.jdo:jdo2-api:2.0" );
      model.addDependency( toDependency( "geronimo-spec:geronimo-spec-jta:1.0.1B-rc2::jar" ) );
      dep = toDependency( "xerces:xerces:2.4.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xml-apis:xml-apis:1.0.b2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "geronimo-spec:geronimo-spec-jta:1.0.1B-rc2" );
      addModel( model );

      model = toModel( "xerces:xerces:2.4.0" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "xerces" );
      model.getRelocation().setArtifactId( "xercesImpl" );
      addModel( model );

      model = toModel( "xerces:xercesImpl:2.4.0" );
      addModel( model );

      model = toModel( "commons-collections:commons-collections:3.2" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-io:commons-io:1.2" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-common:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-xml-tools:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-policies:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "commons-io:commons-io:1.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-xml-tools:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-common:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.2::jar" ) );
      dep = toDependency( "dom4j:dom4j:1.6.1::jar" );
      addExclusion( dep, "xom:xom" );
      model.addDependency( dep );
      dep = toDependency( "jaxen:jaxen:1.1::jar" );
      addExclusion( dep, "jdom:jdom" );
      addExclusion( dep, "xom:xom" );
      model.addDependency( dep );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-log4j12:1.2::jar" ) );
      addModel( model );

      model = toModel( "dom4j:dom4j:1.6.1" );
      dep = toDependency( "jaxme:jaxme-api:0.3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "jaxen:jaxen:1.1-beta-6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "msv:xsdlib:20030807::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "msv:relaxngDatatype:20030807::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "pull-parser:pull-parser:2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xpp3:xpp3:1.1.3.3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "stax:stax-api:1.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "xml-apis:xml-apis:1.0.b2::jar" ) );
      model.addDependency( toDependency( "junitperf:junitperf:1.8::jar", "test" ) );
      model.addDependency( toDependency( "stax:stax-ri:1.0::jar", "test" ) );
      model.addDependency( toDependency( "xerces:xercesImpl:2.6.2::jar", "test" ) );
      model.addDependency( toDependency( "xalan:xalan:2.5.1::jar", "test" ) );
      addModel( model );

      model = toModel( "jaxme:jaxme-api:0.3" );
      addModel( model );

      model = toModel( "jaxen:jaxen:1.1-beta-6" );
      addModel( model );

      model = toModel( "msv:xsdlib:20030807" );
      addModel( model );

      model = toModel( "msv:relaxngDatatype:20030807" );
      addModel( model );

      model = toModel( "xpp3:xpp3:1.1.3.3" );
      addModel( model );

      model = toModel( "stax:stax-api:1.0" );
      addModel( model );

      model = toModel( "stax:stax-ri:1.0" );
      addModel( model );

      model = toModel( "xerces:xercesImpl:2.6.2" );
      addModel( model );

      model = toModel( "xalan:xalan:2.5.1" );
      addModel( model );

      model = toModel( "jaxen:jaxen:1.1" );
      model.addDependency( toDependency( "dom4j:dom4j:1.6.1::jar" ) );
      model.addDependency( toDependency( "jdom:jdom:1.0::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:1.3.02::jar" ) );
      model.addDependency( toDependency( "xerces:xercesImpl:2.6.2::jar" ) );
      model.addDependency( toDependency( "xom:xom:1.0::jar" ) );
      addModel( model );

      model = toModel( "jdom:jdom:1.0" );
      dep = toDependency( "xerces:xercesImpl:2.6.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xml-apis:xml-apis:1.0.b2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "jaxen:jaxen:1.0-FCS::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "saxpath:saxpath:1.0-FCS::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xalan:xalan:2.5.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "xerces:xercesImpl:2.6.0" );
      addModel( model );

      model = toModel( "xalan:xalan:2.5.0" );
      addModel( model );

      model = toModel( "xml-apis:xml-apis:1.3.02" );
      addModel( model );

      model = toModel( "xom:xom:1.0" );
      model.addDependency( toDependency( "xerces:xmlParserAPIs:2.6.2::jar" ) );
      model.addDependency( toDependency( "xerces:xercesImpl:2.6.2::jar" ) );
      model.addDependency( toDependency( "xalan:xalan:2.6.0::jar" ) );
      model.addDependency( toDependency( "com.ibm.icu:icu4j:2.6.1::jar" ) );
      addModel( model );

      model = toModel( "xerces:xmlParserAPIs:2.6.2" );
      addModel( model );

      model = toModel( "xalan:xalan:2.6.0" );
      model.addDependency( toDependency( "xml-apis:xml-apis:2.0.2::jar" ) );
      dep = toDependency( "xerces:xercesImpl:2.6.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "xml-apis:xml-apis:2.0.2" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "xml-apis" );
      model.getRelocation().setArtifactId( "xml-apis" );
      model.getRelocation().setVersion( "1.0.b2" );
      addModel( model );

      model = toModel( "com.ibm.icu:icu4j:2.6.1" );
      addModel( model );

      model = toModel( "org.slf4j:slf4j-log4j12:1.2" );
      model.setParentProject( toParent( "org.slf4j:slf4j-parent:1.2" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-api:1.2::jar" ) );
      model.addDependency( toDependency( "log4j:log4j:1.2.13::jar" ) );
      addModel( model );

      model = toModel( "org.slf4j:slf4j-parent:1.2" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.slf4j:slf4j-api:1.2" );
      model.setParentProject( toParent( "org.slf4j:slf4j-parent:1.2" ) );
      addModel( model );

      model = toModel( "log4j:log4j:1.2.13" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-policies:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-common:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-digest:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.cache:plexus-cache-ehcache:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-slf4j-logging:1.1-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-log4j12:1.2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.cache:plexus-cache-ehcache:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus.cache:plexus-cache-providers-parent:1.0-alpha-2" ) );
      model.addDependency( toDependency( "net.sf.ehcache:ehcache:1.2.4::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.2::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.cache:plexus-cache-providers-parent:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus.cache:plexus-cache-parent:1.0-alpha-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.cache:plexus-cache-api:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.cache:plexus-cache-test:1.0-alpha-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.cache:plexus-cache-parent:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.9" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-16::jar" ) );
      model.addDependencyManagement( toDependency( "commons-lang:commons-lang:2.1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.9" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.10" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-16::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-16" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0-alpha-16" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-16" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-16" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-lang:commons-lang:2.1" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.cache:plexus-cache-api:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus.cache:plexus-cache-parent:1.0-alpha-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-16::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.cache:plexus-cache-test:1.0-alpha-2" );
      addModel( model );

      model = toModel( "net.sf.ehcache:ehcache:1.2.4" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar", "compile" ) );
      dep = toDependency( "org.hibernate:hibernate:3.2.0.cr3::jar", "test" );
      addExclusion( dep, "javax.transaction:jta" );
      addExclusion( dep, "javax.security:jacc" );
      model.addDependency( dep );
      dep = toDependency( "net.sf.hibernate:hibernate:2.1.8::jar", "test" );
      addExclusion( dep, "javax.transaction:jta" );
      addExclusion( dep, "javax.security:jacc" );
      model.addDependency( dep );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "test" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "httpunit:httpunit:1.6::jar", "test" ) );
      model.addDependency( toDependency( "commons-httpclient:commons-httpclient:3.0.1::jar", "test" ) );
      model.addDependency( toDependency( "com.cenqua.clover:clover:1.3.13::jar", "test" ) );
      model.addDependency( toDependency( "checkstyle:checkstyle:4.1::jar", "test" ) );
      model.addDependency( toDependency( "checkstyle:checkstyle-optional:4.1::jar", "test" ) );
      model.addDependency( toDependency( "commons-httpclient:commons-httpclient:3.0.1::jar", "test" ) );
      model.addDependency( toDependency( "httpunit:httpunit:1.6.1::jar", "test" ) );
      model.addDependency( toDependency( "httpunit:httpunit:1.6.1::jar", "test" ) );
      model.addProperty( "licenseFile", "${basedir}/tools/clover.license" );
      addModel( model );

      model = toModel( "commons-logging:commons-logging:1.0.4" );
      dep = toDependency( "log4j:log4j:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "logkit:logkit:1.0.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      dep = toDependency( "avalon-framework:avalon-framework:4.1.3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "log4j:log4j:1.2.6" );
      addModel( model );

      model = toModel( "logkit:logkit:1.0.1" );
      addModel( model );

      model = toModel( "junit:junit:3.7" );
      addModel( model );

      model = toModel( "avalon-framework:avalon-framework:4.1.3" );
      addModel( model );

      model = toModel( "org.hibernate:hibernate:3.2.0.cr3" );
      addModel( model );

      model = toModel( "net.sf.hibernate:hibernate:2.1.8" );
      addModel( model );

      model = toModel( "javax.servlet:servlet-api:2.4" );
      addModel( model );

      model = toModel( "httpunit:httpunit:1.6" );
      model.addDependency( toDependency( "xerces:xmlParserAPIs:2.2.1::jar" ) );
      model.addDependency( toDependency( "xerces:xercesImpl:2.6.2::jar" ) );
      model.addDependency( toDependency( "nekohtml:nekohtml:0.9.1::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependency( toDependency( "rhino:js:1.5R4.1::jar" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar" ) );
      model.addDependency( toDependency( "jtidy:jtidy:4aug2000r7-dev::jar" ) );
      model.addDependency( toDependency( "javax.activation:activation:1.0.2::jar", "test" ) );
      model.addDependency( toDependency( "javax.mail:mail:1.3.1::jar", "test" ) );
      addModel( model );

      model = toModel( "xerces:xmlParserAPIs:2.2.1" );
      addModel( model );

      model = toModel( "nekohtml:nekohtml:0.9.1" );
      model.addDependency( toDependency( "xerces:xerces:2.4.0::jar" ) );
      addModel( model );

      model = toModel( "rhino:js:1.5R4.1" );
      addModel( model );

      model = toModel( "javax.activation:activation:1.0.2" );
      addModel( model );

      model = toModel( "javax.mail:mail:1.3.1" );
      model.addDependency( toDependency( "javax.activation:activation:1.0.2::jar", "compile" ) );
      addModel( model );

      model = toModel( "commons-httpclient:commons-httpclient:3.0.1" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      model.addDependency( toDependency( "commons-codec:commons-codec:1.2::jar" ) );
      addModel( model );

      model = toModel( "commons-logging:commons-logging:1.0.3" );
      dep = toDependency( "log4j:log4j:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "logkit:logkit:1.0.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-codec:commons-codec:1.2" );
      addModel( model );

      model = toModel( "com.cenqua.clover:clover:1.3.13" );
      addModel( model );

      model = toModel( "checkstyle:checkstyle:4.1" );
      model.addDependency( toDependency( "antlr:antlr:2.7.2::jar" ) );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils-core:1.7.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.1::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      addModel( model );

      model = toModel( "antlr:antlr:2.7.2" );
      addModel( model );

      model = toModel( "commons-beanutils:commons-beanutils-core:1.7.0" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-logging:commons-logging:1.0" );
      addModel( model );

      model = toModel( "commons-collections:commons-collections:2.0" );
      addModel( model );

      model = toModel( "commons-collections:commons-collections:2.1" );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "checkstyle:checkstyle-optional:4.1" );
      model.addDependency( toDependency( "checkstyle:checkstyle:4.1::jar" ) );
      addModel( model );

      model = toModel( "httpunit:httpunit:1.6.1" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-slf4j-logging:1.1-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-logging:1.0.4" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-simple:1.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-logging-provider-test:1.0.4::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-logging:1.0.4" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.11" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-logging-provider-test:1.0.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-logging-provider-test:1.0.4" );
      addModel( model );

      model = toModel( "org.slf4j:slf4j-simple:1.2" );
      model.setParentProject( toParent( "org.slf4j:slf4j-parent:1.2" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-api:1.2::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus.registry:plexus-registry:1.0-alpha-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-17::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.12" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-17::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.registry:plexus-registry-test:1.0-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-17" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-17" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-17::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0-alpha-17" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-17::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-component-api:1.0-alpha-17" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-17" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry-test:1.0-alpha-2" );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus.registry:plexus-registry-providers:1.0-alpha-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-test:1.0-alpha-2::jar", "test" ) );
      dep = toDependency( "commons-configuration:commons-configuration:1.3::jar" );
      addExclusion( dep, "commons-beanutils:commons-beanutils-core" );
      addExclusion( dep, "xerces:xerces" );
      addExclusion( dep, "xerces:xercesImpl" );
      addExclusion( dep, "xalan:xalan" );
      addExclusion( dep, "xml-apis:xml-apis" );
      addExclusion( dep, "servletapi:servletapi" );
      model.addDependency( dep );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.7.0::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry-providers:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus.registry:plexus-registry:1.0-alpha-2" ) );
      addModel( model );

      model = toModel( "commons-configuration:commons-configuration:1.3" );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.1::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.1::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging-api:1.0.4::jar" ) );
      model.addDependency( toDependency( "commons-digester:commons-digester:1.6::jar" ) );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils-core:1.7.0::jar" ) );
      model.addDependency( toDependency( "commons-codec:commons-codec:1.3::jar" ) );
      model.addDependency( toDependency( "commons-jxpath:commons-jxpath:1.2::jar" ) );
      model.addDependency( toDependency( "xerces:xerces:2.2.1::jar" ) );
      model.addDependency( toDependency( "xalan:xalan:2.7.0::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:2.0.2::jar" ) );
      dep = toDependency( "servletapi:servletapi:2.4::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "spice:spice-jndikit:1.1::jar", "test" ) );
      model.addDependency( toDependency( "commons-dbcp:commons-dbcp:1.1::jar", "test" ) );
      model.addDependency( toDependency( "commons-pool:commons-pool:1.1::jar", "test" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.7.2.2::jar", "test" ) );
      model.addDependency( toDependency( "dbunit:dbunit:2.1::jar", "test" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "junit-addons:junit-addons:1.4::jar", "test" ) );
      model.addDependency( toDependency( "mockobjects:mockobjects-core:0.09::jar", "test" ) );
      model.addDependency( toDependency( "mockobjects:mockobjects-jdk1.4-j2ee1.3:0.09::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-collections:commons-collections:3.1" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-logging:commons-logging-api:1.0.4" );
      addModel( model );

      model = toModel( "commons-digester:commons-digester:1.6" );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.6::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.1::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:1.0.b2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-beanutils:commons-beanutils:1.6" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-codec:commons-codec:1.3" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-jxpath:commons-jxpath:1.2" );
      model.addDependency( toDependency( "xerces:xerces:1.2.3::jar" ) );
      model.addDependency( toDependency( "servletapi:servletapi:2.2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8::jar" ) );
      model.addDependency( toDependency( "ant:ant-optional:1.5.1::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:2.0.2::jar" ) );
      model.addDependency( toDependency( "jdom:jdom:b9::jar" ) );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.4::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar" ) );
      addModel( model );

      model = toModel( "xerces:xerces:1.2.3" );
      addModel( model );

      model = toModel( "servletapi:servletapi:2.2" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "javax.servlet" );
      model.getRelocation().setArtifactId( "servlet-api" );
      model.getRelocation().setVersion( "2.2" );
      addModel( model );

      model = toModel( "javax.servlet:servlet-api:2.2" );
      addModel( model );

      model = toModel( "junit:junit:3.8" );
      addModel( model );

      model = toModel( "ant:ant-optional:1.5.1" );
      addModel( model );

      model = toModel( "jdom:jdom:b9" );
      addModel( model );

      model = toModel( "commons-beanutils:commons-beanutils:1.4" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "xerces:xerces:2.2.1" );
      addModel( model );

      model = toModel( "xalan:xalan:2.7.0" );
      model.addDependency( toDependency( "xml-apis:xml-apis:2.0.2::jar" ) );
      dep = toDependency( "xerces:xercesImpl:2.6.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "servletapi:servletapi:2.4" );
      addModel( model );

      model = toModel( "spice:spice-jndikit:1.1" );
      addModel( model );

      model = toModel( "commons-dbcp:commons-dbcp:1.1" );
      addModel( model );

      model = toModel( "commons-pool:commons-pool:1.1" );
      addModel( model );

      model = toModel( "hsqldb:hsqldb:1.7.2.2" );
      addModel( model );

      model = toModel( "dbunit:dbunit:2.1" );
      addModel( model );

      model = toModel( "junit-addons:junit-addons:1.4" );
      addModel( model );

      model = toModel( "mockobjects:mockobjects-core:0.09" );
      addModel( model );

      model = toModel( "mockobjects:mockobjects-jdk1.4-j2ee1.3:0.09" );
      addModel( model );

      model = toModel( "commons-beanutils:commons-beanutils:1.7.0" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-jdo2:1.0-alpha-8" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.6" ) );
      model.addDependency( toDependency( "javax.jdo:jdo2-api:2.0::jar" ) );
      dep = toDependency( "jpox:jpox:1.1.1::jar", "test" );
      addExclusion( dep, "javax.sql:jdbc-stdext" );
      model.addDependency( dep );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.7.3.0::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.8" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "jpox:jpox:1.1.1" );
      model.setParentProject( toParent( "jpox:jpox-parent:1.1.1" ) );
      model.addDependency( toDependency( "log4j:log4j:1.2.8::jar" ) );
      model.addDependency( toDependency( "javax.jdo:jdo2-api:2.0::jar" ) );
      model.addDependency( toDependency( "javax.resource:connector:1.0::jar" ) );
      dep = toDependency( "javax.security:jaas:1.0.01::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "javax.sql:jdbc-stdext:2.0::jar" ) );
      dep = toDependency( "ant:ant:1.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "jpox:jpox-dbcp:1.1.1::jar", "test" ) );
      model.addDependency( toDependency( "commons-dbcp:commons-dbcp:1.2::jar", "test" ) );
      model.addDependency( toDependency( "commons-pool:commons-pool:1.2::jar", "test" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.1::jar", "test" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "jpox:jpox-parent:1.1.1" );
      addModel( model );

      model = toModel( "log4j:log4j:1.2.8" );
      addModel( model );

      model = toModel( "javax.resource:connector:1.0" );
      addModel( model );

      model = toModel( "javax.security:jaas:1.0.01" );
      addModel( model );

      model = toModel( "javax.sql:jdbc-stdext:2.0" );
      addModel( model );

      model = toModel( "ant:ant:1.6" );
      addModel( model );

      model = toModel( "jpox:jpox-dbcp:1.1.1" );
      addModel( model );

      model = toModel( "commons-dbcp:commons-dbcp:1.2" );
      addModel( model );

      model = toModel( "commons-pool:commons-pool:1.2" );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.1::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:2.0.2::jar" ) );
      model.addDependency( toDependency( "xerces:xerces:2.0.2::jar" ) );
      addModel( model );

      model = toModel( "hsqldb:hsqldb:1.7.3.0" );
      addModel( model );

      model = toModel( "jpox:jpox:1.1.7" );
      model.setParentProject( toParent( "jpox:jpox-parent:1.1.7" ) );
      model.addDependency( toDependency( "log4j:log4j:1.2.8::jar" ) );
      model.addDependency( toDependency( "javax.jdo:jdo2-api:2.0::jar" ) );
      model.addDependency( toDependency( "javax.resource:connector:1.0::jar" ) );
      model.addDependency( toDependency( "javax.transaction:jta:1.0.1B::jar" ) );
      dep = toDependency( "ant:ant:1.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "jpox:jpox-parent:1.1.7" );
      addModel( model );

      model = toModel( "javax.transaction:jta:1.0.1B" );
      addModel( model );

      model = toModel( "org.apache.derby:derby:10.1.3.1" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-model:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-xml-tools:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-expression-evaluator:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-log4j12:1.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.cache:plexus-cache-api:1.0-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.cache:plexus-cache-ehcache:1.0-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "xmlunit:xmlunit:1.0::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-expression-evaluator:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.7" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.7" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.8" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "xmlunit:xmlunit:1.0" );
      addModel( model );

      model = toModel( "hsqldb:hsqldb:1.8.0.7" );
      addModel( model );

      model = toModel( "org.apache.derby:derbytools:10.1.3.1" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-converter:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-artifact-converter:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.shared:maven-model-converter:2.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-digest:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-i18n:1.0-beta-6::jar" ) );
      model.addDependency( toDependency( "commons-io:commons-io:1.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.7::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-i18n:1.0-beta-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.4" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.4" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-core:1.0-alpha-2-SNAPSHOT-SNAPSHOT" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-core-consumers:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-consumers:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-digest:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-database-consumers:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-consumers:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-database:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-artifact-reports:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-digest:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-indexer:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-model:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.lucene:lucene-core:2.0.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-digest:1.1::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "commons-io:commons-io:1.2::jar" ) );
      model.addDependency( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.lucene:lucene-core:2.0.0" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-lucene-consumers:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-consumers:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-indexer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-plexus-application:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-web-standalone:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-webapp:1.0-alpha-2-SNAPSHOT::war" ) );
      model.addProperty( "archivaVersion", "1.0-alpha-2-SNAPSHOT" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-web-standalone:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-web:1.0-alpha-2-SNAPSHOT" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-proxy:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-base:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "commons-io:commons-io:1.2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      dep = toDependency( "org.codehaus.plexus:plexus-digest:1.1::jar" );
      addExclusion( dep, "org.codehaus.plexus:plexus-container-default" );
      model.addDependency( dep );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-slf4j-logging:1.1-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-log4j12:1.2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-scheduled:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-parent:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-database:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-taskqueue:1.0-alpha-6::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-quartz:1.0-alpha-3::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.archiva:archiva-database-consumers:1.0-alpha-2-SNAPSHOT::jar", "test" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.7::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-slf4j-logging:1.1-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.slf4j:slf4j-log4j12:1.2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-taskqueue:1.0-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.7" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "backport-util-concurrent:backport-util-concurrent:3.0::jar" ) );
      addModel( model );

      model = toModel( "backport-util-concurrent:backport-util-concurrent:3.0" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-quartz:1.0-alpha-3" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.6" ) );
      model.addDependency( toDependency( "quartz:quartz:1.4.5::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.2::jar" ) );
      addModel( model );

      model = toModel( "quartz:quartz:1.4.5" );
      addModel( model );

      model = toModel( "commons-logging:commons-logging:1.0.2" );
      dep = toDependency( "log4j:log4j:1.1.3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "logkit:logkit:1.0.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "log4j:log4j:1.1.3" );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-security:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-web:1.0-alpha-2-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-role-manager:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-memory:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-xwork-integration:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.derby:derby:10.1.3.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-rbac-role-manager:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-rbac:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-model:1.0-alpha-1::jar" ) );
      dep = toDependency( "net.java.dev.stax-utils:stax-utils:20060502::jar" );
      addExclusion( dep, "com.bea.xml:jsr173-ri" );
      model.addDependency( dep );
      model.addDependency( toDependency( "stax:stax-api:1.0.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.woodstox:wstx-asl:3.2.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-memory:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-jdo:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-model:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-common-jdo:1.0-alpha-1::jar" ) );
      dep = toDependency( "net.java.dev.stax-utils:stax-utils:20060502::jar" );
      addExclusion( dep, "com.bea.xml:jsr173-ri" );
      model.addDependency( dep );
      model.addDependency( toDependency( "stax:stax-api:1.0.1::jar" ) );
      dep = toDependency( "stax:stax:1.1.1-dev::jar", "test" );
      addExclusion( dep, "xmlbeans:xmlbeans-jsr173-api" );
      model.addDependency( dep );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.4::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-rbac:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.10" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-20::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-20::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-configuration:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-system:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-policy:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-common-jdo:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-authentication-api:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-keys-api:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-keys-tests:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-keys-cached:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-keys-memory:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-keys-jdo:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-authentication-users:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-authentication-=keys=:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-authentication-memory:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-authentication-keys:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-authorization-api:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-users-api:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-users-jdo:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-users-memory:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-users-cached:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-users-tests:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-authorization-rbac:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-model:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-tests:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-memory:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-cached:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-jdo:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-rbac-role-manager:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-xwork-integration:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-taglib:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-xwork-content:1.0-alpha-1::war" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.redback:redback-xwork-integration:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-20::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-20::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-ehcache:1.0-alpha-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-mail-sender-api:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-mail-sender-javamail:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-expression-evaluator:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-log4j-logging:1.1-alpha-2::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-xwork-integration:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "xalan:xalan:2.7.0::jar" ) );
      model.addDependencyManagement( toDependency( "xml-apis:xml-apis:1.3.03::jar" ) );
      model.addDependencyManagement( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependencyManagement( toDependency( "commons-collections:commons-collections:3.2::jar" ) );
      model.addDependencyManagement( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      model.addDependencyManagement( toDependency( "hsqldb:hsqldb:1.8.0.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.derby:derby:10.1.3.1::jar" ) );
      model.addProperty( "security.version", "1.0-alpha-1" );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-configuration:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-expression-evaluator:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-log4j-logging:1.1-alpha-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.registry:plexus-registry-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-test:1.0-alpha-1::jar" ) );
      dep = toDependency( "commons-configuration:commons-configuration:1.3::jar" );
      addExclusion( dep, "commons-beanutils:commons-beanutils-core" );
      addExclusion( dep, "xerces:xerces" );
      addExclusion( dep, "xerces:xercesImpl" );
      addExclusion( dep, "xalan:xalan" );
      addExclusion( dep, "xml-apis:xml-apis" );
      addExclusion( dep, "servletapi:servletapi" );
      model.addDependency( dep );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.7.0::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry-providers:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.registry:plexus-registry:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-17::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus.registry:plexus-registry-test:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.registry:plexus-registry:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-17::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.registry:plexus-registry-test:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.registry:plexus-registry:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-17::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-log4j-logging:1.1-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-logging:1.0.2" ) );
      model.addDependency( toDependency( "log4j:log4j:1.2.8::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-logging-provider-test:1.0-alpha-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-logging:1.0.2" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-logging-provider-test:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-logging:1.0.2" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-system:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-configuration:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authentication-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authorization-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-cached:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-cached:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authentication-memory:1.0-alpha-1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authentication-api:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-authentication:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-policy:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authentication:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-api:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-users-api:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-users:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-users:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-policy:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-configuration:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-api:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authorization-api:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-authorization:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authorization:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-api:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-users-cached:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-users-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-policy:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-ehcache:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-jdo:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-tests:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-memory:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-log4j-logging:1.1-alpha-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-users-providers:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-users:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-api:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-ehcache:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.7" ) );
      model.addDependency( toDependency( "net.sf.ehcache:ehcache:1.2.4::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.2::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-users-jdo:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-users-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-common-jdo:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-policy:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-tests:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.4::jar", "test" ) );
      dep = toDependency( "net.java.dev.stax-utils:stax-utils:20060502::jar" );
      addExclusion( dep, "com.bea.xml:jsr173-ri" );
      model.addDependency( dep );
      model.addDependency( toDependency( "stax:stax-api:1.0.1::jar" ) );
      model.addDependency( toDependency( "woodstox:wstx-asl:3.2.0::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.2" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.5" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.5" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-common-jdo:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-common:1.0-alpha-1" ) );
      dep = toDependency( "org.codehaus.plexus:plexus-jdo2:1.0-alpha-8::jar" );
      addExclusion( dep, "xerces:xercesImpl" );
      addExclusion( dep, "xerces:xmlParserAPIs" );
      model.addDependency( dep );
      dep = toDependency( "jpox:jpox:1.1.7::jar", "compile" );
      addExclusion( dep, "javax.sql:jdbc-stdext" );
      model.addDependency( dep );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.4::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-configuration:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-common:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "hsqldb:hsqldb:1.8.0.4" );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-users-tests:1.0-alpha-1" );
      addModel( model );

      model = toModel( "net.java.dev.stax-utils:stax-utils:20060502" );
      model.addDependency( toDependency( "com.bea.xml:jsr173-ri:1.0::jar" ) );
      addModel( model );

      model = toModel( "com.bea.xml:jsr173-ri:1.0" );
      model.addDependency( toDependency( "javax.xml:jsr173:1.0::jar" ) );
      addModel( model );

      model = toModel( "javax.xml:jsr173:1.0" );
      addModel( model );

      model = toModel( "stax:stax-api:1.0.1" );
      addModel( model );

      model = toModel( "woodstox:wstx-asl:3.2.0" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "org.codehaus.woodstox" );
      addModel( model );

      model = toModel( "org.codehaus.woodstox:wstx-asl:3.2.0" );
      model.addDependency( toDependency( "stax:stax-api:1.0.1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-users-memory:1.0-alpha-1" );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-keys-api:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-keys:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-digest:1.0::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-keys:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-digest:1.0" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.7" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-keys-cached:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-keys-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-ehcache:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-jdo:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-tests:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-memory:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-log4j-logging:1.1-alpha-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-keys-providers:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-keys:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-keys-jdo:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-keys-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-common-jdo:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-tests:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.4::jar", "test" ) );
      dep = toDependency( "net.java.dev.stax-utils:stax-utils:20060502::jar" );
      addExclusion( dep, "com.bea.xml:jsr173-ri" );
      model.addDependency( dep );
      model.addDependency( toDependency( "stax:stax-api:1.0.1::jar" ) );
      model.addDependency( toDependency( "woodstox:wstx-asl:3.2.0::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-keys-tests:1.0-alpha-1" );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-keys-memory:1.0-alpha-1" );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authentication-memory:1.0-alpha-1" );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authentication-users:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-authentication-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authentication-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-policy:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-cached:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-memory:1.0-alpha-1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authentication-providers:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-authentication:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authentication-=keys=:1.0-alpha-1" );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authentication-keys:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-authentication-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authentication-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-cached:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authorization-rbac:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-authorization-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authorization-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-cached:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-users-cached:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-model:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-authorization-providers:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-authorization:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-rbac-cached:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-rbac-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-system:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authorization-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-model:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-ehcache:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-jdo:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-memory:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-tests:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-log4j-logging:1.1-alpha-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-rbac-providers:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-rbac:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-rbac-model:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-rbac:1.0-alpha-1" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-rbac-jdo:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-rbac-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-model:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-tests:1.0-alpha-1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-common-jdo:1.0-alpha-1::jar" ) );
      dep = toDependency( "net.java.dev.stax-utils:stax-utils:20060502::jar" );
      addExclusion( dep, "com.bea.xml:jsr173-ri" );
      model.addDependency( dep );
      model.addDependency( toDependency( "stax:stax-api:1.0.1::jar" ) );
      dep = toDependency( "stax:stax:1.1.1-dev::jar", "test" );
      addExclusion( dep, "xmlbeans:xmlbeans-jsr173-api" );
      model.addDependency( dep );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.4::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-log4j-logging:1.1-alpha-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-rbac-tests:1.0-alpha-1" );
      addModel( model );

      model = toModel( "stax:stax:1.1.1-dev" );
      model.addDependency( toDependency( "xmlbeans:xmlbeans-jsr173-api:2.0-dev::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      addModel( model );

      model = toModel( "xmlbeans:xmlbeans-jsr173-api:2.0-dev" );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-rbac-memory:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-rbac-providers:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-system:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authorization-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-model:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-tests:1.0-alpha-1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-xwork-integration:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-xwork:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-configuration:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-system:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-policy:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authentication-users:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authentication-keys:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-authorization-rbac:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-rbac-role-manager:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-xwork-integration:1.0-alpha-6::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-mail-sender-api:1.0-alpha-6::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-mail-sender-javamail:1.0-alpha-6::jar" ) );
      model.addDependency( toDependency( "org.extremecomponents:extremecomponents:1.0.1::jar" ) );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils-bean-collections:1.7.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.2::jar" ) );
      dep = toDependency( "org.codehaus.plexus:plexus-velocity:1.1.2::jar" );
      addExclusion( dep, "plexus:plexus-utils" );
      addExclusion( dep, "commons-logging:commons-logging-api" );
      model.addDependency( dep );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      model.addDependency( toDependency( "taglibs:standard:1.1.2::jar" ) );
      model.addDependency( toDependency( "javax.servlet:jstl:1.1.2::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.2::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.2::jar" ) );
      model.addDependency( toDependency( "opensymphony:sitemesh:2.2.1::jar" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.8.0.4::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-keys-memory:1.0-alpha-1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-xwork:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-integrations:1.0-alpha-1" ) );
      model.addDependencyManagement( toDependency( "taglibs:standard:1.1.2::jar" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:jstl:1.1.2::jar" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:jsp-api:2.0::jar", "provided" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-integrations:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-system:1.0-alpha-1::jar" ) );
      addModel( model );

      model = toModel( "taglibs:standard:1.1.2" );
      addModel( model );

      model = toModel( "javax.servlet:jstl:1.1.2" );
      model.addDependency( toDependency( "javax.servlet:jsp-api:2.0::jar", "provided" ) );
      addModel( model );

      model = toModel( "javax.servlet:jsp-api:2.0" );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-xwork-integration:1.0-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.12" ) );
      model.addDependency( toDependency( "org.easymock:easymock:2.2::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-17::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-17::jar" ) );
      model.addDependency( toDependency( "opensymphony:xwork:1.2.1::jar" ) );
      model.addDependency( toDependency( "opensymphony:webwork:2.2.4::jar" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      addModel( model );

      model = toModel( "org.easymock:easymock:2.2" );
      addModel( model );

      model = toModel( "opensymphony:xwork:1.2.1" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.rifers:rife-continuations:0.0.2::jar" ) );
      model.addDependency( toDependency( "opensymphony:oscore:2.2.4::jar" ) );
      model.addDependency( toDependency( "ognl:ognl:2.6.7::jar" ) );
      dep = toDependency( "org.springframework:spring-core:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-aop:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-beans:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-context:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-web:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "org.springframework:spring-mock:1.2.6::jar", "test" ) );
      dep = toDependency( "cglib:cglib:2.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "mockobjects:mockobjects-core:0.09::jar", "test" ) );
      model.addDependency( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      model.addDependency( toDependency( "easymock:easymockclassextension:1.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.rifers:rife-continuations:0.0.2" );
      addModel( model );

      model = toModel( "opensymphony:oscore:2.2.4" );
      addModel( model );

      model = toModel( "ognl:ognl:2.6.7" );
      addModel( model );

      model = toModel( "org.springframework:spring-core:1.2.6" );
      model.setParentProject( toParent( "org.springframework:spring-parent:1.2.6" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      dep = toDependency( "log4j:log4j:1.2.9::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.1::jar" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:1.0.b2::jar", "provided" ) );
      addModel( model );

      model = toModel( "org.springframework:spring-parent:1.2.6" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      dep = toDependency( "log4j:log4j:1.2.9::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "cglib:cglib:2.1_3::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "commons-attributes:commons-attributes-compiler:2.1::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "org.hibernate:hibernate:3.0.5::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "org.hibernate:hibernate-annotations:3.0beta2::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "struts:struts:1.2.7::jar" );
      addExclusion( dep, "servletapi:servletapi" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "jasperreports:jasperreports:1.0.3::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "freemarker:freemarker:2.3.4::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      model.addDependencyManagement( toDependency( "javax.servlet:jsp-api:2.0::jar", "provided" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      model.addDependencyManagement( toDependency( "aopalliance:aopalliance:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "oro:oro:2.0.8::jar" ) );
      dep = toDependency( "commons-pool:commons-pool:1.2::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "com.jamonapi:jamon:1.0::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      model.addDependencyManagement( toDependency( "xdoclet:xjavadoc:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "javax.mail:mail:1.3.2::jar" ) );
      dep = toDependency( "velocity:velocity:1.4::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      model.addDependencyManagement( toDependency( "commons-collections:commons-collections:3.1::jar" ) );
      model.addDependencyManagement( toDependency( "xml-apis:xml-apis:1.0.b2::jar", "provided" ) );
      model.addDependencyManagement( toDependency( "javax.transaction:jta:1.0.1B::jar" ) );
      dep = toDependency( "jotm:jotm:2.0.10::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "net.sf.hibernate:hibernate:2.1.8::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "c3p0:c3p0:0.9.0.2::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "commons-dbcp:commons-dbcp:1.2.1::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "com.experlog:xapool:1.5.0::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      model.addDependencyManagement( toDependency( "commons-lang:commons-lang:2.1::jar" ) );
      dep = toDependency( "com.oracle.toplink:toplink:10.1.3::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "ojb:db-ojb:1.0.3::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "javax.jdo:jdo:2.0-20050809.1515::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "com.ibatis:ibatis-sqlmap:1.3.1::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "com.ibatis:ibatis2-sqlmap:2.1.5.582::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "javax.jms:jms:1.1::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "javax.ejb:ejb:2.0::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "javax.xml:jaxrpc-api:1.1::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "commons-httpclient:commons-httpclient:3.0-rc4::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "com.caucho:burlap:2.1.12::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "com.caucho:hessian:2.1.12::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      model.addDependencyManagement( toDependency( "javax.resource:connector:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "ehcache:ehcache:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "quartz:quartz:1.5.1::jar" ) );
      model.addDependencyManagement( toDependency( "com.servlets:cos:05Nov2002::jar" ) );
      model.addDependencyManagement( toDependency( "easymock:easymock:1.2_RC2_Java1.3::jar", "test" ) );
      model.addDependencyManagement( toDependency( "javax.servlet:jstl:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "taglibs:standard:1.0.6::jar" ) );
      dep = toDependency( "javax.faces:jsf-api:1.1::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "velocity-tools:velocity-tools-generic:1.1::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "velocity-tools:velocity-tools-view:1.1::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "poi:poi:2.5.1-final-20040804::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "itext:itext:1.3::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      dep = toDependency( "net.sourceforge.jexcelapi:jxl:2.5.7::jar" );
      dep.setOptional( true );
      model.addDependencyManagement( dep );
      addModel( model );

      model = toModel( "log4j:log4j:1.2.9" );
      addModel( model );

      model = toModel( "cglib:cglib:2.1_3" );
      addModel( model );

      model = toModel( "commons-attributes:commons-attributes-compiler:2.1" );
      model.addDependency( toDependency( "commons-attributes:commons-attributes-api:2.1::jar" ) );
      addModel( model );

      model = toModel( "commons-attributes:commons-attributes-api:2.1" );
      model.addDependency( toDependency( "ant:ant:1.5::jar" ) );
      model.addDependency( toDependency( "qdox:qdox:1.5::jar" ) );
      addModel( model );

      model = toModel( "ant:ant:1.5" );
      addModel( model );

      model = toModel( "qdox:qdox:1.5" );
      addModel( model );

      model = toModel( "org.hibernate:hibernate:3.0.5" );
      addModel( model );

      model = toModel( "org.hibernate:hibernate-annotations:3.0beta2" );
      addModel( model );

      model = toModel( "struts:struts:1.2.7" );
      addModel( model );

      model = toModel( "jasperreports:jasperreports:1.0.3" );
      addModel( model );

      model = toModel( "freemarker:freemarker:2.3.4" );
      addModel( model );

      model = toModel( "aopalliance:aopalliance:1.0" );
      addModel( model );

      model = toModel( "oro:oro:2.0.8" );
      addModel( model );

      model = toModel( "com.jamonapi:jamon:1.0" );
      addModel( model );

      model = toModel( "xdoclet:xjavadoc:1.1" );
      addModel( model );

      model = toModel( "javax.mail:mail:1.3.2" );
      model.addDependency( toDependency( "javax.activation:activation:1.0.2::jar", "compile" ) );
      addModel( model );

      model = toModel( "velocity:velocity:1.4" );
      model.addDependency( toDependency( "velocity:velocity-dep:1.4::jar", "runtime" ) );
      addModel( model );

      model = toModel( "velocity:velocity-dep:1.4" );
      addModel( model );

      model = toModel( "jotm:jotm:2.0.10" );
      addModel( model );

      model = toModel( "c3p0:c3p0:0.9.0.2" );
      addModel( model );

      model = toModel( "commons-dbcp:commons-dbcp:1.2.1" );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.1::jar" ) );
      model.addDependency( toDependency( "commons-pool:commons-pool:1.2::jar" ) );
      dep = toDependency( "javax.sql:jdbc-stdext:2.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:2.0.2::jar" ) );
      model.addDependency( toDependency( "xerces:xerces:2.0.2::jar" ) );
      addModel( model );

      model = toModel( "com.experlog:xapool:1.5.0" );
      addModel( model );

      model = toModel( "com.oracle.toplink:toplink:10.1.3" );
      addModel( model );

      model = toModel( "ojb:db-ojb:1.0.3" );
      addModel( model );

      model = toModel( "javax.jdo:jdo:2.0-20050809.1515" );
      addModel( model );

      model = toModel( "com.ibatis:ibatis-sqlmap:1.3.1" );
      addModel( model );

      model = toModel( "com.ibatis:ibatis2-sqlmap:2.1.5.582" );
      addModel( model );

      model = toModel( "javax.jms:jms:1.1" );
      addModel( model );

      model = toModel( "javax.ejb:ejb:2.0" );
      addModel( model );

      model = toModel( "javax.xml:jaxrpc-api:1.1" );
      addModel( model );

      model = toModel( "commons-httpclient:commons-httpclient:3.0-rc4" );
      addModel( model );

      model = toModel( "com.caucho:burlap:2.1.12" );
      addModel( model );

      model = toModel( "com.caucho:hessian:2.1.12" );
      addModel( model );

      model = toModel( "ehcache:ehcache:1.1" );
      addModel( model );

      model = toModel( "quartz:quartz:1.5.1" );
      addModel( model );

      model = toModel( "com.servlets:cos:05Nov2002" );
      addModel( model );

      model = toModel( "easymock:easymock:1.2_RC2_Java1.3" );
      addModel( model );

      model = toModel( "javax.servlet:jstl:1.0" );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar", "provided" ) );
      addModel( model );

      model = toModel( "taglibs:standard:1.0.6" );
      addModel( model );

      model = toModel( "javax.faces:jsf-api:1.1" );
      addModel( model );

      model = toModel( "velocity-tools:velocity-tools-generic:1.1" );
      addModel( model );

      model = toModel( "velocity-tools:velocity-tools-view:1.1" );
      addModel( model );

      model = toModel( "poi:poi:2.5.1-final-20040804" );
      addModel( model );

      model = toModel( "itext:itext:1.3" );
      addModel( model );

      model = toModel( "net.sourceforge.jexcelapi:jxl:2.5.7" );
      addModel( model );

      model = toModel( "org.springframework:spring-aop:1.2.6" );
      model.setParentProject( toParent( "org.springframework:spring-parent:1.2.6" ) );
      model.addDependency( toDependency( "org.springframework:spring-beans:1.2.6::jar" ) );
      model.addDependency( toDependency( "aopalliance:aopalliance:1.0::jar" ) );
      model.addDependency( toDependency( "oro:oro:2.0.8::jar" ) );
      dep = toDependency( "commons-pool:commons-pool:1.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "commons-attributes:commons-attributes-compiler:2.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "com.jamonapi:jamon:1.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "cglib:cglib:2.1_3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "xdoclet:xjavadoc:1.1::jar", "test" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      addModel( model );

      model = toModel( "org.springframework:spring-beans:1.2.6" );
      model.setParentProject( toParent( "org.springframework:spring-parent:1.2.6" ) );
      model.addDependency( toDependency( "org.springframework:spring-core:1.2.6::jar" ) );
      dep = toDependency( "cglib:cglib:2.1_3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      model.addDependency( toDependency( "javax.mail:mail:1.3.2::jar", "test" ) );
      model.addDependency( toDependency( "org.hibernate:hibernate:3.0.5::jar", "test" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.springframework:spring-context:1.2.6" );
      model.setParentProject( toParent( "org.springframework:spring-parent:1.2.6" ) );
      model.addDependency( toDependency( "org.springframework:spring-aop:1.2.6::jar" ) );
      dep = toDependency( "velocity:velocity:1.4::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "freemarker:freemarker:2.3.4::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "jasperreports:jasperreports:1.0.3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "org.springframework:spring-web:1.2.6" );
      model.setParentProject( toParent( "org.springframework:spring-parent:1.2.6" ) );
      model.addDependency( toDependency( "javax.servlet:jsp-api:2.0::jar", "provided" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      model.addDependency( toDependency( "javax.servlet:jstl:1.0::jar" ) );
      model.addDependency( toDependency( "org.springframework:spring-context:1.2.6::jar" ) );
      dep = toDependency( "log4j:log4j:1.2.9::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "struts:struts:1.2.7::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "com.servlets:cos:05Nov2002::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "taglibs:standard:1.0.6::jar" ) );
      dep = toDependency( "javax.faces:jsf-api:1.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "org.springframework:spring-mock:1.2.6" );
      model.setParentProject( toParent( "org.springframework:spring-parent:1.2.6" ) );
      dep = toDependency( "org.springframework:spring-jdbc:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-web:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "javax.servlet:jsp-api:2.0::jar", "provided" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.springframework:spring-jdbc:1.2.6" );
      addModel( model );

      model = toModel( "cglib:cglib:2.1" );
      model.addDependency( toDependency( "asm:asm:1.5.3::jar" ) );
      model.addDependency( toDependency( "asm:asm-util:1.3.4::jar" ) );
      model.addDependency( toDependency( "aspectwerkz:aspectwerkz-core:0.8.1::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "asm:asm:1.5.3" );
      addModel( model );

      model = toModel( "asm:asm-util:1.3.4" );
      addModel( model );

      model = toModel( "aspectwerkz:aspectwerkz-core:0.8.1" );
      addModel( model );

      model = toModel( "easymock:easymockclassextension:1.1" );
      addModel( model );

      model = toModel( "opensymphony:webwork:2.2.4" );
      model.addDependency( toDependency( "opensymphony:xwork:1.2.1::jar" ) );
      dep = toDependency( "opensymphony:xwork-tiger:1.2.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "freemarker:freemarker:2.3.4::jar" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      model.addDependency( toDependency( "javax.servlet:jsp-api:2.0::jar", "provided" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      dep = toDependency( "commons-lang:commons-lang:2.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "dwr:dwr:1.1-beta-3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "velocity:velocity:1.4::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "velocity-tools:velocity-tools:1.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "commons-fileupload:commons-fileupload:1.1.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "servlets.com:cos:05Nov2002::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "opensymphony:pell-multipart:2.1.5::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "opensymphony:sitemesh:2.2.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "jetty:org.mortbay.jetty:5.1.4::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "eclipse:jdtcore:3.1.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "jasperreports:jasperreports:1.1.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "jfree:jfreechart:1.0.0::jar" );
      addExclusion( dep, "gnujaxp:gnujaxp" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.apache.struts.tiles:tiles-core:0.2-SNAPSHOT::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "commons-digester:commons-digester:1.7::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "portlet-api:portlet-api:1.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.apache.pluto:pluto:1.0.1-rc4::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-10-SNAPSHOT::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "picocontainer:picocontainer:1.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "picocontainer:picocontainer-gems:1.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "nanocontainer:nanocontainer:1.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "nanocontainer:nanocontainer-nanowar:1.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-beans:1.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-core:1.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-context:1.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-web:1.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "org.springframework:spring-mock:1.2::jar", "compile" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xpp3:xpp3:1.1.3.4-RC8::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "junit:junit:3.8.1::jar", "compile" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar", "test" ) );
      model.addDependency( toDependency( "easymock:easymock:1.2_Java1.3::jar", "test" ) );
      model.addDependency( toDependency( "easymock:easymockclassextension:1.1::jar", "test" ) );
      model.addDependency( toDependency( "jmock:jmock-cglib:1.0.1::jar", "test" ) );
      model.addDependency( toDependency( "mockobjects:mockobjects-core:0.09::jar", "test" ) );
      model.addDependency( toDependency( "mockobjects:mockobjects-jdk1.3:0.09::jar", "test" ) );
      model.addDependency( toDependency( "mockobjects:mockobjects-alt-jdk1.3:0.09::jar", "test" ) );
      model.addDependency( toDependency( "mockobjects:mockobjects-alt-jdk1.3-j2ee1.3:0.09::jar", "test" ) );
      model.addDependency( toDependency( "mockobjects:mockobjects-jdk1.3-j2ee1.3:0.09::jar", "test" ) );
      addModel( model );

      model = toModel( "opensymphony:xwork-tiger:1.2.1" );
      addModel( model );

      model = toModel( "commons-lang:commons-lang:2.0" );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "dwr:dwr:1.1-beta-3" );
      addModel( model );

      model = toModel( "velocity-tools:velocity-tools:1.1" );
      addModel( model );

      model = toModel( "commons-fileupload:commons-fileupload:1.1.1" );
      addModel( model );

      model = toModel( "servlets.com:cos:05Nov2002" );
      addModel( model );

      model = toModel( "opensymphony:pell-multipart:2.1.5" );
      addModel( model );

      model = toModel( "opensymphony:sitemesh:2.2.1" );
      addModel( model );

      model = toModel( "jetty:org.mortbay.jetty:5.1.4" );
      addModel( model );

      model = toModel( "eclipse:jdtcore:3.1.0" );
      addModel( model );

      model = toModel( "jasperreports:jasperreports:1.1.0" );
      addModel( model );

      model = toModel( "jfree:jfreechart:1.0.0" );
      addModel( model );

      model = toModel( "org.apache.struts.tiles:tiles-core:0.2-SNAPSHOT" );
      addModel( model );

      model = toModel( "commons-digester:commons-digester:1.7" );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.6::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.1::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:1.0.b2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "portlet-api:portlet-api:1.0" );
      addModel( model );

      model = toModel( "org.apache.pluto:pluto:1.0.1-rc4" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-10-SNAPSHOT" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0.6-SNAPSHOT" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.2::jar" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1::jar" ) );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0.6-SNAPSHOT" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.8-SNAPSHOT" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.8-SNAPSHOT" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "picocontainer:picocontainer:1.2" );
      addModel( model );

      model = toModel( "picocontainer:picocontainer-gems:1.2" );
      addModel( model );

      model = toModel( "nanocontainer:nanocontainer:1.0" );
      addModel( model );

      model = toModel( "nanocontainer:nanocontainer-nanowar:1.0" );
      addModel( model );

      model = toModel( "org.springframework:spring-beans:1.2" );
      addModel( model );

      model = toModel( "org.springframework:spring-core:1.2" );
      addModel( model );

      model = toModel( "org.springframework:spring-context:1.2" );
      addModel( model );

      model = toModel( "org.springframework:spring-web:1.2" );
      addModel( model );

      model = toModel( "org.springframework:spring-mock:1.2" );
      addModel( model );

      model = toModel( "xpp3:xpp3:1.1.3.4-RC8" );
      addModel( model );

      model = toModel( "jmock:jmock-cglib:1.0.1" );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar" ) );
      model.addDependency( toDependency( "cglib:cglib-full:2.0::jar" ) );
      addModel( model );

      model = toModel( "cglib:cglib-full:2.0" );
      addModel( model );

      model = toModel( "mockobjects:mockobjects-jdk1.3:0.09" );
      addModel( model );

      model = toModel( "mockobjects:mockobjects-alt-jdk1.3:0.09" );
      addModel( model );

      model = toModel( "mockobjects:mockobjects-alt-jdk1.3-j2ee1.3:0.09" );
      addModel( model );

      model = toModel( "mockobjects:mockobjects-jdk1.3-j2ee1.3:0.09" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-mail-sender-api:1.0-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-mail-sender:1.0-alpha-6" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-mail-sender:1.0-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.9" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-mail-sender-javamail:1.0-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-mail-senders:1.0-alpha-6" ) );
      model.addDependency( toDependency( "javax.mail:mail:1.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-mail-sender-test:1.0-alpha-6::jar", "test" ) );
      dep = toDependency( "org.codehaus.plexus:plexus-naming:1.0-alpha-1::jar", "test" );
      addExclusion( dep, "geronimo-spec:geronimo-spec-javamail" );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-mail-senders:1.0-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-mail-sender:1.0-alpha-6" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-mail-sender-api:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "javax.mail:mail:1.4" );
      model.addDependency( toDependency( "javax.activation:activation:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-mail-sender-test:1.0-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-mail-senders:1.0-alpha-6" ) );
      model.addDependency( toDependency( "dumbster:dumbster:1.5::jar" ) );
      addModel( model );

      model = toModel( "dumbster:dumbster:1.5" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-naming:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.6" ) );
      model.addDependency( toDependency( "directory-naming:naming-core:0.8::jar" ) );
      model.addDependency( toDependency( "directory-naming:naming-java:0.8::jar" ) );
      model.addDependency( toDependency( "directory-naming:naming-factory:0.8::jar" ) );
      model.addDependency( toDependency( "commons-dbcp:commons-dbcp:1.2.1::jar" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.7.1::jar", "test" ) );
      addModel( model );

      model = toModel( "directory-naming:naming-core:0.8" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      addModel( model );

      model = toModel( "directory-naming:naming-java:0.8" );
      model.addDependency( toDependency( "directory-naming:naming-core:0.8::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      addModel( model );

      model = toModel( "directory-naming:naming-factory:0.8" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      model.addDependency( toDependency( "directory-naming:naming-core:0.8::jar" ) );
      model.addDependency( toDependency( "geronimo-spec:geronimo-spec-javamail:1.3.1-rc1::jar" ) );
      addModel( model );

      model = toModel( "geronimo-spec:geronimo-spec-javamail:1.3.1-rc1" );
      addModel( model );

      model = toModel( "hsqldb:hsqldb:1.7.1" );
      addModel( model );

      model = toModel( "org.extremecomponents:extremecomponents:1.0.1" );
      dep = toDependency( "avalon-framework:avalon-framework:4.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "batik:batik:1.5-fop-0.20-5::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.7.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.0::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.0::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      dep = toDependency( "fop:fop:0.20.5::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      dep = toDependency( "poi:poi:2.5.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "servletapi:servletapi:2.3::jar", "provided" ) );
      model.addDependency( toDependency( "taglibs:standard:1.0.2::jar" ) );
      dep = toDependency( "xalan:xalan:2.5.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xerces:xercesImpl:2.6.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xml-apis:xml-apis:2.0.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "avalon-framework:avalon-framework:4.0" );
      addModel( model );

      model = toModel( "batik:batik:1.5-fop-0.20-5" );
      addModel( model );

      model = toModel( "commons-collections:commons-collections:3.0" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "fop:fop:0.20.5" );
      addModel( model );

      model = toModel( "poi:poi:2.5.1" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "poi" );
      model.getRelocation().setArtifactId( "poi" );
      model.getRelocation().setVersion( "2.5.1-final-20040804" );
      addModel( model );

      model = toModel( "taglibs:standard:1.0.2" );
      addModel( model );

      model = toModel( "xerces:xercesImpl:2.6.1" );
      addModel( model );

      model = toModel( "commons-beanutils:commons-beanutils-bean-collections:1.7.0" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-velocity:1.1.2" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-7::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar", "compile" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar", "compile" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging-api:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "velocity:velocity:1.4::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-taglib:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-integrations:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-system:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-xwork-integration:1.0-alpha-6::jar" ) );
      model.addDependency( toDependency( "taglibs:standard:1.1.2::jar" ) );
      model.addDependency( toDependency( "javax.servlet:jstl:1.1.2::jar" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar", "provided" ) );
      model.addDependency( toDependency( "javax.servlet:jsp-api:2.0::jar", "provided" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.redback:redback-xwork-content:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.redback:redback-xwork:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-xwork-integration:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.redback:redback-taglib:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "xml-apis:xml-apis:1.3.03" );
      model.setParentProject( toParent( "org.apache:apache:1" ) );
      addModel( model );

      model = toModel( "org.apache:apache:1" );
      addModel( model );

      model = toModel( "org.codehaus.woodstox:wstx-asl:3.2.1" );
      model.addDependency( toDependency( "stax:stax-api:1.0.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.archiva:archiva-signature-consumers:1.0-alpha-2-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.archiva:archiva-consumers:1.0-alpha-2-SNAPSHOT" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-model:2.0.5" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.5" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-project:2.0.5" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.5" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-settings:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-test:2.0.5::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-profile:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-settings:2.0.5" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.5" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-test:2.0.5" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-profile:2.0.5" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.5" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.5::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-app-configuration-model:1.0" );
      model.setParentProject( toParent( "org.apache.maven.shared:maven-app-configuration:1.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-20::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-app-configuration:1.0" );
      model.setParentProject( toParent( "org.apache.maven.shared:maven-shared-components:7" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-app-configuration-web:1.0" );
      model.setParentProject( toParent( "org.apache.maven.shared:maven-app-configuration:1.0" ) );
      model.addDependency( toDependency( "org.apache.maven.shared:maven-app-configuration-model:1.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-project:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2::jar", "runtime" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-20::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-project:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-settings:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-test:2.0.4::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-profile:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-settings:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-test:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-settings:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-manager:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-repository-metadata:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-7::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-repository-metadata:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-profile:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-appserver-host:2.0-alpha-8" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-appserver:2.0-alpha-8" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-20::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-20::jar" ) );
      model.addDependency( toDependency( "mx4j:mx4j:3.0.1::jar" ) );
      model.addDependency( toDependency( "mx4j:mx4j-remote:3.0.1::jar" ) );
      model.addDependency( toDependency( "org.livetribe:livetribe-slp:1.0.2::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-appserver:2.0-alpha-8" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.11" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-20::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-20::jar" ) );
      addModel( model );

      model = toModel( "mx4j:mx4j:3.0.1" );
      addModel( model );

      model = toModel( "mx4j:mx4j-remote:3.0.1" );
      addModel( model );

      model = toModel( "org.livetribe:livetribe-slp:1.0.2" );
      model.setParentProject( toParent( "org.livetribe:livetribe:1.0" ) );
      model.addDependency( toDependency( "backport-util-concurrent:backport-util-concurrent:2.2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.livetribe:livetribe:1.0" );
      addModel( model );

      model = toModel( "backport-util-concurrent:backport-util-concurrent:2.2" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-appserver-service-jetty:2.0-alpha-8" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-appserver-services:2.0-alpha-8" ) );
      model.addDependency( toDependency( "ant:ant:1.6.2::jar" ) );
      model.addDependency( toDependency( "jetty:org.mortbay.jetty:5.1.10::jar" ) );
      model.addDependency( toDependency( "tomcat:jasper-compiler:5.5.15::jar" ) );
      model.addDependency( toDependency( "tomcat:jasper-runtime:5.5.15::jar" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar" ) );
      model.addDependency( toDependency( "javax.servlet:jsp-api:2.0::jar" ) );
      dep = toDependency( "commons-el:commons-el:1.0::jar", "runtime" );
      addExclusion( dep, "log4j:log4j" );
      addExclusion( dep, "commons-logging:commons-logging" );
      addExclusion( dep, "logkit:logkit" );
      model.addDependency( dep );
      model.addDependency( toDependency( "jetty:org.mortbay.jetty.plus:5.1.10::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging-api:1.0.4::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.derby:derby:10.1.3.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-appserver-services:2.0-alpha-8" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-appserver:2.0-alpha-8" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-appserver-host:2.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "ant:ant:1.6.2" );
      dep = toDependency( "xerces:xerces-impl:2.6.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xml-apis:xml-apis:2.6.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "xerces:xerces-impl:2.6.2" );
      addModel( model );

      model = toModel( "xml-apis:xml-apis:2.6.2" );
      addModel( model );

      model = toModel( "jetty:org.mortbay.jetty:5.1.10" );
      addModel( model );

      model = toModel( "tomcat:jasper-compiler:5.5.15" );
      model.setParentProject( toParent( "tomcat:tomcat-parent:5.5.15" ) );
      model.addDependency( toDependency( "javax.servlet:jsp-api:2.0::jar" ) );
      model.addDependency( toDependency( "ant:ant:1.6.5::jar" ) );
      addModel( model );

      model = toModel( "tomcat:tomcat-parent:5.5.15" );
      model.setParentProject( toParent( "org.apache:apache:3" ) );
      model.addDependencyManagement( toDependency( "commons-logging:commons-logging-api:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "ant:ant:1.6.5" );
      dep = toDependency( "xerces:xerces-impl:2.6.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xml-apis:xml-apis:2.6.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "tomcat:jasper-runtime:5.5.15" );
      model.setParentProject( toParent( "tomcat:tomcat-parent:5.5.15" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.4::jar" ) );
      model.addDependency( toDependency( "commons-el:commons-el:1.0::jar" ) );
      addModel( model );

      model = toModel( "commons-el:commons-el:1.0" );
      model.addDependency( toDependency( "servletapi:servletapi:2.4-20040521::jar", "provided" ) );
      model.addDependency( toDependency( "jspapi:jsp-api:2.0-20040521::jar", "provided" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      addModel( model );

      model = toModel( "servletapi:servletapi:2.4-20040521" );
      addModel( model );

      model = toModel( "jspapi:jsp-api:2.0-20040521" );
      addModel( model );

      model = toModel( "jetty:org.mortbay.jetty.plus:5.1.10" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-cli:1.1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-tools:1.0.8" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-5::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-14::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      dep = toDependency( "commons-cli:commons-cli:1.0::jar" );
      addExclusion( dep, "commons-lang:commons-lang" );
      addExclusion( dep, "commons-logging:commons-logging" );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-tools:1.0.8" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-14::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-14" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-14" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-13::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-5::jar" ) );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0-alpha-14" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-5::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-13::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-5" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-component-api:1.0-alpha-13" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0.7-alpha-3" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-5::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0.7-alpha-3" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-5::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-13::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      addModel( model );

      model = toModel( "commons-cli:commons-cli:1.0" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:1.0::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-lang:commons-lang:1.0" );
      model.addDependency( toDependency( "junit:junit:3.7::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-command-line:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-naming:1.0-alpha-3" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.9" ) );
      model.addDependency( toDependency( "directory-naming:naming-core:0.8::jar" ) );
      model.addDependency( toDependency( "directory-naming:naming-java:0.8::jar" ) );
      model.addDependency( toDependency( "directory-naming:naming-factory:0.8::jar" ) );
      model.addDependency( toDependency( "directory-naming:naming-config:0.8::jar" ) );
      model.addDependency( toDependency( "commons-dbcp:commons-dbcp:1.2.1::jar" ) );
      model.addDependency( toDependency( "commons-pool:commons-pool:1.2::jar" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.7.1::jar", "test" ) );
      addModel( model );

      model = toModel( "directory-naming:naming-config:0.8" );
      model.addDependency( toDependency( "directory-naming:naming-core:0.8::jar" ) );
      model.addDependency( toDependency( "directory-naming:naming-factory:0.8::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:1.0.1::jar" ) );
      model.addDependency( toDependency( "commons-digester:commons-digester:1.4.1::jar" ) );
      model.addDependency( toDependency( "directory-naming:naming-java:0.8::jar" ) );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.6.1::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.1::jar" ) );
      model.addDependency( toDependency( "commons-dbcp:commons-dbcp:1.0::jar" ) );
      model.addDependency( toDependency( "commons-pool:commons-pool:1.0.1::jar" ) );
      model.addDependency( toDependency( "hsqldb:hsqldb:1.7.1::jar" ) );
      addModel( model );

      model = toModel( "commons-lang:commons-lang:1.0.1" );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-digester:commons-digester:1.4.1" );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.6::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.1::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:2.0.2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-beanutils:commons-beanutils:1.6.1" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-dbcp:commons-dbcp:1.0" );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:1.0-b1::jar" ) );
      model.addDependency( toDependency( "commons-pool:commons-pool:1.0::jar" ) );
      model.addDependency( toDependency( "jdbc:jdbc:2.0::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:2.0.2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar" ) );
      addModel( model );

      model = toModel( "commons-lang:commons-lang:1.0-b1" );
      addModel( model );

      model = toModel( "commons-pool:commons-pool:1.0" );
      addModel( model );

      model = toModel( "jdbc:jdbc:2.0" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "javax.sql" );
      model.getRelocation().setArtifactId( "jdbc-stdext" );
      model.getRelocation().setVersion( "2.0" );
      addModel( model );

      model = toModel( "commons-pool:commons-pool:1.0.1" );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-simple:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus.webdav:plexus-webdav-providers-parent:1.0-alpha-2" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.1::jar" ) );
      model.addDependency( toDependency( "it.could:webdav:0.4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-providers-parent:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus.webdav:plexus-webdav-parent:1.0-alpha-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.webdav:plexus-webdav-api:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.webdav:plexus-webdav-test:1.0-alpha-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-parent:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.12" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-api:1.0-alpha-2" );
      model.setParentProject( toParent( "org.codehaus.plexus.webdav:plexus-webdav-parent:1.0-alpha-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-20::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-20::jar" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-test:1.0-alpha-2" );
      addModel( model );

      model = toModel( "it.could:webdav:0.4" );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar", "runtime" ) );
      addModel( model );

   }
}
