package org.apache.maven.archiva.dependency.graph;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.dependency.DependencyGraphFactory;
import org.apache.maven.archiva.model.DependencyScope;
import org.apache.maven.archiva.model.VersionedReference;

import java.util.ArrayList;
import java.util.List;

/**
 * ContinuumStoreDependencyGraphTest
 * 
 * DependencyGraphTest for testing <code>org.apache.maven.continuum:continuum-store:1.1-SNAPSHOT</code>
 *
 * Generated by <code>archivadev:generate-dependency-tests</code> plugin
 * @version $Id: ContinuumStoreDependencyGraphTest.java 755277 2009-03-17 15:18:35Z brett $
 */
public class ContinuumStoreDependencyGraphTest
   extends AbstractDependencyGraphFactoryTestCase
{
   public void testResolvedDepsToNodes()
        throws GraphTaskException
   {
      MemoryRepositoryDependencyGraphBuilder graphBuilder = 
                     new MemoryRepositoryDependencyGraphBuilder();
      MemoryRepository repository = new ContinuumStoreMemoryRepository();
      graphBuilder.setMemoryRepository( repository );

      // Create the factory, and add the test resolver.
      DependencyGraphFactory factory = new DependencyGraphFactory();
      factory.setGraphBuilder( graphBuilder );
      factory.setDesiredScope( DependencyScope.TEST );

      // Get the model to resolve from
      VersionedReference rootRef = toVersionedReference( "org.apache.maven.continuum:continuum-store:1.1-SNAPSHOT"); 

      // Perform the resolution.
      DependencyGraph graph = factory.getGraph( rootRef );

      // Test the results.
      assertNotNull( "Graph shouldn't be null.", graph );

      String expectedRootRef = "org.apache.maven.continuum:continuum-store:1.1-SNAPSHOT";
      List<String> expectedNodes = new ArrayList<String>();

      // Check for all nodes, regardless of scope.
      expectedNodes.clear();
      expectedNodes.add( "ant:ant:1.6::jar" );
      expectedNodes.add( "geronimo-spec:geronimo-spec-jta:1.0.1B-rc2::jar" );
      expectedNodes.add( "hsqldb:hsqldb:1.7.3.3::jar" );
      expectedNodes.add( "jakarta-regexp:jakarta-regexp:1.4::jar" );
      expectedNodes.add( "javax.jdo:jdo2-api:2.0::jar" );
      expectedNodes.add( "javax.resource:connector:1.0::jar" );
      expectedNodes.add( "javax.transaction:jta:1.0.1B::jar" );
      expectedNodes.add( "jmock:jmock:1.0.1::jar" );
      expectedNodes.add( "jpox:jpox:1.1.7::jar" );
      expectedNodes.add( "jpox:jpox-enhancer:1.1.7::jar" );
      expectedNodes.add( "junit:junit:3.8.1::jar" );
      expectedNodes.add( "log4j:log4j:1.2.8::jar" );
      expectedNodes.add( "net.java.dev.stax-utils:stax-utils:20060502::jar" );
      expectedNodes.add( "ognl:ognl:2.6.7::jar" );
      expectedNodes.add( "org.apache.bcel:bcel:5.2::jar" );
      expectedNodes.add( "org.apache.maven.continuum:continuum-api:1.1-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.continuum:continuum-model:1.1-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.continuum:continuum-test:1.1-SNAPSHOT::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-component-api:1.0-alpha-20::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-container-default:1.0-alpha-20::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-formica:1.0-beta-13::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-i18n:1.0-beta-6::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-jdo2:1.0-alpha-8::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-utils:1.4::jar" );
      expectedNodes.add( "oro:oro:2.0.6::jar" );
      expectedNodes.add( "stax:stax-api:1.0.1::jar" );

      assertGraph( graph, expectedRootRef, expectedNodes );
   }

}
