package org.apache.maven.archiva.dependency.graph;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.Dependency;
import org.apache.maven.archiva.model.VersionedReference;

/**
 * MavenProjectInfoReportsPluginMemoryRepository
 * 
 * MemoryRepository for testing <code>org.apache.maven.plugins:maven-project-info-reports-plugin:2.1-SNAPSHOT</code>
 *
 * Generated by <code>archivadev:generate-dependency-tests</code> plugin
 * @version $Id: MavenProjectInfoReportsPluginMemoryRepository.java 547277 2007-06-14 15:25:42Z joakime $
 */
public class MavenProjectInfoReportsPluginMemoryRepository
   extends AbstractMemoryRepository
{
   public void initialize()
   {
      ArchivaProjectModel model;
      Dependency dep;

      model = toModel( "org.apache.maven.plugins:maven-project-info-reports-plugin:2.1-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.plugins:maven-plugins:8" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-plugin-api:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-settings:2.0.4::jar" ) );
      model.addDependency( toDependency( "commons-validator:commons-validator:1.2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.reporting:maven-reporting-impl:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.shared:maven-shared-jar:1.0-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.shared:maven-dependency-tree:1.0-alpha-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-api:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-manager-plexus:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-perforce:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-clearcase:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-starteam:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-svnexe:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-cvsexe:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-core:1.0-alpha-8::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-site-renderer:1.0-alpha-8::jar" ) );
      model.addDependency( toDependency( "httpunit:httpunit:1.6::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.shared:maven-plugin-testing-harness:1.0::jar", "test" ) );
      model.addProperty( "wagon.version", "1.0-beta-2" );
      model.addProperty( "scm.version", "1.0-beta-4" );
      addModel( model );

      model = toModel( "org.apache.maven.plugins:maven-plugins:8" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:5" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-parent:5" );
      model.setParentProject( toParent( "org.apache:apache:3" ) );
      addModel( model );

      model = toModel( "org.apache:apache:3" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-plugin-api:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven:2.0.4" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-external:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "junit:junit:3.8.1" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0.3" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0.3" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.4" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.4" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.0.4" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "classworlds:classworlds:1.1-alpha-2" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.4" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-alpha-6" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon:1.0-alpha-6" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-6" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-7" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" ) );
      model.addDependency( toDependency( "com.jcraft:jsch:0.1.24::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-alpha-6" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-6::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "com.jcraft:jsch:0.1.24" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-7::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-7" );
      model.setParentProject( toParent( "plexus:plexus-containers:1.0.2" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "plexus:plexus-containers:1.0.2" );
      model.setParentProject( toParent( "plexus:plexus-root:1.0.3" ) );
      addModel( model );

      model = toModel( "plexus:plexus-root:1.0.3" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "plexus:plexus-utils:1.0.2" );
      model.setParentProject( toParent( "plexus:plexus-root:1.0.3" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-external:1.0-alpha-6" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-file:1.0-alpha-7" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-6" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" ) );
      dep = toDependency( "plexus:plexus-jetty-httpd:1.0-beta-1::jar", "test" );
      addExclusion( dep, "plexus:plexus-container-default" );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "plexus:plexus-jetty-httpd:1.0-beta-1" );
      model.setParentProject( toParent( "plexus:plexus-components:1.0" ) );
      model.addDependency( toDependency( "jetty:jetty:4.2.10::jar" ) );
      model.addDependency( toDependency( "servletapi:servletapi:2.3::jar" ) );
      addModel( model );

      model = toModel( "plexus:plexus-components:1.0" );
      model.setParentProject( toParent( "plexus:plexus-root:1.0" ) );
      model.addDependency( toDependency( "plexus:plexus-container-default:1.0-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "plexus:plexus-root:1.0" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "plexus:plexus-container-default:1.0-alpha-2" );
      addModel( model );

      model = toModel( "jetty:jetty:4.2.10" );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar", "runtime" ) );
      addModel( model );

      model = toModel( "javax.servlet:servlet-api:2.3" );
      addModel( model );

      model = toModel( "servletapi:servletapi:2.3" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "javax.servlet" );
      model.getRelocation().setArtifactId( "servlet-api" );
      model.getRelocation().setVersion( "2.3" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-settings:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-model:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "commons-validator:commons-validator:1.2.0" );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.7.0::jar" ) );
      model.addDependency( toDependency( "commons-digester:commons-digester:1.6::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar" ) );
      model.addDependency( toDependency( "oro:oro:2.0.8::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:2.0.2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-beanutils:commons-beanutils:1.7.0" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      addModel( model );

      model = toModel( "commons-logging:commons-logging:1.0.3" );
      dep = toDependency( "log4j:log4j:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "logkit:logkit:1.0.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "log4j:log4j:1.2.6" );
      addModel( model );

      model = toModel( "logkit:logkit:1.0.1" );
      addModel( model );

      model = toModel( "junit:junit:3.7" );
      addModel( model );

      model = toModel( "commons-digester:commons-digester:1.6" );
      model.addDependency( toDependency( "commons-beanutils:commons-beanutils:1.6::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.1::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:1.0.b2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-beanutils:commons-beanutils:1.6" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-logging:commons-logging:1.0" );
      addModel( model );

      model = toModel( "commons-collections:commons-collections:2.0" );
      addModel( model );

      model = toModel( "commons-collections:commons-collections:2.1" );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "xml-apis:xml-apis:1.0.b2" );
      addModel( model );

      model = toModel( "commons-logging:commons-logging:1.0.4" );
      dep = toDependency( "log4j:log4j:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "logkit:logkit:1.0.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      dep = toDependency( "avalon-framework:avalon-framework:4.1.3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "avalon-framework:avalon-framework:4.1.3" );
      addModel( model );

      model = toModel( "oro:oro:2.0.8" );
      addModel( model );

      model = toModel( "xml-apis:xml-apis:2.0.2" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "xml-apis" );
      model.getRelocation().setArtifactId( "xml-apis" );
      model.getRelocation().setVersion( "1.0.b2" );
      addModel( model );

      model = toModel( "org.apache.maven.reporting:maven-reporting-impl:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven.reporting:maven-reporting:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-project:2.0.4::jar" ) );
      model.addDependency( toDependency( "commons-validator:commons-validator:1.2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-core:1.0-alpha-7::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-plugin-api:2.0.4::jar" ) );
      model.addDependency( toDependency( "oro:oro:2.0.7::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.reporting:maven-reporting-api:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-site-renderer:1.0-alpha-7::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.reporting:maven-reporting:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-project:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-settings:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-test:2.0.4::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-profile:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-test:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-settings:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-manager:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-repository-metadata:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-7::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-repository-metadata:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-profile:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia-core:1.0-alpha-7" );
      model.setParentProject( toParent( "org.apache.maven.doxia:doxia:1.0-alpha-7" ) );
      model.addDependency( toDependency( "oro:oro:2.0.7::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-sink-api:1.0-alpha-7::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia:1.0-alpha-7" );
      addModel( model );

      model = toModel( "oro:oro:2.0.7" );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia-sink-api:1.0-alpha-7" );
      model.setParentProject( toParent( "org.apache.maven.doxia:doxia:1.0-alpha-7" ) );
      addModel( model );

      model = toModel( "org.apache.maven.reporting:maven-reporting-api:2.0.4" );
      model.setParentProject( toParent( "org.apache.maven.reporting:maven-reporting:2.0.4" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-sink-api:1.0-alpha-7::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia-site-renderer:1.0-alpha-7" );
      model.setParentProject( toParent( "org.apache.maven.doxia:doxia:1.0-alpha-7" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-core:1.0-alpha-7::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-i18n:1.0-beta-6::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-velocity:1.1.2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-decoration-model:1.0-alpha-7::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-i18n:1.0-beta-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.4" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.4" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-velocity:1.1.2" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-7::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar", "compile" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar", "compile" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging-api:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "velocity:velocity:1.4::jar", "compile" ) );
      addModel( model );

      model = toModel( "commons-logging:commons-logging-api:1.0.4" );
      addModel( model );

      model = toModel( "velocity:velocity:1.4" );
      model.addDependency( toDependency( "velocity:velocity-dep:1.4::jar", "runtime" ) );
      addModel( model );

      model = toModel( "velocity:velocity-dep:1.4" );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia-decoration-model:1.0-alpha-7" );
      model.setParentProject( toParent( "org.apache.maven.doxia:doxia:1.0-alpha-7" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-shared-jar:1.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.shared:maven-shared-components:3" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0.2::jar", "compile" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0.2::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-digest:1.0::jar" ) );
      model.addDependency( toDependency( "org.apache.bcel:bcel:5.2::jar", "compile" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.1::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-shared-components:3" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:4" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-parent:4" );
      model.setParentProject( toParent( "org.apache:apache:3" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-model:2.0.2" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven:2.0.2" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-external:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-6" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-alpha-6" ) );
      model.addDependency( toDependency( "com.jcraft:jsch:0.1.24::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-file:1.0-alpha-6" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-manager:2.0.2" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.2" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-repository-metadata:2.0.2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-6::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0.2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-repository-metadata:2.0.2" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact:2.0.2" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0.2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-digest:1.0" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.7" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.7" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.8" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.8" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.bcel:bcel:5.2" );
      model.addDependency( toDependency( "jakarta-regexp:jakarta-regexp:1.4::jar" ) );
      addModel( model );

      model = toModel( "jakarta-regexp:jakarta-regexp:1.4" );
      addModel( model );

      model = toModel( "commons-collections:commons-collections:3.1" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-dependency-tree:1.0-alpha-2" );
      model.setParentProject( toParent( "org.apache.maven.shared:maven-shared-components:5" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-project:2.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-shared-components:5" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:4" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:4" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-test:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-beta-2" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-common-test:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-beta-2::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:1.0-beta-2::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "com.jcraft:jsch:0.1.27::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:1.0-beta-2::jar", "test" ) );
      addModel( model );

      model = toModel( "com.jcraft:jsch:0.1.27" );
      dep = toDependency( "com.jcraft:jzlib:1.0.7::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "com.jcraft:jzlib:1.0.7" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-file:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-http-shared:1.0-beta-2::jar" ) );
      model.addDependency( toDependency( "xml-apis:xml-apis:1.0.b2::jar" ) );
      dep = toDependency( "plexus:plexus-jetty-httpd:1.0-beta-1::jar", "test" );
      addExclusion( dep, "plexus:plexus-container-default" );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-shared:1.0-beta-2" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:1.0-beta-2" ) );
      model.addDependency( toDependency( "jtidy:jtidy:4aug2000r7-dev::jar" ) );
      addModel( model );

      model = toModel( "jtidy:jtidy:4aug2000r7-dev" );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-api:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm:1.0-beta-4" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-manager-plexus:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-managers:1.0-beta-4" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-managers:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm:1.0-beta-4" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-api:1.0-beta-4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-provider-perforce:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-providers:1.0-beta-4" ) );
      model.addDependency( toDependency( "regexp:regexp:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-providers:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm:1.0-beta-4" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-api:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-test:1.0-beta-4::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-test:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm:1.0-beta-4" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-api:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-manager-plexus:1.0-beta-4::jar" ) );
      addModel( model );

      model = toModel( "regexp:regexp:1.3" );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-provider-clearcase:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-providers:1.0-beta-4" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-provider-starteam:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-providers:1.0-beta-4" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-provider-svnexe:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-providers-svn:1.0-beta-4" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-svn-commons:1.0-beta-4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-svntest:1.0-beta-4::jar", "test" ) );
      model.addDependency( toDependency( "regexp:regexp:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-providers-svn:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-providers:1.0-beta-4" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-provider-svn-commons:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-providers-svn:1.0-beta-4" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-provider-svntest:1.0-beta-4" );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-provider-cvsexe:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-providers-cvs:1.0-beta-4" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-cvstest:1.0-beta-4::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-cvs-commons:1.0-beta-4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-providers-cvs:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-providers:1.0-beta-4" ) );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-provider-cvstest:1.0-beta-4" );
      addModel( model );

      model = toModel( "org.apache.maven.scm:maven-scm-provider-cvs-commons:1.0-beta-4" );
      model.setParentProject( toParent( "org.apache.maven.scm:maven-scm-providers-cvs:1.0-beta-4" ) );
      model.addDependency( toDependency( "org.apache.maven.scm:maven-scm-provider-cvstest:1.0-beta-4::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia-core:1.0-alpha-8" );
      model.setParentProject( toParent( "org.apache.maven.doxia:doxia:1.0-alpha-8" ) );
      model.addDependency( toDependency( "oro:oro:2.0.7::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-sink-api:1.0-alpha-8::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "runtime" ) );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia:1.0-alpha-8" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:1" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-parent:1" );
      model.setParentProject( toParent( "org.apache:apache:1" ) );
      addModel( model );

      model = toModel( "org.apache:apache:1" );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia-sink-api:1.0-alpha-8" );
      model.setParentProject( toParent( "org.apache.maven.doxia:doxia:1.0-alpha-8" ) );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia-site-renderer:1.0-alpha-8" );
      model.setParentProject( toParent( "org.apache.maven.doxia:doxia:1.0-alpha-8" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-core:1.0-alpha-8::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-i18n:1.0-beta-6::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-velocity:1.1.3::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.doxia:doxia-decoration-model:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-velocity:1.1.3" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.5" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:2.0::jar" ) );
      model.addDependency( toDependency( "velocity:velocity:1.4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.5" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.5" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.5" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.doxia:doxia-decoration-model:1.0-alpha-8" );
      model.setParentProject( toParent( "org.apache.maven.doxia:doxia:1.0-alpha-8" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "httpunit:httpunit:1.6" );
      model.addDependency( toDependency( "xerces:xmlParserAPIs:2.2.1::jar" ) );
      model.addDependency( toDependency( "xerces:xercesImpl:2.6.2::jar" ) );
      model.addDependency( toDependency( "nekohtml:nekohtml:0.9.1::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependency( toDependency( "rhino:js:1.5R4.1::jar" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar" ) );
      model.addDependency( toDependency( "jtidy:jtidy:4aug2000r7-dev::jar" ) );
      model.addDependency( toDependency( "javax.activation:activation:1.0.2::jar", "test" ) );
      model.addDependency( toDependency( "javax.mail:mail:1.3.1::jar", "test" ) );
      addModel( model );

      model = toModel( "xerces:xmlParserAPIs:2.2.1" );
      addModel( model );

      model = toModel( "xerces:xercesImpl:2.6.2" );
      addModel( model );

      model = toModel( "nekohtml:nekohtml:0.9.1" );
      model.addDependency( toDependency( "xerces:xerces:2.4.0::jar" ) );
      addModel( model );

      model = toModel( "xerces:xerces:2.4.0" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "xerces" );
      model.getRelocation().setArtifactId( "xercesImpl" );
      addModel( model );

      model = toModel( "xerces:xercesImpl:2.4.0" );
      addModel( model );

      model = toModel( "rhino:js:1.5R4.1" );
      addModel( model );

      model = toModel( "javax.activation:activation:1.0.2" );
      addModel( model );

      model = toModel( "javax.mail:mail:1.3.1" );
      model.addDependency( toDependency( "javax.activation:activation:1.0.2::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-plugin-testing-harness:1.0" );
      model.setParentProject( toParent( "org.apache.maven.shared:maven-shared-components:7" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-project:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-core:2.0::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.1::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.shared:maven-shared-components:7" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:5" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-project:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-test:2.0::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-profile:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven:2.0" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-5::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-5" );
      model.addDependency( toDependency( "com.jcraft:jsch:0.1.23::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "compile" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar", "compile" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-5::jar", "test" ) );
      addModel( model );

      model = toModel( "com.jcraft:jsch:0.1.23" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-5" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-file:1.0-alpha-5" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "test" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-5::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-5" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "test" ) );
      model.addDependency( toDependency( "servletapi:servletapi:2.3::jar", "test" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "jetty:jetty:4.2.10::jar", "test" ) );
      model.addDependency( toDependency( "plexus:plexus-jetty-httpd:1.0-beta-1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-5::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-test:2.0" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-profile:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-model:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-manager:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-repository-metadata:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-5::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-repository-metadata:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-core:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-settings:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-5::jar", "runtime" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-plugin-parameter-documenter:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-5::jar", "runtime" ) );
      model.addDependency( toDependency( "org.apache.maven.reporting:maven-reporting-api:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-profile:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-repository-metadata:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-error-diagnostics:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-project:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-plugin-registry:2.0::jar" ) );
      dep = toDependency( "commons-cli:commons-cli:1.0::jar" );
      addExclusion( dep, "commons-lang:commons-lang" );
      addExclusion( dep, "commons-logging:commons-logging" );
      model.addDependency( dep );
      model.addDependency( toDependency( "org.apache.maven:maven-plugin-api:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-plugin-descriptor:2.0::jar" ) );
      dep = toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" );
      addExclusion( dep, "plexus:plexus-utils" );
      addExclusion( dep, "org.codehaus.plexus:plexus-container-default" );
      model.addDependency( dep );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-monitor:2.0::jar" ) );
      dep = toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-5::jar", "runtime" );
      addExclusion( dep, "plexus:plexus-utils" );
      addExclusion( dep, "org.codehaus.plexus:plexus-container-default" );
      model.addDependency( dep );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-settings:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-plugin-parameter-documenter:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.reporting:maven-reporting-api:2.0" );
      model.setParentProject( toParent( "org.apache.maven.reporting:maven-reporting:2.0" ) );
      dep = toDependency( "doxia:doxia-sink-api:1.0-alpha-4::jar" );
      addExclusion( dep, "plexus:plexus-container-default" );
      addExclusion( dep, "plexus:plexus-utils" );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "org.apache.maven.reporting:maven-reporting:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      addModel( model );

      model = toModel( "doxia:doxia-sink-api:1.0-alpha-4" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-error-diagnostics:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-plugin-registry:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "commons-cli:commons-cli:1.0" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:1.0::jar" ) );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "commons-lang:commons-lang:1.0" );
      model.addDependency( toDependency( "junit:junit:3.7::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-plugin-api:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-plugin-descriptor:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-plugin-api:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-monitor:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      addModel( model );

   }
}
