package org.apache.maven.archiva.database.updater;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.commons.collections.CollectionUtils;
import org.codehaus.plexus.spring.PlexusInSpringTestCase;

import java.util.List;

/**
 * DatabaseConsumersTest 
 *
 * @version $Id: DatabaseConsumersTest.java 755266 2009-03-17 14:28:40Z brett $
 */
public class DatabaseConsumersTest
    extends PlexusInSpringTestCase
{
    private DatabaseConsumers lookupDbConsumers()
        throws Exception
    {
        DatabaseConsumers dbconsumers = (DatabaseConsumers) lookup( DatabaseConsumers.class );
        assertNotNull( "DatabaseConsumers should not be null.", dbconsumers );
        return dbconsumers;
    }

    public void testGetAvailableCleanupConsumers()
        throws Exception
    {
        DatabaseConsumers dbconsumers = lookupDbConsumers();
        List<DatabaseCleanupConsumer> available = dbconsumers.getAvailableCleanupConsumers();
        assertNotNull( "Available Cleanup Consumers should never be null.", available );

        assertTrue( "Available Cleanup Consumers should have entries.", CollectionUtils.isNotEmpty( available ) );
    }

    public void testGetAvailableUnprocessedConsumers()
        throws Exception
    {
        DatabaseConsumers dbconsumers = lookupDbConsumers();
        List<DatabaseUnprocessedArtifactConsumer> available = dbconsumers.getAvailableUnprocessedConsumers();
        assertNotNull( "Available Unprocessed Consumers should never be null.", available );

        assertTrue( "Available Unprocessed Consumers should have entries.", CollectionUtils.isNotEmpty( available ) );
    }

    public void testGetSelectedCleanupConsumers()
        throws Exception
    {
        DatabaseConsumers dbconsumers = lookupDbConsumers();
        List<ArchivaArtifactConsumer> available = dbconsumers.getSelectedCleanupConsumers();
        assertNotNull( "Selected Cleanup Consumers should never be null.", available );

        assertTrue( "Selected Cleanup Consumers should have entries.", CollectionUtils.isNotEmpty( available ) );
    }

    public void testGetSelectedUnprocessedConsumers()
        throws Exception
    {
        DatabaseConsumers dbconsumers = lookupDbConsumers();
        List<ArchivaArtifactConsumer> available = dbconsumers.getSelectedUnprocessedConsumers();
        assertNotNull( "Selected Unprocessed Consumers should never be null.", available );

        assertTrue( "Selected Unprocessed Consumers should have entries.", CollectionUtils.isNotEmpty( available ) );
    }

}
