package org.apache.maven.archiva.security;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.Collections;
import java.util.List;

/**
 * UserRepositories stub used for testing. 
 *
 * @version $Id$
 */
public class UserRepositoriesStub
    implements UserRepositories
{
    private List<String> repoIds = Collections.singletonList( "test-repo" );

    public void createMissingRepositoryRoles( String repoId )
        throws ArchivaSecurityException
    {
        // TODO Auto-generated method stub

    }

    public List<String> getObservableRepositoryIds( String principal )
        throws PrincipalNotFoundException, AccessDeniedException, ArchivaSecurityException
    {
        return repoIds;
    }

    public void setObservableRepositoryIds( List<String> repoIds )
    {
        this.repoIds = repoIds; 
    }

    public boolean isAuthorizedToUploadArtifacts( String principal, String repoId )
        throws PrincipalNotFoundException, ArchivaSecurityException
    {
        // TODO Auto-generated method stub
        return false;
    }
    
    public boolean isAuthorizedToDeleteArtifacts( String principal, String repoId )
    {
        return false;
    }

    public List<String> getManagableRepositoryIds( String principal )
        throws PrincipalNotFoundException, AccessDeniedException, ArchivaSecurityException
    {
        // TODO Auto-generated method stub
        return null;
    }

}
