#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

# 2.0-b120308
# - (C) \̊ԈႢ(FFT̑̒PʂȂ)CB
# - (ǉ) ڍאݒŁAF0^[Qbglɍ킹đ̐ݒlݒ肷{^ǉ(autoF0Settings)
# - (ύX) F0ōl̃ftHgl400800Ɉグ

# 2.0-b110624
# - (ǉ) ustt@C甭Xg쐬ł悤ɂ(makeRecListFromUst)
# - (폜) setParamp̃Tu[`폜
# - (C) I[fBII/Oݒ葋ŃG[oC(ioSettings)
# - (ǉ) I[fBII/Oݒ葋ɌxǉB
# - (ǉ) ESCŊeݒ葋悤ɂ(bgmGuide, pitchGuide, tempoGuide, ioSettings, settings)
# - (ǉ) ŉɃV[gJbgL[ꗗ\

# 2.0-b100509
# - (ύX) `R[hsetParamō̃x[Xɂ(Redraw)
# - (C) I[fBIfoCX̃̕oOC(setIODevice)

# 2.0-b100204
# - (ǉ) g`̕\/\؂ւ悤ɂ(toggleWaveȂ)
# - (ǉ) ǂݍݍς݂̃p[^ɕʂ̌p[^t@C}[W(mergeParamFile)
# - (ǉ) I𒆂͈̔͂̒lꊇύX@\(changeCell)
# - (ǉ) I[fBIfoCX̃CeVύX@\(ioSettings)
# - (C) I[fBIhCo̕኱(ioSettings)
# - (ύX) p[^ǂލۂwav݂ȂGg͍폜悤ɂ(readParamFile)

# 2.0-b091205
# - (ǉ) CD&DꂽƂ̏ǉ(procDnd)
# - (ǉ) ^C~O␳ؑւǉ(timingAdjMode)
# - (C) ׂoȌCB
# - (ǉ) vOXo[\
# - (ǉ) oto.iniǂݍݍp̃LbV@\
# - (ǉ) F3Alt-F3őp[^AĂ悤ɂB
# - (ǉ) GCAXꊇϊ@\ǉ(changeAlias)
# - (C) Ap[^spaceōĐƁA\̔g`łȂg`ĐoOCB

# 2.0-b091120
# - (ύX) SbZ[WOt@CB
# - (ǉ) wav[̖Jbg@\ǉ (cutWav)
# - (C) p[^ꗗ\̐l폜"0"ƕ\oO?CB

# 2.0-b091104
# - (ǉ) ǂݍݎɃp[^(P/A)Isł悤ɂB
# - (ǉ) s`FbNp̎@\ѐݒ葋ǉ
# - (ǉ) ^Ãp[^(genParam)
# - (ύX) t@Cۑ̕ۑΏۂύX(saveSettings)
# - (C) s𕡐ۂɃp[^ɋ󗓂ꍇ̃Rs[̃oOCB

# 2.0-b091007
# - (C) ȑOEuNŐVo[Wœ悤ɏCB

# 2.0-b090903
# - (ǉ) uNlύXۂɁAwavt@C̑̉̍uNl
#          AĕύXł悤ɂB
# - (ύX) e푋JƂɃtH[JX悤ɕύXB
# - (ǉ) p[^B
# - (ύX) p[^ꗗ\̃^Cgꍇ͐؂l߂悤ɕύXB
# - (ύX) }EX+F1`F5Ŋep[^hbO\B
# - (C) setParamF0\ȂoȌCB
# - (C) setParamŃ}EXhbOɂZIłȂoȌCB

# 2.0-b090822
# - (C) setParam̈ꗗ\^Cg̃t@C\XVȂoOCB
# - (C) setParam̈ꗗ\̒lɑ}E폜ƂJ[\ɍsoOCB
# - (ύX) Sp[^}CNsecxɂB
# - (ǉ) EuN̒̕lɑΉB
# - (ǉ) IvVŉEuN̐؂ւ悤ɂB
# - (ǉ) IvVōuN̕ύX̑p[^̂ӂ܂
#          ؂ւ悤ɂ
# (2.0-b090813)
# - (ύX) XgXN[łQỎ悤ɂB
# - (ǉ) t@C𐶐ł悤ɂB

# 2.0-b090803
# - (C) readParamFileBoto.iniɃGgȂꍇ̃oOCB
# -iǉ) c[j[DCꊇǉ
# -iǉ) c[j[wavt@CύXi`"_"t)ǉ
# - (ǉ) Xg{bNX̉ctrl+wheelŕύX\ɂB

# 2.0-b090727
# - (ύX) setParamŔg`ɃGCAX\B
# - (ύX) ꗗ\^CgɃt@C\B
# - (ύX) ꗗ\̏㉺ړŕ\̏[E[Ń[vȂ悤ɂB
# - (ύX) KChBGMݒ葋ŁABGMA^C[W{^ǉB
# - (ύX) I[fBII/Oݒ葋ɐ\B
# - (C) ^(loop)ŁAXg܂łI悤ɂB
# - (ύX) Redraw̉Z񐔂팸B
# - (C) makeRecListFromDirł̃t@Co^̃oOCB

# 2.0-b090724
# - (C) val2sampŎlԂƂoOCB

# 2.0-b090719
# - (C) gm[Đ~łȂoOCB

# 2.0-b090715
# - saveParamFile (paramU̓e𒼐ڏo悤ɂ)

# 2.0-b090706
# - oremo.tcl {̂̃Tu[`Wʃt@CɈڍsB

#---------------------------------------------------
# Tu[`

#---------------------------------------------------
# Cʕ\ZbgH
#
proc resetDisplay {} {
  global v t rec type

  set v(recSeq)  0
  set v(typeSeq) 0
  set v(listSeq) 1
  set v(recLab)  [lindex $v(recList)  $v(recSeq)]
  set v(typeLab) [lindex $v(typeList) $v(typeSeq)]
  readWavFile
  Redraw all
}

#---------------------------------------------------
# ۑtH_ɂwavt@Cǂ݁AXgɋL
#
proc makeRecListFromDir {{readParam 0}} {
  global v t

  set v(recList) {}
  foreach filename [glob -nocomplain [format "%s/*.wav" $v(saveDir)]] {
    set filename [file rootname [file tail $filename]]
    if {$filename == ""} continue
    ;# tH_ъgq菜t@CXgɊi[
    ;# Ɣ^Cv͕Ȃ
    lappend v(recList) $filename
  }
  set v(typeList) {""}
}

#---------------------------------------------------
# reclist.txtۑ
#
proc saveRecList {} {
  global v t

  set fn [tk_getSaveFile -initialfile $v(recListFile) \
            -title $t(saveRecList,title) -defaultextension "txt" ]
  if {$fn == ""} return

  set v(recListFile) $fn
  if [catch {open $v(recListFile) w} out] { 
    tk_messageBox -message [eval format $t(saveRecList,errMsg)] \
      -title $t(.confm.fioErr) -icon warning
  } else { 
    foreach sn $v(recList) {
      if [catch {set data [puts $out $sn]}] {
        tk_messageBox -message [eval format $t(saveRecList,errMsg2)] \
          -title $t(.confm.fioErr) -icon warning
      }
    }
    close $out
  }
  set v(msg) [eval format $t(saveRecList,doneMsg)]
}

#---------------------------------------------------
# USTt@C烊Xg𐶐
#
proc makeRecListFromUst {args} {
  global v t

  if {[llength $args] == 0 || ! [file exists $v(recListFile)]} {
    set fn [tk_getOpenFile -initialfile $v(recListFile) \
            -title $t(makeRecListFromUst,title1) -defaultextension "ust" \
            -filetypes { {{reclist file} {.ust}} {{All Files} {*}} }]
  } else {
    set fn [lindex $args 0]
  }
  if {$fn == ""} return
  set v(recListFile) [file rootname $fn].txt

  if [catch {open $fn r} in] { 
    tk_messageBox -message [eval format $t(makeRecListFromUst,errMsg)]
      -title $t(.confm.fioErr) -icon warning
  } else { 
    set v(recList) {}
    while {![eof $in]} {
      set data [split [gets $in] "="]
      if {[llength $data] > 1} {
        set item [lindex $data 0]       ;# ږ
        set val  [lindex $data 1]       ;# f[^e
        if {$item == "Lyric"} {
          ;# dȂ΃Xgɒǉ
          if {[lsearch -exact $v(recList) $val] < 0} {
            lappend v(recList) $val
          }
        }
      }
    }
    close $in
  }
  set v(recSeq) 0
  set v(recLab) [lindex $v(recList) $v(recSeq)]
  set v(msg) [eval format $t(makeRecListFromUst,doneMsg)]
  set v(typeList) {""}
}

#---------------------------------------------------
# Xgt@Cǂ݁AXgɋL
#
proc readRecList {args} {
  global v t

  if {[llength $args] == 0 || ! [file exists $v(recListFile)]} {
    set fn [tk_getOpenFile -initialfile $v(recListFile) \
            -title $t(readRecList,title1) -defaultextension "txt" \
            -filetypes { {{reclist file} {.txt}} {{All Files} {*}} }]
  } else {
    set fn [lindex $args 0]
  }
  if {$fn == ""} return
  set v(recListFile) $fn

  if [catch {open $v(recListFile) r} in] { 
    tk_messageBox -message [eval format $t(readRecList,errMsg)]
      -title $t(.confm.fioErr) -icon warning
  } else { 
    if [catch {set data [read -nonewline $in]}] {
      tk_messageBox -message [eval format $t(readRecList,errMsg2)]
        -title $t(.confm.fioErr) -icon warning
    }
    regsub -all {[[:space:]]} $data " " data
    set v(recList) {}
    foreach line [split $data " "] {
      if {$line != ""} {
        lappend v(recList) $line
      }
    }
    close $in
  }
  set v(recSeq) 0
  set v(recLab) [lindex $v(recList) $v(recSeq)]
  set v(msg) [eval format $t(readRecList,doneMsg)]
  #initParamU
}

#---------------------------------------------------
# ^CṽXgt@Cǂ݁AXgɋL
# Xg̍ŏ̗vf "" Ă
#
proc readTypeList {args} {
  global v t

  if {[llength $args] == 0 || ! [file exists $v(typeListFile)]} {
    set fn [tk_getOpenFile -initialfile $v(typeListFile) \
            -title $t(readTypeList,title) -defaultextension "txt" \
            -filetypes { {{typelist file} {.txt}} {{All Files} {*}} }]
  } else {
    set fn [lindex $args 0]
  }
  if {$fn == ""} return
  set v(typeListFile) $fn

  set v(typeList) {""}
  if [catch {open $v(typeListFile) r} in] { 
    tk_messageBox -message [eval format $t(readTypeList,errMsg) \
      -title $t(.confm.fioErr) -icon warning
  } else { 
    if [catch {set data [read -nonewline $in]}] {
      tk_messageBox -message [eval format $t(readTypeList,errMsg2) \
        -title $t(.confm.fioErr) -icon warning
    } else {
      regsub -all {[[:space:]]} $data " " data
      foreach line [split $data " "] {
        if {$line != ""} {
          lappend v(typeList) $line
        }
      }
    }
    close $in
  }
  set v(typeSeq) 0
  set v(typeLab) [lindex $v(typeList) $v(typeSeq)]
  set v(msg) [eval format $t(readTypeList,doneMsg)]
  #initParamU
}

#---------------------------------------------------
# {tHgݒ肷
#
proc fontSetting {} {
  global v t

  switch $::tcl_platform(platform) {
    unix {
      font create bigkfont -family mincho -size $v(bigFontSize) \
        -weight normal -slant roman
      font create kfont -family mincho -size $v(fontSize) \
        -weight normal -slant roman
      font create smallkfont -family mincho -size $v(smallFontSize) \
        -weight normal -slant roman
    }
    windows {
      font create bigkfont -family $t(fontName) -size $v(bigFontSize) \
        -weight normal -slant roman
      font create kfont    -family $t(fontName) -size $v(fontSize) \
        -weight normal -slant roman
      font create smallkfont -family $t(fontName) -size $v(smallFontSize) \
        -weight normal -slant roman
    }
  }
}

#---------------------------------------------------
# IC}jA
#
proc onlineHelp {url} {
    global v t

    if {$::tcl_platform(platform) == "windows"} {
        if {[string match $::tcl_platform(os) "Windows NT"]} {
            exec $::env(COMSPEC) /c start $url &
        } {
            exec start $url &
        }
    } else {
        # atode, ͂߂firefoxɂȂƁBB
        if [catch {exec sh -c "netscape -remote 'openURL($url)' -raise"} res] {
            if [string match *netscape* $res] {
                exec sh -c "netscape $url" &
            }
        }
    }
}

#---------------------------------------------------
# ۑfBNgw肷
# ύX1ALZ0Ԃ
#
proc choosesaveDir {{readParam 0}} {
  global v t

  set d [tk_chooseDirectory -initialdir $v(saveDir) -title $t(choosesaveDir,title)]
  if {$d != ""} {
    set v(saveDir) $d
    set v(msg) [eval format $t(choosesaveDir,doneMsg)]

    #if {$readParam != 0} {
    #  set act [tk_dialog .confm $t(.confm) $t(choosesaveDir,q) \
    #    question 0 $t(.confm.r) $t(.confm.nr)]
    #  set v(paramFile) "$v(saveDir)/oto.ini"
    #  if {$act == 0} readParamFile
    #}
    return 1  ;# ύX
  }
  return 0    ;# ύXȂ
}

#---------------------------------------------------
# ۑłΔg`t@Cɕۑ
#
proc saveWavFile {} {
  global v snd t

  if $v(recStatus) {
    if {[snd length] > 0} {
      if {[file exists $v(saveDir)] == 0} {
        file mkdir $v(saveDir)
      }
      snd write $v(saveDir)/$v(recLab)$v(typeLab).wav 
      set v(msg) [eval format $t(saveWavFile,doneMsg)]
      set v(recStatus) 0
    }
  }
}

#---------------------------------------------------
# t@Cg`ǂ
#
proc readWavFile {} {
  global v snd t

  if {[snd length] > 0} { snd length 0 }
  if {[file readable $v(saveDir)/$v(recLab)$v(typeLab).wav]} {
    snd read $v(saveDir)/$v(recLab)$v(typeLab).wav
  }
}

#---------------------------------------------------
# ϗ̊eK̎g߂
#
proc setSinScale {} {
  global v t
  set v(sinScale) {}
  set v(sinNote) {}
  for {set oct $v(sinScaleMin)} {$oct <= $v(sinScaleMax)} {incr oct} {
    for {set i 0} {$i < 12} {incr i} {
      lappend v(sinScale) [expr int(27.5 * pow(2, $oct + ($i - 9.0)/12.0) + 0.5)]
      lappend v(sinNote) "[lindex $v(toneList) $i]$oct"
    }
  }
}

#---------------------------------------------------
# F0vZɃL[{[hA}EX͂𐧌邽߂̑
# ܂\łĂȂAF0vZ̓͂𐧌ł̂
# Ƃ肠OK(F0vZɓ͂Ɨ邱Ƃ邽)
#
proc waitWindow {message fraction} {
  global t
  set w .waitw
  if {$fraction >= 1.0 && [winfo exists $w]} {
    grab release $w
    destroy $w
    return
  }
  if [winfo exists $w] return

  toplevel $w
  grab set $w
  wm title $w $t(waitWindow,title)
  label $w.l -text "calc.."
  pack $w.l
  wm transient $w .
  wm geom $w +100+100
}

#---------------------------------------------------
#
proc changeTone {chg} {
  global f0 v t
  
  set next [expr [lsearch $v(toneList) $f0(guideTone)] + $chg]

  if {$next < 0} {
    if {$f0(guideOctave) > $v(sinScaleMin)} {
      set next [expr ($next + [llength $v(toneList)])]
      incr f0(guideOctave) -1
    } else {
      set next [lsearch $v(toneList) $f0(guideTone)]
    }
  } elseif {$next >= [llength $v(toneList)]} {
    if {$f0(guideOctave) < $v(sinScaleMax)} {
      set next [expr $next % [llength $v(toneList)]]
      incr f0(guideOctave)
    } else {
      set next [lsearch $v(toneList) $f0(guideTone)]
    }
  }

  set f0(guideTone) [lindex $v(toneList) $next]
  if {$v(playOnsaStatus)} {  ;# [vĐȂA
    toggleOnsaPlay           ;# ~āA
    toggleOnsaPlay           ;# xĐB
  }
}

#---------------------------------------------------
# ^BGM̑
#
proc bgmGuide {} {
  global v bgm t
  if [isExist .bgmg] return ;# dNh~
  toplevel .bgmg
  wm title .bgmg $t(bgmGuide,title)
  bind .bgmg <Escape> {destroy .bgmg}

  label .bgmg.lMode -text $t(bgmGuide,mode)
  radiobutton .bgmg.r1 -variable v(rec) -value 1 -command {bgm stop} \
    -text $t(bgmGuide,r1)
  radiobutton .bgmg.r2 -variable v(rec) -value 2 -command {bgm stop} \
    -text $t(bgmGuide,r2)
  radiobutton .bgmg.r3 -variable v(rec) -value 3 -command {bgm stop} \
    -text $t(bgmGuide,r3)
  radiobutton .bgmg.r4 -variable v(rec) -value 0 -command {bgm stop} \
    -text $t(bgmGuide,r4)

  label .bgmg.lWav -text $t(bgmGuide,bgm)
  frame .bgmg.fWav
  button .bgmg.fWav.b1 -textvar v(bgmFile) -relief solid -command {
    set fn [tk_getOpenFile -initialfile $v(bgmFile) \
            -title $t(bgmGuide,bTitle) -defaultextension "wav" \
            -filetypes { {{wav file} {.wav}} {{All Files} {*}} }]
    if {$fn != ""} {
      set v(bgmFile) $fn
      bgm stop
;#      set v(playMetroStatus) 0
    }
  }
  button .bgmg.fWav.b2 -image snackOpen -highlightthickness 0 -bg $v(bg) -command {
    set fn [tk_getOpenFile -initialfile $v(bgmFile) \
            -title $t(bgmGuide,bTitle) -defaultextension "wav" \
            -filetypes { {{wav file} {.wav}} {{All Files} {*}} }]
    if {$fn != ""} {
      set v(bgmFile) $fn
      bgm stop
;#      set v(playMetroStatus) 0
    }
  }
  button .bgmg.fWav.bp -text $t(bgmGuide,play) -bitmap snackPlay -command {
    testPlayBGM $v(bgmFile)
  }
  button .bgmg.fWav.bs -text $t(bgmGuide,stop) -bitmap snackStop -command {
    testStopBGM 
  }
  pack .bgmg.fWav.b1 -side left -fill x -expand 1
  pack .bgmg.fWav.b2 .bgmg.fWav.bp .bgmg.fWav.bs -side left

  frame .bgmg.fImg
  label .bgmg.fImg.l -text $t(bgmGuide,tplay)
  button .bgmg.fImg.bp -text $t(bgmGuide,play) -bitmap snackPlay -command {
    set ext [file extension $v(bgmFile)]
    testPlayBGM [file rootname $v(bgmFile)]-sample$ext
  }
  button .bgmg.fImg.bs -text $t(bgmGuide,stop) -bitmap snackStop -command {
    testStopBGM 
  }
  pack .bgmg.fImg.l .bgmg.fImg.bp .bgmg.fImg.bs -side left

  grid .bgmg.lMode   -row 0 -column 0 -sticky e
  grid .bgmg.r1      -row 0 -column 1 -sticky w
  grid .bgmg.r2      -row 1 -column 1 -sticky w
  grid .bgmg.r3      -row 2 -column 1 -sticky w
  grid .bgmg.r4      -row 3 -column 1 -sticky w

  grid .bgmg.lWav    -row 4 -column 0 -sticky e
  grid .bgmg.fWav    -row 4 -column 1 -sticky ewsn

  grid .bgmg.fImg    -row 5 -column 1 -sticky ewsn
}

#---------------------------------------------------
# w肵t@CǂݍōĐ
#
proc testPlayBGM {fname} {
  global bgm t
  if [snack::audio active] return
  if ![file exists $fname] {
    tk_messageBox -message "[eval format $t(testPlayBGM,errMsg)] (fname=$fname)" \
      -title $t(testPlayBGM,errTitle) -icon warning -parent .bgmg
    return
  }
  bgm read $fname
  bgm play
}

#---------------------------------------------------
# BGM~
#
proc testStopBGM {} {
  global bgm t
  bgm stop
}


#---------------------------------------------------
# gm[̑
#
proc tempoGuide {} {
  global v metro t
  if [isExist .tg] return ;# dNh~
  toplevel .tg
  wm title .tg $t(tempoGuide,title)

  bind .tg <KeyPress-m>     toggleMetroPlay
  bind .tg <KeyPress-M>     toggleMetroPlay
  bind .tg <Escape>         {destroy .tg}

  label .tg.lwav -text $t(tempoGuide,click)
  button .tg.bwav -textvar v(clickWav) -relief solid -command {
    set fn [tk_getOpenFile -initialfile $v(clickWav) \
            -title $t(tempoGuide,clickTitle) -defaultextension "wav" \
            -filetypes { {{wav file} {.wav}} {{All Files} {*}} }]
    if {$fn != ""} {
      set v(clickWav) $fn
      metro stop
      set v(playMetroStatus) 0
    }
  }

  label .tg.l -text $t(tempoGuide,tempo)
  entry .tg.ebpm -textvar v(tempo) -validate key -validatecommand {
          if {![string is integer %P]} {return 0}
          if {%P <= 0} {return 0}
          set v(tempoMSec) [expr 60000.0 / double(%P)]
          metro stop
          set v(playMetroStatus) 0
          return 1
        }
  label .tg.lbpm -text $t(tempoGuide,bpm)
  label .tg.lbpmSec1 -textvar v(tempoMSec) -fg red
  label .tg.lbpmSec2 -text $t(tempoGuide,bpmUnit)
  label .tg.mes -text $t(tempoGuide,comment)

  grid .tg.lwav -row 0 -column 0 -sticky e
  grid .tg.bwav -row 0 -column 1 -columnspan 4 -sticky nesw

  grid .tg.l        -row 1 -column 0 -sticky e
  grid .tg.ebpm     -row 1 -column 1 -sticky nesw
  grid .tg.lbpm     -row 1 -column 2 -sticky w
  grid .tg.lbpmSec1 -row 1 -column 3 -sticky e
  grid .tg.lbpmSec2 -row 1 -column 4 -sticky w

  grid .tg.mes -row 2 -columnspan 5
}

#---------------------------------------------------
# gw肵singĐ
#
proc pitchGuide {} {
  global v f0 t
  if [isExist .pg] return ;# dNh~
  toplevel .pg
  wm title .pg $t(pitchGuide,title)

  bind .pg <KeyPress-Up>    {changeTone 1}
  bind .pg <KeyPress-8>     {changeTone 1}
  bind .pg <KeyPress-Down>  {changeTone -1}
  bind .pg <KeyPress-2>     {changeTone -1}
  bind .pg <KeyPress-Left>  {changeTone -12}
  bind .pg <KeyPress-4>     {changeTone -12}
  bind .pg <KeyPress-Right> {changeTone 12}
  bind .pg <KeyPress-6>     {changeTone 12}
  bind .pg <KeyPress-o>     toggleOnsaPlay
  bind .pg <KeyPress-O>     toggleOnsaPlay
  bind .pg <Escape>         {destroy .pg}

  packToneList .pg.tl $t(pitchGuide,sel) guideTone guideOctave guideFreqTmp 10 guideVol

  pack [frame .pg.vl] -fill x
  label .pg.vl.l -text $t(pitchGuide,vol)
  scale .pg.vl.s -from 0 -to 32768 -show no -var f0(guideVol) -orient horiz
  pack .pg.vl.l -side left -anchor nw
  pack .pg.vl.s -side left -anchor nw -fill x -expand 1
  label .pg.mes -text $t(pitchGuide,comment)
  pack .pg.mes -side left -anchor nw

  ;# eɑΉgvZĕ\(ɉ)
  ;# orIN^[uɕωΎgvZs
  ;# gf0(guideFreq)łȂf0(guideFreqTmp)ɓ̂́A
  ;#uOKvoruKpv{^܂ŒlύX𔽉fȂ߁B
  set f0(guideFreqTmp) [tone2freq "$f0(guideTone)$f0(guideOctave)"]
  trace variable f0 w calcGuideFreq
  proc calcGuideFreq {var elm mode} {
    global f0 t
    switch $elm {
      "guideTone" -
      "guideOctave" {
        set f0(guideFreqTmp) [tone2freq "$f0(guideTone)$f0(guideOctave)"]
      }
    }
  }
  bind .pg <Destroy> { trace vdelete f0 w calcGuideFreq }
}

#---------------------------------------------------
# w肵g[Hz]singĐ
#
proc playSin {freq vol length} {
  global v onsa t
  if [snack::audio active] return
  if $::debug {puts $freq}
  if {$freq > 10 && $vol > 0} { 
#    set f [snack::filter generator $freq $vol 0.0 sine $v(sampleRate)]
    set g  [snack::filter generator $freq $vol 0.01 triangle $length]
    set f1 [snack::filter formant 500 50]
    set f2 [snack::filter formant 1500 75]
    set f3 [snack::filter formant 2500 100]
    set f4 [snack::filter formant 3500 150]
    set f  [snack::filter compose $g $f1 $f2 $f3 $f4]
    onsa play -filter $f -command "$f destroy" 
  }
}

#---------------------------------------------------
# Ỏ̎^Ɉړ
#
proc prevRec {args} { 
  global v rec t

  # 
  array set a [list -save 1]
  array set a $args

  set v(msg) ""
  if $a(-save) { saveWavFile }
  $rec selection clear $v(recSeq)
  if {$v(recSeq) > 0} {
    incr v(recSeq) -1
    $rec see [expr $v(recSeq) - 2]
  } else {
    set v(recSeq) [expr [llength $v(recList)] - 1]
    $rec see $v(recSeq)
  }
  $rec selection set $v(recSeq)
  set v(recLab) [lindex $v(recList) $v(recSeq)] 
  set v(recStatus) 0
  readWavFile
  Redraw all
  if $::debug {puts "Ỏ, recseq=$v(recSeq), v(recLab)=$v(recLab)"}
}

#---------------------------------------------------
# ̉̎^Ɉړ
#
proc nextRec {args} { 
  global v rec t

  # 
  array set a [list -save 1]
  array set a $args

  set v(msg) ""
  if $a(-save) { saveWavFile }
  $rec selection clear $v(recSeq)
  if {$v(recSeq) < [expr [llength $v(recList)] - 1]} {
    incr v(recSeq)
    $rec see [expr $v(recSeq) + 2]
  } else {
    set v(recSeq) 0
    $rec see 0
  }
  $rec selection set $v(recSeq)
  set v(recLab) [lindex $v(recList) $v(recSeq)] 
  set v(recStatus) 0
  readWavFile
  Redraw all
  if $::debug { puts "̉, recseq=$v(recSeq), v(recLab)=$v(recLab)" }
}

#---------------------------------------------------
# w肵ԍ̉̎^Ɉړ
#
proc jumpRec {index args} { 
  global v rec t

  # 
  array set a [list -save 1]
  array set a $args

  if {$v(recSeq) == $index} return
  set v(msg) ""
  if $a(-save) { saveWavFile }
  $rec selection clear $v(recSeq)
  set v(recSeq) $index
  $rec see $v(recSeq)
  $rec selection set $v(recSeq)
  set v(recLab) [lindex $v(recList) $v(recSeq)] 
  set v(recStatus) 0
  readWavFile
  Redraw all
  if $::debug { puts "̉, recseq=$v(recSeq), v(recLab)=$v(recLab)" }
}

#---------------------------------------------------
# O̔b^Cv̎^Ɉړ
#
proc prevType {args} { 
  global v type t

  # 
  array set a [list -save 1]
  array set a $args

  set v(msg) ""
  if $a(-save) { saveWavFile }
  $type selection clear $v(typeSeq)
  if {$v(typeSeq) > 0} {
    incr v(typeSeq) -1
  } else {
    set v(typeSeq) [expr [llength $v(typeList)] - 1]
  }
  $type see $v(typeSeq)
  $type selection set $v(typeSeq)
  set v(typeLab) [lindex $v(typeList) $v(typeSeq)] 
  set v(recStatus) 0
  readWavFile
  Redraw all
  if $::debug { puts "Õ^Cv, typeseq=$v(typeSeq), v(typeLab)=$v(typeLab)" }
}

#---------------------------------------------------
# ̔b^Cv̎^Ɉړ
#
proc nextType {args} { 
  global v type t

  # 
  array set a [list -save 1]
  array set a $args

  set v(msg) ""
  if $a(-save) { saveWavFile }
  $type selection clear $v(typeSeq)
  if {$v(typeSeq) < [expr [llength $v(typeList)] - 1]} {
    incr v(typeSeq)
  } else {
    set v(typeSeq) 0
  }
  $type see $v(typeSeq)
  $type selection set $v(typeSeq)
  set v(typeLab) [lindex $v(typeList) $v(typeSeq)] 
  set v(recStatus) 0
  readWavFile
  Redraw all
  if $::debug { puts "̃^Cv, typeseq=$v(typeSeq), v(typeLab)=$v(typeLab)" }
}

#---------------------------------------------------
# w肵ԍ̔^Cv̎^Ɉړ
#
proc jumpType {index args} { 
  global v type t

  # 
  array set a [list -save 1]
  array set a $args

  if {$v(typeSeq) == $index} return
  set v(msg) ""
  if $a(-save) { saveWavFile }
  $type selection clear $v(typeSeq)
  set v(typeSeq) $index
  $type see $v(typeSeq)
  $type selection set $v(typeSeq)
  set v(typeLab) [lindex $v(typeList) $v(typeSeq)] 
  set v(recStatus) 0
  readWavFile
  Redraw all
  if $::debug { puts "̉, typeseq=$v(typeSeq), v(typeLab)=$v(typeLab)" }
}

#---------------------------------------------------
# DC
#
proc removeDC {} {
  global snd t
  set flt [snack::filter iir -numerator "0.99 -0.99" -denominator "1 -0.99"] 
  snd filter $flt -continuedrain 0
}

#---------------------------------------------------
# g`Ɋgk(ctrl+}EXzC[)
# mode=1...g, mode=0...k
#
proc changeWidth {mode} {
  global v t
  if $mode {
    incr v(cWidth) +40
  } elseif {$v(cWidth) <= $v(cWidthMin)} {
    set v(cWidth) $v(cWidthMin)
  } else {
    incr v(cWidth) -40
  }
  Redraw scale
}

#---------------------------------------------------
# Xg{bNXɊgk(ctrl+}EXzC[)
# mode=1...g, mode=0...k
#
proc changeRecListWidth {mode} {
  global rec t
  set width [$rec cget -width]
  if $mode {
    $rec configure -width [expr $width +1]   ;# g
  } elseif {$width > 5} {
    $rec configure -width [expr $width -1]   ;# k
  }
}

#---------------------------------------------------
# ^CvXg{bNXɊgk(ctrl+}EXzC[)
# mode=1...g, mode=0...k
#
proc changeTypeListWidth {mode} {
  global type t
  set width [$type cget -width]
  if $mode {
    $type configure -width [expr $width +1]   ;# g
  } elseif {$width > 5} {
    $type configure -width [expr $width -1]   ;# k
  }
}

#---------------------------------------------------
# ^Jn(BGM)
#
proc autoRecStart {} {
  global bgm bgmParam v t

  if [snack::audio active] return
  if {$v(rec) == 0} return   ;# ^[hłȂȂI

  ;# BGMt@Cǂݍ
  if ![file exists $v(bgmFile)] {
    tk_messageBox -title $t(.confm.fioErr) -icon error \
      -message [eval format $t(autoRecStart,errMsg)]
    return
  }
  bgm read $v(bgmFile)

  ;# BGMݒt@Cǂݍ
  set v(bgmParamFile) [file rootname $v(bgmFile)].txt
  if [catch {open $v(bgmParamFile) r} fp] {
    tk_messageBox -title $t(.confm.fioErr) -icon error \
      -message [eval format $t(autoRecStart,errMsg2)]
    return
  }

  set unit [regsub -all -- {,} [string trim [gets $fp]] ""]   ;# Pʂ擾
  if ![regexp {^(sec|SEC|msec|MSEC|sample)$} $unit] {
    tk_messageBox -message "[eval format $t(autoRecStart,errMsg3)] ($t(autoRecStart,unit)=$unit)" -icon warning
    return
  }
  array unset bgmParam
  set bgmParam(autoRecStatus) 0  ;# ȉ̉͒ɃG[ꍇ0return
  set sr [bgm cget -rate]
  while {![eof $fp]} {
    set l [gets $fp]
    if {[regexp {^[[:space:]]*#} $l]} continue
    set p [split $l ","] ;# s,,^Jn,^~,̎^ֈړ,s[g
    if {[llength $p] >= 6} {
      set seq [string trim [lindex $p 0]]
      set bgmParam($seq,pStart)  [val2samp [string trim [lindex $p 1]] $unit $sr]
      set bgmParam($seq,rStart)  [string trim [lindex $p 2]]
      set bgmParam($seq,rStop)   [string trim [lindex $p 3]]
      set bgmParam($seq,nextRec) [string trim [lindex $p 4]]
      set bgmParam($seq,repeat)  [string trim [lindex $p 5]]
      if {[llength $p] >= 7} {
        set bgmParam($seq,msg)   [string trim [lindex $p 6]]
      } else {
        set bgmParam($seq,msg)   ""
      }
      set bgmParam($seq,repeat)  [string trim [lindex $p 5]]
      if {$seq > 1} {
        if {$bgmParam([expr $seq - 1],repeat) != 0} {
          set bgmParam([expr $seq - 1],pStop) $bgmParam([expr $seq - 1],pStart)
        } else {
          set bgmParam([expr $seq - 1],pStop) [expr $bgmParam($seq,pStart) - 1]
        }
      }
    }
  }
  close $fp
  if {$bgmParam($seq,repeat) != 0} {
    set bgmParam($seq,pStop) $bgmParam($seq,pStart)
  } else {
    ;# XpQeBȐݒt@C̏ꍇÃG[`FbNʂ\
    tk_messageBox -message [eval format $t(autoRecStart,errMsg4)] -icon error
    return
    ;# set bgmParam($seq,pStop) [bgm length]  ;# BGM
  }

  set bgmParam(autoRecStatus) 1
  set v(recStatus) 1
  .msg.msg configure -fg blue
  autoRec 1 ;# BGMĐE^Jn
}

#---------------------------------------------------
# ^Jn(KChBGMĐ,^Jn/~BċAIɌĂ΂)
#
proc autoRec {seq} {
  global bgm bgmParam v t
  if $bgmParam(autoRecStatus) {
    set com ""
    if {$bgmParam($seq,repeat) != 0} {
      if {$v(rec) == 3} {
        set com "autoRec $bgmParam($seq,repeat)"  ;#s[g
      } else {
        autoRecStop                               ;#s[gI
        return
      }
    } else {
      set com "autoRec [expr $seq + 1]"
    }
    if {$bgmParam($seq,rStart) != 0} {
      .msg.msg configure -fg red
      aRecStart
    }
    if {$bgmParam($seq,rStop)   != 0} {
      .msg.msg configure -fg blue
      aRecStop
    }
    if {$bgmParam($seq,nextRec) != 0} {
      if {$v(rec) == 3 && $v(recSeq) < [expr [llength $v(recList)] - 1]} {
        .msg.msg configure -fg blue
        nextRec                             ;# ̉
      } else {
        autoRecStop                         ;# ̉֍sI
        return
      }
    }
    set v(msg) $bgmParam($seq,msg)
    bgm play -start $bgmParam($seq,pStart) -end $bgmParam($seq,pStop) -command $com
  }
}

#---------------------------------------------------
# Ŏw肵Pʂ̒lTvPʂɕϊ
#
proc val2samp {val from sr} {
  switch $from {
    MSEC -
    msec { ;# msec  TvPʂɕϊ
      return [expr int($val / 1000.0 * $sr)]
    }
    SEC  -
    sec  { ;# sec  TvPʂɕϊ
      return [expr int($val * $sr)]
    }
    default { ;# ̂܂ܕԂ(Ôߐ)
      return int($val);
    }
  }
}

#---------------------------------------------------
# ^Jn
#
proc aRecStart {} {
  global snd v bgmParam t
  if {$v(rec) == 0 || $bgmParam(autoRecStatus) == 0} return   ;# ^[hłȂȂI
  snd record
  set v(recStatus) 1
}

#---------------------------------------------------
# ^I
#
proc aRecStop {} {
  global snd v t
  if {$v(rec) == 0} return   ;# ^[hłȂȂI
  snd stop
  if $v(removeDC) removeDC
;#  Redraw all
}

proc autoRecStop {} {
  global bgm bgmParam v t
  set bgmParam(autoRecStatus) 0
  bgm stop   ;# {͂Ŏ~܂ė~ǎ~܂ĂȂBB
  .msg.msg configure -fg black
  set v(msg) [eval format $t(autoRecStop,doneMsg)]
  aRecStop
}

#---------------------------------------------------
# gm[Đ/~̐ؑ
#
proc toggleMetroPlay {} {
  global v metro t

  if $v(playMetroStatus) {
    set v(msg) $t(toggleMetroPlay,stopMsg)
    metro stop  ;# {͂Ŏ~܂ė~~܂Ȃ
    set v(playMetroStatus) 0
  } else {
    ;# e|̃`FbN
    if {$v(tempo) < 50 || $v(tempo) > 200} {
      tk_messageBox -title $t(toggleMetroPlay,errTitle) -icon error \
        -message [eval format $t(toggleMetroPlay,errMsg)]
      return
    }
    if ![file exists $v(clickWav)] {
      tk_messageBox -title $t(toggleMetroPlay,errTitle) -icon error \
        -message [eval format $t(toggleMetroPlay,errMsg2)]
      return
    }
    metro read $v(clickWav)
    set v(playMetroStatus) 1
    loopPlay metro [expr int($v(tempoMSec) / 1000.0 * [metro cget -rate])]
    set v(msg) $t(toggleMetroPlay,playMsg)
  }
}

#---------------------------------------------------
# wav[vĐ
#
proc loopPlay {s end} {
  global v t
  if $v(playMetroStatus) {
    $s play -start 0 -end $end -command "loopPlay $s $end"
  }
}

#---------------------------------------------------
# Đ/~̐ؑ
#
proc toggleOnsaPlay {} {
  global v f0 onsa t

  if $v(playOnsaStatus) {
    set v(msg) $t(toggleOnsaPlay,stopMsg)
    onsa stop
    set v(playOnsaStatus) 0
  } else {
    set v(msg) $t(toggleOnsaPlay,playMsg)
    set v(playOnsaStatus) 1
    playSin [tone2freq $f0(guideTone)$f0(guideOctave)] \
      $f0(guideVol) -1
  }
}

#---------------------------------------------------
# Đ/~̐ؑ
#
proc togglePlay {{start 0} {end -1}} {
  global v snd t

  if $v(playStatus) {
    snd stop
    set v(playStatus) 0
    set v(msg) $t(togglePlay,stopMsg)
  } else {
    set v(msg) $t(togglePlay,playMsg)
    set v(playStatus) 1
    snd play -start $start -end $end -command {
      set v(playStatus) 0       ;# ĐIƂ̏
      set v(msg) $t(togglePlay,stopMsg)
    }
  }
}

#---------------------------------------------------
# ^C~O␳[hON/OFF̐ؑ
#
proc timingAdjMode {} {
  global v t

  if $v(timingAdjMode) {
    tk_messageBox -message [eval format $t(timingAdjMode,startMsg)] \
      -icon info
    set v(msg)  $t(timingAdjMode,on)
  } else {
    tk_messageBox -message [eval format $t(timingAdjMode,doneMsg)] \
      -icon info
    set v(msg)  $t(timingAdjMode,off)
  }
}

#---------------------------------------------------
# g`\/\̐ؑ
#
proc toggleWave {} {
  global v t

  ;#if [snack::audio active] return
  if $v(showWave) {
      set v(waveh) $v(wavehbackup)
  } else {
      set v(wavehbackup) $v(waveh)
      set v(waveh) 0
  }
  Redraw wave
}

#---------------------------------------------------
# XyNg\/\̐ؑ
#
proc toggleSpec {} {
  global v t

  ;#if [snack::audio active] return
  if $v(showSpec) {
      set v(spech) $v(spechbackup)
  } else {
      set v(spechbackup) $v(spech)
      set v(spech) 0
  }
  Redraw spec
}

#---------------------------------------------------
# p[\/\̐ؑ
#
proc togglePow {} {
  global v t

  ;#if [snack::audio active] return
  if $v(showpow) {
      set v(powh) $v(powhbackup)
  } else {
      set v(powhbackup) $v(powh)
      set v(powh) 0
  }
  Redraw pow
}

#---------------------------------------------------
# F0\/\̐ؑ
#
proc toggleF0 {} {
  global v t

  ;#if [snack::audio active] return
  if $v(showf0) {
      set v(f0h) $v(f0hbackup)
  } else {
      set v(f0hbackup) $v(f0h)
      set v(f0h) 0
  }
  Redraw f0
}

#---------------------------------------------------
# UTAUpp[^\/\̐ؑ
#
proc toggleParam {} {
  global v t

  Redraw param
}

#---------------------------------------------------
# p[pl̏c\
# snack  unix/snack.tcl  frequencyAxis 
proc powerAxis {canvas x y width height args} {
  # 
  array set a [list \
    -tags snack_y_axis -font {Helvetica 8} -pwMax 100 \
    -fill black -draw0 0 -pwMin 0]
  array set a $args

  if {$height <= 0} return
  if {$a(-pwMax) <= $a(-pwMin)} return

  ;# ticklist...ڐ̊Ԋǔ
  set ticklist [list 1 2 5 10 20 50 100 200 500]
  set npt 1   ;# npt...ڐ̒l̊Ԋu
  ;# dy...ڐ`悷Ԋu(yW)
  set dy [expr {double($height * $npt) / ($a(-pwMax) - $a(-pwMin))}]

  while {$dy < [font metrics $a(-font) -linespace]} {
    foreach elem $ticklist {
      if {$elem <= $npt} {
        continue
      }
      set npt $elem
      break
    }
    set dy [expr {double($height * $npt) / ($a(-pwMax) - $a(-pwMin))}]
  }
  set hztext dB

  if $a(-draw0) {
    set i0 0
    set j0 0
  } else {
    set i0 $dy
    set j0 1
  }

  if {$a(-pwMin) != 0} {
    set j0 [expr int($a(-pwMin) / $npt) + 1]
  }

  for {set i $i0; set j $j0} {$i < $height} {set i [expr {$i+$dy}]; incr j} {
    set yc [expr {$height + $y - $i}]  ;# `悷yW

    if {$npt < 1000} {
      set tm [expr {$j * $npt}]
    } else {
      set tm [expr {$j * $npt / 1000}]
    }
    if {$yc > [expr {8 + $y}]} {
      if {[expr {$yc - [font metrics $a(-font) -ascent]}] > \
          [expr {$y + [font metrics $a(-font) -linespace]}] ||
          [font measure $a(-font) $hztext]  < \
          [expr {$width - 8 - [font measure $a(-font) $tm]}]} {
        $canvas create text [expr {$x +$width - 8}] [expr {$yc-2}]\
          -text $tm -fill $a(-fill)\
          -font $a(-font) -anchor e -tags $a(-tags)
      }
      $canvas create line [expr {$x + $width - 5}] $yc \
        [expr {$x + $width}]\
        $yc -tags $a(-tags) -fill $a(-fill)
    }
  }
  $canvas create text [expr {$x + 2}] [expr {$y + 1}] -text $hztext \
    -font $a(-font) -anchor nw -tags $a(-tags) -fill $a(-fill)

  return $npt
}

#---------------------------------------------------
# F0pl̏c\
# snack  unix/snack.tcl  frequencyAxis 
proc f0Axis {canvas x y width height args} {
  # 
  array set a [list \
    -tags snack_y_axis -font {Helvetica 8} -f0Max 100 \
    -fill black -draw0 0 -f0Min 0 -unit Hz]
  array set a $args

  if {$height <= 0} return
  if {$a(-f0Max) <= $a(-f0Min)} return

  ;# ticklist...ڐ̊Ԋǔ
  set ticklist [list 1 2 5 10 20 50 100 200 500]
  set npt 1   ;# npt...ڐ̒l̊Ԋu
  ;# dy...ڐ`悷Ԋu(yW)
  set dy [expr {double($height * $npt) / ($a(-f0Max) - $a(-f0Min))}]

  while {$dy < [font metrics $a(-font) -linespace]} {
    foreach elem $ticklist {
      if {$elem <= $npt} {
        continue
      }
      set npt $elem
      break
    }
    set dy [expr {double($height * $npt) / ($a(-f0Max) - $a(-f0Min))}]
  }
  set hztext $a(-unit)
  if {$hztext == "semitone"} {set hztext st} ;# \Zk

  if $a(-draw0) {
    set i0 0
    set j0 0
  } else {
    set i0 $dy
    set j0 1
  }

  if {$a(-f0Min) != 0} {
    set j0 [expr int($a(-f0Min) / $npt) + 1]
  }

  ;# j=`悷ڐ̔ԍ, i=`WɊւϐ
  for {set i $i0; set j $j0} {$i < $height} {set i [expr {$i+$dy}]; incr j} {
    set yc [expr {$height + $y - $i}]  ;# `悷yW

    if {$npt < 1000} {
      set tm [expr {$j * $npt}]
    } else {
      set tm [expr {$j * $npt / 1000}]
    }
    if {$yc > [expr {8 + $y}]} {
      if {[expr {$yc - [font metrics $a(-font) -ascent]}] > \
          [expr {$y + [font metrics $a(-font) -linespace]}] ||
          [font measure $a(-font) $hztext]  < \
          [expr {$width - 8 - [font measure $a(-font) $tm]}]} {
        $canvas create text [expr {$x +$width - 8}] [expr {$yc-2}]\
          -text $tm -fill $a(-fill)\
          -font $a(-font) -anchor e -tags $a(-tags)
      }
      $canvas create line [expr {$x + $width - 5}] $yc \
        [expr {$x + $width}]\
        $yc -tags $a(-tags) -fill $a(-fill)
    }
  }
  $canvas create text [expr {$x + 2}] [expr {$y + 1}] -text $hztext \
    -font $a(-font) -anchor nw -tags $a(-tags) -fill $a(-fill)

  return $npt
}

#---------------------------------------------------
# FI
#
proc chooseColor {w key initcolor} {
  global v t
  set ctmp [tk_chooseColor -initialcolor $initcolor -title $t(chooseColor,title)]
  if {$ctmp != ""} {
    set v($key) $ctmp
    $w configure -bg $v($key)
  }
}

#---------------------------------------------------
# ɑΉgԂ
#
proc tone2freq {tone} {
  global v t
  for {set i 0} {$i < [llength $v(sinNote)]} {incr i} {
    if {$tone == [lindex $v(sinNote) $i]} break
  }
  return [lindex $v(sinScale) $i]
}

#---------------------------------------------------
# g`Fݒ
#
proc setColor {w key msg} {
  global v t

  set ic $v($key)
  pack [frame $w.$key] -anchor nw
  label  $w.$key.l  -text $msg -width 20 -anchor nw
  label  $w.$key.l2 -textvar v($key) -width 7 -anchor nw -bg $v($key)
  button $w.$key.b  -text $t(setColor,selColor) -command "chooseColor $w.$key.l2 $key $ic"
  pack $w.$key.l $w.$key.l2 $w.$key.b -side left
}

#---------------------------------------------------
# 1Hzɑ΂gZ~g[ɂ
#
proc hz2semitone {hz} {
  return [expr log($hz) / log(2) * 12.0]
}


#---------------------------------------------------
# ږF[Gg[]̃t[Ĕzu(powerp)
#
proc packEntryPower {wname text key} {
  global power t
  pack [frame $wname] -anchor w
  label $wname.lfl -text $text -width 20 -anchor w
  entry $wname.efl -textvar power($key) -wi 6
  pack $wname.lfl $wname.efl -side left
}

#---------------------------------------------------
# ږF[Gg[]̃t[Ĕzu(f0p)
#
proc packEntryF0 {wname text key} {
  global f0 t
  pack [frame $wname] -anchor w
  label $wname.lfl -text $text -width 20 -anchor w
  entry $wname.efl -textvar f0($key) -wi 6
  pack $wname.lfl $wname.efl -side left
}

#---------------------------------------------------
# ̑Ij[packt[𐶐
#
proc packToneList {w text toneKey octaveKey freqKey width vol} {
  global f0 v t
  pack [frame $w] -fill x
  # ږx
  label $w.l -text $text -width $width -anchor w
  # I
  eval tk_optionMenu $w.t f0($toneKey) $v(toneList)
  # IN^[uI
  set ss {}
  for {set i $v(sinScaleMin)} {$i <= $v(sinScaleMax)} {incr i} {
    lappend ss $i
  }
  eval tk_optionMenu $w.o f0($octaveKey) $ss
  # {^
  button $w.play -text $t(packToneList,play) -bitmap snackPlay -command \
    "playSin \[tone2freq \$f0($toneKey)\$f0($octaveKey)\] \$f0($vol) \$v(sampleRate)"
  button $w.togglePlay -text $t(packToneList,repeat) -command {
    toggleOnsaPlay
  }
  # ɑΉg\郉x
  label $w.$freqKey -textvar f0($freqKey) -width 3 -anchor e
  label $w.unit -text "Hz"
  pack $w.l $w.t $w.o $w.play $w.togglePlay $w.$freqKey $w.unit -side left
}

#---------------------------------------------------
#   o̓foCXobt@TCY
#
proc audioSettings {} {
  global dev snd bgm t

  set dev(in)   [encoding convertfrom [lindex [snack::audio inputDevices]  0]]
  set dev(out)  [encoding convertfrom [lindex [snack::audio outputDevices] 0]]
  set dev(ingain)    [snack::audio record_gain]
  set dev(outgain)   [snack::audio play_gain]
  set dev(latency)   [snack::audio playLatency]
  set dev(sndBuffer) [snd cget -buffersize]
  set dev(bgmBuffer) [bgm cget -buffersize]
  # snack::audio selectInput $dev(in) ;# R[hΉ
}

#---------------------------------------------------
#   o̓foCX̐ݒ葋̒lfoCXɔf
#
proc setIODevice {} {
  global dev snd bgm t
  ;# dev(in),dev(out)ɂ̓j[\̂ߊR[hsjisutf-8
  ;# ϊĂBfoCXݒ莞ɂ͌̊R[h
  ;# w肵ȂƃG[ɂȂlqȂ̂ňȉ̂悤ȃR[hőΉĂ
  foreach dname [snack::audio inputDevices] {
    if {$dev(in) == [encoding convertfrom $dname]} {
      snack::audio selectInput  $dname
      break
    }
  }
  foreach dname [snack::audio outputDevices] {
    if {$dev(out) == [encoding convertfrom $dname]} {
      snack::audio selectOutput $dname
      break
    }
  }
  snack::audio record_gain  $dev(ingain)
  snack::audio play_gain    $dev(outgain)
  snack::audio playLatency  $dev(latency)
  snd configure -buffersize $dev(sndBuffer)
  bgm configure -buffersize $dev(bgmBuffer)
}

#---------------------------------------------------
#   ݂̐ݒۑ
#
proc saveSettings {} {
  global startup bgmParam v f0 power startup dev uttTiming genParam estimate t

  set fn [tk_getSaveFile -initialfile $startup(initFile) \
            -title $t(saveSettings,title) -defaultextension "tcl" ]
  if {$fn == ""} return

  set aList {bgmParam v f0 power startup dev uttTiming genParam estimate}

  set fp [open $fn w]   ;# ۑt@CJ

  foreach aName $aList {
    set sList [array get $aName]
    foreach {key value} $sList {
      if {$aName == "v" && $key != "paramChanged" 
                        && $key != "msg"
                        && $key != "version"} {
        puts $fp [format "set %s(%s)\t\t{%s}" $aName $key $value]
      }
    }
  }
  close $fp
}

#---------------------------------------------------
#   w肵Nς݂`FbNBNς݂ȂtH[JXB
#
proc isExist {w} {
  if [winfo exists $w] {
    raise $w
    focus $w
    return 1
  } else {
    return 0
  }
}

#---------------------------------------------------
#   o̓foCXobt@TCYݒ肷鑋
#
proc ioSettings {} {
  global ioswindow dev dev_bk snd bgm t

  if [isExist $ioswindow] return ;# dNh~
  toplevel $ioswindow
  wm title $ioswindow $t(ioSettings,title)
  bind $ioswindow <Escape> {destroy $ioswindow}

  ;# QCACeV̍ŐV󋵂擾
  set dev(ingain)  [snack::audio record_gain]
  set dev(outgain) [snack::audio play_gain]
  set dev(latency) [snack::audio playLatency]
  set dev(sndBuffer) [snd cget -buffersize]
  set dev(bgmBuffer) [bgm cget -buffersize]

  array set dev_bk [array get dev]     ;# p[^obNAbv

  ;# ̓foCX̑I
  set devList {}
  foreach d [snack::audio inputDevices] {
    set d [encoding convertfrom $d]
    lappend devList "$d"
    # if {[string length $d] == [string bytelength $d]} {  ;# pfoCX̂ݓo^
    #  lappend devList "$d"
    # }
  }
  set f1 [frame $ioswindow.f1]
  label $f1.l -text $t(ioSettings,inDev) -width 12 -anchor w
  eval tk_optionMenu $f1.in dev(in) $devList
  pack $f1.l $f1.in -side left
  pack $f1 -anchor w

  ;# o̓foCX̑I
  set devList {}
  foreach d [snack::audio outputDevices] {
    set d [encoding convertfrom $d]
    lappend devList "$d"
    #if {[string length $d] == [string bytelength $d]} {  ;# pfoCX̂ݓo^
    #  lappend devList "$d"
    #}
  }
  set f2 [frame $ioswindow.f2]
  label $f2.l -text $t(ioSettings,outDev) -width 12 -anchor w
  eval tk_optionMenu $f2.out dev(out) $devList
  pack $f2.l $f2.out -side left
  pack $f2 -anchor w

  ;# ̓QC̎w
  set f3 [frame $ioswindow.f3]
  label $f3.l -text $t(ioSettings,inGain) -width 28 -anchor w
  entry $f3.e -textvar dev(ingain) -wi 6
  scale $f3.s -variable dev(ingain) -orient horiz \
    -from 0 -to 100 -res 1 -showvalue 0
  pack $f3.l $f3.e $f3.s -side left
  pack $f3 -anchor w

  ;# o̓QC̎w
  set f4 [frame $ioswindow.f4]
  label $f4.l -text $t(ioSettings,outGain) -width 28 -anchor w
  entry $f4.e -textvar dev(outgain) -wi 6
  scale $f4.s -variable dev(outgain) -orient horiz \
    -from 0 -to 100 -res 1 -showvalue 0
  pack $f4.l $f4.e $f4.s -side left
  pack $f4 -anchor w

  ;# CeV̎w
  set f5 [frame $ioswindow.f5]
  label $f5.l -text $t(ioSettings,latency) -width 28 -anchor w
  entry $f5.e -textvar dev(latency) -wi 6
  label $f5.u -text "(msec)"
  pack $f5.l $f5.e $f5.u -side left
  pack $f5 -anchor w

  ;# ^̃obt@TCY̎w
  set f6 [frame $ioswindow.f6]
  label $f6.l -text $t(ioSettings,sndBuffer) -width 28 -anchor w
  entry $f6.e -textvar dev(sndBuffer) -wi 6
  label $f6.u -text "(sample)"
  pack $f6.l $f6.e $f6.u -side left
  pack $f6 -anchor w

  ;# KChBGM̃obt@TCY̎w
  set f7 [frame $ioswindow.f7]
  label $f7.l -text $t(ioSettings,bgmBuffer) -width 28 -anchor w
  entry $f7.e -textvar dev(bgmBuffer) -wi 6
  label $f7.u -text "(sample)"
  pack $f7.l $f7.e $f7.u -side left
  pack $f7 -anchor w

  ;# {^
  set fb [frame $ioswindow.fb]
  button $fb.ok -text $t(.confm.ok) -wi 6 -command {
    setIODevice
    destroy $ioswindow
  }
  button $fb.ap -text $t(.confm.apply) -wi 6 -command {
    setIODevice
    array set dev_bk [array get dev]     ;# p[^obNAbv
  }
  button $fb.cn -text $t(.confm.c) -wi 6 -command {
    array set dev [array get dev_bk]     ;# p[^ȑȌԂɖ߂
    setIODevice
    destroy $ioswindow
  }
  pack $fb.ok $fb.ap $fb.cn -side left
  pack $fb -anchor w

  ;# 
  set fm [frame $ioswindow.fm]
  label $fm.lm0  -fg red -text $t(ioSettings,comment0)
  label $fm.lm0b -fg red -text $t(ioSettings,comment0b)
  label $fm.lm1  -fg red -text $t(ioSettings,comment1)
  label $fm.lm2  -fg red -text $t(ioSettings,comment2)
  pack $fm.lm0 $fm.lm0b $fm.lm1 $fm.lm2 -anchor w -side top
  pack $fm -anchor w

  raise $ioswindow
  focus $ioswindow
}

#---------------------------------------------------
# vOXo[ĕ\
#
proc initProgressWindow {{title "now processing..."}} {
  global prgWindow v
  if [isExist $prgWindow] return

  toplevel $prgWindow
  wm title $prgWindow $title
  wm attributes $prgWindow -toolwindow 1
  wm attributes $prgWindow -topmost 1
  set topg [split [wm geometry .] "x+"]
  set x [expr [lindex $topg 2] + [lindex $topg 0] / 2 - 100]
  set y [expr [lindex $topg 3] + [lindex $topg 1] / 2 - 5]
  wm geometry $prgWindow "+$x+$y"

  set v(pregress) 0

  ttk::progressbar $prgWindow.p -length 200 -variable v(progress) -mode determinate
  pack $prgWindow.p

  raise .progress
  focus .progress
  update
}

#---------------------------------------------------
# vOXo[XVBi󋵂$progress(0`100)Ŏw肷)
#
proc updateProgressWindow {progress} {
  global v prgWindow

  set v(progress) $progress
  raise $prgWindow
  focus $prgWindow
  update
}

#---------------------------------------------------
# vOXo[
#
proc deleteProgressWindow {} {
  global prgWindow
  destroy $prgWindow
}



#---------------------------------------------------
# ڍאݒ
#
proc settings {} {
  global swindow v power f0 v_bk power_bk f0_bk snd t
    # *_bk͑ϐɂȂƃLZɃobNAbvAłȂ

  ;# dNh~
  if [isExist $swindow] return
  toplevel $swindow
  wm title $swindow $t(settings,title)
  wm resizable $swindow 0 0
  bind $swindow <Escape> {destroy $swindow}

  array set v_bk     [array get v]     ;# p[^obNAbv
  array set power_bk [array get power] ;# p[^obNAbv
  array set f0_bk    [array get f0]    ;# p[^obNAbv

  ;# 1Jڂ̃t[
  set frame1 [frame $swindow.l]
  pack $frame1 -side left -anchor n -fill y -padx 2 -pady 2

  ;#---------------------------
  ;# g`
  set lf1 [labelframe $frame1.lf1 -text $t(settings,wave) \
    -relief groove -padx 5 -pady 5]
  pack $lf1 -anchor w -fill x

  ;# g`F̐ݒ
  set cw [frame $lf1.f4w]
  setColor $cw "wavColor" $t(settings,waveColor)
  pack $cw -anchor nw

  ;# TvOg̐ݒ
  pack [frame $lf1.f20] -anchor w
  label $lf1.f20.l -text $t(settings,sampleRate) -width 20 -anchor w
  entry $lf1.f20.e -textvar v(sampleRate) -wi 6
  pack $lf1.f20.l $lf1.f20.e  -side left

  ;#---------------------------
  ;# XyNgp[^
  set lf2 [labelframe $frame1.lf2 -text $t(settings,spec) \
    -relief groove -padx 5 -pady 5]
  pack $lf2 -anchor w -fill x

  ;# XyNg̔zF
  pack [frame $lf2.f45] -anchor w
  label $lf2.f45.l -text $t(settings,specColor) -width 20 -anchor w
  tk_optionMenu $lf2.f45.cm v(cmap) grey color1 color2
  pack $lf2.f45.l $lf2.f45.cm -side left

  ;# XyNgg̍ōl
  pack [frame $lf2.f20] -anchor w
  label $lf2.f20.l -text $t(settings,maxFreq) -width 20 -anchor w
  entry $lf2.f20.e -textvar v(topfr) -wi 6
  scale $lf2.f20.s -variable v(topfr) -orient horiz \
    -from 0 -to [expr $v(sampleRate)/2] -showvalue 0
  pack $lf2.f20.l $lf2.f20.e $lf2.f20.s -side left

  ;# 邳
  pack [frame $lf2.f30] -anchor w
  label $lf2.f30.l -text $t(settings,brightness) -width 20 -anchor w
  entry $lf2.f30.e -textvar v(brightness) -wi 6
  scale $lf2.f30.s -variable v(brightness) -orient horiz \
    -from -100 -to 100 -res 0.1 -showvalue 0
  pack $lf2.f30.l $lf2.f30.e $lf2.f30.s -side left

  ;# RgXg
  pack [frame $lf2.f31] -anchor w
  label $lf2.f31.l -text $t(settings,contrast) -width 20 -anchor w
  entry $lf2.f31.e -textvar v(contrast) -wi 6
  scale $lf2.f31.s -variable v(contrast) -orient horiz \
    -from -100 -to 100 -res 0.1 -showvalue 0
  pack $lf2.f31.l $lf2.f31.e $lf2.f31.s -side left

  ;# FFT(K2ׂ̂ɂ邱)
  pack [frame $lf2.f32] -anchor w
  label $lf2.f32.l -text $t(settings,fftLength) -width 20 -anchor w
  tk_optionMenu $lf2.f32.om v(fftlen) 8 16 32 64 128 256 512 1024 2048 4096
  pack $lf2.f32.l $lf2.f32.om -side left

  ;# (KFFTȉɂ邱)
  pack [frame $lf2.f33] -anchor w
  label $lf2.f33.l -text $t(settings,fftWinLength) -width 20 -anchor w
  entry $lf2.f33.e -textvar v(winlen) -wi 6
  scale $lf2.f33.s -variable v(winlen) -orient horiz \
    -from 8 -to 4096 -showvalue 0
  pack $lf2.f33.l $lf2.f33.e $lf2.f33.s -side left

  ;# vGt@VX
  pack [frame $lf2.f34] -anchor w
  label $lf2.f34.l -text $t(settings,fftPreemph) -width 20 -anchor w
  entry $lf2.f34.e -textvar v(preemph) -wi 6
  pack $lf2.f34.l $lf2.f34.e -side left

  ;# ̑I
  pack [frame $lf2.f35] -anchor w
  label $lf2.f35.lwn -text $t(settings,fftWinKind) -width 20 -anchor w
  tk_optionMenu $lf2.f35.mwn v(window) \
    Hamming Hanning Bartlett Blackman Rectangle
  pack $lf2.f35.lwn $lf2.f35.mwn -side left

  ;#---------------------------
  ;# p[̐ݒ
  set lf3 [labelframe $frame1.lf3 -text $t(settings,pow) \
    -relief groove -padx 5 -pady 5]
  pack $lf3 -anchor w -fill x

  ;# p[F̐ݒ
  set cp [frame $lf3.f4p]
  setColor $cp "powcolor" $t(settings,powColor)
  pack $cp -anchor nw

  ;# p[o݂̐ݒ
  packEntryPower $lf3.ffl $t(settings,powLength) frameLength

  ;# vGt@VX̐ݒ
  packEntryPower $lf3.fem $t(settings,powPreemph) preemphasis

  ;# ̐ݒ
  packEntryPower $lf3.fwl $t(settings,winLength) windowLength

  ;# ̑I
  pack [frame $lf3.fwn] -anchor w
  label $lf3.fwn.lwn -text $t(settings,powWinKind) -width 20 -anchor w
  tk_optionMenu $lf3.fwn.mwn power(window) \
    Hamming Hanning Bartlett Blackman Rectangle
  pack $lf3.fwn.lwn $lf3.fwn.mwn -side left

  ;#---------------------------
  ;#---------------------------
  ;# 2Jڂ̃t[
  set frame2 [frame $swindow.r]
  pack $frame2 -side left -anchor n -fill both -expand true -padx 2 -pady 2

  ;#---------------------------
  ;# F0̐ݒ
  set lf4 [labelframe $frame2.lf4 -text $t(settings,f0) \
    -relief groove -padx 5 -pady 5]
  pack $lf4 -anchor w -fill x

  ;# F0F̐ݒ
  set cf [frame $lf4.f4f]
  setColor $cf "f0color" $t(settings,f0Color)
  pack $cf -anchor nw

  ;# oASY̑I
  pack [frame $lf4.p1] -anchor w
  label $lf4.p1.l -text $t(settings,f0Argo) -width 20 -anchor w
  tk_optionMenu $lf4.p1.mt f0(method) ESPS AMDF
  pack $lf4.p1.l $lf4.p1.mt -side left

  ;# entry^̐ݒ肢낢
  packEntryF0 $lf4.p2 $t(settings,f0Length)    frameLength
  packEntryF0 $lf4.p3 $t(settings,f0WinLength) windowLength
  packEntryF0 $lf4.p4 $t(settings,f0Max)       max
  packEntryF0 $lf4.p5 $t(settings,f0Min)       min

  ;# \Pʂ̑I
  pack [frame $lf4.p6] -anchor w
  label $lf4.p6.l -text $t(settings,f0Unit) -width 20 -anchor w
  tk_optionMenu $lf4.p6.mt f0(unit) Hz semitone
  pack $lf4.p6.l $lf4.p6.mt -side left

  ;# Ot͈͂̐ݒ
  checkbutton $lf4.p7cb -text $t(settings,f0FixRange) \
    -variable f0(fixShowRange) -onvalue 1 -offvalue 0 -anchor w
  pack [labelframe $lf4.p7 -labelwidget $lf4.p7cb \
    -relief ridge -padx 5 -pady 5] -anchor w -fill x
  packToneList $lf4.p7.tl1 $t(settings,f0FixRange,h) \
    showMaxTone showMaxOctave showMaxTmp 10 checkVol
  packToneList $lf4.p7.tl2 $t(settings,f0FixRange,l) \
    showMinTone showMinOctave showMinTmp 10 checkVol

  ;# e̐\
  checkbutton  $lf4.p8cb -text $t(settings,grid) \
    -variable f0(showToneLine) -onvalue 1 -offvalue 0 -anchor w
  pack [labelframe $lf4.p8 -labelwidget $lf4.p8cb \
    -relief ridge -padx 5 -pady 5] -anchor w -fill x
  setColor $lf4.p8 "toneLineColor" $t(settings,gridColor)

  ;# ^[Qbg̐\
  checkbutton $lf4.p9cb -text $t(settings,target) \
    -variable f0(showTgtLine) -onvalue 1 -offvalue 0 -anchor w
  pack [labelframe $lf4.p9 -labelwidget $lf4.p9cb \
    -relief ridge -padx 5 -pady 5] -anchor w -fill x
  packToneList $lf4.p9.tl $t(settings,targetTone) \
    tgtTone tgtOctave tgtFreqTmp 10 checkVol
  setColor $lf4.p9 "tgtf0color" $t(settings,targetColor)
  label  $lf4.p9.al -text $t(settings,autoSetting) -anchor nw
  button $lf4.p9.ab -text $t(.confm.run) -command autoF0Settings
  pack $lf4.p9.al $lf4.p9.ab -side left

  ;# eɑΉgvZĕ\(ɉ)
  ;# orIN^[uɕωΎgvZs
  ;# gf0(tgtFreq)ȂǂłȂf0(tgtFreqTmp)Ȃǂɓ̂́A
  ;#uOKvoruKpv{^܂ŒlύX𔽉fȂ߁B
  set f0(showMaxTmp) [tone2freq "$f0(showMaxTone)$f0(showMaxOctave)"]
  set f0(showMinTmp) [tone2freq "$f0(showMinTone)$f0(showMinOctave)"]
  set f0(tgtFreqTmp) [tone2freq "$f0(tgtTone)$f0(tgtOctave)"]
  trace variable f0 w calcFreq
  proc calcFreq {var elm mode} {
    global f0 t
    switch $elm {
      "showMaxTone" -
      "showMaxOctave" {
        set f0(showMaxTmp) [tone2freq "$f0(showMaxTone)$f0(showMaxOctave)"]
      }
      "showMinTone" -
      "showMinOctave" {
        set f0(showMinTmp) [tone2freq "$f0(showMinTone)$f0(showMinOctave)"]
      }
      "tgtTone" -
      "tgtOctave" {
        set f0(tgtFreqTmp) [tone2freq "$f0(tgtTone)$f0(tgtOctave)"]
      }
    }
  }
  bind $swindow <Destroy> { trace vdelete f0 w calcFreq }

  ;#---------------------------
  ;# OK, Apply, LZ{^
  pack [frame $frame2.f] -anchor e -side bottom -padx 2 -pady 2
  button $frame2.f.exit -text $t(.confm.c) -command {
    array set v     [array get v_bk]     ;# p[^ȑȌԂɖ߂
    array set power [array get power_bk] ;# p[^ȑȌԂɖ߂
    array set f0    [array get f0_bk]    ;# p[^ȑȌԂɖ߂
    Redraw all
    destroy $swindow
  }
  button $frame2.f.app -text $t(.confm.apply) -command {
    ;# TvOg̕ύX
    if {$v(sampleRate) != $v_bk(sampleRate)} {
      snd configure -rate $v(sampleRate)
    }
    ;# ^[Qbg̎g߂
    set f0(tgtFreq) [tone2freq "$f0(tgtTone)$f0(tgtOctave)"]
    ;# F0\͈͎g߂
    if $f0(fixShowRange) {
      set f0(showMin) [tone2freq "$f0(showMinTone)$f0(showMinOctave)"]
      set f0(showMax) [tone2freq "$f0(showMaxTone)$f0(showMaxOctave)"]
    }
    Redraw all
    ;# p[^obNAbv̍XV
    array set v_bk     [array get v]     ;# p[^obNAbv
    array set power_bk [array get power] ;# p[^obNAbv
    array set f0_bk    [array get f0]    ;# p[^obNAbv
  }
  button $frame2.f.ok -text $t(.confm.ok) -wi 6 -command {
    ;# TvOg̕ύX
    if {$v(sampleRate) != $v_bk(sampleRate)} {
      snd configure -rate $v(sampleRate)
    }
    ;# ^[Qbg̎g߂
    set f0(tgtFreq) [tone2freq "$f0(tgtTone)$f0(tgtOctave)"]
    ;# F0\͈͎g߂
    if $f0(fixShowRange) {
      set f0(showMin) [tone2freq "$f0(showMinTone)$f0(showMinOctave)"]
      set f0(showMax) [tone2freq "$f0(showMaxTone)$f0(showMaxOctave)"]
    }
    Redraw all
    destroy $swindow
  }
  pack $frame2.f.exit $frame2.f.app $frame2.f.ok -side right
}

#---------------------------------------------------
# F0^[Qbgɍ킹đ̐ݒlݒ肷
#
proc autoF0Settings {} {
  global v f0

  set tgtFreq [tone2freq "$f0(tgtTone)$f0(tgtOctave)"]

  set f0(max) [expr int($tgtFreq + 200)]
  if {$tgtFreq >= 260} {
    set f0(min) [expr int($tgtFreq - 200)]
  } else {
    set f0(min) 60
  }

  set f0(fixShowRange) 1
  set ret [calcTone $f0(tgtTone) $f0(tgtOctave) 2]
  set f0(showMaxTone)   [lindex $ret 0]
  set f0(showMaxOctave) [lindex $ret 1]
  if {$f0(showMaxOctave) > $v(sinScaleMax)} {
    set f0(showMaxOctave) $v(sinScaleMax)
    set f0(showMaxTone)   [lindex $v(toneList) [expr [llength $v(toneList)] -1]]
  }
  set ret [calcTone $f0(tgtTone) $f0(tgtOctave) -2]
  set f0(showMinTone)   [lindex $ret 0]
  set f0(showMinOctave) [lindex $ret 1]
  if {$f0(showMinOctave) < $v(sinScaleMin)} {
    set f0(showMinOctave) $v(sinScaleMin)
    set f0(showMinTone)   [lindex $v(toneList) 0]
  }
  set f0(showMin) [tone2freq "$f0(showMinTone)$f0(showMinOctave)"]
  set f0(showMax) [tone2freq "$f0(showMaxTone)$f0(showMaxOctave)"]
}

#---------------------------------------------------
# tone-octaveaddxHグƂ̃g[ƃIN^[ũXgԂ
#
proc calcTone {tone octave add} {
  global v
  for {set i 0} {$i < [llength $v(toneList)]} {incr i} {
    if {$tone == [lindex $v(toneList) $i]} break
  }
  set seq [expr $i + $add]
  while {$seq >= [llength $v(toneList)]} {
    incr octave
    incr seq -12
  }
  while {$seq < 0} {
    incr octave -1
    incr seq +12
  }
  set ret {}
  lappend ret [lindex $v(toneList) $seq]
  lappend ret $octave
  return $ret
}

#---------------------------------------------------
# LoXĕ`
#
proc Redraw {opt} {
  global v c cYaxis snd power f0 rec t

  # `撆͑̑삪łȂ悤ɂ
  # grab set $c
  # ꂪƑ̋hbOăTCYύXłȂȂ̂Ń{c

  ;# LoX̂̂폜čĒ
  set v(cHeight) [expr $v(waveh) + $v(spech) + $v(powh) + $v(f0h) + $v(timeh)]
  if {$v(cHeight) < [winfo height $rec]} {set v(cHeight) [winfo height $rec]}
  $c delete obj
  $c delete axis
  $c configure -height $v(cHeight) -width $v(cWidth)
  $c create line 0 0 $v(cWidth) 0 -tags axis -fill $v(fg)

  $cYaxis delete axis
  $cYaxis configure -height $v(cHeight)
  $cYaxis create line 0 2 $v(yaxisw) 2 -tags axis -fill $v(fg)
  $cYaxis create line $v(yaxisw) 0 $v(yaxisw) $v(cHeight) -tags axis -fill $v(fg)
  set sndLen [snd length -unit SECONDS]
  if {$sndLen > 0} {
    set v(wavepps) [expr double($v(cWidth)) / $sndLen]
  } else {
    set v(wavepps) [expr double(1.0 / $v(cWidth))]
  }

  ;# g`\
  if $v(showWave) {
    $c create waveform 0 0 -sound snd -height $v(waveh) -width $v(cWidth) \
      -tags [list obj wave] -debug $::debug -fill $v(wavColor)
    $c lower wave
    $cYaxis create text $v(yaxisw) 4 -text [snd max] \
      -font $v(sfont) -anchor ne -tags axis -fill $v(fg)
    $cYaxis create text $v(yaxisw) $v(waveh) -text [snd min] \
      -font $v(sfont) -anchor se -tags axis -fill $v(fg)
    set ylow $v(waveh)
    $c create line 0 $ylow $v(cWidth) $ylow -tags axis -fill $v(fg)
    set yAxisLow [expr $v(waveh) + 2]
    $cYaxis create line 0 $yAxisLow $v(yaxisw) $yAxisLow -tags axis -fill $v(fg)
#    $c create line $v(yaxisw) 0 $v(yaxisw) $v(waveh) -tags axis -fill $v(fg)
  }

  ;# XyNg\
  if $v(showSpec) {
    if {$v(winlen) > $v(fftlen)} {
      set v(winlen) $v(fftlen)
    }
    $c create spectrogram 0 $v(waveh) -sound snd -height $v(spech) \
      -width $v(cWidth) -tags [list obj spec] -debug $::debug \
      -fftlength $v(fftlen) -winlength $v(winlen) -windowtype $v(window) \
      -topfr $v(topfr) -contrast $v(contrast) -brightness $v(brightness) \
      -preemph $v(preemph) -colormap $v($v(cmap)) -topfrequency $v(topfr)
    $c lower spec
    snack::frequencyAxis $cYaxis 0 $v(waveh) $v(yaxisw) $v(spech) \
          -topfr $v(topfr) -tags axis -font $v(sfont)
    set ylow [expr $v(spech) + $v(waveh)]
    $c create line 0 $ylow $v(cWidth) $ylow -tags axis
    set yAxisLow [expr $ylow + 2]
    $cYaxis create line 0 $yAxisLow $v(yaxisw) $yAxisLow -tags axis -fill $v(fg)
#    $c create line $v(yaxisw) $v(waveh) $v(yaxisw) $ylow -tags axis -fill $v(fg)
  }

  ;# p[\
  if $v(showpow) {
    ;# p[𒊏o
    set ytop [expr $v(waveh) + $v(spech)]
    set ylow [expr $ytop     + $v(powh)]
    if {$opt == "all" || $opt == "pow"} {
      set power(power) [snd power -framelength $power(frameLength) \
      -windowtype $power(window) -preemphasisfactor $power(preemphasis) \
      -windowlength [expr int($power(windowLength) * $v(sampleRate))] \
      -start 0 -end -1]
    }

    if {[llength $power(power)] > 0} {
      # p[̍őlEŏl߂
      if {$opt == "all" || $opt == "pow"} {
        set power(powerMax) [lindex $power(power) 0]
        set power(powerMin) [lindex $power(power) 0]
        for {set i 1} {$i < [llength $power(power)]} {incr i} {
          if {$power(powerMax) < [lindex $power(power) $i]} {
            set power(powerMax) [lindex $power(power) $i]
          }
          if {$power(powerMin) > [lindex $power(power) $i]} {
            set power(powerMin) [lindex $power(power) $i]
          }
        }
      }

      # ppd= 1dB̃sNZB4͏㉺e2sNZ̃}[W
      if {[expr $power(powerMax) - $power(powerMin)] > 0} {
        set ppd [expr double($v(powh)) / ($power(powerMax) - $power(powerMin))]
      } else {
        set ppd 0
      }

      set coord {} ;# p[ȐW(x,y)
      for {set i 0} {$i < [llength $power(power)]} {incr i} {
        lappend coord \
          [expr $i * $power(frameLength) * $v(wavepps)] \
          [expr $ylow - ([lindex $power(power) $i] - $power(powerMin)) * $ppd]
      }
      set pwtags {obj pow}
      eval {$c create line} $coord -tags {$pwtags} -fill $v(powcolor)
      powerAxis $cYaxis 0 $ytop $v(yaxisw) $v(powh) \
        -pwMax $power(powerMax) -tags axis -fill $v(fg) \
        -font $v(sfont) -pwMin $power(powerMin)
    }
    $c create line 0 $ylow $v(cWidth) $ylow -tags axis
#    $c create line $v(yaxisw) $ytop $v(yaxisw) $ylow -tags axis -fill $v(fg)
    set yAxisLow [expr $ylow + 2]
    $cYaxis create line 0 $yAxisLow $v(yaxisw) $yAxisLow -tags axis -fill $v(fg)

    ;# p[𒊏oȂ炻FIDL^
    if {$power(fid) != $v(recLab)} {
      set power(fid) $v(recLab)
    }
  }

  ;# F0\
  if $v(showf0) {
    set ytop [expr $v(waveh) + $v(spech) + $v(powh)]
    set ylow [expr $ytop + $v(f0h)]
    ;# F0𒊏o
    if {$opt == "all" || $opt == "f0"} {
      set seriestmp {}
      if {[catch {set seriestmp [snd pitch -method $f0(method) \
        -framelength $f0(frameLength) -windowlength $f0(windowLength) \
        -maxpitch $f0(max) -minpitch $f0(min) \
        -progress waitWindow] } ret]} {
        if {$ret != ""} {
          puts "error: $ret"
        }
        set seriestmp {}
      }
      set f0(f0) {}
      foreach s $seriestmp {
        set val [lindex [split $s " "] 0]
        if {$f0(unit) == "semitone" && $val > 0} {
          set val [hz2semitone $val]
        }
        lappend f0(f0) $val
      }
    }

    if {[llength $f0(f0)] > 0} {
      # F0̍őlEŏl߂
      if {$opt == "all" || $opt == "f0"} {
        if {$f0(fid) != $v(recLab)} {
          set f0(extractedMax) [lindex $f0(f0) 0]
          set f0(extractedMin) [lindex $f0(f0) 0]
          for {set i 1} {$i < [llength $f0(f0)]} {incr i} {
            if {$f0(extractedMax) < [lindex $f0(f0) $i]} {
              set f0(extractedMax) [lindex $f0(f0) $i]
            }
            if {$f0(extractedMin) > [lindex $f0(f0) $i] && [lindex $f0(f0) $i] > 0 ||
                $f0(extractedMin) <= 0} {
              set f0(extractedMin) [lindex $f0(f0) $i]
            }
          }
        }
      }
      # `悷XP[߂
      if {$f0(fixShowRange)} {
        set f0(extractedMax) $f0(showMax)
        set f0(extractedMin) $f0(showMin)
        if {$f0(unit) == "semitone"} {
          if {$f0(extractedMax) > 0} { set f0(extractedMax) [hz2semitone $f0(extractedMax)] }
          if {$f0(extractedMin) > 0} { set f0(extractedMin) [hz2semitone $f0(extractedMin)] }
        }
#      } else {
#        set f0(extractedMin) $f0(min)  ;# f0(min)ɂĂ
#        if {$f0(unit) == "semitone"} {
#          if {$f0(extractedMin) > 0} { set f0(extractedMin) [hz2semitone $min] }
#        }
      }

      if {$f0(extractedMax) > $f0(extractedMin) && $f0(extractedMin) >= 0} {
        # ppd= 1Hz̃sNZB4͏㉺e2sNZ̃}[W
        set ppd [expr double($v(f0h)) / ($f0(extractedMax) - $f0(extractedMin))]

        # eɑΉgŉ
        if $f0(showToneLine) {
          for {set i 0} {$i < [llength $v(sinScale)]} {incr i} {
            if {$f0(unit) == "semitone"} {
              set tgt [hz2semitone [lindex $v(sinScale) $i]]
            } else {
              set tgt [lindex $v(sinScale) $i]
            }
            set y1 [expr $ylow - ($tgt - $f0(extractedMin)) * $ppd]
            if {$y1 <= [expr $ylow - $v(f0h)]} break
            if {$y1 < $ylow} {
              $c create line 0 $y1 $v(cWidth) $y1 -tags axis \
                -fill $v(toneLineColor)
            }
          }
        }

        # ^[QbgЂ
        if $f0(showTgtLine) {
          if {$f0(unit) == "semitone"} {
            set tgt [hz2semitone $f0(tgtFreq)]
          } else {
            set tgt $f0(tgtFreq)
          }
          set y1 [expr $ylow - ($tgt - $f0(extractedMin)) * $ppd ]
          if {$y1 <= $ylow && $y1 >= [expr $ylow - $v(f0h)]} {
            $c create text [expr 0 + 2] $y1 \
              -text "$f0(tgtTone)$f0(tgtOctave)" -fill $v(tgtf0color) \
              -font smallkfont -anchor w -tags {axis tgtName}
            $c create line [lindex [$c bbox tgtName] 2] $y1 $v(cWidth) $y1 -tags axis \
              -fill $v(tgtf0color)
          }
        }

        # F0f[^vbg
        # set coord {} ;# F0ȐW(x,y)
        set f0tags {obj f0}
        for {set i 0} {$i < [llength $f0(f0)]} {incr i} {
          # lappend coord \
          #   [expr $i * $f0(frameLength) * $v(wavepps)] \
          #   [expr $ylow - ([lindex $f0(f0) $i] - $f0(f0Min)) * $ppd]
          if {[lindex $f0(f0) $i] > 0} {
            set x1 [expr $i * $f0(frameLength) * $v(wavepps) - 2]
            set y1 [expr $ylow - ([lindex $f0(f0) $i] - $f0(extractedMin)) * $ppd - 2]
            set x2 [expr $x1 + 3]
            set y2 [expr $y1 + 3]
            if {$y1 <= $ylow && $y1 >= [expr $ylow - $v(f0h)]} {
              $c create oval $x1 $y1 $x2 $y2 -tags $f0tags -fill $v(f0color)
            }
          }
        }
      }
#      eval {$c create line} $coord -tags {$f0tags} -fill $v(f0color)
      f0Axis $cYaxis 0 $ytop $v(yaxisw) $v(f0h) \
        -tags axis -fill $v(fg) -font $v(sfont) \
        -f0Max $f0(extractedMax) -f0Min $f0(extractedMin) -unit $f0(unit)
    }
    # 
    $c create line 0 $ylow $v(cWidth) $ylow -tags axis
#    $c create line $v(yaxisw) $ytop $v(yaxisw) $ylow -tags axis -fill $v(fg)
    set yAxisLow [expr $ylow + 2]
    $cYaxis create line 0 $yAxisLow $v(yaxisw) $yAxisLow -tags axis -fill $v(fg)

    ;# F0𒊏oȂFIDL^
    if {$f0(fid) != $v(recLab)} {
      set f0(fid) $v(recLab)
    }
  }

  ;# Ԏ\
  if {$v(showWave) || $v(showSpec) || $v(showpow) || $v(showf0)} {
    set ytop [expr $v(waveh) + $v(spech) + $v(powh) + $v(f0h)]
    set ylow [expr $ytop + $v(timeh)]
    snack::timeAxis $c 0 $ytop $v(cWidth) $v(timeh) $v(wavepps) \
      -tags axis -starttime 0 -fill $v(fg)
    $c create line 0 $ylow $v(cWidth) $ylow -tags axis
  }

  ;# grab
  ;#  grab release $c
}

#---------------------------------------------------
# ^Jn
#
proc recStart {} {
  global snd v bgmParam t
  if {$v(rec) == 0} return   ;# ^[hłȂȂI
  if {$v(rec) >= 2} {
    ;# ^̏ꍇ
    if {$bgmParam(autoRecStatus) == 0} {
      autoRecStart
    } else {
      autoRecStop
    }
  } else {
    ;# 蓮^(ver.1.0̕@)̏ꍇ
    set v(msg) $t(recStart,msg)
    snd record
    set v(recStatus) 1
  }
}

#---------------------------------------------------
# ^I
#
proc recStop {} {
  global snd v t
  if {$v(rec) != 1} return   ;# 蓮^[hłȂȂI
  set v(msg) $t(recStop,msg)
  snd stop
  if $v(removeDC) removeDC
  Redraw all
}

#---------------------------------------------------
# t@CۑďI
#
proc Exit {} {
  global v t
#  if $v(paramChanged) {
#    set act [tk_dialog .confm $t(.confm) $t(Exit,q1) \
#      question 2 $t(Exit,a1) $t(Exit,a2) $t(Exit,a3)]
#    switch $act {
#      0 {                      ;# ۑďIꍇ
#          if ![saveParamFile] {
#            return  ;# ŕۑȂI~B
#          }
#        }
#      1 { }                    ;# ۑIꍇ
#      2 { return }             ;# IȂꍇ
#    }
#  }

  if $v(recStatus) {
    set act [tk_dialog .confm $t(.confm) $t(Exit,q2) \
      question 2 $t(Exit,a1) $t(Exit,a2) $t(Exit,a3)]
    if {$act == 2} {
      return
    } elseif {$act == 0} {
      saveWavFile
    }
  }

  exit
}

#---------------------------------------------------
# ENbNj[
#
proc PopUpMenu {X Y x y} {
  global v rclickMenu t

  $rclickMenu delete 0 end
  $rclickMenu add checkbutton -variable v(showWave) \
    -label $t(PopUpMenu,showWave) -command toggleWave
  $rclickMenu add checkbutton -variable v(showSpec) \
    -label $t(PopUpMenu,showSpec) -command toggleSpec
  $rclickMenu add checkbutton -variable v(showpow) \
    -label $t(PopUpMenu,showPow) -command togglePow
  $rclickMenu add checkbutton -variable v(showf0) \
    -label $t(PopUpMenu,showF0) -command toggleF0
  $rclickMenu add command -label $t(PopUpMenu,pitchGuide) -command pitchGuide
  $rclickMenu add command -label $t(PopUpMenu,tempoGuide) -command tempoGuide
  $rclickMenu add command -label $t(PopUpMenu,settings)   -command settings

  catch {tk_popup $rclickMenu $X $Y}
}

#---------------------------------------------------
# o[W\
#
proc Version {} {
  global v t
  tk_messageBox -title $t(Version,msg) \
    -message "$v(appname) version $v(version)"
}

#---------------------------------------------------
# Xg{bNXEBWbg w  d XN[(Windows)
# +/-120  Windows ŃzC[1ۂ%DɃZbgl
#
proc listboxScroll {w d} {
  if {$w ne ""} {
    $w yview scroll [expr -$d / 120] units
  }
}

#---------------------------------------------------
# usage
#
proc usage {} {
  global argv0 t
  puts "usage: $argv0 \[-d saveDir|-f initScript\]"
}

