#!/bin/sh
# the next line restarts using wish \
exec /cygdrive/c/Tcl/bin/wish "$0" "$@"

# ver.0.2
# - (ǉ) čpust̏o͋@\ǉBt@Ćuust-resyn.ustvƂȂB
# - (ǉ) ooto.inȉdGCAXɒʂԍtB

# ver.0.1
# - (C) ustJȂƂɃG[oȂ悤ɂ(openUstFile, makeCorpus)

# MacOSł̍B
# 1) nkf -w8Bsource/fransing.app/Contents/Resources/Scripts/fransing.tcluB
#    ̍ہAȂsڂ#!̑Oɉ̕R[h}ꂽ̂ŁA
#    Oo[WɃRsyǂƎvB
# 3) MacOSŎsĂ݂B

package require -exact snack 2.2

array unset v
set v(appname) fransing
set v(version) 0.2
if {$::tcl_platform(os) == "Darwin"} {
  set scriptDir [file dirname [info script]]
  set d [split "$scriptDir" "/"]
  set topdir [join [lrange $d 0 [expr [llength $d] - 5]] "/"]
} elseif {[info exists ::starkit::topdir]} {
  set topdir [file dirname [info nameofexecutable]]
} else {
  set topdir [file dirname $argv0]
}
set v(inDir)  "$topdir/in"
set v(outDir) "$topdir/out"
set v(inExt)  "wav"          ;# ͔g`t@C̊gq
set v(outExt) "wav"          ;# o͔g`t@C̊gq
set v(maxO)      0.05         ;# I[o[bv̍ől
set v(maxP)      0.4          ;# s̍ől
set v(marginL)   0.2          ;# wav؂óAɊmۂ]
set v(marginR)   0.2          ;# wav؂óAEɊmۂ]
set v(nameRule)  "_%p+%m%r"   ;# K
set v(gobi)      0            ;# 1=̖ۑ
set v(outUst)    0            ;# 1=čpusto͂
set v(progress)  0
set paramUsize   0
array unset paramU
set prgWindow .progress

if {$::tcl_platform(os) == "Darwin"} {
  set nkf "$scriptDir/nkf"     ;# oto.inisjisɕϊ邽߂nkf
  set nkfResult "$scriptDir/nkfTmpResult"  ;# nkf̏o͌ʂꎞۑt@C
}

#---------------------------------------------------
# ꃂ[̕ꉹ̉fԂ
#
proc getVowel {mora} {
  set vA {                  \
          A J T ^ i n }    K U _ o p  @  }
  set vI {                        \
          C L V ` j q ~        M W a r s    B  }
  set vU {                     \
          E N X c k t          O Y d u v D  b }
  set vE {                        \
          G P Z e l w         Q [ f x y    F  }
  set vO {                    \
          I R \ g m z     S ] h { |  H    }
  set vN { }
  set vR {R _}

  set last [expr [string length $mora] -1]
  for {set i $last} {$i >= 0} {incr i -1} {  ;# ̉EŶTB"3"ȂǂɑΉB
    set char [string range $mora $i $i]

    if {[lsearch $vA $char] >= 0} { return "a" }
    if {[lsearch $vI $char] >= 0} { return "i" }
    if {[lsearch $vU $char] >= 0} { return "u" }
    if {[lsearch $vE $char] >= 0} { return "e" }
    if {[lsearch $vO $char] >= 0} { return "o" }
    if {[lsearch $vN $char] >= 0} { return "n" }
    if {[lsearch $vR $char] >= 0} { return "-" }   ;# xꍇ
  }
  return "-"
}

#------------------------------------------------------------
# NoteNum特𓾂
#
proc noteNum2Note {NoteNum} {
  if {$NoteNum < 0} return ""
  set tone   [lindex {C C# D D# E F F# G G# A A# B} [expr $NoteNum % 12]]
  set octave [expr int(($NoteNum - 12) / 12)]
  return "$tone$octave"
}

#------------------------------------------------------------
# ustt@Cǂݍ
#
#   ust(num)         ... 
#   ust(ԍ,Left)   ... Jn(b)
#   ust(ԍ,Right)  ... I(b)
#   ust(ԍ,Length) ... (b)
#   ust(ԍ,Lyric)  ... (PƉustłA`ɂċL)
# ǂݍݐ0As1Ԃ
#
proc openUstFile {fn ust} {
  global v
  upvar $ust _ust

  if {$::tcl_platform(os) == "Darwin"} {
    global nkf nkfResult
    exec -- $nkf -w8 $fn > $nkfResult     ;# R[hutf-8ɕϊ
    set fn $nkfResult
  }

  if [catch {open $fn r} in] { return 1 }
  if [catch {set ustall [read $in]}] { return 1 }
  array unset _ust
  set _ust(num) 0
  close $in
  set Tempo 120
  set Length 0
  set Label   ""
  set NoteNum -1 
  set labelOld  "R"
  set end   0       ;# x
  set endOld 0      ;# x
  foreach row [split $ustall \n] {
    regexp {^Tempo=([0-9\.]+)}  $row dummy Tempo   ;# e|
    regexp {^Length=([0-9\.]+)} $row dummy Length  ;# 
    regexp {^Lyric=(.+)$}       $row dummy Label   ;# 
    regexp {^NoteNum=(.+)$}     $row dummy NoteNum ;# ԍ
    ;# ̃ZNV؂A#TRACKEND
    if {[regexp {^\[#([0-9]+)\]$} $row dummy seq]  || $row == "\[#TRACKEND\]"} {
      if {$seq == "0000"} continue         ;# ŏ̉ZNV͔΂
      set _ust($_ust(num),Length) [expr $Length / 480.0 * 60.0 / $Tempo]  ;# L^
      set _ust($_ust(num),Note)   [noteNum2Note $NoteNum]  ;# ԍ
      set end [expr $end + $_ust($_ust(num),Length)]
      set _ust($_ust(num),Left) $endOld                    ;# JnL^
      set _ust($_ust(num),Right) $end                      ;# IL^
      if {$seq == "0001" && $Label != "R"} {
        tk_messageBox -message "ustt@C̍ŏ̉xɂȂĂ܂B" \
          -title "G[" -icon warning
        return 1
      }
      if {[regexp {[^ ] [^ ]} $Label]} {
        ;# ustAf[^ꍇ
        set preVowel [string range $Label 0 0]  ;# sꉹ𓾂
        set mora ""
        for {set i 2} {$i < [string length $Label]} {incr i} {  ;# Y[𔲂o(3Ȃǂsuffix)
          set char [string range $Label $i $i]
          if {$char != "_" && [isKana $char]} {
            set mora "$mora$char"
          } else {
            break
          }
        }
        set _ust($_ust(num),Lyric) "$preVowel $mora"               ;# L^
      } else {
        ;# ustPƉf[^ꍇ
        set preVowel [getVowel $labelOld]  ;# xAɂ
        set mora ""
        for {set i 0} {$i < [string length $Label]} {incr i} {  ;# Y[𔲂o(3Ȃǂsuffix)
          set char [string range $Label $i $i]
          if {$char != "_" && [isKana $char]} {
            set mora "$mora$char"
          } else {
            break
          }
        }
        set _ust($_ust(num),Lyric) "$preVowel $mora"               ;# L^
      }
      incr _ust(num)
      set endOld $end
      set labelOld $Label
    }
  }
  return 0
}

#------------------------------------------------------------
# wav+ust番wavoto.ini
#
proc makeCorpus {} {
  global v paramU paramUsize

  ;# KɕK{p[^ΏI
  if {[regexp {%p} $v(nameRule)] == 0 || 
      [regexp {%m} $v(nameRule)] == 0 || [regexp {%r} $v(nameRule)] == 0} {
    tk_messageBox -message "KK%pA%mA%rw肵ĉB" -title "G[" -icon warning
    return
  }

  ;# t@CIDQW߂
  set ustFileIDs {}
  foreach fn [glob -nocomplain "$v(inDir)/*.$v(inExt)"] {
    set fn [file rootname [file tail $fn]]
    if {$fn == "" || ! [file exists "$v(inDir)/$fn.ust"]} continue
    lappend ustFileIDs $fn
  }

  ;# o̓fBNg΍
  if {! [file exists "$v(outDir)"]} {
    file mkdir "$v(outDir)"
  } else {
    if {[llength [glob -nocomplain "$v(outDir)/*"]] > 0} {
      set ret [tk_dialog .confm "mF" "o̓tH_Ƀt@C܂B\n𑱍s܂H" \
                question 2 "tH_ɂĎs" "tH_ɂs" "~"]
      if {$ret == 2} {
        return
      } elseif {$ret == 0} {
        file delete -force -- "$v(outDir)"
        file mkdir "$v(outDir)"
      }
    }
  }

  ;# oto.inĩGCAXzɓ
  set aliasList [readAlias "$v(outDir)/oto.ini"]

  ;# wavAust̑g
  set paramUsize 1
  set iU   1  ;# paramU1JEg(0n߂ȂBsetParam̎dlɂ킹邽)
  array unset paramU
  snack::sound sndOrg
  foreach s $ustFileIDs {
    array unset ust
    set ret [openUstFile "$v(inDir)/$s.ust" ust]   ;# ustf[^ǂݍށBdΔԍ
    if {$ret != 0} continue                        ;# ustǂ߂Ȃꍇ͎

    sndOrg flush
    sndOrg read "$v(inDir)/$s.$v(inExt)"
    initProgressWindow "processing: $s"
    set sndOrg [sndOrg convert -channels Mono]
    set sampleRate [sndOrg cget -rate]
    set maxOMS [cut3 [expr $v(maxO) * 1000]]       ;# I[o[bvől(Pmsec)
    for {set i 1} {$i < $ust(num)} {incr i} {
      set iOld [expr $i - 1]

      ;# start`endԂ؂owavۑ
      set tmpP [expr $ust($iOld,Length) / 2.0]
      if {$tmpP > $v(maxP)} {
        set tmpP $v(maxP)
      }
      set start [expr $ust($i,Left) - $tmpP - $v(marginL)]
      set Sadj 0
      if {$start < 0} {
        set Sadj $start  ;# w肵mۏoȂ͕sLS̒l␳
        set start 0
      }
      set tmpNextP [expr $ust($i,Length) / 2.0]
      if {$tmpNextP > $v(maxP)} {
        set tmpNextP $v(maxP)
      }
      set end [expr $ust($i,Right) - $tmpNextP + $v(marginR)]
      if {$end >= [sndOrg length -unit SECONDS]} {
        set end -1
      }

      if {$ust($i,Lyric) != "- R"} {
        if {$v(gobi) == 0 && [regexp {^. R} $ust($i,Lyric)]} continue   ;# o^ȂȂ玟
        ;# wavt@Cۑ
        snack::sound snd
        if {$end >= 0} {
          snd copy sndOrg -start [expr int($start * $sampleRate)] -end [expr int($end * $sampleRate)]
        } else {
          snd copy sndOrg -start [expr int($start * $sampleRate)] -end $end
        }
        set choufukuNum 1
        set outFileWithR [makeWavNameID "$ust($i,Lyric)" "$v(nameRule)" "$ust($i,Note)" $i "$s"]
        set outFile [string map {"%r" ""} $outFileWithR]
        while {[file exists "$v(outDir)/$outFile.$v(outExt)"]} {
          incr choufukuNum
          set outFile [string map [eval format "{%%r \"$choufukuNum\"}"] $outFileWithR]
        }
        snd write "$v(outDir)/$outFile.$v(outExt)"

        ;# oto.inĩp[^

        ;# S
        set S  [cut3 [expr ($v(marginL) + $Sadj) * 1000]]
        if {$S < 0} {
          set S 0
        }
        set paramU($iU,1) $S

        ;# O
        set O [cut3 [expr ($ust($iOld,Length) / 3.0) * 1000]]
        if {$O > $maxOMS} {
          set O $maxOMS
        }
        set paramU($iU,2) $O

        ;# P
        set P [cut3 [expr ($ust($i,Left) - ($start + $S / 1000.0)) * 1000]]
        set paramU($iU,3) $P

        ;# C
        set paramU($iU,4) [cut3 [expr $P + $ust($i,Length) / 6.0 * 1000]]

        ;# E
        set tmpNextP [expr $ust($i,Length) / 2.0]
        if {$tmpNextP > $v(maxP)} {
          set tmpNextP $v(maxP)
        }
        set E [cut3 [expr -($ust($i,Right) - $tmpNextP - ($start + $S / 1000.0)) * 1000]] ;# \
        set paramU($iU,5) $E
        if {[regexp {^_} $outFile] == 0} { ;# wavt@Cu_vŎn܂Ȃꍇ
          set paramU($iU,5) [cut3 [expr [snd length -unit SECONDS] * 1000 - (abs($E) + $S)]] ;# \(t@C̎Ԓ)ɂ
          if {$paramU($iU,5) < 0} {
            set paramU($iU,5) 0
          }
        }

        ;# Alias
        set aliasChoufukuNum 1
        set outAlias $ust($i,Lyric)
        while {[lsearch -exact $aliasList $outAlias] >= 0} {
          incr aliasChoufukuNum
          set outAlias $ust($i,Lyric)$aliasChoufukuNum
        }
        lappend aliasList $outAlias
        set paramU($iU,6) $outAlias

        ;# wavFile
        set paramU($iU,0) "$outFile"
        ;#puts "$paramU($iU,6): ($start - $end), \t$paramU($iU,1)\t$paramU($iU,2)\t$paramU($iU,3)\t$paramU($iU,4)\t$paramU($iU,5)"
        incr iU
        incr paramUsize
      }
      updateProgressWindow [expr 100 * $i / $ust(num)]
    }
    deleteProgressWindow

    ;# čpusto͂
    if $v(outUst) { makeResynthesisUst $s }
  }
  ;#puts "lyric: (wavstart wavend), \tS\tO\tP\tC\tE"
  saveParamFile "$v(outDir)/oto.ini"
  set num [expr $paramUsize - 1]
  tk_messageBox -message "$numwavɕ܂B" -title "I" -icon info
}

#---------------------------------------------------
# čpustt@C쐬
#
proc makeResynthesisUst {inUstFid} {
  global v paramU paramUsize

  set inUst  "$v(inDir)/$inUstFid.ust"
  set outUst "$v(outDir)/$inUstFid-resyn.ust"

  ;# MacOSȂ炢񊿎R[hutf-8ɂ
  if {$::tcl_platform(os) == "Darwin"} {
    global nkf nkfResult
    exec -- $nkf -w8 $inUst > $nkfResult     ;# R[hutf-8ɕϊ
    set inUst $nkfResult
  }

  ;# ust荞
  if [catch {open $inUst r} in] { return 1 }
  if [catch {set ustall [read $in]}] { return 1 }
  close $in

  ;# oust
  if {$::tcl_platform(os) == "Darwin"} {
    if [catch {open $nkfResult w} out] { return 1 } ;# ŊR[hsjisɂ̂
  } else {
    if [catch {open $outUst    w} out] { return 1 }
  }
  set i 1
  foreach row [split $ustall \n] {
    if {[regexp {^Lyric=(.+)$} $row dummy Lyric]} {
      if {$Lyric == "R"} {
        puts $out "$row"
      } else {
        puts $out "Lyric=$paramU($i,6)"                        ;# ւďo
        incr i
      }
    } elseif {[regexp {^VoiceDir=} $row]} {
      set VoiceDir [file nativename [file normalize $v(outDir)]]  ;# tH_ւďo
      puts $out "VoiceDir=$VoiceDir"
    } elseif {[regexp {^CacheDir=} $row]} {
      puts $out "CacheDir=$inUstFid-resyn.cache"               ;# LbVtH_ւďo
    } else {
      puts $out "$row"
    }
  }
  close $out

  if {$::tcl_platform(os) == "Darwin"} {
    global nkf nkfResult
    exec -- $nkf -s $nkfResult > $outUst    ;# R[hsjisɕϊ
  }
}

#---------------------------------------------------
# _ȉ3őł؂
#
proc cut3 {val} {
  if {$val >= 0} {
    return [expr int($val * 1000 + 0.5) / 1000.0 ]
  } else {
    return [expr int($val * 1000 - 0.5) / 1000.0 ]
  }
}

#---------------------------------------------------
# p[^̃GCAXꗗ(Xg)𓾂
#
proc readAlias {fn} {
  global v

  set aliasList {}
  if [catch {open $fn r} fp] {
    return $aliasList
  }

  while {![eof $fp]} {
    set p [split [gets $fp] "=,"]   ;# "fname,A,S,C,E,P,O"
    if {[llength $p] == 7} {
      lappend aliasList [lindex $p 1]
    }
  }
  close $fp
  return $aliasList
}

#---------------------------------------------------
# p[^ۑ
# return: 1=ۑB0=ۑȂB
#
proc saveParamFile {fn} {
  global paramU paramUsize v

  if {$fn == ""} {return 0}

  ;# ۑt@CJ
  set mode w
  if {[file exists $fn]} {
    set mode a              ;# oto.iniΒǋL[hɂ
  }
  if [catch {open $fn $mode} fp] {
    tk_messageBox -message "error: can not open $fn" -title "G[" -icon warning
    return
  }

  for {set i 1} {$i < $paramUsize} {incr i} {
    if {[array names paramU "$i,0"] != ""} {
      set name $paramU($i,0).$v(outExt)
      set S 0; set O 0; set P 0; set C 0; set E 0; set A "";
      if {[array names paramU "$i,1"] != ""} { set S $paramU($i,1) }
      if {[array names paramU "$i,2"] != ""} { set O $paramU($i,2) }
      if {[array names paramU "$i,3"] != ""} { set P $paramU($i,3) }
      if {[array names paramU "$i,4"] != ""} { set C $paramU($i,4) }
      if {[array names paramU "$i,5"] != ""} { set E $paramU($i,5) }
      if {[array names paramU "$i,6"] != ""} { set A $paramU($i,6) }
      puts $fp $name=$A,$S,$C,$E,$P,$O    ;# t@C֏o
      #puts $name=$A,$S,$C,$E,$P,$O
    }
  }
  close $fp        ;# t@C

  if {$::tcl_platform(os) == "Darwin"} {
    global nkf
    exec -- $nkf -s --in-place $fn      ;# R[hsjisɕϊ
  }
  return 1
}

#---------------------------------------------------
# char܂͕ЉȂ1AȊOȂ0Ԃ
#
proc isKana {char} {
  set kanaList {                     \
                A J T ^ i n }       K U _ o p  @  \
                                           \
                C L V ` j q ~           M W a r s    B  \
                                       \
                E N X c k t        O Y d u v  D b \
                                           \
                G P Z e l w            Q [ f x y    F  \
                                       \
                I R \ g m z        S ] h { |  H    \
                  J K \
                R _ }
  if {[lsearch $kanaList $char] >= 0} {
    return 1
  } else {
    return 0
  }
}

#---------------------------------------------------
# wavt@C߂ifBNgAgqAd̒ʂԍ͂Ȃj
# ȂAK%r͂ł%r̂܂ܕԂiȉŏd𒲂ׂđΉj
# choufuku""łȂ%ruĕԂ
#
proc makeWavNameID {Lyric nameRule note noteSeq orgName {choufuku ""}} {
  global v

  set nameID $nameRule

  ;# %p,%m̏i%pɐsꉹA%mɓY[}j
  set str ""
  set preVowel ""
  regexp {^([^ ]+) (.+)$} $Lyric dummy preVowel str  ;# sꉹpreVowel
  ;# Y[mora
  set mora ""
  for {set i 0} {$i < [string length $str]} {incr i} {
    set char [string range $str $i $i]
    if {$char != "_" && [isKana $char]} {
      set mora "$mora$char"
    } else {
      break
    }
  }
  set nameID [string map [eval format "{%%p \"$preVowel\"}"] $nameID]
  set nameID [string map [eval format "{%%m \"$mora\"}"]     $nameID]

  ;# %n̏i%nɉ}j
  if {[regexp {%n} $nameID]} {
    set nameID [string map [eval format "{%%n \"$note\"}"] $nameID]
  }

  ;# %ȍi%oɌt@C}j
  if {[regexp {%o} $nameID]} {
    set nameID [string map [eval format "{%%o \"$orgName\"}"] $nameID]
  }

  ;# %t̏i%tɊeustł̉̒ʂԍ}j
  if {[regexp {%t} $nameID]} {
    set nameID [string map [eval format "{%%t \"$noteSeq\"}"] $nameID]
  }

  ;# %ȑ (%rwavt@C̏dʂԍ})
  if {[regexp {%r} $nameID] && $choufuku != ""} {
    set nameID [string map [eval format "{%%r \"$choufuku\"}"] $nameID]
  }

  return $nameID
}

#---------------------------------------------------
# vOXo[ĕ\
#
proc initProgressWindow {{title "now processing..."}} {
  global prgWindow v
  if [isExist $prgWindow] return

  toplevel $prgWindow
  wm title $prgWindow $title
  if {$::tcl_platform(os) != "Darwin"} {
    wm attributes $prgWindow -toolwindow 1
    wm attributes $prgWindow -topmost 1
  }
  bind $prgWindow <Escape> "destroy $prgWindow"
  set topg [split [wm geometry .] "x+"]
  set x [expr [lindex $topg 2] + [lindex $topg 0] / 2 - 100]
  set y [expr [lindex $topg 3] + [lindex $topg 1] / 2 - 5]
  wm geometry $prgWindow "+$x+$y"

  set v(progress) 0

  ttk::progressbar $prgWindow.p -length 200 -variable v(progress) -mode determinate
  pack $prgWindow.p

  raise $prgWindow
  focus $prgWindow
}

#---------------------------------------------------
# vOXo[XVBi󋵂$progress(0`100)Ŏw肷)
#
proc updateProgressWindow {progress} {
  global v prgWindow

  set v(progress) $progress
  raise $prgWindow
  focus $prgWindow
  update
}

#---------------------------------------------------
# vOXo[
#
proc deleteProgressWindow {} {
  global prgWindow
  destroy $prgWindow
}

#---------------------------------------------------
#   w肵Nς݂`FbNBNς݂ȂtH[JXB
#
proc isExist {w} {
  if [winfo exists $w] {
    raise $w
    focus $w
    return 1
  } else {
    return 0
  }
}

#---------------------------------------------------
# ͓e̎Ȃ1AłȂȂ0Ԃ
#
proc isPlusDouble {x} {
  if {[string is double "$x"] && "$x" >= 0} {
    return 1
  }
  return 0
}

#---------------------------------------------------
# tk_chooseDirectory p̃bp[(macΉ̂)
# MacOSł-initialdirɑ݂Ȃt@Cw肷ƃG[
#
proc my_chooseDirectory {{args {}}} {
  global topdir
  array set a $args

  if {$::tcl_platform(os) == "Darwin"} {
    if {[array names a "-initialdir"] == "" || ! [file exists $a(-initialdir)] } {
      set a(-initialdir) $topdir
    }
  }
  if {[array names a "-initialdir"] != ""} {
    set a(-initialdir) "\"$a(-initialdir)\""
  }

  set command [join "tk_chooseDirectory [array get a]" " "]
  eval $command
}

#---------------------------------------------------
# GUI
#
snack::createIcons    ;# ACRgp

# o̓tH_
labelframe  .fIO -text "o" -relief groove -padx 5 -pady 5
label  .fIO.inDir(l)  -text "̓tH_"
entry  .fIO.inDir(e)  -textvar v(inDir) -width 85
button .fIO.inDir(b)  -image snackOpen -text "I" -command {
  set d [my_chooseDirectory -initialdir "$v(inDir)" -title "̓tH_̑I"]
  if {$d != ""} {
    set v(inDir) $d
  }
}
label  .fIO.outDir(l) -text "o̓tH_"
entry  .fIO.outDir(e) -textvar v(outDir) -width 85
button .fIO.outDir(b) -image snackOpen -text "I" -command {
  set d [my_chooseDirectory -initialdir "$v(outDir)" -title "o̓tH_̑I"]
  if {$d != ""} {
    set v(outDir) $d
  }
}
grid .fIO.inDir(l)   -row 0 -column 0 -pady 2 -sticky nse
grid .fIO.inDir(e)   -row 0 -column 1 -columnspan 3 -pady 2 -sticky nswe -ipady 0
grid .fIO.inDir(b)   -row 0 -column 4 -pady 2
grid .fIO.outDir(l)  -row 1 -column 0 -pady 2 -sticky nse
grid .fIO.outDir(e)  -row 1 -column 1 -pady 2 -sticky nswe -ipady 0 -columnspan 3
grid .fIO.outDir(b)  -row 1 -column 4 -pady 2

# p[^
labelframe  .fp -text "p[^ݒ" -relief groove -padx 5 -pady 5
label  .fp.maxP(l)    -text "(1) s̍ől(b)"
entry  .fp.maxP(e)    -textvar v(maxP)    -validate all -vcmd {isPlusDouble "%P"}
label  .fp.maxO(l)    -text "(2) I[o[bv̍ől(b)"
entry  .fp.maxO(e)    -textvar v(maxO) -validate all -vcmd {
  if {[string is double "%P"]} {
    return 1
  }
  return 0
}
label  .fp.marginL(l) -text "(3) wav؂o̗](Y̍)(b)"
entry  .fp.marginL(e) -textvar v(marginL) -validate all -vcmd {isPlusDouble "%P"}
label  .fp.marginR(l) -text "(4) wav؂o̗](ỶE)(b)"
entry  .fp.marginR(e) -textvar v(marginR) -validate all -vcmd {isPlusDouble "%P"}
frame  .fp.right
grid .fp.right      -row 0 -column 2 -padx 2 -pady 2 -sticky ne -rowspan 5
grid .fp.maxP(l)    -row 0 -column 0 -padx 2 -pady 2 -sticky ne
grid .fp.maxP(e)    -row 0 -column 1 -padx 2 -pady 2 -sticky nw
grid .fp.maxO(l)    -row 1 -column 0 -padx 2 -pady 2 -sticky ne
grid .fp.maxO(e)    -row 1 -column 1 -padx 2 -pady 2 -sticky nw
grid .fp.marginL(l) -row 2 -column 0 -padx 2 -pady 2 -sticky ne
grid .fp.marginL(e) -row 2 -column 1 -padx 2 -pady 2 -sticky nw
grid .fp.marginR(l) -row 3 -column 0 -padx 2 -pady 2 -sticky ne
grid .fp.marginR(e) -row 3 -column 1 -padx 2 -pady 2 -sticky nw

# }
canvas .fp.right.c    -width 283 -height 277
if {$::tcl_platform(os) == "Darwin"} {
  image create photo rule -file "$scriptDir/rule.gif"
} else {
  image create photo rule -file "$topdir/rule.gif"
}
.fp.right.c create image 0 0 -image rule -anchor nw
# ̑
labelframe    .fp.right.fo   -text "̑" -relief groove -padx 5 -pady 5
checkbutton   .fp.right.fo.cb(gobi) -text "t(a RȂ)ۑ" -variable v(gobi)
checkbutton   .fp.right.fo.cb(ust)  -text "čpusto͂" -variable v(outUst)
label         .fp.right.fo.exl      -text "͔g`tH[}bg"
if {$::tcl_platform(os) == "Darwin"} {
  tk_optionMenu .fp.right.fo.ext v(inExt) wav aiff
} else {
  tk_optionMenu .fp.right.fo.ext v(inExt) wav mp3 aiff
}
grid .fp.right.fo.cb(gobi) -row 0 -column 0 -padx 2 -pady 0 -sticky nw -columnspan 2
grid .fp.right.fo.cb(ust)  -row 1 -column 0 -padx 2 -pady 0 -sticky nw -columnspan 2
grid .fp.right.fo.exl      -row 2 -column 0 -padx 2 -pady 0 -sticky nw
grid .fp.right.fo.ext      -row 2 -column 1 -padx 2 -pady 0 -sticky nw
pack .fp.right.c
pack .fp.right.fo -fill both -expand 1

# wavt@C
labelframe .fp.fn   -text "wavt@C̕t" -relief groove -padx 5 -pady 5
grid .fp.fn -row 4  -column 0 -padx 2 -pady 2 -sticky nsew -columnspan 2
label .fp.fn.rule(l) -text "K"
entry .fp.fn.rule(e) -textvar v(nameRule) -width 40 -validate all -vcmd {
  set v(nameSample)   "[makeWavNameID "a " %P "A4" 3 "USTFILE" 5].$v(outExt)"
  set v(nameTemplate) "[makeWavNameID "(sꉹ) " %P "()" "(ʂԍ)" "(ust)" "(wavdʂԍ)"].$v(outExt)"
  return 1
}
label .fp.fn.exp(1)  -text "%p ... sꉹ(K{)"
label .fp.fn.exp(2)  -text "%m ... Y(K{)"
label .fp.fn.exp(3)  -text "%r ... wavt@Cd̒ʂԍ(K{)"
label .fp.fn.exp(4)  -text "%n ... (C)"
label .fp.fn.exp(5)  -text "%t ... ustt@Cł̉ʂԍ(C)"
label .fp.fn.exp(6)  -text "%o ... ust(C)"

label .fp.fn.rule(1)   -textvar v(nameTemplate) -foreground #ff0000
label .fp.fn.sample(0) -text "F"
label .fp.fn.sample(1) -textvar v(nameSample) -foreground #ff0000
grid .fp.fn.rule(l)    -row 0 -column 0 -padx 2 -pady 2 -sticky ne
grid .fp.fn.rule(e)    -row 0 -column 1 -padx 2 -pady 2 -sticky nwse
grid .fp.fn.rule(1)    -row 1 -column 1 -padx 2 -pady 0 -sticky nw -columnspan 3
grid .fp.fn.sample(0)  -row 2 -column 0 -padx 2 -pady 0 -sticky ne
grid .fp.fn.sample(1)  -row 2 -column 1 -padx 2 -pady 0 -sticky nw -columnspan 3
grid .fp.fn.exp(1)     -row 3 -column 1 -padx 2 -pady 0 -sticky nw -columnspan 3
grid .fp.fn.exp(2)     -row 4 -column 1 -padx 2 -pady 0 -sticky nw -columnspan 3
grid .fp.fn.exp(3)     -row 5 -column 1 -padx 2 -pady 0 -sticky nw -columnspan 3
grid .fp.fn.exp(4)     -row 6 -column 1 -padx 2 -pady 0 -sticky nw -columnspan 3
grid .fp.fn.exp(5)     -row 7 -column 1 -padx 2 -pady 0 -sticky nw -columnspan 3
grid .fp.fn.exp(6)     -row 8 -column 1 -padx 2 -pady 0 -sticky nw -columnspan 3

# s
frame .fdo
button .fdo.b(do)     -text "s" -command makeCorpus
button .fdo.b(cancel) -text "I" -command exit
grid .fdo.b(do) .fdo.b(cancel)

grid .fIO -row 0 -column 0 -padx 2 -pady 0 -sticky new
grid .fp  -row 1 -column 0 -padx 2 -pady 0 -sticky new
grid .fdo -row 2 -column 0 -padx 2 -pady 0 -sticky nw

wm title . "$v(appname) $v(version)"
set v(nameSample)   "[makeWavNameID "a " "$v(nameRule)" "A4" 3 "USTFILE" 5].$v(outExt)"
set v(nameTemplate) "[makeWavNameID "(sꉹ) " "$v(nameRule)" "()" "(ʂԍ)" "(ust)" "(wavdʂԍ)"].$v(outExt)"

