require "singleton"
require "jwr/helper"
require "jwr/drawing"
require "jwr/shapes"
require "jwr/layer"
require "Win32API"

class Jwr
  include Singleton
  
  #Nbv{[h֐Q
  $OpenClipboard = Win32API.new("user32", "OpenClipboard", ["I"], "I");
  $CloseClipboard = Win32API.new("user32", "CloseClipboard", [], "I");
  $EmptyClipboard = Win32API.new("user32", "EmptyClipboard", [], nil);
  $GetClipboardData = Win32API.new("user32", "GetClipboardData", ["I"], "I");
  $SetClipboardData = Win32API.new("user32", "SetClipboardData", ["I", "I"], "I");
  
  #֐Q
  $GlobalAlloc = Win32API.new("kernel32", "GlobalAlloc", ["I","I"], "I");
  $GlobalLock = Win32API.new("kernel32", "GlobalLock", ["I"], "P");   #get
  $GlobalLockI = Win32API.new("kernel32", "GlobalLock", ["I"], "I");  #set
  $GlobalUnlock = Win32API.new("kernel32", "GlobalUnlock", ["I"], "I");
  $GlobalSize = Win32API.new("kernel32", "GlobalSize", ["I"], "I");
  $GlobalFree = Win32API.new("kernel32", "GlobalFree", ["I"], "I");
  
  #i|C^j֐Q
  $lstrcpy = Win32API.new("kernel32", "lstrcpyA", ["P", "P"], "P");
  $lstrlen = Win32API.new("kernel32", "lstrlenA", ["P"], "I");
  
  CF_TEXT = 1 #ɂ낢
  #GMEM_DDESHARE = 0x2000; #ɂ낢날
  GMEM_MOVEABLE = 0x0002;
  
  #eLXg擾\bh
  def self.getClipboardText
    clpdata = ""
    while $OpenClipboard.Call(0) == 0 #J܂ōđ҂
      sleep 1
    end
    begin
      if(h = $GetClipboardData.Call(CF_TEXT))!=0  #H
        if p = $GlobalLock.Call(h)  #bNĎoׂ
          clpdata = p;
          $GlobalUnlock.Call(h);
        end
      end
    ensure
      $CloseClipboard.Call
    end
    return clpdata;
  end
  
  #eLXgݒ胁\bh
  def self.setClipboardText(str)
    if $OpenClipboard.Call(0) != 0  #JȂcO
      if(str!=String)
        str=str.to_s
      end
      len = $lstrlen.Call(str)
      hmem = $GlobalAlloc.Call(GMEM_MOVEABLE, len+1);
      pmem = $GlobalLockI.Call(hmem);
      $lstrcpy.Call(pmem, str);
      $GlobalUnlock.Call(hmem);
      $EmptyClipboard.Call;
      $SetClipboardData.Call(CF_TEXT, hmem);
      $CloseClipboard.Call
    end
  end

  @@option = {
    :input => "jwc_temp.txt",
    :output => "jwc_temp.txt",
    :path => ".\\"
  }

  attr_reader :jwc_temp, :drawing, :shapes,
              :layer_group, :layers
  
  def self.start(option = {})
    @@option=@@option.merge option
    
    instance.init(@@option[:path] + @@option[:input])
    yield instance
    
    File.open(@@option[:path] + @@option[:output], "w"){|f|
      f.write instance.jwc_temp
    }
  end
  
  def self.readAll(option = {})
    @@option=@@option.merge option
    
    instance.init(@@option[:path] + @@option[:input])
    yield instance
    
  end
  
  def self.jw_instance(option = {})
    @@option=@@option.merge option
    
    instance.init(@@option[:path] + @@option[:input])
    return instance
  end
  
  def self.jw(option = {})
    return Jwr.jw_instance(option)
  end
  
  def self.[](i)
    return (@@option[i]) 
  end
  
  def init(input)
    @jwc_temp = ""
#    if( input.is_a?(Synbol) )
#      #
#    else
      @jwc_temp_old = File.read(input)
#    end
    @drawing = Drawing.new
    @shapes = Shapes.new
    @layer_group = nil # LayerGroup instance
    @layers = []
    
    ## parse
    lines = @jwc_temp_old.split(/\n/)
    
    # @drawing
    while line = lines.shift
      case line
      when /^cn"\$<(.+?)>$/
        @drawing.cn = $1
      when /^hk\s(.+?)$/
        @drawing.hk = $1.to_i
      when /^hs\s(.+?)$/
        @drawing.hs = $1.split(/\s/).map{|e|e.to_f}
      when /^hcw\s(.+?)$/
        @drawing.hcw = $1.split(/\s/).map{|e|e.to_f}
      when /^hch\s(.+?)$/
        @drawing.hch = $1.split(/\s/).map{|e|e.to_f}
      when /^hcd\s(.+?)$/
        @drawing.hcd = $1.split(/\s/).map{|e|e.to_f}
      when /^hcc\s+?([0-9\-\.]+?)$/
        @drawing.hcc = $1.split(/\s/).map{|e|e.to_i}
      when /^hn\s(.+?)$/
        @drawing.hn = $1.split(/\s/).map{|e|e.to_f}
      when /^hp(.+?)\s+?([0-9\-\.]+?)\s+?([0-9\-\.]+?)$/
        p = [$2.to_f, $3.to_f]
        @drawing.hpn[$1] = p
        @drawing.hpn[$1.to_i] = p
      when /^lg([0-9a-f])$/
        @drawing.lgn = $1.to_i(16)
      when /^ly([0-9a-f])$/
        @drawing.lyn = $1.to_i(16)
      when /^lc([1-9])$/
        @drawing.lcn = $1.to_i
      when /^lt([0-9]*?)$/
        @drawing.ltn = $1.to_i
      when /^cn0\s(.*?)$/
        @drawing.cnn = [0] + $1.split(/\s/).map{|e|e.to_f}
      when /^cn([1-9]|10)$/
        @drawing.cnn = $1.to_i
      when /^cn"\$<(.*?)>$/
        @drawing.cn = $1
      when "#"
        break
      end
    end
    
    # @shapes
    @shapes.property = {
      :lgn => @drawing.layer_group,
      :lyn => @drawing.layer,
      :lcn => @drawing.line_color,
      :ltn => @drawing.line_type,
      :cnn => @drawing.font_type,
      :cn  => @drawing.font,
      :zn  => []
    }
    
    while line = lines.shift
      case line
      when /^lg(.*?)$/
        @shapes.property[:lgn] = $1.to_i(16)
      when /^ly(.*?)$/
        @shapes.property[:lyn] = $1.to_i(16)
      when /^lc(.*?)$/
        @shapes.property[:lcn] = $1.split(/\s/).map{|e|e.to_i}
      when /^lt(.*?)$/
        @shapes.property[:ltn] = $1.to_i
      when /^cn(.*?)$/
        @shapes.property[:cnn] = $1.split(/\s/).map{|e|e.to_f}
      when /^cn"\$<(.*?)>$/
        @shapes.property[:cn] = $1
      when /^z([1-5]?)$/
        @shapes.property[:zn] << $1.to_i
      when /^pn([1-9]?)$/
        @shapes.property[:pnn] = $1.to_i
        
      when /^((\s[0-9\-\.].+?){4})$/
        @shapes.add_shape Line.new(*($1.split(/\s/)[1..4].map{|e|e.to_f}))
      when /^ci\s(.*?)$/
        type=($1.split(/\s/).map{|e|e.to_f});
        if type.size==7 then
	        @shapes.add_shape Arc.new(*(type))
        else
	        @shapes.add_shape Circle.new(*(type))
        end 
      when /^c([hvsroptkz2])\s(.*?)\s"(.*?)$/
        args = [$1, $2, $3]
        args[1] = args[1].split(/\s/)
        @shapes.add_shape Text.new(*args.flatten)
      when /^pt\s(.*?)$/
#        @shapes.add_shape Point.new(*($1.split(/\s/).map{|e|e.to_f}))
        # == }u ==(_}[J_ɕϊ)
        pointData=($1.split(/\s/).map{|e|e.to_f})
        if (pointData.size>2) 
          pointData=pointData[0,2]
        end
        @shapes.add_shape Point.new(*(pointData))
       # == }u ==I
      when /^pl/
        args = []
        while (line = lines.shift) != "#"
          args << line.split(/\s/).map{|e|e.to_f}
        end
        @shapes.add_shape CurveLine.new(args)
      when "#"
        break
      else
        @shapes.add_shape AnKnowShape.new(line)
      end
    end
    
    # @layer_group, @layer
    if lines.length == 34
      lg = lines[0].match(/^lg([0-9a-f])\s([0-9]+?)$/).to_a[1..2]
      lgn = lines[1].match(/^lgn(.*?)$/).to_a[1]
      @layer_group = LayerGroup.new(lgn, lg[0].to_i(16), lg[1].to_i)
      16.times{|i|
        ly = lines[i*2+2].match(/^ly[0-9a-f]\s([0-9]+?)$/).to_a[1]
        lyn = lines[i*2+3].match(/^lyn(.*?)$/).to_a[1]
        @layers[i] = Layer.new(lyn, i, ly.to_i)
      }
    end
  end # initialize
  
  # jwc_temp.txt̃obNAbv
  def temp(fname = "temp.txt")
    File.open(fname, "w"){|f|
      f.write @jwc_temp_old
    }
  end
  
  # jwc_temp.txt̏
  def save()
    File.open(@@option[:path] + @@option[:output], "w"){|f|
      f.write @jwc_temp
    }
  end
  
  # x_
  def [](x)
    @drawing.point[x]
  end
  
  # ȉ`ʌn(jwc_tempɏ)\bh
  def write(s)
    @jwc_temp << "#{s}\n"
  end
  
  def draw(obj)
    write obj.drawing_format
  end
  
  def redraw(obj)
    set_layer_group obj.lgn
    set_layer obj.lyn
    if( Point === obj ) then
	    set_point_color obj.pnn
	else
	    set_color *obj.lcn
    end
    set_line_type obj.ltn
    if Text ===obj then
	    set_char_type *obj.cnn
	    set_font obj.cn
	end
    write obj.drawing_format
  end
  
  # :line => Line
  # > def line(*args)
  # >   draw(Line.new(*args))
  # > end
  
  map_table = {
    :line => Line,
    :circle => Circle,
    :text => Text,
    :point => Point,
    :curve => CurveLine,
    :triangle => Triangle,
    :rectangle => Rectangle
  }
  
  map_table.each{|key, klass|
    define_method(key){|*args|
      draw(klass.new(*args))
    }
  }
  
  def set_layer_group(n)
    write "lg#{n.to_s(16)}"
  end
  
  def set_layer(n)
    write "ly#{n.to_s(16)}"
  end
  
  def set_color(n, color=0)
    case n
    when (1..9)
      write "lc#{n}"
    when 10
      write "lc#{n} #{color}"
    end
  end
  
  def set_line_type(n)
    write "lt#{n}"
  end
  
  def set_point_color(n)
    write "pn#{n}"
  end
  
  def set_char_type(n, *args)
    case n
    when (1..10)
      write "cn#{n}"
    when 0
      write "cn#{n} #{args.join(' ')}"
    end
  end
  
  def set_font(s)
    write "cn\"$<#{s}>"
  end
  
  def set_data_property(*n)
    write "z#{n.join(" ")}"
  end
  
  
  def delete_selected
    write "hd"
  end
  
  def error(str)
    write "he #{str}"
  end
  
  def hr; end
  def hslash; end
  
  def alert(str)
    write "h##{str}"
  end
  
  def by; end
end
