module JwrTool
   include Math
   EPS = 0.001
   
   def rage(ang)
      (ang / 360) * 2 * PI
   end
   
   require "complex"
#  def intersection(ln1,ln2,err=0)

	# vZ덷␳
	def complex_eq(a,b)
		(abs((a)-(b)) < EPS)
	end
   
	# xNg̓ (dot product) : aEb = |a||b|cos
	def complex_dot(a,b) 
	   if(Complex===a && Complex===b) then
		  return (a.real * b.real + a.imag * b.imag);
	   end
	   return nil
	end
	# xNg̊O (cross product) : a~b = |a||b|sin
	def complex_cross(a,b) 
	   if(Complex===a && Complex===b) then
		  return (a.real * b.imag - a.imag * b.real);
	   end
	   return nil
	end

	# 2̒𔻒 : ab <=> dot(a, b) = 0
	def is_orthogonal(a1,a2,b1,b2) 
	  return complex_eq( complex_dot(a1-a2, b1-b2), 0.0 );
	end
	
	# 2̕s : a//b <=> cross(a, b) = 0
	def is_parallel(a1,a2,b1,b2) 
	  return complex_eq( complex_cross(a1-a2, b1-b2), 0.0 );
	end

    # a1,a2[_Ƃb1,b2[_Ƃ̌
	def is_complex_intersected_ls(a1,a2,b1,b2) 
	  return ( complex_cross(a2-a1, b1-a1) * complex_cross(a2-a1, b2-a1) < EPS ) &&
	         ( complex_cross(b2-b1, a1-b1) * complex_cross(b2-b1, a2-b1) < EPS );
	end

    # a1,a2[_Ƃb1,b2[_Ƃ̌_vZ
	def complex_intersection_ls(a1,a2,b1,b2)
	  b = b2-b1;
	  d1 = abs(complex_cross(b, a1-b1));
	  d2 = abs(complex_cross(b, a2-b1));
	  d = d1 + d2
	  if d==0
	  	return nil
	  end
	  t = d1 / (d);

	  return a1 + (a2-a1) * t;
	end
	
	# _a,bʂ钼Ɠ_cƂ̉
	def complex_distance_l_p(a,b,c) 
	  lo = complex_cross(b-a, c-a)
	  if(lo==nil) then
	  	  return nil
	  end
	  if(lo>=0) then
		  return (lo).abs / (b-a).abs;
	  else
		  return -(lo).abs / (b-a).abs;
	  end
	end

	# _a,bʂ钼Ɠ_cƂ̉()
	def complex_distance_l_p2(a,b,c) 
	  lo = complex_cross(b-a, c-a)
	  if(lo==nil) then
	  	  return nil
	  end
	  return (lo).abs / (b-a).abs;
	end
	
	# lƓ_pƂ̉
	def distance_line_point(l,p) 
	  return complex_distance_l_p2(Complex.new(l.x1.to_f,l.y1.to_f),Complex.new(l.x2.to_f,l.y2.to_f),Complex.new(p.x.to_f,p.y.to_f));
	end
	
	# n_a1,I_a2ʂ钼Ǝn_b1,I_b2ʂ钼̌_vZ
	def complex_intersection_l(a1,a2,b1,b2)
	  a = a2 - a1;
	  b = b2 - b1;
	  vcross=complex_cross(b, a);
	  if(vcross==0) 
	    return nil
	  end
	  return a1 + a * complex_cross(b, b1-a1) / vcross;
	end
	
  # _
  def inter_line(ln1,ln2,err=0)
	if is_complex_intersected_ls(Complex.new(ln1.x1.to_f,ln1.y1.to_f),Complex.new(ln1.x2.to_f,ln1.y2.to_f),Complex.new(ln2.x1.to_f,ln2.y1.to_f),Complex.new(ln2.x2.to_f,ln2.y2.to_f))==true then
		vcomplex = complex_intersection_l(Complex.new(ln1.x1.to_f,ln1.y1.to_f),Complex.new(ln1.x2.to_f,ln1.y2.to_f),Complex.new(ln2.x1.to_f,ln2.y1.to_f),Complex.new(ln2.x2.to_f,ln2.y2.to_f))
		if(vcomplex==nil)
			return [nil,nil],2
		end
		return [vcomplex.real,vcomplex.imag],0
	else
		return [nil,nil],1
	end

  end

  # _
  def inter_line_segment(ln1,ln2,err=0)
	if is_complex_intersected_ls(Complex.new(ln1.x1,ln1.y1),Complex.new(ln1.x2,ln1.y2),Complex.new(ln2.x1,ln2.y1),Complex.new(ln2.x2,ln2.y2))==true then
		vcomplex = complex_intersection_ls(Complex.new(ln1.x1,ln1.y1),Complex.new(ln1.x2,ln1.y2),Complex.new(ln2.x1,ln2.y1),Complex.new(ln2.x2,ln2.y2))
		return [vcomplex.real,vcomplex.imag],0
	else
		return [nil,nil],1
	end

  end

end
