class Shape
  include Math
  
  
  attr_accessor :attrnames, :lgn, :lyn, :lcn, :ltn, :cnn, :cn, :zn
  map_alias(
    :lgn => :layer_group,
    :lyn => :layer,
    :lcn => :line_color,
    :ltn => :line_type,
    :cnn => :font_type,
    :cn  => :font,
    :zn  => :type
  )
  
  def initialize(*args)
    @attrnames=[:lgn, :lyn, :lcn, :ltn, :cnn, :cn, :zn]
    init(*args)
  end
  
  def set_property(property)
    property.each{|key, val|
      instance_variable_set("@#{key}", (val.methods.include?(:dup) ? val.dup : val))
    }
  end
  
  def line?; false; end
  def circle?; false; end
  def arc?; false; end
  def text?; false; end
  def point?; false; end
  def curve?; false; end
  def anknow?; false; end

end

class Line < Shape
  require "jwr/jwr_tool"
  include JwrTool
  attr_reader :x1, :y1, :x2, :y2
  
  def init(x1, y1, x2, y2)
    @x1, @y1, @x2, @y2 = x1, y1, x2, y2
  end
  
  def length
    sqrt((@x1-@x2)**2 + (@y1-@y2)**2)
  end
  
  def general
    if @x1 == @x2
      [0, nil]
    elsif @y1 == @y2
      [nil, @y1]
    else
      a = (@y1-@y2) / (@x1-@x2)
      b = @y1 - a * @x1
      [a, b]
    end
  end
  alias slope_intercept general
  
  def slope
    general[0]
  end
  
  def intersection(other)
    case other
    when Line
#      return (inter_line(self,other)[0])
      pot = inter_line(self,other)
      if(pot[1]!=0) then
         if(distance_line_point(self,Point.new(other.x1,other.y1))<0.002) then
            return [other.x1,other.y1]
         elsif(distance_line_point(self,Point.new(other.x2,other.y2))<0.002) then
            return [other.x2,other.y2]
         else
            return [nil,nil]
         end
      else
         return pot[0]
      end
    end
  end
  
  def intersegment(other)
    case other
    when Line
      return (inter_line_segment(self,other)[0])
    end
  end
  
  def move(x, y)
    @x1 += x
    @x2 += x
    @y1 += y
    @y2 += y
    self
  end
  
  def drawing_format
    [@x1, @y1, @x2, @y2].map{|e|e.to_s}.join(" ")
  end
  
  def sen_hen_format(p , lyn=nil , mode = 0)
    line_data=drawing_format()
    # _W
    if(Point===p) then
		line_data[0]-=p.x;
		line_data[1]-=p.y;
		line_data[2]-=p.x;
		line_data[3]-=p.y;
	end
	smode="00"
	emode="00"
	if(Numeric===mode) then
		case mode
		when 0 # W
	       smode="00"
	       emode="00"
		when 1 # w[_in_j́AړAI_wWō}
	       smode="10"
	       emode="01"
		when 2 # wE[_iI_j́AړAn_wWō}
	       smode="01"
	       emode="10"
	    end
	elsif(Array===mode) then
	    # ݒ
	    smode,emode=*mode
	end
    if (lyn!=nil) then
	    return "#{smode} #{emode} #{line_data} #{@lcn} #{@ltn} #{lyn}"
    else
	    return "#{smode} #{emode} #{line_data} #{@lcn} #{@ltn} #{@lyn}"
	end
  end
  
  def ang
  	atan2((@y2-@y1) , (@x2-@x1))
  end
  
  def skid_line(deg,wide)
    a=rage(deg)+self.ang
    [ @x1 - wide*sin(a) , @y1 + wide*cos(a) , @x2 - wide*sin(a) , @y2 + wide*cos(a)]
  end
  
  def online_point(t)
    a=self.ang
    [ @x1 - t*sin(a) , @y1 + t*cos(a) ]
  end
  
  def minxpoint 
  	if @x1<@x2 then
  		return [ @x1,@y1 ]
  	else
  		return [ @x2,@y2 ]
  	end
  end

  def minypoint 
  	if @y1<@y2 then
  		return [ @x1,@y1 ]
  	else
  		return [ @x2,@y2 ]
  	end
  end
  
  def __minpoint (p)
    px,py=nil,nil
    if (Point===p) then
       px,py=p.x,p.y
    elsif (Array===p) then
       px,py=*p
    else
       return nil
    end
    if(sqrt((@x1-px)**2 + (@y1-py)**2)<sqrt((@x2-px)**2 + (@y2-py)**2)) then
      return yield("top")
      # [@x1,@y1]
    else
      return yield("end")
      # [@x2,@y2]
    end
  end
  private :__minpoint
  
  def minpoint (p)
    __minpoint(p) { | ans |
       if(ans=="top") then
          [@x1,@y1]
       else
          [@x2,@y2]
       end
    }
  end
  
  def minswap (p)
    __minpoint(p) { | ans |
       if(ans=="top") then
          [@x1,@y1,@x2,@y2]
       else
          [@x2,@y2,@x1,@y1]
       end
    }
  end
  
  def distance_from_point(x,y=nil)
    if(x===Point && y==nil) then
		return distance_line_point(self,x);
    else
		return distance_line_point(self,Point.new(x,y));
	end
  end

  def distance_from_point2(x,y=nil)
    if(x===Point && y==nil) then
		return complex_distance_l_p(Complex.new(self.x1,self.y1),Complex.new(self.x2,self.y2),Complex.new(x.x,x.y));
#		return distance_line_point(self,x);
    else
		return complex_distance_l_p(Complex.new(self.x1,self.y1),Complex.new(self.x2,self.y2),Complex.new(x,y));
#		return distance_line_point(self,Point.new(x,y));
	end
  end

  def swap(t)
    [ @x2, @y2, @x1, @y1 ]
  end

#  def shortline
  
  def line?; true; end
end

class Circle < Shape
  attr_reader :x, :y, :r
  
  def init(x, y, r, option={})
    @option = {
      :flattening => 1,
      :axial_angle => 0
    }.merge(option)
    # start_angle, end_angle, flattening, axial_angle
    
    @x, @y, @r = x, y, r
    if option.empty?
      @type = :usual
    else
      
    end
  end
  
  def general
    case @type
    when :usual
      [@x, @y, @r]
    end
  end
  
  def area
    pi * (@r ** 2)
  end
  
  def move(x, y)
    @x += x
    @y += y
    self
  end
  
  def drawing_format
    a = ["ci", @x, @y, @r]
    unless @option.length == 2
      a << @option[:start_angle]
      a << @option[:end_angle]
      a << @option[:flattening]
      a << @option[:axial_angle]
    end
    a.map{|e|e.to_s}.join(" ")
  end
  
  def circle?; true; end
end

class Arc < Shape
  attr_reader :x, :y, :r, :sa, :ea, :ft, :aa
  
  def init(x, y, r, sa, ea, ft, aa, option={})
    @option = {
      :flattening => 1,
      :axial_angle => 0
    }.merge(option)
    # start_angle, end_angle, flattening, axial_angle
    
    @x, @y, @r, @sa, @ea, @ft, @aa = x, y, r, sa, ea, ft, aa
    if option.empty?
      @type = :usual
    else
      
    end
  end
  
  def general
    case @type
    when :usual
      [@x, @y, @r]
    end
  end
  
  def x1
    @x+@r*sin((@sa / 360) * 2 * PI)
  end
  
  def y1
    @y+@r*cos((@sa / 360) * 2 * PI)
  end
  
  def x2
    @x+@r*sin((@ea / 360) * 2 * PI)
  end
  
  def y2
    @y+@r*cos((@ea / 360) * 2 * PI)
  end
  
  def area
    pi * (@r ** 2)
  end
  
  def move(x, y)
    @x += x
    @y += y
    self
  end
  
  def drawing_format
    a = ["ci", @x, @y, @r, @sa, @ea, @ft, @aa]
    a.map{|e|e.to_s}.join(" ")
  end
  
  def circle?; true; end
  def arc?; true; end
end

class Text < Shape
  require "jwr/jwr_tool"
  include JwrTool
  attr_reader :type, :x, :y, :xv, :yv, :string
  @@xy2=Struct.new("Xy2",:x1,:y1,:x2,:y2)
  @@type_table = {
    :h => "",
    :v => "c",
    :s => "@l",
    :r => "a @l",
    :o => "a @l",
    :p => "px @l",
    :t => "ݐ @l",
    :k => "e ^kf[^",
    :z => "e f[^",
    2 => "2.5Df[^"
  }
  
  def x1
    @x.to_f
  end
  
  def y1
    @y.to_f
  end
  
  def x2
    @x.to_f+@xv.to_f
  end
  
  def y2
    @y.to_f+@yv.to_f
  end
  
  def init(type, x, y, xv, yv, str)
    @type, @x, @y, @xv, @yv, @string = type, x, y, xv, yv, str.to_s
  end
  
  def move(x, y)
    @x += x
    @y += y
    self
  end
  
  def drawing_format
    "c#{@type} #{@x} #{@y} #{@xv} #{@yv} \"#{@string}"
  end
  
  def ang
  	atan2((@yv) , (@xv))
  end
  
  def point(t)
    a=self.ang
    [ @x - t*sin(a) , @y + t*cos(a) ]
  end
  
  def line_point()
    [ @x, @y, @x+@xv, @y+@yv ]
  end
  
  def intersection(other)
    case other
    when Line
      pot = inter_line(@@xy2.new(* self.line_point),other)
      if(pot[1]!=0) then
         if(distance_line_point(@@xy2.new(* self.line_point),Point.new(other.x1,other.y1))<0.002) then
            return [other.x1,other.y1]
         elsif(distance_line_point(@@xy2.new(* self.line_point),Point.new(other.x2,other.y2))<0.002) then
            return [other.x2,other.y2]
         else
            return [nil,nil]
         end
      else
         return pot[0]
      end
    when Text
      pot = inter_line(@@xy2.new(* self.line_point),@@xy2.new(* other.line_point))
      if(pot[1]!=0) then
         if(distance_line_point(@@xy2.new(* self.line_point),Point.new(other.x,other.y))<0.002) then
            return [other.x,other.y]
         elsif(distance_line_point(@@xy2.new(* self.line_point),Point.new(other.x+other.xv,other.y+other.yv))<0.002) then
            return [other.x+other.xv,other.y+other.yv]
         else
            return [nil,nil]
         end
      else
         return pot[0]
      end
    end
  end
  
  def intersegment(other)
    case other
    when Line
      return (inter_line_segment(@@xy2.new(* self.line_point),other)[0])
    when Text
      return (inter_line_segment(@@xy2.new(* self.line_point),@@xy2.new(* other.line_point))[0])
    end
  end

  def text?; true; end
end

class Point < Shape
  attr_reader :x, :y
  def init(x, y)
    @x, @y = x, y
  end
  
  def move(x, y)
    @x += x
    @y += y
    self
  end
  
  def drawing_format
    "pt #{@x} #{@y}"
  end
  
  def point?; true; end
end

class CurveLine < Shape
  attr_reader :lines
  def init(*args)
  	@lines=[]
  	while args.size >= 4
	  	@lines<<Line.new(args.shift,args.shift,args.shift,args.shift);
	end
  end
  def drawing_format
    ret="pl \n"
    @lines.each { |line|
	    ret << "#{line.x1} #{line.y1} #{line.x2}  #{line.y2}\n"
    }
    ret << "\#"
    return ret
  end
  def curve?; true; end
end

class AnKnowShape < Shape
  attr_reader :text
  def init(text_data)
  	@text=text_data
  end
  def drawing_format; "#{@text}"; end
  def anknow?; true; end
end

