class Triangle < Shape
  attr_reader :lines
  
  def init(p1, p2, p3)
    @lines = [Line.new(*(p3+p1)), Line.new(*(p1+p2)), Line.new(*(p2+p3))]
  end
  
  def self.new2(line1, line2, line3)
    p1 = intersection(line1, line2)
    p2 = intersection(line2, line3)
    p3 = intersection(line3, line1)
    self.new(p1, p2, p3)
  end
  
  def points
    ps = []
    @lines.each{|e|
      ps << [e.x1, e.y1] << [e.x2, e.y2]
    }
    ps.uniq
  end
  
  def area
    l1, l2, l3 = @lines.map{|e|e.length}
    s = 0.5 * (l1+l2+l3)
    sqrt(s * (s-l1) * (s-l2) * (s-l3))
  end
  
  def move(x, y)
    @lines.each{|line| line.move(x, y) }
    self
  end
  
  def drawing_format
    @lines.map{|e|e.drawing_format}.join("\n")
  end
end

class Rectangle < Shape
  def init(x1, y1, x2, y2)
    line1 = Line.new(x1, y1, x1, y2)
    line2 = Line.new(x1, y1, x2, y1)
    line3 = Line.new(x2, y1, x2, y2)
    line4 = Line.new(x1, y2, x2, y2)
    @lines = [line1, line2, line3, line4]
  end
  
  def area
    ((x1-x2) * (y1-y2)).abs
  end
  
  def move(x, y)
    @lines.each{|line| line.move(x, y) }
    self
  end
  
  def drawing_format
    @lines.map{|e|e.drawing_format}.join("\n")
  end
end