/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.ConvertingSetting;
import saccubus.FFmpeg;
import saccubus.WayBackDate;
import saccubus.conv.CombineXML;
import saccubus.conv.CommandReplace;
import saccubus.conv.ConvertToVideoHook;
import saccubus.conv.NicoXMLReader;
import saccubus.net.BrowserInfo;
import saccubus.net.NicoClient;
import saccubus.net.Path;
import saccubus.util.Cws2Fws;
import saccubus.util.Stopwatch;
import saccubus.util.Util;

public class Converter
extends Thread {
    private final ConvertingSetting Setting;
    private String Tag;
    private String VideoID;
    private String VideoTitle;
    private String VideoBaseName;
    private String Time;
    private JLabel Status;
    private final ConvertStopFlag StopFlag;
    private static final String TMP_COMMENT = "_vhook.tmp";
    private static final String TMP_OWNERCOMMENT = "_vhookowner.tmp";
    private static final String TMP_OPTIONALTHREAD = "_vhookoptional.tmp";
    private static final String VIDEO_URL_PARSER = "http://www.nicovideo.jp/watch/";
    public static final String OWNER_EXT = "[Owner].xml";
    public static final String OPTIONAL_EXT = "{Optional}.xml";
    private static final String TMP_COMBINED_XML = "_tmp_comment.xml";
    private static final String TMP_COMBINED_XML2 = "_tmp_optional.xml";
    private static final String THUMB_INFO = "_thumb_info";
    private String OtherVideo;
    private final String WatchInfo;
    private final JLabel MovieInfo;
    private BrowserInfo.BrowserCookieKind BrowserKind = BrowserInfo.BrowserCookieKind.NONE;
    private final BrowserInfo BrowserInfo = new BrowserInfo();
    private String UserSession = "";
    private final Stopwatch Stopwatch;
    private File selectedVhook;
    private FFmpeg.Aspect videoAspect;
    private File fwsFile = null;
    private VideoIDFilter DefaultVideoIDFilter;
    private String proxy;
    private int proxy_port;
    private String mailAddress;
    private String password;
    private String inSize;
    private String setSize;
    private String padOption;
    private String outSize;
    private String aprilFool;
    private StringBuffer sbRet = null;
    private String result = "0";
    private String dateUserFirst = "";
    private File VideoFile = null;
    private File CommentFile = null;
    private File OwnerCommentFile = null;
    private File OptionalThreadFile = null;
    private File ConvertedVideoFile = null;
    private File CommentMiddleFile = null;
    private File OwnerMiddleFile = null;
    private File OptionalMiddleFile = null;
    private FFmpeg ffmpeg = null;
    private File VhookNormal = null;
    private File VhookWide = null;
    private int wayOfVhook = 0;
    private ArrayList<File> listOfCommentFile = new ArrayList();
    private String optionalThreadID = "";
    private String errorLog = "";
    private int ownerCommentNum = 0;
    private File fontDir;
    private File gothicFont = null;
    private File simsunFont = null;
    private File gulimFont = null;
    private File arialFont = null;
    private File georgiaFont = null;
    private File devabagariFont = null;
    private File tahomaFont = null;
    private File mingliuFont = null;
    private File newMinchoFont = null;
    private File estrangeloEdessaFont = null;
    private File arialUnicodeFont = null;
    private File gujaratiFont = null;
    private Pattern ngWordPat;
    private Pattern ngIDPat;
    private CommandReplace ngCmd;
    private Path thumbInfo = new Path("null");
    private File thumbInfoFile;
    private static final int CODE_CONVERTING_ABORTED = 100;
    private String ExtOption;
    private String InOption;
    private String OutOption;
    private String MainOption;
    private String ffmpegOptionName = "\u76f4\u63a5\u5165\u529b";
    private String ffmpegVfOption = "";
    private static final String VFILTER_FLAG = "-vfilters";
    private static final String TCOMMENT_EXT = ".txml";

    public Converter(String url, String time, ConvertingSetting setting, JLabel status, ConvertStopFlag flag, JLabel movieInfo, JLabel watch) {
        int index;
        url = url.trim();
        if (url.startsWith(VIDEO_URL_PARSER)) {
            url = url.substring(VIDEO_URL_PARSER.length());
        }
        if ((index = url.indexOf(63)) >= 0) {
            this.Tag = url.substring(0, index);
            this.WatchInfo = url.substring(index);
        } else {
            this.Tag = url;
            this.WatchInfo = "";
        }
        this.VideoID = "[" + this.Tag + "]";
        this.DefaultVideoIDFilter = new VideoIDFilter(this.VideoID);
        this.Time = time.equals("000000") || time.equals("0") ? "" : time;
        this.Setting = setting;
        this.Status = status;
        this.StopFlag = flag;
        this.MovieInfo = movieInfo;
        this.MovieInfo.setText(" ");
        this.Stopwatch = new Stopwatch(watch);
    }

    public Converter(String url, String time, ConvertingSetting setting, JLabel status, ConvertStopFlag flag, JLabel movieInfo, JLabel watch, StringBuffer sbret) {
        this(url, time, setting, status, flag, movieInfo, watch);
        this.sbRet = sbret;
    }

    public File getVideoFile() {
        return this.VideoFile;
    }

    private String getVideoBaseName() {
        return this.VideoBaseName;
    }

    public ConvertingSetting getSetting() {
        return this.Setting;
    }

    public String getErrorLog() {
        return this.errorLog;
    }

    private void sendtext(String text) {
        this.Status.setText(text);
    }

    private boolean isSaveConverted() {
        return this.Setting.isSaveConverted();
    }

    private boolean isSaveVideo() {
        return this.Setting.isSaveVideo();
    }

    private boolean isSaveComment() {
        return this.Setting.isSaveComment();
    }

    private boolean isSaveOwnerComment() {
        return this.Setting.isSaveOwnerComment() && this.isSaveComment();
    }

    private boolean isConvertWithComment() {
        return this.Setting.isConvertWithComment();
    }

    private boolean isConvertWithOwnerComment() {
        return this.Setting.isConvertWithOwnerComment();
    }

    private boolean isVideoFixFileName() {
        return this.Setting.isVideoFixFileName();
    }

    private boolean isCommentFixFileName() {
        return this.Setting.isCommentFixFileName();
    }

    private boolean isDeleteVideoAfterConverting() {
        return this.Setting.isDeleteVideoAfterConverting();
    }

    private boolean isDeleteCommentAfterConverting() {
        return this.Setting.isDeleteCommentAfterConverting();
    }

    private boolean useProxy() {
        return this.Setting.useProxy();
    }

    private boolean checkOK() {
        this.sendtext("\u30c1\u30a7\u30c3\u30af\u3057\u3066\u3044\u307e\u3059");
        if (!(this.isSaveConverted() || this.isSaveVideo() || this.isSaveComment() || this.isSaveOwnerComment() || this.Setting.isSaveThumbInfo())) {
            this.sendtext("\u4f55\u3082\u3059\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u305b\u3093");
            this.result = "1";
            return false;
        }
        if (this.isSaveConverted()) {
            File a = new File(this.Setting.getFFmpegPath());
            if (!a.canRead()) {
                this.sendtext("FFmpeg\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                this.result = "2";
                return false;
            }
            this.ffmpeg = new FFmpeg(this.Setting.getFFmpegPath());
            if (this.Setting.isUseVhookNormal()) {
                if (this.Setting.getVhookPath().indexOf(32) >= 0) {
                    this.sendtext("\u3059\u3044\u307e\u305b\u3093\u3002\u73fe\u5728vhook\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u306f\u534a\u89d2\u7a7a\u767d\u306f\u4f7f\u3048\u307e\u305b\u3093\u3002");
                    this.result = "3";
                    return false;
                }
                this.VhookNormal = new File(this.Setting.getVhookPath());
                if (!this.VhookNormal.canRead()) {
                    this.sendtext("Vhook\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    this.result = "4";
                    return false;
                }
                ++this.wayOfVhook;
            }
            if (this.Setting.isUseVhookWide()) {
                if (this.Setting.getVhookWidePath().isEmpty()) {
                    this.VhookWide = this.VhookNormal;
                } else {
                    if (this.Setting.getVhookWidePath().indexOf(32) >= 0) {
                        this.sendtext("\u3059\u3044\u307e\u305b\u3093\u3002\u73fe\u5728vhook\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u306f\u534a\u89d2\u7a7a\u767d\u306f\u4f7f\u3048\u307e\u305b\u3093\u3002");
                        this.result = "5";
                        return false;
                    }
                    this.VhookWide = new File(this.Setting.getVhookWidePath());
                }
                if (!this.VhookWide.canRead()) {
                    this.sendtext("Vhook\u30e9\u30a4\u30d6\u30e9\u30ea\uff08\u30ef\u30a4\u30c9\uff09\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    this.result = "6";
                    return false;
                }
                ++this.wayOfVhook;
            }
            if (this.wayOfVhook == 0) {
                this.sendtext("\u4f7f\u7528\u3067\u304d\u308bVhook\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                this.result = "7";
                return false;
            }
            if (this.Setting.isEnableCA()) {
                String windir = System.getenv("windir");
                if (windir == null) {
                    this.sendtext("Windows\u30d5\u30a9\u30eb\u30c0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    this.result = "8";
                    return false;
                }
                this.fontDir = new File(windir, "Fonts");
                if (!this.fontDir.isDirectory()) {
                    this.sendtext("Fonts\u30d5\u30a9\u30eb\u30c0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    this.result = "9";
                    return false;
                }
                this.simsunFont = new File(this.fontDir, "SIMSUN.TTC");
                if (!this.simsunFont.canRead()) {
                    this.sendtext("CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.simsunFont.getPath());
                    this.result = "10";
                    return false;
                }
                this.gulimFont = new File(this.fontDir, "GULIM.TTC");
                if (!this.gulimFont.canRead()) {
                    this.sendtext("CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.gulimFont.getPath());
                    this.result = "11";
                    return false;
                }
                this.arialFont = new File(this.fontDir, "arial.ttf");
                if (!this.arialFont.canRead()) {
                    this.sendtext("CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.arialFont.getPath());
                    this.result = "12";
                    return false;
                }
                this.gothicFont = new File(this.fontDir, "msgothic.ttc");
                if (!this.gothicFont.canRead()) {
                    this.sendtext("CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.gothicFont.getPath());
                    this.result = "13";
                    return false;
                }
                this.georgiaFont = new File(this.fontDir, "sylfaen.ttf");
                if (!this.georgiaFont.canRead()) {
                    this.sendtext("\u8b66\u544a\u3000CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.georgiaFont.getPath());
                    System.out.println("CA\u7528\u30d5\u30a9\u30f3\u30c8" + this.georgiaFont.getPath() + "\u3092" + this.gothicFont.getName() + "\u3067\u4ee3\u66ff\u3057\u307e\u3059\u3002");
                    this.georgiaFont = this.gothicFont;
                }
                this.devabagariFont = new File(this.fontDir, "mangal.ttf");
                if (!this.devabagariFont.canRead()) {
                    this.sendtext("\u8b66\u544a\u3000CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.devabagariFont.getPath());
                    System.out.println("CA\u7528\u30d5\u30a9\u30f3\u30c8" + this.devabagariFont.getPath() + "\u3092" + this.arialFont.getName() + "\u3067\u4ee3\u66ff\u3057\u307e\u3059\u3002");
                    this.devabagariFont = this.arialFont;
                }
                this.tahomaFont = new File(this.fontDir, "tahoma.ttf");
                if (!this.tahomaFont.canRead()) {
                    this.sendtext("\u8b66\u544a\u3000CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.tahomaFont.getPath());
                    System.out.println("CA\u7528\u30d5\u30a9\u30f3\u30c8" + this.tahomaFont.getPath() + "\u3092" + this.arialFont.getName() + "\u3067\u4ee3\u66ff\u3057\u307e\u3059\u3002");
                    this.tahomaFont = this.arialFont;
                }
                this.mingliuFont = new File(this.fontDir, "mingliu.ttc");
                if (!this.mingliuFont.canRead()) {
                    this.sendtext("\u8b66\u544a\u3000CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.mingliuFont.getPath());
                    System.out.println("CA\u7528\u30d5\u30a9\u30f3\u30c8" + this.mingliuFont.getPath() + "\u3092" + this.simsunFont.getName() + "\u3067\u4ee3\u66ff\u3057\u307e\u3059\u3002");
                    this.mingliuFont = this.simsunFont;
                }
                this.newMinchoFont = new File(this.fontDir, "NGULIM.TTF");
                if (!this.newMinchoFont.canRead()) {
                    this.sendtext("\u8b66\u544a\u3000CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.newMinchoFont.getPath());
                    System.out.println("CA\u7528\u30d5\u30a9\u30f3\u30c8" + this.newMinchoFont.getPath() + "\u3092" + this.simsunFont.getName() + "\u3067\u4ee3\u66ff\u3057\u307e\u3059\u3002");
                    this.newMinchoFont = this.simsunFont;
                }
                this.estrangeloEdessaFont = new File(this.fontDir, "estre.ttf");
                if (!this.estrangeloEdessaFont.canRead()) {
                    this.sendtext("\u8b66\u544a\u3000CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.estrangeloEdessaFont.getPath());
                    System.out.println("CA\u7528\u30d5\u30a9\u30f3\u30c8" + this.estrangeloEdessaFont.getPath() + "\u3092" + this.arialFont.getName() + "\u3067\u4ee3\u66ff\u3057\u307e\u3059\u3002");
                    this.estrangeloEdessaFont = this.arialFont;
                }
                this.arialUnicodeFont = new File(this.fontDir, "ARIALUNI.TTF");
                if (!this.arialUnicodeFont.canRead()) {
                    this.sendtext("CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.arialUnicodeFont.getPath());
                    System.out.println("\u8b66\u544a\u3000CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.arialUnicodeFont.getPath());
                    this.arialUnicodeFont = null;
                }
                this.gujaratiFont = new File(this.fontDir, "SHRUTI.TTF");
                if (!this.gujaratiFont.canRead()) {
                    this.sendtext("\u8b66\u544a\u3000CA\u7528\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + this.gujaratiFont.getPath());
                    System.out.println("CA\u7528\u30d5\u30a9\u30f3\u30c8" + this.gujaratiFont.getPath() + "\u3092" + this.arialFont.getName() + "\u3067\u4ee3\u66ff\u3057\u307e\u3059\u3002");
                    this.gujaratiFont = this.arialFont;
                }
            } else {
                a = new File(this.Setting.getFontPath());
                if (!a.canRead()) {
                    this.sendtext("\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    this.result = "30";
                    return false;
                }
            }
        } else {
            if (this.isDeleteVideoAfterConverting()) {
                this.sendtext("\u5909\u63db\u3057\u306a\u3044\u306e\u306b\u3001\u52d5\u753b\u524a\u9664\u3057\u3061\u3083\u3063\u3066\u826f\u3044\u3093\u3067\u3059\u304b\uff1f");
                this.result = "31";
                return false;
            }
            if (this.isDeleteCommentAfterConverting()) {
                this.sendtext("\u5909\u63db\u3057\u306a\u3044\u306e\u306b\u3001\u30b3\u30e1\u30f3\u30c8\u524a\u9664\u3057\u3061\u3083\u3063\u3066\u826f\u3044\u3093\u3067\u3059\u304b\uff1f");
                this.result = "32";
                return false;
            }
        }
        if (this.isSaveVideo() || this.isSaveComment() || this.isSaveOwnerComment() || this.Setting.isSaveThumbInfo()) {
            this.UserSession = this.BrowserInfo.getUserSession(this.Setting);
            this.BrowserKind = this.BrowserInfo.getValidBrowser();
            if (this.BrowserKind == BrowserInfo.BrowserCookieKind.NONE) {
                this.mailAddress = this.Setting.getMailAddress();
                this.password = this.Setting.getPassword();
                if (this.mailAddress == null || this.mailAddress.isEmpty() || this.password == null || this.password.isEmpty()) {
                    this.sendtext("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304b\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u7a7a\u767d\u3067\u3059\u3002");
                    this.result = "33";
                    return false;
                }
            } else if (this.UserSession.isEmpty()) {
                this.sendtext("\u30d6\u30e9\u30a6\u30b6" + this.BrowserKind.getName() + "\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u53d6\u5f97\u306b\u5931\u6557");
                this.result = "34";
                return false;
            }
            if (this.useProxy()) {
                this.proxy = this.Setting.getProxy();
                this.proxy_port = this.Setting.getProxyPort();
                if (this.proxy == null || this.proxy.isEmpty() || this.proxy_port < 0 || this.proxy_port > 65535) {
                    this.sendtext("\u30d7\u30ed\u30ad\u30b7\u306e\u8a2d\u5b9a\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                    this.result = "35";
                    return false;
                }
            } else {
                this.proxy = null;
                this.proxy_port = -1;
            }
        }
        this.sendtext("\u30c1\u30a7\u30c3\u30af\u7d42\u4e86");
        return true;
    }

    private NicoClient getNicoClient() {
        if (this.isSaveVideo() || this.isSaveComment() || this.isSaveOwnerComment() || this.Setting.isSaveThumbInfo()) {
            this.sendtext("\u30ed\u30b0\u30a4\u30f3\u4e2d");
            NicoClient client = null;
            client = this.BrowserKind != BrowserInfo.BrowserCookieKind.NONE ? new NicoClient(this.BrowserKind, this.UserSession, this.proxy, this.proxy_port, this.Stopwatch) : new NicoClient(this.mailAddress, this.password, this.proxy, this.proxy_port, this.Stopwatch);
            if (!client.isLoggedIn()) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u5931\u6557 " + this.BrowserKind.getName() + " " + client.getExtraError());
            } else {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u6210\u529f " + this.BrowserKind.getName());
            }
            return client;
        }
        return null;
    }

    private boolean saveVideo(NicoClient client) {
        File folder = this.Setting.getVideoFixFileNameFolder();
        this.sendtext("\u52d5\u753b\u306e\u4fdd\u5b58");
        if (this.isSaveVideo()) {
            if (this.isVideoFixFileName()) {
                if (folder.mkdir()) {
                    System.out.println("Folder created: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u52d5\u753b\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    this.result = "40";
                    return false;
                }
                this.VideoFile = new File(folder, String.valueOf(this.getVideoBaseName()) + ".flv");
            } else {
                this.VideoFile = this.Setting.getVideoFile();
            }
            this.sendtext("\u52d5\u753b\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u52d5\u753b\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                this.result = "41";
                return false;
            }
            if (this.Setting.isDisableEco() && client.isEco()) {
                this.sendtext("\u30a8\u30b3\u30ce\u30df\u30fc\u30e2\u30fc\u30c9\u306a\u306e\u3067\u4e2d\u6b62\u3057\u307e\u3059");
                this.result = "42";
                return false;
            }
            this.VideoFile = client.getVideo(this.VideoFile, this.Status, this.StopFlag, this.isVideoFixFileName() && this.Setting.isChangeMp4Ext());
            if (this.stopFlagReturn()) {
                this.result = "43";
                return false;
            }
            if (this.VideoFile == null) {
                this.sendtext("\u52d5\u753b\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557" + client.getExtraError());
                this.result = "44";
                return false;
            }
            if (this.optionalThreadID == null || this.optionalThreadID.isEmpty()) {
                this.optionalThreadID = client.getOptionalThreadID();
            }
        } else if (this.isSaveConverted()) {
            if (this.isVideoFixFileName()) {
                String videoFilename = this.detectTitleFromVideo(folder);
                if (videoFilename == null) {
                    if (this.OtherVideo == null) {
                        this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        this.result = "45";
                    } else {
                        this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c.flv\u3067\u3042\u308a\u307e\u305b\u3093\uff1a" + this.OtherVideo);
                        this.result = "46";
                    }
                    return false;
                }
                this.VideoFile = new File(folder, videoFilename);
                if (!this.VideoFile.canRead()) {
                    this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                    this.result = "47";
                    return false;
                }
            } else {
                this.VideoFile = this.Setting.getVideoFile();
                if (!this.VideoFile.exists()) {
                    this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    this.result = "48";
                    return false;
                }
            }
        }
        this.sendtext("\u52d5\u753b\u306e\u4fdd\u5b58\u3092\u7d42\u4e86");
        return true;
    }

    private boolean saveComment(NicoClient client) {
        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58");
        File folder = this.Setting.getCommentFixFileNameFolder();
        String commentTitle = "";
        String prefix = "";
        String back_comment = this.Setting.getBackComment();
        if (this.isSaveComment()) {
            if (this.isCommentFixFileName()) {
                if (folder.mkdir()) {
                    System.out.println("Folder created: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    this.result = "50";
                    return false;
                }
                if (this.Setting.isAddTimeStamp()) {
                    WayBackDate wbDate;
                    prefix = this.Time == null || this.Time.isEmpty() || this.Time.equals("0") || this.Time.equals("Owner") || this.Time.equals("Optional") ? "[" + WayBackDate.formatNow() + "]" : ((wbDate = new WayBackDate(this.Time)).isValid() ? "[" + wbDate.format() + "]" : "[" + this.Time + "]");
                }
                commentTitle = String.valueOf(this.getVideoBaseName()) + prefix;
                this.CommentFile = new File(folder, String.valueOf(commentTitle) + ".xml");
            } else {
                this.CommentFile = this.Setting.getCommentFile();
            }
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                this.result = "51";
                return false;
            }
            if (this.Setting.isFixCommentNum()) {
                back_comment = client.getBackCommentFromLength(back_comment);
            }
            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
            this.CommentFile = client.getComment(this.CommentFile, this.Status, back_comment, this.Time, this.StopFlag, this.Setting.getCommentIndex());
            if (this.stopFlagReturn()) {
                this.result = "52";
                return false;
            }
            if (this.CommentFile == null) {
                this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557 " + client.getExtraError());
                this.result = "53";
                return false;
            }
            this.dateUserFirst = this.getDateUserFirst(this.CommentFile);
            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u7d42\u4e86");
            this.optionalThreadID = client.getOptionalThreadID();
            this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u4fdd\u5b58");
            if (this.optionalThreadID != null && !this.optionalThreadID.isEmpty()) {
                this.OptionalThreadFile = this.isCommentFixFileName() ? new File(folder, String.valueOf(this.getVideoBaseName()) + prefix + OPTIONAL_EXT) : this.getOptionalThreadFile(this.Setting.getCommentFile());
                this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
                this.OptionalThreadFile = client.getOptionalThread(this.OptionalThreadFile, this.Status, this.optionalThreadID, back_comment, this.Time, this.StopFlag, this.Setting.getCommentIndex());
                if (this.stopFlagReturn()) {
                    this.result = "54";
                    return false;
                }
                if (this.OptionalThreadFile == null) {
                    this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557 " + client.getExtraError());
                    this.result = "55";
                    return false;
                }
                if (this.dateUserFirst.isEmpty()) {
                    this.dateUserFirst = this.getDateUserFirst(this.OptionalThreadFile);
                }
                this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u4fdd\u5b58\u7d42\u4e86");
            }
        }
        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u7d42\u4e86");
        return true;
    }

    private File getOptionalThreadFile(File file) {
        if (file == null || !file.isFile() || file.getPath() == null) {
            return this.mkTemp(OPTIONAL_EXT);
        }
        String path = file.getPath();
        int index = path.lastIndexOf(".");
        if (index > path.lastIndexOf(File.separator)) {
            path = path.substring(0, index);
        }
        return new File(String.valueOf(path) + OPTIONAL_EXT);
    }

    private String getDateUserFirst(File comfile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.CommentFile));
            String text = br.readLine();
            int begin = 0;
            int end = 0;
            if (text.contains("date=\"") && (end = text.indexOf("\" ", begin = text.indexOf("date=\"") + "date=\"".length())) > 0) {
                return text.substring(begin, end);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private boolean saveOwnerComment(NicoClient client) {
        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isSaveOwnerComment()) {
            if (this.isCommentFixFileName()) {
                if (folder.mkdir()) {
                    System.out.println("Folder created: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    this.result = "60";
                    return false;
                }
                this.OwnerCommentFile = new File(folder, String.valueOf(this.getVideoBaseName()) + OWNER_EXT);
            } else {
                this.OwnerCommentFile = this.Setting.getOwnerCommentFile();
            }
            this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                this.result = "61";
                return false;
            }
            this.OwnerCommentFile = client.getOwnerComment(this.OwnerCommentFile, this.Status, this.StopFlag);
            if (this.stopFlagReturn()) {
                this.result = "62";
                return false;
            }
            if (this.OwnerCommentFile == null) {
                this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557");
                System.out.println("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557");
                return true;
            }
            if (this.optionalThreadID == null || this.optionalThreadID.isEmpty()) {
                this.optionalThreadID = client.getOptionalThreadID();
            }
        }
        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u7d42\u4e86");
        return true;
    }

    private boolean saveThumbInfo(NicoClient client) {
        this.sendtext("\u52d5\u753b\u60c5\u5831\u306e\u4fdd\u5b58");
        File folder = this.Setting.getVideoFixFileNameFolder();
        if (this.Setting.isSaveThumbInfo()) {
            String ext = this.Setting.isSaveThumbInfoAsText() ? ".txt" : ".xml";
            folder = this.Setting.getVideoFixFileNameFolder();
            if (this.isVideoFixFileName()) {
                if (folder.mkdir()) {
                    System.out.println("Folder created: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u52d5\u753b\u60c5\u5831\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    this.result = "A0";
                    return false;
                }
                this.thumbInfoFile = new File(folder, String.valueOf(this.getVideoBaseName()) + ext);
            } else {
                this.thumbInfoFile = this.getThumbInfoFileFrom(this.Setting.getVideoFile(), ext);
            }
            if (this.thumbInfoFile == null) {
                this.sendtext("\u52d5\u753b\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u304cnull\u3067\u3059");
                this.result = "A1";
                return false;
            }
            this.sendtext("\u52d5\u753b\u60c5\u5831\u306e\u4fdd\u5b58\u4e2d");
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u52d5\u753b\u60c5\u5831\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                this.result = "A2";
                return false;
            }
            this.thumbInfo = client.getThumbInfoFile(this.Tag);
            if (this.stopFlagReturn()) {
                this.result = "A3";
                return false;
            }
            if (this.thumbInfo == null) {
                this.sendtext("\u52d5\u753b\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557" + client.getExtraError());
                this.result = "A4";
                return false;
            }
            System.out.println("reading:" + this.thumbInfo);
            if (!this.saveThumbUser(this.thumbInfo, client)) {
                System.out.println("\u6295\u7a3f\u8005\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557");
                return false;
            }
            if (!this.saveThumbnailJpg(this.thumbInfo, client)) {
                System.out.println("\u30b5\u30e0\u30cd\u30a4\u30eb\u753b\u50cf\u306e\u53d6\u5f97\u306b\u5931\u6557");
                return false;
            }
            String text = Path.readAllText(this.thumbInfo.getPath(), "UTF-8");
            text = text.replace("\n", "\r\n");
            try {
                PrintWriter pw = new PrintWriter(this.thumbInfoFile, "UTF-8");
                pw.write(text);
                pw.flush();
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.thumbInfo.delete()) {
                System.out.println("Deleted:" + this.thumbInfo);
            }
        }
        this.sendtext("\u52d5\u753b\u60c5\u5831\u306e\u4fdd\u5b58\u7d42\u4e86");
        return true;
    }

    private boolean saveThumbUser(Path infoFile, NicoClient client) {
        this.sendtext("\u6295\u7a3f\u8005\u60c5\u5831\u306e\u4fdd\u5b58");
        Path userThumbFile = null;
        if (this.Setting.isSaveThumbUser()) {
            int index;
            String infoXml = Path.readAllText(infoFile.getPath(), "UTF-8");
            String userID = NicoClient.getXmlElement(infoXml, "user_id");
            if (userID == null || userID.isEmpty() || userID.equals("none")) {
                this.sendtext("\u6295\u7a3f\u8005\u306e\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093");
                this.result = "A5";
                return false;
            }
            System.out.println("\u6295\u7a3f\u8005:" + userID);
            File userFolder = new File(this.Setting.getUserFolder());
            if (userFolder.mkdirs()) {
                System.out.println("Folder created: " + userFolder.getPath());
            }
            if (!userFolder.isDirectory()) {
                this.sendtext("\u30e6\u30fc\u30b6\u30fc\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093");
                this.result = "A6";
                return false;
            }
            userThumbFile = new Path(userFolder, String.valueOf(userID) + ".htm");
            String html = null;
            String ownerName = null;
            if (!userThumbFile.canRead()) {
                userThumbFile = client.getThumbUserFile(userID, userFolder);
            }
            if (userThumbFile != null && userThumbFile.canRead()) {
                html = Path.readAllText(userThumbFile.getPath(), "UTF-8");
                ownerName = NicoClient.getXmlElement(html, "title");
            }
            if (ownerName == null || ownerName.contains("\u975e\u516c\u958b\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb")) {
                ownerName = null;
                userThumbFile = client.getUserInfoFile(userID, userFolder);
                if (userThumbFile != null && userThumbFile.canRead()) {
                    html = Path.readAllText(userThumbFile.getPath(), "UTF-8");
                    ownerName = NicoClient.getXmlElement(html, "title");
                }
                if (ownerName == null) {
                    this.sendtext("\u6295\u7a3f\u8005\u306e\u60c5\u5831\u306e\u5165\u624b\u306b\u5931\u6557");
                    this.result = "A7";
                    return false;
                }
            }
            if ((index = ownerName.lastIndexOf("\u3055\u3093\u306e\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u2010")) > 0) {
                ownerName = ownerName.substring(0, index);
            }
            if ((index = ownerName.lastIndexOf("\u3055\u3093\u306e\u30e6\u30fc\u30b6\u30fc\u30da\u30fc\u30b8 \u2010")) > 0) {
                ownerName = String.valueOf(ownerName.substring(0, index)) + "(\u30cb\u30b3\u30ec\u30dd\u975e\u516c\u958b)";
            }
            infoXml = infoXml.replace("</user_id>", "</user_id>\n<user>" + ownerName + "</user>");
            try {
                PrintWriter pw = new PrintWriter((File)infoFile, "UTF-8");
                pw.write(infoXml);
                pw.flush();
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        this.sendtext("\u6295\u7a3f\u8005\u60c5\u5831\u306e\u4fdd\u5b58\u7d42\u4e86");
        return true;
    }

    private boolean saveThumbnailJpg(Path infoFile, NicoClient client) {
        this.sendtext("\u30b5\u30e0\u30cd\u30a4\u30eb\u753b\u50cf\u306e\u4fdd\u5b58");
        File thumbnailJpg = null;
        if (this.Setting.isSaveThumbnailJpg()) {
            String infoXml = Path.readAllText(infoFile.getPath(), "UTF-8");
            String url = NicoClient.getXmlElement(infoXml, "thumbnail_url");
            if (url == null || url.isEmpty() || !url.startsWith("http")) {
                this.sendtext("\u30b5\u30e0\u30cd\u30a4\u30eb\u753b\u50cf\u306e\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093");
                this.result = "A8";
                return false;
            }
            if (this.isVideoFixFileName()) {
                File folder = this.Setting.getVideoFixFileNameFolder();
                if (folder.mkdir()) {
                    System.out.println("Folder created: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u30b5\u30e0\u30cd\u30a4\u30eb\u753b\u50cf\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    this.result = "A9";
                    return false;
                }
                thumbnailJpg = new File(folder, String.valueOf(this.getVideoBaseName()) + ".jpg");
            } else {
                File file = this.Setting.getVideoFile();
                if (file == null || !file.isFile() || file.getPath() == null) {
                    thumbnailJpg = this.mkTemp(String.valueOf(this.Tag) + "_thumnail.jpg");
                } else {
                    String path = file.getPath();
                    int index = path.lastIndexOf(".");
                    if (index > path.lastIndexOf(File.separator)) {
                        path = String.valueOf(path.substring(0, index)) + ".jpg";
                    }
                    thumbnailJpg = new File(path);
                }
            }
            this.sendtext("\u30b5\u30e0\u30cd\u30a4\u30eb\u753b\u50cf\u306e\u4fdd\u5b58\u4e2d");
            if (!client.getThumbnailJpg(url, thumbnailJpg)) {
                this.sendtext("\u30b5\u30e0\u30cd\u30a4\u30eb\u753b\u50cf\u306e\u53d6\u5f97\u306b\u5931\u6557" + client.getExtraError());
                this.result = "AA";
                return false;
            }
        }
        this.sendtext("\u30b5\u30e0\u30cd\u30a4\u30eb\u753b\u50cf\u306e\u4fdd\u5b58\u7d42\u4e86");
        return true;
    }

    private File getThumbInfoFileFrom(File file, String ext) {
        if (file == null || !file.isFile() || file.getPath() == null) {
            return this.mkTemp(THUMB_INFO + ext);
        }
        String path = file.getPath();
        int index = path.lastIndexOf(".");
        if (index > path.lastIndexOf(File.separator)) {
            path = path.substring(0, index);
        }
        return new File(String.valueOf(path) + THUMB_INFO + ext);
    }

    private boolean makeNGPattern() {
        this.sendtext("NG\u30d1\u30bf\u30fc\u30f3\u4f5c\u6210\u4e2d");
        try {
            String all_regex = "/((docomo|iPhone|softbank) (white )?)?.* 18[46]|18[46] .*/";
            String def_regex = "/((docomo|iPhone|softbank) (white )?)?18[46]/";
            String ngWord = this.Setting.getNG_Word().replaceFirst("^all", all_regex).replace(" all", all_regex);
            ngWord = ngWord.replaceFirst("^default", def_regex).replace(" default", def_regex);
            this.ngWordPat = NicoXMLReader.makePattern(ngWord);
            this.ngIDPat = NicoXMLReader.makePattern(this.Setting.getNG_ID());
            this.ngCmd = new CommandReplace(this.Setting.getNGCommand(), this.Setting.getReplaceCommand());
        }
        catch (Exception e) {
            this.sendtext("NG\u30d1\u30bf\u30fc\u30f3\u4f5c\u6210\u306b\u5931\u6557\u3002\u304a\u305d\u3089\u304f\u6b63\u898f\u8868\u73fe\u306e\u9593\u9055\u3044\uff1f");
            this.result = "70";
            return false;
        }
        this.sendtext("NG\u30d1\u30bf\u30fc\u30f3\u4f5c\u6210\u7d42\u4e86");
        return true;
    }

    private Path mkTemp(String uniq) {
        return Path.mkTemp(String.valueOf(this.Tag) + uniq);
    }

    private boolean convertComment() {
        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u4e2d");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isConvertWithComment()) {
            if (this.Setting.isAddTimeStamp() && this.isCommentFixFileName()) {
                ArrayList<String> pathlist = this.detectFilelistFromComment(folder);
                if (pathlist == null || pathlist.isEmpty()) {
                    this.sendtext(String.valueOf(this.Tag) + ": \u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u30fb\u904e\u53bb\u30ed\u30b0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    this.result = "71";
                    return false;
                }
                if (pathlist.size() > 0) {
                    ArrayList<File> filelist = new ArrayList<File>();
                    for (String path : pathlist) {
                        filelist.add(new File(folder, path));
                    }
                    this.CommentFile = this.mkTemp(TMP_COMBINED_XML);
                    this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u7d50\u5408\u4e2d");
                    if (!CombineXML.combineXML(filelist, this.CommentFile)) {
                        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u7d50\u5408\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\uff08\u30d0\u30b0\uff1f\uff09");
                        this.result = "72";
                        return false;
                    }
                    if (this.dateUserFirst.isEmpty()) {
                        this.dateUserFirst = this.getDateUserFirst(this.CommentFile);
                    }
                    this.listOfCommentFile = filelist;
                }
            }
            if (!this.isSaveComment()) {
                if (this.isCommentFixFileName()) {
                    if (!this.Setting.isAddTimeStamp()) {
                        String commentfilename = this.detectTitleFromComment(folder);
                        if (commentfilename == null) {
                            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                            this.result = "73";
                            return false;
                        }
                        this.CommentFile = new File(folder, commentfilename);
                        if (!this.CommentFile.canRead()) {
                            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                            this.result = "74";
                            return false;
                        }
                        if (this.dateUserFirst.isEmpty()) {
                            this.dateUserFirst = this.getDateUserFirst(this.CommentFile);
                        }
                    }
                } else {
                    this.CommentFile = this.Setting.getCommentFile();
                    if (!this.CommentFile.exists()) {
                        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        this.result = "75";
                        return false;
                    }
                    if (this.dateUserFirst.isEmpty()) {
                        this.dateUserFirst = this.getDateUserFirst(this.CommentFile);
                    }
                }
            }
            this.CommentMiddleFile = this.mkTemp(TMP_COMMENT);
            if (!this.convertToCommentMiddle(this.CommentFile, this.CommentMiddleFile)) {
                this.sendtext("\u30b3\u30e1\u30f3\u30c8\u5909\u63db\u306b\u5931\u6557");
                this.CommentMiddleFile = null;
                this.result = "76";
                return false;
            }
            if (!this.CommentMiddleFile.canRead()) {
                this.CommentMiddleFile = null;
            }
        }
        return true;
    }

    private boolean convertOprionalThread() {
        this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u306e\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u4e2d");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isConvertWithComment()) {
            if (this.isCommentFixFileName()) {
                if (this.Setting.isAddTimeStamp()) {
                    ArrayList<String> pathlist = this.detectFilelistFromOptionalThread(folder);
                    if (pathlist == null || pathlist.isEmpty()) {
                        this.sendtext(String.valueOf(this.Tag) + ": \u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u30fb\u904e\u53bb\u30ed\u30b0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        System.out.println("No optional thread.");
                        this.OptionalThreadFile = null;
                        return true;
                    }
                    ArrayList<File> filelist = new ArrayList<File>();
                    for (String path : pathlist) {
                        filelist.add(new File(folder, path));
                    }
                    this.OptionalThreadFile = this.mkTemp(TMP_COMBINED_XML2);
                    this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u7d50\u5408\u4e2d");
                    if (!CombineXML.combineXML(filelist, this.OptionalThreadFile)) {
                        this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u304c\u7d50\u5408\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\uff08\u30d0\u30b0\uff1f\uff09");
                        this.result = "77";
                        return false;
                    }
                    if (this.dateUserFirst.isEmpty()) {
                        this.dateUserFirst = this.getDateUserFirst(this.OptionalThreadFile);
                    }
                    this.listOfCommentFile.addAll(filelist);
                } else {
                    String filename = this.detectTitleFromOptionalThread(folder);
                    if (filename == null || filename.isEmpty()) {
                        this.sendtext(String.valueOf(this.Tag) + ": \u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        System.out.println("No optional thread.");
                        this.OptionalThreadFile = null;
                        return true;
                    }
                    this.OptionalThreadFile = new File(folder, filename);
                    if (this.dateUserFirst.isEmpty()) {
                        this.dateUserFirst = this.getDateUserFirst(this.OptionalThreadFile);
                    }
                }
            } else {
                this.OptionalThreadFile = this.getOptionalThreadFile(this.Setting.getCommentFile());
                if (!this.OptionalThreadFile.exists()) {
                    this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    System.out.println("No optional thread.");
                    this.OptionalThreadFile = null;
                    return true;
                }
                if (this.dateUserFirst.isEmpty()) {
                    this.dateUserFirst = this.getDateUserFirst(this.OptionalThreadFile);
                }
            }
            this.OptionalMiddleFile = this.mkTemp(TMP_OPTIONALTHREAD);
            if (!this.convertToCommentMiddle(this.OptionalThreadFile, this.OptionalMiddleFile)) {
                this.sendtext("\u30aa\u30d7\u30b7\u30e7\u30ca\u30eb\u30b9\u30ec\u30c3\u30c9\u5909\u63db\u306b\u5931\u6557");
                this.OptionalMiddleFile = null;
                this.result = "78";
                return false;
            }
            if (!this.OptionalMiddleFile.canRead()) {
                this.OptionalMiddleFile = null;
            }
        }
        return true;
    }

    private boolean convertOwnerComment() {
        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u4e2d");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isConvertWithOwnerComment()) {
            if (!this.isSaveOwnerComment()) {
                if (this.isCommentFixFileName()) {
                    String ownerfilename = this.detectTitleFromOwnerComment(folder);
                    if (ownerfilename == null) {
                        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        System.out.println("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        this.OwnerCommentFile = null;
                        return true;
                    }
                    this.OwnerCommentFile = new File(folder, ownerfilename);
                    if (!this.OwnerCommentFile.canRead()) {
                        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                        this.result = "81";
                        return false;
                    }
                } else {
                    this.OwnerCommentFile = this.Setting.getOwnerCommentFile();
                    if (!this.OwnerCommentFile.exists()) {
                        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        System.out.println("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        this.OwnerCommentFile = null;
                        return true;
                    }
                }
            }
            this.OwnerMiddleFile = this.mkTemp(TMP_OWNERCOMMENT);
            if (!this.convertToCommentMiddle(this.OwnerCommentFile, this.OwnerMiddleFile)) {
                this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u5909\u63db\u306b\u5931\u6557");
                this.OwnerMiddleFile = null;
                this.result = "83";
                return false;
            }
            if (!this.OwnerMiddleFile.canRead()) {
                this.OwnerMiddleFile = null;
                this.ownerCommentNum = 0;
            } else {
                try {
                    FileInputStream fos = new FileInputStream(this.OwnerMiddleFile);
                    this.ownerCommentNum = Util.readInt(fos);
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.OwnerMiddleFile = null;
                    this.result = "84";
                    return false;
                }
            }
        }
        return true;
    }

    private void deleteCommentFile() {
        if (this.CommentFile != null && this.CommentFile.delete()) {
            System.out.println("Deleted: " + this.CommentFile.getPath());
        }
        if (this.OptionalThreadFile != null && this.OptionalThreadFile.delete()) {
            System.out.println("Deleted: " + this.OptionalThreadFile.getPath());
        }
        this.deleteList(this.listOfCommentFile);
        if (this.OwnerCommentFile != null && this.OwnerCommentFile.delete()) {
            System.out.println("Deleted: " + this.OwnerCommentFile.getPath());
        }
    }

    private boolean convertToCommentMiddle(File commentfile, File middlefile) {
        if (!ConvertToVideoHook.convert(commentfile, middlefile, this.ngIDPat, this.ngWordPat, this.ngCmd, this.Setting.getScoreLimit())) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(middlefile);
            int comment_num = Util.readInt(fis);
            fis.close();
            if (comment_num == 0 && middlefile.delete()) {
                System.out.println("Deleted 0 comment-file: " + middlefile.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean convertVideo() throws IOException {
        this.sendtext("\u52d5\u753b\u306e\u5909\u63db\u3092\u958b\u59cb");
        this.Stopwatch.start();
        if (!this.VideoFile.canRead()) {
            this.sendtext("\u52d5\u753b\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
            this.result = "90";
            return false;
        }
        File folder = this.Setting.getConvFixFileNameFolder();
        if (!this.chekAspectVhookOption(this.VideoFile, this.wayOfVhook)) {
            this.result = "91";
            return false;
        }
        if (this.Setting.isConvFixFileName()) {
            if (folder.mkdir()) {
                System.out.println("Created folder: " + folder.getPath());
            }
            if (!folder.isDirectory()) {
                this.sendtext("\u5909\u63db\u5f8c\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                this.result = "92";
                return false;
            }
            String conv_name = this.VideoTitle;
            if (conv_name == null) {
                conv_name = "";
            }
            if (!this.Setting.isNotAddVideoID_Conv()) {
                String string = conv_name = this.Setting.isChangeTitleId() ? String.valueOf(this.VideoTitle) + this.VideoID : String.valueOf(this.VideoID) + this.VideoTitle;
            }
            if (conv_name.isEmpty()) {
                this.sendtext("\u5909\u63db\u5f8c\u306e\u30d3\u30c7\u30aa\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u78ba\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
                this.result = "93";
                return false;
            }
            if (this.Setting.isAddOption_ConvVideoFile()) {
                byte[] dirName = new File(folder, conv_name).getAbsolutePath().getBytes("Shift_JIS");
                if (dirName.length > 243) {
                    conv_name = this.VideoID;
                }
                if ((folder = new File(folder, conv_name = conv_name.trim())).mkdir()) {
                    System.out.println("Created folder: " + folder.getPath());
                }
                if (!folder.isDirectory()) {
                    this.sendtext("\u52d5\u753b(FFmpeg\u8a2d\u5b9a\u540d)\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    this.result = "94";
                    return false;
                }
                conv_name = String.valueOf(this.MainOption) + this.InOption + this.OutOption;
                if (!this.getFFmpegVfOption().isEmpty()) {
                    conv_name = "-vfilters " + this.getFFmpegVfOption() + conv_name;
                }
                if ((dirName = new File(folder, conv_name = String.valueOf(this.getFFmpegOptionName()) + Converter.safeAsciiFileName(conv_name)).getAbsolutePath().getBytes("Shift_JIS")).length > 252) {
                    int len = conv_name.length() - (dirName.length - 252);
                    if (len < 1) {
                        this.sendtext("\u4f5c\u6210\u3059\u308b\u30d3\u30c7\u30aa\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u9577\u3059\u304e\u307e\u3059\u3002");
                        this.result = "95";
                        return false;
                    }
                    conv_name = conv_name.substring(0, len);
                }
                conv_name = conv_name.trim();
            }
            this.ConvertedVideoFile = new File(folder, String.valueOf(conv_name) + this.ExtOption);
        } else {
            String filename = this.Setting.getConvertedVideoFile().getPath();
            if (!filename.endsWith(this.ExtOption)) {
                filename = String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + this.ExtOption;
                this.ConvertedVideoFile = new File(filename);
            } else {
                this.ConvertedVideoFile = this.Setting.getConvertedVideoFile();
            }
        }
        if (this.ConvertedVideoFile.getAbsolutePath().equals(this.VideoFile.getAbsolutePath())) {
            this.sendtext("\u5909\u63db\u5f8c\u306e\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u5909\u63db\u524d\u3068\u540c\u3058\u3067\u3059");
            this.result = "96";
            return false;
        }
        int code = this.converting_video();
        this.Stopwatch.stop();
        File log_vhext = new File(".", "[log]vhext.txt");
        Path video_vhext = Path.mkTemp(String.valueOf(this.Tag) + "[log]vhext.txt");
        if (video_vhext.exists()) {
            if (log_vhext.delete()) {
                Path.fileCopy(video_vhext, log_vhext);
            }
        } else {
            Path.fileCopy(video_vhext, log_vhext);
        }
        if (code == 0) {
            this.sendtext("\u5909\u63db\u304c\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            System.out.println(this.ffmpeg.getLastFrame());
            return true;
        }
        if (code != 100) {
            this.sendtext("\u5909\u63db\u30a8\u30e9\u30fc\uff1a(" + code + ") " + this.ffmpeg.getLastError());
        }
        this.result = "97";
        return false;
    }

    private static String safeAsciiFileName(String str) {
        str = str.replace('/', '_').replace('\\', '_').replace('?', '_').replace('*', '_').replace(':', ';').replace('|', '_').replace('\"', '\'').replace('<', '(').replace('>', ')').replaceAll(" +", " ").trim();
        return str;
    }

    @Override
    public void run() {
        try {
            this.Stopwatch.clear();
            this.Stopwatch.start();
            if (!this.checkOK()) {
                return;
            }
            NicoClient client = this.getNicoClient();
            if (client != null) {
                if (!client.isLoggedIn()) {
                    return;
                }
                if (!client.getVideoInfo(this.Tag, this.WatchInfo, this.Time, this.Setting.isSaveWatchPage())) {
                    if (this.Tag == null || this.Tag.isEmpty()) {
                        this.sendtext("URL/ID\u306e\u6307\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093 " + client.getExtraError());
                    } else {
                        this.sendtext(String.valueOf(this.Tag) + "\u306e\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557 " + client.getExtraError());
                    }
                    return;
                }
                if (this.stopFlagReturn()) {
                    return;
                }
                this.VideoTitle = client.getVideoTitle();
                this.VideoBaseName = this.Setting.isChangeTitleId() ? String.valueOf(this.VideoTitle) + this.VideoID : String.valueOf(this.VideoID) + this.VideoTitle;
                this.sendtext(String.valueOf(this.Tag) + "\u306e\u60c5\u5831\u306e\u53d6\u5f97\u306b\u6210\u529f");
            }
            this.Stopwatch.show();
            if (!this.saveVideo(client) || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.saveComment(client) || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.saveOwnerComment(client) || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.saveThumbInfo(client) || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            System.out.println("\u5909\u63db\u524d\u6642\u9593\u3000" + this.Stopwatch.formatElapsedTime());
            if (!this.isSaveConverted()) {
                this.sendtext("\u52d5\u753b\u30fb\u30b3\u30e1\u30f3\u30c8\u3092\u4fdd\u5b58\u3057\u3001\u5909\u63db\u306f\u884c\u3044\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                return;
            }
            this.Stopwatch.show();
            if (!this.makeNGPattern() || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.convertComment() || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.convertOwnerComment() || this.stopFlagReturn()) {
                return;
            }
            this.Stopwatch.show();
            if (!this.convertOprionalThread() || this.stopFlagReturn()) {
                return;
            }
            try {
                this.Stopwatch.show();
                if (this.convertVideo()) {
                    if (this.isDeleteCommentAfterConverting() && this.CommentFile != null) {
                        this.deleteCommentFile();
                    }
                    if (this.isDeleteVideoAfterConverting() && this.VideoFile != null && this.VideoFile.delete()) {
                        System.out.println("Deleted: " + this.VideoFile.getPath());
                    }
                    if (this.CommentMiddleFile != null && this.CommentMiddleFile.delete()) {
                        System.out.println("Deleted: " + this.CommentMiddleFile.getPath());
                    }
                    if (this.OwnerMiddleFile != null && this.OwnerMiddleFile.delete()) {
                        System.out.println("Deleted: " + this.OwnerMiddleFile.getPath());
                    }
                    if (this.OptionalMiddleFile != null && this.OptionalMiddleFile.delete()) {
                        System.out.println("Deleted: " + this.OptionalMiddleFile.getPath());
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        finally {
            this.StopFlag.finished();
            this.Stopwatch.show();
            this.Stopwatch.stop();
            System.out.println("\u5909\u63db\u6642\u9593\u3000" + this.Stopwatch.formatLatency());
            System.out.println("LastStatus:[" + this.result + "]" + this.Status.getText());
            System.out.println("VideoInfo: " + this.MovieInfo.getText());
            if (this.sbRet != null) {
                this.sbRet.append("RESULT=" + this.result + "\n");
                if (!this.dateUserFirst.isEmpty()) {
                    this.sbRet.append("DATEUF=" + this.dateUserFirst + "\n");
                }
            }
        }
    }

    private void deleteList(ArrayList<File> list) {
        if (list == null) {
            return;
        }
        boolean b = true;
        for (File file : list) {
            boolean bl = b = file.delete() && b;
        }
        if (!b) {
            System.out.println("Can't delete list of all Comment.");
        }
    }

    private boolean chekAspectVhookOption(File video, int way) {
        String str;
        this.fwsFile = null;
        try {
            this.fwsFile = Cws2Fws.createFws(video);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.fwsFile != null) {
            this.VideoFile = this.fwsFile;
            video = this.fwsFile;
        }
        this.videoAspect = this.ffmpeg.getAspect(video);
        if (this.videoAspect == null) {
            str = "Analize Error   ";
            this.videoAspect = FFmpeg.Aspect.NORMAL;
        } else {
            str = String.valueOf(this.videoAspect.explain()) + "  ";
        }
        if (way == 1) {
            if (this.VhookNormal == null) {
                if (!this.videoAspect.isWide()) {
                    str = "\u2260" + str;
                }
                this.videoAspect = FFmpeg.Aspect.WIDE;
            } else {
                if (this.videoAspect.isWide()) {
                    str = "\u2260" + str;
                }
                this.videoAspect = FFmpeg.Aspect.NORMAL;
            }
        }
        String auto = "";
        if (way == 2) {
            auto = "\u81ea\u52d5\u9078\u629e ";
        }
        if (this.videoAspect.isWide()) {
            this.selectedVhook = this.VhookWide;
            this.MovieInfo.setText(String.valueOf(auto) + "\u62e1\u5f35Vhook \u30ef\u30a4\u30c9 " + str);
        } else {
            this.selectedVhook = this.VhookNormal;
            this.MovieInfo.setText(String.valueOf(auto) + "\u62e1\u5f35Vhook \u5f93\u6765 " + str);
        }
        if (!this.detectOption(this.videoAspect.isWide())) {
            this.sendtext("\u5909\u63db\u30aa\u30d7\u30b7\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return false;
        }
        if (!this.addAdditionalOption(this.videoAspect.isWide())) {
            this.sendtext("\u8ffd\u52a0\u30aa\u30d7\u30b7\u30e7\u30f3\u306e\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return false;
        }
        if (this.Setting.getReplaceOptions() != null) {
            this.replace3option(this.Setting.getReplaceOptions());
        }
        this.ffmpegVfOption = this.getvfOption();
        this.inSize = this.videoAspect.getSize();
        this.setSize = this.getSetSize();
        this.padOption = this.getPadOption();
        this.outSize = this.getOutSize();
        if (this.outSize == null) {
            int width = this.videoAspect.getWidth();
            int height = this.videoAspect.getHeight();
            if (this.videoAspect.isWide()) {
                double rate = 640.0 / (double)width;
                width = 640;
                height = (int)((double)height * rate);
            } else {
                double rate = 384.0 / (double)height;
                width = (int)((double)width * rate);
                height = 384;
            }
            if (this.setSize != null) {
                String[] list = this.setSize.split(":");
                try {
                    width = Integer.parseInt(list[0]);
                    height = Integer.parseInt(list[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Output Commetnt Area " + width + ":" + height);
        } else {
            System.out.println("Output Commetnt Area " + this.outSize);
        }
        return true;
    }

    private String getSetSize() {
        String[] list = this.OutOption.split(" +");
        int i = 0;
        while (i < list.length) {
            String size;
            String arg = list[i];
            if (arg.equals("-s") && i + 1 < list.length && (size = list[i + 1]).contains("x")) {
                return size.replace('x', ':');
            }
            ++i;
        }
        return null;
    }

    private String getPadOption() {
        return this.getFromVfOpotion("pad=");
    }

    private String getOutSize() {
        String outs = this.getFromVfOpotion("outs=");
        String outs_str = "outs=" + outs;
        if (outs != null) {
            if (outs_str.equals(this.getFFmpegVfOption())) {
                this.setFfmpegVfOption("");
            } else if (this.getvfOption().startsWith(outs_str)) {
                this.setFfmpegVfOption(this.getFFmpegVfOption().replace(String.valueOf(outs_str) + ",", ""));
            } else {
                this.setFfmpegVfOption(this.getFFmpegVfOption().replace("," + outs_str, ""));
            }
        }
        return outs;
    }

    private String getFromVfOpotion(String prefix) {
        String option = this.getFFmpegVfOption();
        String[] list = option.split(",");
        int i = 0;
        while (i < list.length) {
            String arg = list[i];
            if (arg.startsWith(prefix)) {
                return arg.substring(prefix.length());
            }
            ++i;
        }
        return null;
    }

    private boolean addAdditionalOption(boolean wide) {
        String addOption = "";
        addOption = wide ? this.Setting.getWideAddOption() : this.Setting.getAddOption();
        if (addOption.isEmpty()) {
            return true;
        }
        String[] list = addOption.split(" +");
        HashMap<String, String> optionMap = new HashMap<String, String>(16);
        String key = "";
        String value = "";
        int i = 0;
        while (i < list.length) {
            String arg = list[i];
            if (arg.startsWith("-")) {
                if (!key.isEmpty()) {
                    optionMap.put(key, value);
                }
                key = arg;
                value = "";
            } else {
                value = arg;
            }
            ++i;
        }
        if (!key.isEmpty()) {
            optionMap.put(key, value);
        }
        this.replace3option(optionMap);
        return true;
    }

    private int converting_video() {
        int code = -1;
        this.ffmpeg.setCmd("-y ");
        this.ffmpeg.addCmd(this.MainOption);
        this.ffmpeg.addCmd(" ");
        this.ffmpeg.addCmd(this.InOption);
        this.ffmpeg.addCmd(" -i ");
        this.ffmpeg.addFile(this.VideoFile);
        this.ffmpeg.addCmd(" ");
        this.ffmpeg.addCmd(this.OutOption);
        if (!this.Setting.isVhookDisabled()) {
            if (!this.addVhookSetting(this.ffmpeg, this.selectedVhook, this.videoAspect.isWide())) {
                return -1;
            }
        } else if (!this.getFFmpegVfOption().isEmpty()) {
            this.ffmpeg.addCmd(" -vfilters ");
            this.ffmpeg.addCmd(this.getFFmpegVfOption());
        }
        this.ffmpeg.addCmd(" ");
        this.ffmpeg.addFile(this.ConvertedVideoFile);
        System.out.println("arg:" + this.ffmpeg.getCmd());
        code = this.ffmpeg.exec(this.Status, 100, this.StopFlag, this.Stopwatch);
        this.errorLog = this.ffmpeg.getErrotLog().toString();
        return code;
    }

    private boolean addVhookSetting(FFmpeg ffmpeg, File vhookExe, boolean isWide) {
        try {
            String extra;
            String encoding = "Shift_JIS";
            ffmpeg.addCmd(" -vfilters \"");
            if (!this.getFFmpegVfOption().isEmpty()) {
                ffmpeg.addCmd(this.getFFmpegVfOption());
                ffmpeg.addCmd(",");
            }
            ffmpeg.addCmd("vhext=");
            ffmpeg.addFile(vhookExe);
            if (this.CommentMiddleFile != null) {
                ffmpeg.addCmd("|--data-user:");
                ffmpeg.addCmd(URLEncoder.encode(Path.toUnixPath(this.CommentMiddleFile), encoding));
                ffmpeg.addCmd("|--show-user:");
                ffmpeg.addCmd(this.Setting.getVideoShowNum());
            }
            if (this.OwnerMiddleFile != null) {
                ffmpeg.addCmd("|--data-owner:");
                ffmpeg.addCmd(URLEncoder.encode(Path.toUnixPath(this.OwnerMiddleFile), encoding));
                int ownershowcomment = Integer.parseInt("1000");
                if (ownershowcomment > this.ownerCommentNum) {
                    ownershowcomment = this.ownerCommentNum;
                }
                ffmpeg.addCmd("|--show-owner:" + ownershowcomment);
            }
            if (this.OptionalMiddleFile != null) {
                ffmpeg.addCmd("|--data-optional:");
                ffmpeg.addCmd(URLEncoder.encode(Path.toUnixPath(this.OptionalMiddleFile), encoding));
                ffmpeg.addCmd("|--show-optional:");
                ffmpeg.addCmd(this.Setting.getVideoShowNum());
                if (this.Setting.isOptionalTranslucent()) {
                    ffmpeg.addCmd("|--optional-translucent");
                }
            }
            if (this.Setting.getFontPath() != null) {
                ffmpeg.addCmd("|--font:");
                ffmpeg.addCmd(URLEncoder.encode(Path.toUnixPath(this.Setting.getFontPath()), encoding));
            }
            ffmpeg.addCmd("|--font-index:");
            ffmpeg.addCmd(this.Setting.getFontIndex());
            ffmpeg.addCmd("|--shadow:" + this.Setting.getShadowIndex());
            if (this.Setting.isVhook_ShowConvertingVideo()) {
                ffmpeg.addCmd("|--enable-show-video");
            }
            if (this.Setting.isFixFontSize()) {
                ffmpeg.addCmd("|--enable-fix-font-size");
            }
            if (this.Setting.isOpaqueComment()) {
                ffmpeg.addCmd("|--enable-opaque-comment");
            }
            if (isWide) {
                ffmpeg.addCmd("|--nico-width-wide");
            }
            ffmpeg.addCmd("|--input-size:" + this.inSize);
            if (this.setSize != null) {
                ffmpeg.addCmd("|--set-size:" + this.setSize);
            }
            if (this.padOption != null) {
                ffmpeg.addCmd("|--pad-option:" + this.padOption);
            }
            if (this.outSize != null) {
                ffmpeg.addCmd("|--out-size:" + this.outSize);
            }
            if (this.Setting.isFontHeightFix()) {
                ffmpeg.addCmd("|--font-height-fix-ratio:" + this.Setting.getFontHeightFixRaito());
            }
            String comment_speed = this.Setting.getCommentSpeed();
            if (this.Setting.isSetCommentSpeed() && comment_speed != null && !comment_speed.isEmpty()) {
                ffmpeg.addCmd("|--comment-speed:" + URLEncoder.encode(comment_speed, encoding));
            }
            if ((extra = this.Setting.getExtraMode()).contains("-April=")) {
                int index = extra.indexOf("-April=");
                this.aprilFool = extra.substring(index + "-April=".length());
                index = (String.valueOf(this.aprilFool) + " ").indexOf(" ");
                this.aprilFool = this.aprilFool.substring(0, index).trim();
                extra = extra.replace("-April=" + this.aprilFool, "");
            }
            if (this.aprilFool != null) {
                ffmpeg.addCmd("|--april-fool:" + this.aprilFool);
            }
            if (extra.contains("debug")) {
                ffmpeg.addCmd("|--debug-print");
            }
            if (!extra.isEmpty()) {
                ffmpeg.addCmd("|--extra-mode:" + extra.replaceFirst("debug", ""));
            }
            if (this.Setting.isEnableCA()) {
                ffmpeg.addCmd("|--enable-CA");
                ffmpeg.addCmd("|--font-dir:" + URLEncoder.encode(String.valueOf(Path.toUnixPath(this.fontDir)) + "/", encoding));
                ffmpeg.addCmd("|--gothic-font:");
                ffmpeg.addCmd(this.getFontUrl(this.gothicFont, encoding));
                ffmpeg.addCmd("|--simsun-font:");
                ffmpeg.addCmd(this.getFontUrl(this.simsunFont, encoding));
                ffmpeg.addCmd("|--gulim-font:");
                ffmpeg.addCmd(this.getFontUrl(this.gulimFont, encoding));
                ffmpeg.addCmd("|--arial-font:");
                ffmpeg.addCmd(this.getFontUrl(this.arialFont, encoding));
                ffmpeg.addCmd("|--georgia-font:");
                ffmpeg.addCmd(this.getFontUrl(this.georgiaFont, encoding));
                ffmpeg.addCmd("|--devanagari-font:");
                ffmpeg.addCmd(this.getFontUrl(this.devabagariFont, encoding));
                ffmpeg.addCmd("|--tahoma-font:");
                ffmpeg.addCmd(this.getFontUrl(this.tahomaFont, encoding));
                ffmpeg.addCmd("|--mingliu-font:");
                ffmpeg.addCmd(this.getFontUrl(this.mingliuFont, encoding));
                String newMinchoPath = this.newMinchoFont.getName();
                if (this.newMinchoFont == this.simsunFont) {
                    newMinchoPath = "1 " + newMinchoPath;
                }
                ffmpeg.addCmd("|--new-mincho-font:");
                ffmpeg.addCmd(URLEncoder.encode(newMinchoPath, encoding));
                ffmpeg.addCmd("|--estrangelo-edessa-font:");
                ffmpeg.addCmd(this.getFontUrl(this.estrangeloEdessaFont, encoding));
                ffmpeg.addCmd("|--gujarati-font:");
                ffmpeg.addCmd(this.getFontUrl(this.gujaratiFont, encoding));
                if (this.arialUnicodeFont != null) {
                    ffmpeg.addCmd("|--arial-unicode-font:");
                    ffmpeg.addCmd(this.getFontUrl(this.arialUnicodeFont, encoding));
                }
                if (this.Setting.isUseLineSkip()) {
                    ffmpeg.addCmd("|--use-lineskip-as-fontsize");
                }
                if (this.Setting.isUseExtraFont()) {
                    ffmpeg.addCmd("|--extra-font:");
                    ffmpeg.addCmd(URLEncoder.encode(this.Setting.getExtraFontText(), encoding));
                }
            }
            if (this.Setting.isDisableOriginalResize()) {
                ffmpeg.addCmd("|--disable-original-resize");
            }
            if (this.Setting.isFontWidthFix()) {
                ffmpeg.addCmd("|--font-width-fix-ratio:" + this.Setting.getFontWidthFixRaito());
            }
            ffmpeg.addCmd("|--end-of-loooooooooooooooooooooong-argument1|--end-of-argument2\"");
            return true;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String getFontUrl(File fontfile, String enc) throws UnsupportedEncodingException {
        if (this.fontDir.isDirectory() && fontfile.getParentFile().equals(this.fontDir)) {
            return URLEncoder.encode(fontfile.getName(), enc);
        }
        return URLEncoder.encode(Path.toUnixPath(fontfile), enc);
    }

    public boolean isConverted() {
        return this.StopFlag.isConverted();
    }

    private boolean stopFlagReturn() {
        if (this.StopFlag.needStop()) {
            this.sendtext("\u4e2d\u6b62\u3057\u307e\u3057\u305f\u3002");
            return true;
        }
        return false;
    }

    public ConvertStopFlag getStopFlag() {
        return this.StopFlag;
    }

    boolean detectOption(boolean isWide) {
        File option_file = null;
        option_file = !isWide ? this.Setting.getOptionFile() : this.Setting.getWideOptionFile();
        if (option_file != null) {
            block7: {
                try {
                    Properties prop = new Properties();
                    prop.loadFromXML(new FileInputStream(option_file));
                    this.ExtOption = prop.getProperty("EXT");
                    this.InOption = prop.getProperty("IN");
                    this.OutOption = prop.getProperty("OUT");
                    this.MainOption = prop.getProperty("MAIN");
                    if (this.ExtOption != null && this.InOption != null && this.OutOption != null && this.MainOption != null) break block7;
                    return false;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            this.ffmpegOptionName = option_file.getName().replace(".xml", "");
        }
        if (!isWide) {
            this.ExtOption = this.Setting.getCmdLineOptionExt();
            this.InOption = this.Setting.getCmdLineOptionIn();
            this.OutOption = this.Setting.getCmdLineOptionOut();
            this.MainOption = this.Setting.getCmdLineOptionMain();
        } else {
            this.ExtOption = this.Setting.getWideCmdLineOptionExt();
            this.InOption = this.Setting.getWideCmdLineOptionIn();
            this.OutOption = this.Setting.getWideCmdLineOptionOut();
            this.MainOption = this.Setting.getWideCmdLineOptionMain();
        }
        if (this.ExtOption != null && !this.ExtOption.startsWith(".")) {
            this.ExtOption = "." + this.ExtOption;
        }
        return true;
    }

    private void replace3option(Map<String, String> map) {
        for (Map.Entry<String, String> pair : map.entrySet()) {
            String optOut;
            String optIn;
            String optMain = this.replaceOption(this.MainOption, pair.getKey(), pair.getValue());
            if (optMain != null) {
                this.MainOption = optMain;
            }
            if ((optIn = this.replaceOption(this.InOption, pair.getKey(), pair.getValue())) != null) {
                this.InOption = optIn;
            }
            if ((optOut = this.replaceOption(this.OutOption, pair.getKey(), pair.getValue())) != null) {
                this.OutOption = optOut;
            }
            if (optIn != null || optOut != null || optMain != null) continue;
            this.OutOption = String.valueOf(pair.getKey()) + " " + pair.getValue() + " " + this.OutOption;
        }
    }

    private String replaceOption(String option, String key, String value) {
        key = String.valueOf(key) + " ";
        if (option != null && !option.isEmpty() && option.contains(key)) {
            String ret = option.trim();
            int keypos = ret.indexOf(key);
            int valpos = (ret = String.valueOf(ret) + " ").indexOf(" ", keypos) + 1;
            if (valpos >= ret.length()) {
                return String.valueOf(ret) + value;
            }
            ret = String.valueOf(ret) + " ";
            int valend = ret.indexOf(" ", valpos);
            ret = String.valueOf(ret.substring(0, valpos)) + value + ret.substring(valend);
            return ret.trim();
        }
        return null;
    }

    private String getvfOption() {
        String vfIn = this.getvfOption(this.InOption);
        this.InOption = this.deletevfOption(this.InOption, vfIn);
        String vfOut = this.getvfOption(this.OutOption);
        this.OutOption = this.deletevfOption(this.OutOption, vfOut);
        String vfMain = this.getvfOption(this.MainOption);
        this.MainOption = this.deletevfOption(this.MainOption, vfMain);
        if (vfIn.isEmpty()) {
            vfIn = vfMain;
        } else if (!vfMain.isEmpty()) {
            vfIn = String.valueOf(vfIn) + "," + vfMain;
        }
        if (vfIn.isEmpty()) {
            vfIn = vfOut;
        } else if (!vfOut.isEmpty()) {
            vfIn = String.valueOf(vfIn) + "," + vfOut;
        }
        return vfIn;
    }

    private String getvfOption(String option) {
        if (option == null) {
            return "";
        }
        int index = option.indexOf(VFILTER_FLAG);
        if (index < 0) {
            return "";
        }
        option = option.substring(index + VFILTER_FLAG.length());
        index = (option = option.trim()).indexOf(" ");
        if (index < 0) {
            return option;
        }
        option = option.substring(0, index);
        return option;
    }

    private String deletevfOption(String option, String vfoption) {
        if (option == null) {
            return "";
        }
        return option.replace(VFILTER_FLAG, "").replace(vfoption, "").replaceAll(" +", " ");
    }

    public String getInOption() {
        return this.InOption;
    }

    public String getFFmpegOptionName() {
        return this.ffmpegOptionName;
    }

    public String getFFmpegVfOption() {
        return this.ffmpegVfOption;
    }

    public void setFfmpegVfOption(String vfOption) {
        this.ffmpegVfOption = vfOption;
    }

    private void setVideoTitleIfNull(String path) {
        String videoTitle = this.VideoTitle;
        if (videoTitle == null) {
            videoTitle = this.getTitleFromPath(path, this.VideoID);
            int index = videoTitle.lastIndexOf("[");
            if (index >= 0) {
                videoTitle = videoTitle.substring(0, index);
            }
            System.out.println("Title<" + videoTitle + ">");
            this.VideoTitle = videoTitle;
        }
    }

    String detectTitleFromVideo(File dir) {
        if (dir == null) {
            return null;
        }
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].startsWith(this.VideoID)) {
                String path = list[i];
                if (path.endsWith(".flv") || path.endsWith(".mp4") && this.Setting.isChangeMp4Ext()) {
                    this.setVideoTitleIfNull(path);
                    return path;
                }
                this.OtherVideo = path;
            }
            ++i;
        }
        return null;
    }

    private String detectTitleFromComment(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            String path = list[i];
            if (path.endsWith(".xml") && !path.endsWith(OWNER_EXT) && !path.endsWith(OPTIONAL_EXT)) {
                this.setVideoTitleIfNull(path);
                return path;
            }
            ++i;
        }
        return null;
    }

    private String detectTitleFromOwnerComment(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            block7: {
                String ext;
                String path;
                block6: {
                    block5: {
                        path = list[i];
                        if (!path.endsWith(OWNER_EXT)) break block5;
                        ext = OWNER_EXT;
                        break block6;
                    }
                    if (!path.endsWith(TCOMMENT_EXT)) break block7;
                    ext = TCOMMENT_EXT;
                }
                this.setVideoTitleIfNull(path.replace(ext, ""));
                return path;
            }
            ++i;
        }
        return null;
    }

    private String detectTitleFromOptionalThread(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            String path = list[i];
            if (path.endsWith(OPTIONAL_EXT)) {
                this.setVideoTitleIfNull(path.replace(OPTIONAL_EXT, ""));
                return path;
            }
            ++i;
        }
        return null;
    }

    private ArrayList<String> detectFilelistFromComment(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        ArrayList<String> filelist = new ArrayList<String>();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.endsWith(".xml") && !path.endsWith(OWNER_EXT) && !path.endsWith(OPTIONAL_EXT)) {
                this.setVideoTitleIfNull(path);
                filelist.add(path);
            }
            ++n2;
        }
        return filelist;
    }

    private ArrayList<String> detectFilelistFromOptionalThread(File dir) {
        String[] list = dir.list(this.DefaultVideoIDFilter);
        if (list == null) {
            return null;
        }
        ArrayList<String> filelist = new ArrayList<String>();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.endsWith(OPTIONAL_EXT)) {
                this.setVideoTitleIfNull(path.replace(OPTIONAL_EXT, ""));
                filelist.add(path);
            }
            ++n2;
        }
        return filelist;
    }

    private String getTitleFromPath(String path, String videoID) {
        if (path.indexOf(videoID) >= 0) {
            path = path.replace(videoID, "");
        }
        if (path.lastIndexOf(".") > path.lastIndexOf(File.separator)) {
            path = path.substring(0, path.lastIndexOf("."));
        }
        return path;
    }

    private static class VideoIDFilter
    implements FilenameFilter {
        private final String VideoTag;

        public VideoIDFilter(String videoTag) {
            this.VideoTag = videoTag;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.indexOf(this.VideoTag) >= 0;
        }
    }
}

