/*
 *  The MIT License
 *
 *  Copyright 2011 Masahiko, SAWAI <say@users.sourceforge.jp>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.service;

import android.content.Context;
import android.database.Cursor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.routine_work.simple_battery_logger.BatteryUtils;
import org.routine_work.simple_battery_logger.db.DBConstants;
import org.routine_work.simple_battery_logger.util.Log;

/**
 *
 * @author sawai
 */
public class CsvFileExporter implements DBConstants
{

	public static final String CSV_FILE_SUFFIX = ".csv";
	private static final String LOG_TAG = "simple-battery-logger";
	private Context context;

	public CsvFileExporter(Context context)
	{
		this.context = context;
	}

	public void export(File outputFile, Cursor cursor) throws IOException
	{
		Log.v(LOG_TAG, "Hello");
		Log.d(LOG_TAG, "export() : outputFile => " + outputFile);
		Log.v(LOG_TAG, "export() : parentFile.exists => " + outputFile.getParentFile().exists());

		// init output writer
		FileOutputStream fos = new FileOutputStream(outputFile);
		OutputStreamWriter osw = new OutputStreamWriter(fos);
		BufferedWriter writer = new BufferedWriter(osw);
		try
		{
			// write header
			writer.write("Datetime,Status,Health,Level,Scale,Plugged,Voltage,Temperature\n");

			if (cursor.moveToFirst())
			{
				int dateTimeIndex = cursor.getColumnIndex(BatteryHistory.Columns.DATETIME);
				int statusIndex = cursor.getColumnIndex(BatteryHistory.Columns.STATUS);
				int healthIndex = cursor.getColumnIndex(BatteryHistory.Columns.HEALTH);
				int levelIndex = cursor.getColumnIndex(BatteryHistory.Columns.LEVEL);
				int scaleIndex = cursor.getColumnIndex(BatteryHistory.Columns.SCALE);
				int pluggedIndex = cursor.getColumnIndex(BatteryHistory.Columns.PLUGGED);
				int voltageIndex = cursor.getColumnIndex(BatteryHistory.Columns.VOLTAGE);
				int temperatureIndex = cursor.getColumnIndex(BatteryHistory.Columns.TEMPERATURE);

				do
				{
					String datetime = cursor.getString(dateTimeIndex);
					int status = cursor.getInt(statusIndex);
					int health = cursor.getInt(healthIndex);
					int level = cursor.getInt(levelIndex);
					int scale = cursor.getInt(scaleIndex);
					int plugged = cursor.getInt(pluggedIndex);
					int voltage = cursor.getInt(voltageIndex);
					int temperature = cursor.getInt(temperatureIndex);

					// code to string
					int statusStringId = BatteryUtils.STATUS_CODE_AND_RESOURCE_MAP.get(status);
					String statusString = context.getString(statusStringId);
					int healthStringId = BatteryUtils.HEALTH_CODE_AND_RESOURCE_MAP.get(health);
					String healthString = context.getString(healthStringId);
					int pluggedStringId = BatteryUtils.PLUGGED_CODE_AND_RESOURCE_MAP.get(plugged);
					String pluggedString = context.getString(pluggedStringId);

					// write data
					writer.write(String.format("%s,%s,%s,%d,%d,%s,%d,%.1f\n",
						datetime,
						statusString, healthString,
						level, scale, pluggedString,
						voltage, temperature / 10.0f));
				}
				while (cursor.moveToNext());
			}
		}
		finally
		{
			// quit output writer
			if (writer != null)
				writer.close();
		}

		Log.v(LOG_TAG, "Bye");
	}
}
