/*
 *  The MIT License
 *
 *  Copyright 2011 Masahiko, SAWAI <say@users.sourceforge.jp>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.service;

import android.app.IntentService;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import java.util.Date;
import org.routine_work.simple_battery_logger.db.BatteryHistoryDBHelper;
import org.routine_work.simple_battery_logger.util.Log;

/**
 *
 * @author sawai
 */
public class DeleteAllDataService extends IntentService
{
	private static final String LOG_TAG = "simple-battery-logger";

	public DeleteAllDataService(String name)
	{
		super(name);
	}

	public DeleteAllDataService()
	{
		this("DeleteAllDataService");
	}

	@Override
	protected void onHandleIntent(Intent intent)
	{
		Log.i(LOG_TAG, "DeleteAllDataService : Start at " + new Date());

		// delete 
		boolean deleteOk = deleteAllData();

		// send broad cast intent
		Intent broadcastIntent = new Intent();
		broadcastIntent.setAction(DeleteAllDataCompletedReceiver.DELETE_ALL_DATA_COMPLETED_ACTION);
		broadcastIntent.putExtra(DeleteAllDataCompletedReceiver.EXTRA_RESULT, deleteOk);
		sendBroadcast(broadcastIntent);

		Log.i(LOG_TAG, "DeleteAllDataService : End at " + new Date());
	}

	private boolean deleteAllData()
	{
		boolean result = false;

		try
		{
			BatteryHistoryDBHelper dbHelper = new BatteryHistoryDBHelper(this);
			try
			{
				SQLiteDatabase db = dbHelper.getWritableDatabase();
				try
				{
					dbHelper.deleteAll(db);
					dbHelper.vaccum(db);
					result = true;
				}
				finally
				{
					db.close();
				}
			}
			finally
			{
				dbHelper.close();
			}
		}
		catch (Exception e)
		{
			Log.e(LOG_TAG, "Delete all data failed.", e);
		}

		return result;
	}
}
