/*
 *  The MIT License
 *
 *  Copyright 2011 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.debug;

import android.app.Activity;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import android.os.BatteryManager;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import java.util.Calendar;
import java.util.Random;
import org.routine_work.simple_battery_logger.R;
import org.routine_work.simple_battery_logger.service.DeleteOldDataService;
import org.routine_work.simple_battery_logger.db.BatteryHistoryDBHelper;
import org.routine_work.simple_battery_logger.service.ExportAllDataCsvFileService;
import org.routine_work.simple_battery_logger.util.Log;

public class DebugActivity extends Activity
	implements View.OnClickListener
{

	public static final String LOG_TAG = "simple-battery-logger";

	/** Called when the activity is first created. */
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.debug_activity);
		int[] buttonIds =
		{
			R.id.create_test_log_data_button,
			R.id.delete_old_data_button,
			R.id.export_csv_button,
		};
		for (int buttonId : buttonIds)
		{
			Button button = (Button) findViewById(buttonId);
			button.setOnClickListener(this);
		}
	}

	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.create_test_log_data_button:
				createSampleData();
				break;
			case R.id.delete_old_data_button:
				deleteOldData();
				break;
			case R.id.export_csv_button:
				exportCsv();
				break;
		}
	}

	private void createSampleData()
	{
		Log.v(LOG_TAG, "Hello");
		CreateTestLogDataTask task = new CreateTestLogDataTask();
		task.execute();
		Log.v(LOG_TAG, "Bye");
	}

	private void deleteOldData()
	{
		Log.v(LOG_TAG, "Hello");
		Intent deleteOldDataIntent = new Intent(this, DeleteOldDataService.class);
		startService(deleteOldDataIntent);
		Log.v(LOG_TAG, "Bye");
	}

	private void exportCsv()
	{
		Log.v(LOG_TAG, "Hello");
		Intent exportCsvIntent = new Intent(this, ExportAllDataCsvFileService.class);
		startService(exportCsvIntent);
		Log.v(LOG_TAG, "Bye");
	}

	class CreateTestLogDataTask extends AsyncTask<Void, Void, Boolean>
	{

		@Override
		protected Boolean doInBackground(Void... arg0)
		{
			Boolean result = Boolean.FALSE;
			BatteryHistoryDBHelper dbHelper = new BatteryHistoryDBHelper(DebugActivity.this);

			try
			{
				SQLiteDatabase db = dbHelper.getWritableDatabase();
				try
				{

					db.beginTransaction();
					try
					{
						final int DAY_COUNT = 365 * 2;
						final int DATA_COUNT = DAY_COUNT * 6;
						Random random = new Random();
						Calendar cal = Calendar.getInstance();
						cal.add(Calendar.DAY_OF_MONTH, -DAY_COUNT);
						for (int i = 0; i < DATA_COUNT; i++)
						{
							int status = BatteryManager.BATTERY_STATUS_DISCHARGING;
							int health = BatteryManager.BATTERY_HEALTH_GOOD;
							int level = i % 90;
							int scale = 100;
							int voltage = 3900 + random.nextInt(200);
							int temp = 310 + random.nextInt(20);
							int plugged = BatteryManager.BATTERY_PLUGGED_USB;
							dbHelper.insertBatteryData(db, cal.getTime(),
								status, health,
								level, scale,
								plugged, voltage, temp);
							cal.add(Calendar.HOUR_OF_DAY, 4);
							cal.add(Calendar.SECOND, -1);

						}
						db.setTransactionSuccessful();
						result = Boolean.TRUE;
					}
					finally
					{
						db.endTransaction();
					}
				}
				finally
				{
					if (db != null)
					{
						db.close();
						db = null;
					}
				}
			}
			catch (Exception e)
			{
				Log.e(LOG_TAG, "createSampleData() failed.", e);
			}

			return result;
		}

		@Override
		protected void onPostExecute(Boolean result)
		{
			String message;
			if (result.booleanValue())
			{
				message = "The test log data were created.";
			}
			else
			{
				message = "The test log data creation failed.";
			}
			Toast.makeText(DebugActivity.this, message, Toast.LENGTH_SHORT).show();
		}
	}
}
