/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dolinc.aglib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileAccess {
    private String fileName = null;
    BufferedWriter bwriter = null;
    BufferedReader breader = null;
    public String CHARSET_JIS = "ISO2022JP";
    public String CHARSET_SIFT_JIS = "Shift_JIS";
    public String CHARSET_EUC_JP = "EUC_JP";
    public String CHARSET_UTF8 = "UTF-8";
    public String CHARSET_UTF16 = "UTF-16";
    public String CHARSET_WINDOWS_JP = "MS932";

    public static String getCurrentPath() {
        return new File(".").getAbsoluteFile().getParent();
    }

    public FileAccess(String filename) {
        this.fileName = filename;
    }

    public int writeOpen() {
        int retVal = 0;
        try {
            this.bwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), this.CHARSET_WINDOWS_JP));
        }
        catch (IOException e) {
            retVal = -1;
        }
        return retVal;
    }

    public int writeOpen(String charSet) {
        int retVal = 0;
        try {
            this.bwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), charSet));
        }
        catch (IOException e) {
            retVal = -1;
        }
        return retVal;
    }

    public int writeClose() {
        int retVal = 0;
        try {
            this.bwriter.close();
            this.bwriter = null;
        }
        catch (IOException e) {
            retVal = -1;
        }
        return retVal;
    }

    public int writePrint(String writeString) {
        int retVal = 0;
        try {
            this.bwriter.write(writeString);
            System.out.println(writeString);
        }
        catch (IOException e) {
            retVal = -1;
        }
        return retVal;
    }

    public int writePrintln(String writeString) {
        int retVal = 0;
        try {
            this.bwriter.write(String.valueOf(writeString) + "\r\n");
            System.out.println(writeString);
        }
        catch (IOException e) {
            retVal = -1;
        }
        return retVal;
    }

    public int readOpen() {
        int retVal = 0;
        try {
            this.breader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), this.CHARSET_WINDOWS_JP));
        }
        catch (IOException e) {
            retVal = -1;
        }
        return retVal;
    }

    public int readOpen(String charSet) {
        int retVal = 0;
        try {
            this.breader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), charSet));
        }
        catch (IOException e) {
            retVal = -1;
        }
        return retVal;
    }

    public int readClose() {
        int retVal = 0;
        try {
            this.breader.close();
            this.breader = null;
        }
        catch (IOException e) {
            retVal = -1;
        }
        return retVal;
    }

    public String readLine() {
        String retStr = "";
        try {
            retStr = this.breader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retStr;
    }
}

