/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dolinc.snmp;

import java.util.HashMap;
import jp.co.dolinc.aglib.FileAccess;
import jp.co.dolinc.file.LogRecRes;
import jp.co.dolinc.snmp.BaseCommandResponder;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.smi.VariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnListValueCommandResponder
extends BaseCommandResponder
implements CommandResponder {
    private HashMap<String, String> retValues = null;
    private LogRecRes log = null;

    public ReturnListValueCommandResponder(HashMap<String, String> retList) {
        this.retValues = retList;
        this.log = new LogRecRes(String.valueOf(FileAccess.getCurrentPath()) + "\\test.txt");
    }

    @Override
    public void processPdu(CommandResponderEvent snmpEvent) {
        System.out.println("* * * * * * * * * * SNMP EVENT * * * * * * * * * * " + snmpEvent.getPDU().getRequestID());
        try {
            PDU receivePDU = snmpEvent.getPDU();
            if (receivePDU != null) {
                switch (receivePDU.getType()) {
                    case -92: {
                        break;
                    }
                    case -89: {
                        break;
                    }
                    case -90: {
                        break;
                    }
                    default: {
                        this.log.open();
                        PDU responsePDU2 = new PDU();
                        responsePDU2.setType(snmpEvent.getPDU().getType());
                        responsePDU2.setRequestID(snmpEvent.getPDU().getRequestID());
                        responsePDU2.setErrorIndex(0);
                        responsePDU2.setErrorStatus(0);
                        responsePDU2.setType(-94);
                        int i = 0;
                        while (i < snmpEvent.getPDU().size()) {
                            VariableBinding varbind = snmpEvent.getPDU().get(i);
                            String valStr = this.retValues.get(varbind.getOid().toString());
                            if (valStr != null) {
                                String err = this.getVariableFromError(valStr);
                                String timeout = this.getVariableFromTimeout(valStr);
                                if (err != null) {
                                    responsePDU2.setErrorStatus(Integer.valueOf(err));
                                    this.log.outLog(snmpEvent.getPDU().get(i), String.valueOf(err) + "," + PDU.toErrorStatusText(responsePDU2.getErrorStatus()));
                                    break;
                                }
                                if (timeout != null) {
                                    responsePDU2.clear();
                                    this.log.outLog(snmpEvent.getPDU().get(i), timeout);
                                    break;
                                }
                                varbind.setVariable(this.getVariableFromString(valStr));
                            }
                            responsePDU2.add(varbind);
                            this.log.outLog(snmpEvent.getPDU().get(i), varbind);
                            ++i;
                        }
                        this.log.close();
                        this.sendResonse(snmpEvent, responsePDU2);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HashMap<String, String> getRetValues() {
        return this.retValues;
    }

    public void setRetValues(HashMap<String, String> retValues) {
        this.retValues = retValues;
    }

    public String ValueListToString() {
        StringBuffer retValue = new StringBuffer();
        for (String key : this.retValues.keySet()) {
            retValue.append(key);
            retValue.append(" = ");
            retValue.append(this.retValues.get(key));
            retValue.append("\n");
        }
        return retValue.toString();
    }
}

