/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dolinc.snmp;

import java.io.IOException;
import java.net.UnknownHostException;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;

public class TrapReciveAgent {
    private Snmp snmp = null;

    public void start(String targetPc, CommandResponder responder) {
        System.out.println("starting snmp receiver... from " + targetPc);
        ThreadPool pool = null;
        try {
            int numWorkers = 5;
            pool = ThreadPool.create("workers", numWorkers);
            MultiThreadedMessageDispatcher dispatcher = new MultiThreadedMessageDispatcher(pool, new MessageDispatcherImpl());
            String udpAddr = "udp:" + targetPc;
            Address listenAddr = GenericAddress.parse(System.getProperty("snmp4j.listenAddress", udpAddr));
            AbstractTransportMapping tm = listenAddr instanceof UdpAddress ? new DefaultUdpTransportMapping((UdpAddress)listenAddr) : new DefaultTcpTransportMapping((TcpAddress)listenAddr);
            this.snmp = new Snmp(dispatcher, tm);
            this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv1());
            this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv2c());
            this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv3());
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel(usm);
            this.snmp.listen();
            this.snmp.addCommandResponder(responder);
            System.out.println("succeed: start snmp receiver.");
        }
        catch (UnknownHostException e) {
            System.out.println("Error:" + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Error:" + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Error:" + e.getMessage());
        }
    }
}

