/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Collections;
import java.util.Iterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.NoLogger;

public class LogFactory {
    public static final String SNMP4J_LOG_FACTORY_SYSTEM_PROPERTY = "snmp4j.LogFactory";
    private static LogFactory snmp4jLogFactory = null;
    private static boolean configChecked = false;

    public static LogAdapter getLogger(Class c) {
        LogFactory.checkConfig();
        if (snmp4jLogFactory == null) {
            return NoLogger.instance;
        }
        return snmp4jLogFactory.createLogger(c.getName());
    }

    private static void checkConfig() {
        if (!configChecked) {
            configChecked = true;
            LogFactory.getFactoryFromSystemProperty();
        }
    }

    private static synchronized void getFactoryFromSystemProperty() {
        try {
            String factory = System.getProperty(SNMP4J_LOG_FACTORY_SYSTEM_PROPERTY, null);
            if (factory != null) {
                try {
                    Class<?> c = Class.forName(factory);
                    snmp4jLogFactory = (LogFactory)c.newInstance();
                }
                catch (ClassNotFoundException ex) {
                }
                catch (IllegalAccessException ex) {
                }
                catch (InstantiationException instantiationException) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public LogAdapter getRootLogger() {
        return NoLogger.instance;
    }

    public static LogAdapter getLogger(String className) {
        LogFactory.checkConfig();
        if (snmp4jLogFactory == null) {
            return NoLogger.instance;
        }
        return snmp4jLogFactory.createLogger(className);
    }

    protected LogAdapter createLogger(Class c) {
        return NoLogger.instance;
    }

    protected LogAdapter createLogger(String className) {
        return NoLogger.instance;
    }

    public static void setLogFactory(LogFactory factory) {
        configChecked = true;
        snmp4jLogFactory = factory;
    }

    public static LogFactory getLogFactory() {
        if (snmp4jLogFactory == null) {
            return new LogFactory();
        }
        return snmp4jLogFactory;
    }

    public Iterator loggers() {
        return Collections.singletonList(NoLogger.instance).iterator();
    }
}

