﻿
//-----------------------------
// Class C2calendar
//-----------------------------
/* タスク更新履歴管理
	tgt.がイベント処理（マウスクリック）時に呼ばれ、定義されてないと言われたので一部を$(this)に置き換えたが、これもちょっと違うみたい。
	イベント時はC2scheduler直下の処理が呼ばれ、かつthisはイベントを受けた要素に換わっているのか？
	C2scheduler直下の処理はinitとかのサブメソッドにして、イベント時には呼ばれないようにすべきなのか？
■ベース描画
*/
/* 疑問・課題管理
□非営業日の表示をどうするか？
	以下のいずれか1つでも満たすなら表示？
	(1)未が1件以上ある。
	(2)予定が（全メンバー含めて）1件以上ある。
	方法は？
	(1)Rails側でXMLデータに含めないように制御する。
	(2)JS側で制御する。
*/

(function($) {

	
	// プラグインを設定 //
	// 「c2calendar」はプラグイン名。
	//外部からアクセス可能なメソッドはjQuery.fnにアタッチする。最後のセミコロンは必要

	$.fn.c2calendar = function(options){
	
		
		//テンプレートHTML読み込み入れ替え
		//load_html_sync(this.find('td.c2-header-left'),'./jquery-c2scheduler/c2calendar/parts_html/c2_calendar_fmt1.html');
		load_html_sync(this.find('td.c2-header-left'),'./jquery-c2calendar/parts_html/c2_calendar_fmt1.html');
		load_html_sync(this.find('td.c2-header-right'),'./jquery-c2calendar/parts_html/c2_calendar_fmt2.html');
		load_html_sync(this.find('div#c2scd_contents'),'./jquery-c2calendar/parts_html/c2_calendar_fmt3.html');
		
		//処理が終わるまでローディング画像を表示
		$(this.find('.c2-view-month')).append('<div id="loading"></div>');
		var opt;//引数optionsを格納するハッシュ
		
		//デフォルト値用にTODAYのYYYYMMDD形式の文字列を生成。
		var today = new Date();
		var todayStr = $.formatDate(today,'yyyyMMdd');
		
		//optのデフォルト値
		var opt_defaults={
				current_yyyymm: todayStr.slice(0, 4)//年月をYYYYMM形式で渡す。
				,current_date: todayStr
					
				,width: 976 //スケジューラ中身（タイムライン）の幅。表示枠幅より大きい値の場合は横スクロールになる。
				,max_height: 250//スケジューラ表示枠の高さのMAX値。行が多くてこの高さ内に表示できない場合は縦スクロールになる。
				//,label_col_width: 256
			};

		//引数optionsの中のNULLだった値のみをデフォルト値で上書き。
		opt = $.extend({},opt_defaults,options || {});//defaults自体も上書きされないよう、第一引数は{}にする。「 || {}」はoptionsのNUll時対策。
		var tgt = this;//このfunctionを$.fn.c2calendar→$.fn.c2calendarへ階層変更したために、thisはc2schedulerになった。→やっぱ分割に戻したので復活。
		//var tgt = this.tgt;//変数$.fn.c2scheduler.tgtでもらうことに変更。やっぱ分割にしたのでやめ。
		$.fn.c2calendar.config = $.extend(c_conf_defaults,$.fn.c2calendar.set_config || {});
		
		//セレクタをスケカレ間で受け渡すために格納しておく。
		$.fn.c2calendar.config["selector"]=this.selector;
		//再度戻ってきた時にnullかどうか判断するため保存。
		$.fn.c2calendar.config["option_values"]=options;

		
		//省略参照のため変数へ
		var conf = $.fn.c2calendar.config;
		
		this.find('.c2-title.label.left').text(conf.title_label);
		
		//draw_calendar_base(tgt,opt,conf,c_cal_conf);
		calendar_init(tgt,opt,conf,c_cal_conf);
		
		//=====イベント設定=====
		//スケジューラとの切り替え後も残るように、すべてliveで設定。
		if ( ! c_cal_conf.event_ready_flg){
			
			//====上部ボタン====
			//マウスダウン
			//tgt.find('.c2-button , .recent_month').mousedown(function(){
			tgt.find('.c2-button , .recent_month').live('mousedown', function(){
				$(this).addClass('c2-state-down');
			});
			//マウスアップ
			//this.find('.c2-button , .recent_month').mouseup(function(e){
			tgt.find('.c2-button , .recent_month').live('mouseup', function(e){
				$(this).removeClass('c2-state-down');
				//$('.debug').html('x:' + e.pageX + 'y:' + e.pageY);
			});
			
			//マウスクリック
			//ボタンによる日付変更
			//this.find('.c2-button.c2-button-prev.cal').click(function(){
			tgt.find('.c2-button.c2-button-prev.cal').live('click', function(){
				var tgt_date = c_cal_conf.cr_startDateObj;//後でまた再代入されるのでcr_startDateObj上書きでよい。
				tgt_date.setMonth(tgt_date.getMonth() - 1);//年の変わり目でも-1で問題ない。
				opt.current_yyyymm = $.formatDate(tgt_date,'yyyyMM')
				redraw_calendar(tgt,opt,conf,c_cal_conf);
			});
			//tgt.find('.c2-button.c2-button-next.cal').click(function(){
			tgt.find('.c2-button.c2-button-next.cal').live('click', function(){
				var tgt_date = c_cal_conf.cr_startDateObj;
				tgt_date.setMonth(tgt_date.getMonth() + 1);
				opt.current_yyyymm = $.formatDate(tgt_date,'yyyyMM')
				redraw_calendar(tgt,opt,conf,c_cal_conf);
			});
			//tgt.find('.c2-button.c2-button-today.cal').click(function(){
			tgt.find('.c2-button.c2-button-today.cal').live('click', function(){
				var tgt_date = new Date();
				tgt_date.setHours(0, 0, 0, 0);//一応時刻をクリアしておく。
				opt.current_yyyymm = $.formatDate(tgt_date,'yyyyMM')
				redraw_calendar(tgt,opt,conf,c_cal_conf);
			});
			
			//ちなみにclickイベント等は同じDOM要素にイベント設定を複数設定できるので、
			//挙動を変更したい場合は一度古いイベント設定を削除しないと予想しない挙動になる。
			//tgt.find('.c2-header-right .recent_month').click(function(){
			tgt.find('.c2-header-right .recent_month').live('click', function(){
				opt.current_yyyymm = $(this).data('month');
				redraw_calendar(tgt,opt,conf,c_cal_conf);
			});
			
			//c2schedulerへのリンク（呼び出し）
			if (conf.scheluler_link_flg){
				tgt.find('table#c2cl_table td .day_label, #calendar .c2-day-content .capacity').live('click', function(){
					changeTo_c2scheduler( $(this).data('date') , 33);//division_idは仮
				});
			}
			c_cal_conf.event_ready_flg = true;//イベント設定の完了済みフラグ。
		}
		
		
		return tgt;//メソッドチェーンを断ち切らないために、tgt(=this.tgt)を返す。
	};///親ブロックここまで


	//config public 定義
	$.fn.c2calendar.config ={};
	
	var c_cal_conf ={};//private。計算結果の値を使いまわすために格納するハッシュ。configにまるっとハッシュをセットされてキーが消えないないようにconfigとは別ハッシュにしてprivateにしておく。
	
	//$.fn.c2calendar.configのデフォルト値
	var c_conf_defaults = {
		title_label:'Calendar'//上部タイトル左端欄に表示する文言
		,selector: '#scheduler_body'//実行時にはoptionでもらうが、スケカレ間で渡すためにここに格納。
		,option_values:{}//最初のoption値を保存しておくため。
		,tooltip_trigger: 'click' //tooltipの表示トリガーイベント。'mouseenter' or 'click'
		,load_info_days_url:'./jquery-c2calendar/calendar_data.xml' //日別情報を読み込むxmlのURL。オプションパラメータはチームidとyyyymm？
		,level_indication_hash:{"0":"×","3":"△","5":"○"} //空き状況レベルを表示する印
		,holidays:[]//祝日データ。デフォルトnull。
		,info_days:[]//日別情報データ。デフォルトnull。
		,scheluler_link_flg:true//c2schelulerへのリンク（切り替え可）有無。デフォルトtrue。
		,load_required_flg:true//データの読み込みするか。デフォルトtrue。
	};
	
	//内部関数定義
	function redraw_calendar_at(tgt,opt,conf,c_cal_conf) {
		
	}
	
	function draw_calendar_base(tgt,opt,conf,c_cal_conf) {
		
		//スケジューラとイベント設定を分けるためにクラス追加。
		tgt.find('.c2-button').addClass('cal');
			
		c_cal_conf.cr_startDateObj = formatDateStr2Date(opt.current_yyyymm + '01');//1日指定でDateオブジェクトに。時刻
		
		//本日をDateオブジェクトで取得。Today判別用。
		var match_todayObj = new Date();
		match_todayObj.setHours(0, 0, 0, 0);//一応時刻をクリアしておく。
		var match_todayStr = $.formatDate(match_todayObj,'yyyy-MM-dd');//比較用に文字列にしておく。
		
		//年月表示
		tgt.find('.c2-title.current_date').text($.formatDate(c_cal_conf.cr_startDateObj,'yyyy年MM月'));
		//チーム名表示。info_daysの1番目から取得
		tgt.find('.c2-title.owner_name').text(info_days[0].owner_name);
		
		/*右上の直近3ヶ月のリンク表示。未確定日あり日数表示*/
		var recentDateObj = new Date(c_cal_conf.cr_startDateObj.getTime());//走査用DateObj。順次上書き利用。
		for (var j = 1; j <= 3; j++) {
			//対象のボタンObjを変数へ
			var tgt_obj = tgt.find('.c2-header-right .recent_month.next-' + j );
			//まずクリア
			tgt_obj.removeClass('pending_exists pending_none');
			//走査用DateObjを１ヶ月進める。
			recentDateObj.setMonth(recentDateObj.getMonth() + 1);
			var str_pe_days_count = '', pe_days_count = 0;
			//指定月のデータのみ、配列へ
			var cr_month_data = $.grep($.fn.c2calendar.info_days, function(val,key){
					return ($.formatDate(recentDateObj,'yyyy-MM') == val.date.substring(0, 7));
				});
			if(cr_month_data.length > 0){//指定月のデータがあれば
				//さらに未確定ありの日のみ、に絞って配列へ
				var pe_days_count_ary = $.grep(cr_month_data, function(val,key){
					return (val.pending_works_count != '0');
				});
				pe_days_count = pe_days_count_ary.length;//数値のまま
				if(pe_days_count > 0){//未確定ありの日が0日以上なら
					tgt_obj.addClass('pending_exists');
				}else{
					tgt_obj.addClass('pending_none');
				}
				str_pe_days_count = '(' +pe_days_count + ')';
				//簡易ツールチップとして、title属性に文字列埋め込み。マウスオーバー時に表示。
				tgt_obj.attr('title','未確定あり:' + pe_days_count + '日');
			}
			tgt_obj.find('.label').text($.formatDate(recentDateObj,'M月'))
				.siblings().filter('.count').text( str_pe_days_count );
			
			//クリック時のための仕込み。opt.current_yyyymmに代入するための値をセットしておく。
			tgt_obj.data('month',$.formatDate(recentDateObj,'yyyyMM'));//データを関連つけておく。
		}
		
		//初期化クリア
		tgt.find('table#c2cl_table td').removeClass('c2-other-month holiday today pending_exists')
			.find('.day_label .label').text('')
			.end()
			.find('.c2-day-content').html('');
		
		//Date変数を他の変数に代入すると参照渡しになるので元が上書きされる！よってこのような方法でコピー
		var tmpDateObj = new Date(c_cal_conf.cr_startDateObj.getTime());//走査用DateObj
		//day_ary = new Array;
		//開始日付。第1週の日曜日（前月の可能性あり）に戻して日付をセット
		tmpDateObj.setDate(tmpDateObj.getDate() - c_cal_conf.cr_startDateObj.getDay());
		
		//for (var i = 1; i <= (7*6); tmpDateObj.setDate(tmpDateObj.getDate() +1), i++) {//カレンダーのマス目分ループ。iは1スタート。
		var i = 0;
		tgt.find('table#c2cl_table td').each(function(){
			//Date変数を他の変数に代入すると参照渡しになるので元が上書きされる！よってこのような方法でコピー
			//var tgt_dateObj = new Date(tmpDateObj.getTime());
			//day_ary.push(tgt_dateObj);
			i ++;//セルナンバー。未使用。
			
			//祝日判別
			//holidayデータからカレント日付のデータを探す。
			var holidays_match = $.grep(conf.holidays, function(val,key){
				return ($.formatDate(tmpDateObj,'yyyy/M/d') == val.Date);
			});
			if(holidays_match.length > 0){
				$(this).addClass('holiday').find('.day_label .label').text(htmlEscape(holidays_match[0].Name1));
			}
			
			//Today判別。文字列にして比較
			if(match_todayStr == $.formatDate(tmpDateObj,'yyyy-MM-dd')){
				$(this).addClass('today');
			}
			
			//カレンダー日付セット。
			$(this).find('.day_label .c2-day-number').text(tmpDateObj.getDate());
			
			//当月判別
			if(c_cal_conf.cr_startDateObj.getMonth() != tmpDateObj.getMonth()){
				$(this).addClass('c2-other-month');
			}else{
				//日別情報セット
				//info_daysデータからカレント日付のデータを探す。
				var info_day_match = $.grep($.fn.c2calendar.info_days, function(val,key){
					return ($.formatDate(tmpDateObj,'yyyy-MM-dd') == val.date);
				});
				if(info_day_match.length > 0){
					if ((info_day_match[0].pending_works_count +0) > 0){
						$(this).addClass('pending_exists');
					}
					$(this).find('.c2-day-content').html(
						'<span class="pending_works"><span class="count">' 
						+ info_day_match[0].pending_works_count 
						+ '</span><span class="small">件</span></span>&nbsp;' 
						+ '<div class="capacity"><div class="capa am lv' 
						+ info_day_match[0].capa_level_am 
						+ '">AM：' 
						+ conf.level_indication_hash[info_day_match[0].capa_level_am] 
						+ '</div>' 
						+ '<div class="capa pm lv' 
						+ info_day_match[0].capa_level_pm 
						+ '">PM：' 
						+ conf.level_indication_hash[info_day_match[0].capa_level_pm] 
						+ '</div></div>'
						);
				}
			}
			//要素が生成された後
			
			//スケジューラへのリンクパラメータ用に日付のYYMMDD文字列をdataとして関連付けしておく。
			$(this).find('.day_label, .c2-day-content .capacity').data('date',$.formatDate(tmpDateObj,'yyyyMMdd'));//'date'というキーで関連つけ。
			//次のループのために
			tmpDateObj.setDate(tmpDateObj.getDate() +1);
			
			//alert (index);
		});
		//要素が生成されたループ後、まとめて。
		if (conf.scheluler_link_flg){
			tgt.find('.day_label, #calendar .c2-day-content .capacity').css('cursor','pointer');//カーソルをポインタに
			//簡易ツールチップ
			tgt.find('#calendar .c2-day-content .capacity').attr('title','この日のスケジュールへ切り替え（上部のみ）');
			tgt.find('#calendar td .day_label').attr('title','この日のスケジュールへ切り替え（上下連動。未確定ワーク一覧が表示されていた場合、それもこの日の検索結果に変わります。）');
		}
		
	}// end function draw_calendar_base()
	
	//最後の配置・大きさ調整
	function calendar_adjust_final(tgt,opt,conf,c_cal_conf) {
		//周辺領域
		var titleHeader_H = parseInt(tgt.find('table.c2-header').outerHeight()) || 10;//デバッグのために0ではなく10にしておく。
		var cal_HeaderTitle_H = parseInt(tgt.find('div.c2calendar-header-title').outerHeight()) || 10;//デバッグのために0ではなく10にしておく。
		var cal_content_H = parseInt(tgt.find('div.c2-content').outerHeight()) || 100;
		var tmp_contents_H = cal_HeaderTitle_H + cal_content_H + ((tgt.find('table.c2cl_table').outerWidth() > tgt.outerWidth()) ? 17 : 0);//横スクロールバーがつく大きさなら、高さにスクロールバーの幅（17px）プラスする。
		
		var contents_H = (opt.max_height >= (titleHeader_H + tmp_contents_H)) ? tmp_contents_H + 15 : opt.max_height - titleHeader_H ;
		tgt.find('div#c2scd_contents').outerWidth(tgt.outerWidth()).outerHeight(contents_H);//幅調整&高さ調整。幅は親DIVに合わせる。tmp_contents_H少し足りないので15足す。
		tgt.outerHeight((titleHeader_H + contents_H));//'px'なしでよさげ。
		
		//処理が終わったらloadingを消す
		tgt.find('.c2-view-month #loading').remove();
	}// end function calendar_adjust_final()
	
	
	function calendar_init(tgt,opt,conf,c_cal_conf) {

		//var conf = $.fn.c2scheduler.config;//記述簡略のため変数へ

		//処理が終わるまでローディング画像を表示
		if (tgt.find('.c2-view-month #loading').length == 0){//schedulerからの切り替え時はすでにある。
			tgt.find('.c2-view-month').append('<div id="loading"></div>');
		}

		/*========サブ関数を実行==========*/
		//データロード処理&描画開始
		//load_info_days_data(conf.load_info_days_url, opt.current_yyyymm, tgt, opt, conf, c_cal_conf);
		
		
		if (conf.load_required_flg){
			//データロード処理&描画開始
			load_info_days_data(conf.load_info_days_url, opt.current_yyyymm, tgt, opt, conf, c_cal_conf);
		}else{
			draw_calendar_base(tgt,opt,conf,c_cal_conf);//描画
			calendar_adjust_final(tgt,opt,conf,c_cal_conf);//最後の大きさ調整
			
		}
		
		
	};//end  calendar_init()
	
	//mode_configの設定で再描画する。
	function redraw_calendar(tgt,opt,conf,c_cal_conf) {
		draw_calendar_base(tgt,opt,conf,c_cal_conf);//描画
		calendar_adjust_final(tgt,opt,conf,c_cal_conf);//最後の大きさ調整
	}
	
	
	//データ配列定義
	$.fn.c2calendar.info_days = [];
	//データロード系メソッド=====
	
	//privateMethod　日別情報ロード＆描画
	load_info_days_data = function(url, yyyymm, tgt, opt, conf, c_cal_conf){
		$.ajax({
			url: url, 
			dataType : 'xml',
			data: {}, //テスト時はパラメータ渡せない{cr_date: yyyymm , cr_section_id : 1 }//'201207'
			type: 'GET',
			success: function(data){
				var info_days = $.xml2json(data).info_day;//プラグインを利用してJSON形式に変換。
				//要素が1つの場合、配列になっていないので配列へ。
				//var new_array = new Array;
				if (!(info_days instanceof Array)){
					info_days[0] = info_days;
					//alert("not instanceof Array");
				/*}else{
					new_timeframes = org_timeframes;
				*/
				}
				$.fn.c2calendar.info_days = info_days;
				//$.fn.c2calendar.status.flg_loaded_info_days = true;//ロード完了フラグ
				
				draw_calendar_base(tgt,opt,conf,c_cal_conf);//描画
				
				calendar_adjust_final(tgt,opt,conf,c_cal_conf);//最後の大きさ調整
			}
		});
	};//end $.fn.c2calendar.load_info_days_data
	
	
	//c2schedulerの呼び出し
	function changeTo_c2scheduler(current_date_str,division_id){
		
		//入れ替え部分を明示的に消しておく。そうしないとイベント設定が重複する？→live設定にしているものは入れ替えても残る。
		//$('#scheduler_body td.c2-header-left ,#scheduler_body td.c2-header-right ,#scheduler_body div#c2scd_contents').empty();
		
		//config設定（一応）
		/*
		$.fn.c2scheduler.set_config = {
			scale_step_minutes: 60//30
			,range_start_no: 0//16
			,range_end_no: 24//40
			,min_width_to_time_labeling_only_at_flat: 30//100
			//,disp_tooltip_duration: 45//未使用
			//,entry_col_op_width: 18 //エントリ名右のアイコン用TD。0ならTD作成しない。
			//,mb_tf_name: 'mobile' //移動時間のタイムフレームのクラスの名。指定クラスが追加される。
			,tooltip_trigger: 'click' //tooltipの表示トリガーイベント。'mouseenter' or 'click'
			,use_48clock: false //スケールバーに48時間表記（AM1時は25:00）を使用するか？デフォルトfalse。
			,use_strong_line: ['00:00','12:00'] //グリッド罫線に目立つ線を使用する時刻を「HH:MM」の文字列で指定(頭0埋め)。48時間表記かどうかはuse_48clock指定と合わせる。'24:00'は×。'00:00'を指定。
			,load_y_entries_url:'./jquery-c2scheduler/test_y_entries_data.xml' //y_entriesを読み込むxmlのURL。日付パラメータはオプションのcurrent_date
			,load_timeframes_url:'./jquery-c2scheduler/test_timeframes_data.xml' //timeframesを読み込むxmlのURL。日付パラメータはオプションのcurrent_date
			,def_x_scroll_glidNo:0 //デフォルトの横スクロール位置。グリッド位置番号（1から）で指定。
			,use_scale_bar_date: false //スケールバーを2段表示で上に日付表示にするか
			,scale_bar_date_height:20//スケールバーを2段表示時の日付パートの高さ。
			,holidays:holidays//祝日データ。
			,calendar_link_flg:true//c2calendarへのリンク（切り替え可）有無。
			,cr_division_id:division_id//デフォルトnull。
			,load_required_flg: !($.fn.c2scheduler.config.cr_division_id == division_id)//☆データの読み込みするか。division_id同じだったら不要。
		};
		*/
		
		//c2scheduler側でdivision_idをパラメータプロパティとして設定しないと、スケ・CAL間で行き来できないか。
		//$.fn.c2scheduler.set_config.load_y_entries_url = ''
		//$.fn.c2scheduler.set_config.load_timeframes_url = ''
		
		var sch_opt= $.extend({}//defaults自体も上書きされないよう、第一引数は{}にする。
				,{width: 1200,max_height: 300,label_col_width: 160,holidays:holidays}
				,$.fn.c2scheduler.config["option_values"] || {}	//「 || {}」はNUll時対策。
				,{current_date: current_date_str}	//yyyymmdd
				);
			/*
			current_date: current_date_str//yyyymmdd
			,width: 1200//976スケジューラ中身（タイムライン）の幅。表示枠幅より大きい値の場合は横スクロールになる。
			,max_height: 300//スケジューラ表示枠の高さのMAX値。行が多くてこの高さ内に表示できない場合は縦スクロールになる。
			,label_col_width: 160//256//各スケジュールのエントリ名列の幅。ただし、全体幅の端数があればその分加算される。最大config.scale_step_minutes -1 ピクセル誤差が出る。
			*/
		
		//スケカレ間で受け渡し。
		$( $.fn.c2calendar.config["selector"] ).c2scheduler(sch_opt);
		
	}
	
	//テンプレート系プロパティ
	$.fn.c2calendar.templates={};
	//{%プロパティ名%}という形式の文字列を埋め込むとそのプロパティで置換
	//{%プロパティ名 カスタム関数=opt カスタム関数=opt%}という形式でプロパティ名の後に半角スペースで関数名とそのオプション引数指定可能。
	//=の前後に半角スペースを入れてはならない。opt内に半角スペースを指定する場合は「\z」で暫定対応とした。（\sは正規表現とカブり、扱いづらいため。）。
	
	//INFO　未確定0件用
	$.fn.c2calendar.templates.day_content_none = '{%title%}&nbsp;{%description%}&nbsp;{%lumping_count fmt=[集約$_件]%}<br />◆{%start%} ～ {%end%}';
	//INFO　未確定あり用
	$.fn.c2calendar.templates.day_content_exists = '<a href="javascript:open_editwin(\'{%data1%}\');">{%title%}</a>&nbsp;{%description%} {%lumping_count fmt=[集約$_件]%}<br />◆{%start%}&nbsp;～&nbsp;{%end%}';
	
	
	
	/*=======private ユーティリティ関数=======*/
	//"yyyy-mm-dd hh:mm"（分までor 日付のみ）の形式の日時文字列をDateオブジェクトに変換して返す。
	//日付区切りは-./ or 区切りなしのどれでもよい。yearは4桁のみ。月日は1桁でもよい。
	//時刻は半角スペースはさんで"hh:mm"のみ(1桁でもよい。マッチしなければ時刻は無視される)。
	function formatDateStr2Date(dateStr){
		//if (dateStr.match(/^(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})/)){
		if (dateStr.match(/^(\d{4})[\-\./]?(\d{1,2})[\-\./]?(\d{1,2}) (\d{1,2}):(\d{1,2})/)){//時:分あり。
			return new Date(RegExp.$1,(RegExp.$2 - 1),RegExp.$3,RegExp.$4,RegExp.$5);//月は0～11なのでマイナス1。
		}else if (dateStr.match(/^(\d{4})[\-\./]?(\d{2})[\-\./]?(\d{2})/)){//日付のみ
			return new Date(RegExp.$1,(RegExp.$2 - 1),RegExp.$3);//月は0～11なのでマイナス1。
		}
		return null;
	};
	
	//HTMLエスケープ処理（一般的なHMTLメタ文字6字）
	function htmlEscape(str) {
		var result = str;
		
		//2重エスケープ防止のため、逆置換して先に一旦戻しておく。
		result = result.replace(/&amp;/g,"&");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/&quot;/g,'"');//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/&#039;/g,"'");//ちなみにXMLのエスケープ文字は「&apos;」。XMLと異なる。
		result = result.replace(/&apos;/g,"'");//XMLのエスケープ文字対応。
		result = result.replace(/&lt;/g,"<");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/&gt;/g,">");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/&nbsp;/g," ");//半角スペース
			
		//本置換
		result = result.replace(/&/g,"&amp;");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/"/g,"&quot;");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/'/g,"&#039;");//ちなみにXMLのエスケープ文字は「&apos;」。XMLと異なる。
		result = result.replace(/</g,"&lt;");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/>/g,"&gt;");//ちなみにXMLのエスケープ文字も同じ。
		result = result.replace(/ /g,"&nbsp;");//半角スペース
		return result;
	};
	
	///テンプレートHTML(urlで指定)を同期通信でロードし、selecter_strの要素のHMTLに挿入する。
	function load_html_sync(selecter_str,url){
		//テンプレートHTML読み込み入れ替え
		//$( '#scheduler_body div#c2scd_contents' ).load('./sg_scheduler_fmt.html');//loadは非同期なのでボツ。
		$.ajax({
			async:false, //同期通信。defaultはtrue(非同期)。
			ifModified:true, //前回と変更があった時のみ更新。defaultはfalse。
			url: url, 
			dataType : 'html',
			//data: {}, //パラメータ不要。
			type: 'GET',
			success: function(data){
				$( selecter_str ).html(data);
			}
		});
	}

})(jQuery);