/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef	__IPC_CONF_H__
#define	__IPC_CONF_H__

/* ----- rpcShm.h ----- */
#define	IPC_MARSHAL_SHARED_MEM_NAME				"/IpcMarshal"
#define	IPC_DATABASE_SHARED_MEM_NAME				"/IpcDatabase"
#define	IPC_MSG_QUE_SHARED_MEM_NAME				"/IpcMsgQue"

#define	IPC_MARSHAL_SHARED_MEM_REAL_SIZE			(1024*1024)	/* 1MB  FOR EXT DATA */
#define	IPC_DATABASE_SHARED_REAL_MEM_SIZE			(1024*100)	/* 100KB FOR DATABASE */
#define	IPC_MSG_QUE_SHARED_REAL_MEM_SIZE			(1024*100)	/* 100KB FOR MSG QUE */

#define	IPC_SHM_MIN_FREE_SIZE					64	/* MIN FREE SIZE */
#define	IPC_DEVIDE_MAX_ALLOC_SIZE				4

#define	IPC_MSG_QUE_SHARED_MEM_ADDR				0xB8000000
#define	IPC_DATABASE_SHARED_MEM_ADDR				0xB8100000
#define	IPC_MARSHAL_SHARED_MEM_ADDR				0xB8200000


/* ----- ipcQue.h ----- */
#define	IPC_MSG_QUE_MAX_QUE_SIZE				256
#define	IPC_MSG_QUE_DEFAULT_TIMEOUT				10*1000	/* msec */

#define	IPC_SHM_MSG_QUE_MEM_SIZE				IPC_MSG_QUE_SHARED_REAL_MEM_SIZE
#define	IPC_SHM_MSG_QUE_NUM_OF_DEV				1
#define	IPC_SHM_MSG_QUE_MIN_SIZE				64	/* DUMMY */
#define	IPC_SHM_MSG_QUE_RATE_OF_MAGNIFY				2	/* DUMMY */

#ifdef	USE_HASH_IN_IPC
#define	IPC_USE_HASH_FUNC_FOR_MSG_QUE

#define	IPC_GLOBAL_MSG_QUE_HASH_TABLE				256
#define	IPC_LOCAL_MSG_QUE_HASH_TABLE				256
#endif	/* USE_HASH_IN_IPC */


/* ----- ipcShmDB.h ----- */
#define	IPC_SHM_DATABASE_MEM_SIZE				IPC_DATABASE_SHARED_REAL_MEM_SIZE
#define	IPC_SHM_DATABASE_NUM_OF_DEV				1
#define	IPC_SHM_DATAABSE_MIN_SIZE				64	/* DUMMY */
#define	IPC_SHM_DATABASE_RATE_OF_MAGNIFY			2	/* DUMMY */

#define	IPC_HASH_RAND_NUM_SIZE_OF_TBL_NUM			4
#define	IPC_HASH_RAND_NUM_SIZE_OF_TABLE				256

#define	IPC_SHM_DATABASE_FUNC_DB_HASH_TABLE			512
//#define	IPC_SHM_DATABASE_FUNC_DB_HASH_TABLE		32


/* ----- ipcMarshal.h ----- */
#define	IPC_MARSHAL_DATA_SHARED_MEM_NAME			IPC_MARSHAL_SHARED_MEM_NAME
#define	IPC_SHM_MARSHAL_NUM_OF_DEV				6
#define	IPC_SHM_MARSHAL_MIN_SIZE				64
#define	IPC_SHM_MARSHAL_RATE_OF_MAGNIFY			2


/* ----- ipcSkelton.h ----- */
#define	IPC_SKELTON_MANAGE_QUE_SIZE				32
#define	IPC_SKELTON_MANAGE_TASK_SCHED_POLICY			SCHED_FIFO
#define	IPC_SKELTON_MANAGE_TASK_PRIORITY			RPC_SCHED_PRIO_MID_H
#define	IPC_SKELTON_MANAGE_TASK_DETACH_STATE			PTHREAD_CREATE_DETACHED
#define	IPC_SKELTON_MANAGE_TASK_STACK_SIZE			(64 * 1024)

#define	IPC_SKELTON_START_NUM_OF_TASK_RESOURCE			5
#define	IPC_SKELTON_START_NUM_OF_QUE_RESOURCE			IPC_SKELTON_NUM_OF_TASK_RESOURCE
#define	IPC_SKELTON_QUE_SIZE					16
#define	IPC_SKELTON_TASK_SCHED_POLICY				SCHED_FIFO
#define	IPC_SKELTON_TASK_PRIORITY				IPC_SCHED_PRIO_LOW_L
#define	IPC_SKELTON_TASK_DETACH_STATE				PTHREAD_CREATE_DETACHED
#define	IPC_SKELTON_TASK_STACK_SIZE				(1024 * 1024)

#define	IPC_SKELTON_MAX_NUM_OF_TASK_RESOURCE			20
#define	IPC_SKELTON_MAX_NUM_OF_QUE_RESOURCE			IPC_SKELTON_MAX_NUM_OF_TASK_RESOURCE


/* ----- ipcStub.h ----- */
#define	IPC_STUB_START_NUM_OF_CB_TASK_RESOURCE			3
#define	IPC_STUB_CB_TASK_SCHED_POLICY				SCHED_FIFO
#define	IPC_STUB_CB_TASK_PRIORITY				RPC_SCHED_PRIO_MID_M
#define	IPC_STUB_CB_TASK_DETACH_STATE				PTHREAD_CREATE_DETACHED
#define	IPC_STUB_CB_TASK_STACK_SIZE				(64 * 1024)

#define	IPC_STUB_START_NUM_OF_QUE_RESOURCE			5
#define	IPC_STUB_QUE_SIZE					16

#define	IPC_STUB_MAX_NUM_OF_CB_TASK_RESOURCE			10
#define	IPC_STUB_MAX_NUM_OF_QUE_RESOURCE			20

#define	IPC_STUB_DEFAULT_TIMEOUT				(30*1000)	/* msec */

#ifdef	USE_MULTICAST_RPC
#define	IPC_STUB_START_NUM_OF_MLTCST_RESOURCE			3
#define	IPC_STUB_MAX_NUM_OF_MLTCST_RESOURCE			5
#endif	/* USE_MULTICAST_RPC */


/* ----- ipcRendezv.h ----- */
#ifdef	USE_RENDEZVOUS

#define	IPC_RENDEZV_DATA_SHARED_MEM_NAME			IPC_MSG_QUE_SHARED_MEM_NAME

#define	IPC_RENDEZV_DEFAULT_TIMEOUT				30*1000	/* msec */

#define	IPC_RENDEZV_SLEEP_FOR_SWITCH_TASK			1	/* msec */

#ifdef	USE_HASH_IN_IPC
#define	IPC_USE_HASH_FUNC_FOR_RENDEZV

#define	IPC_GLOBAL_RENDEZV_HASH_TABLE				256
#define	IPC_LOCAL_RENDEZV_HASH_TABLE				256
#endif	/* USE_HASH_IN_IPC */
#endif	/* USE_RENDEZVOUS */

#endif	/* __IPC_CONF_H_ */
