/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef	USE_RENDEZVOUS

#ifndef	IPCRENDEZV_H_
#define	IPCRENDEZV_H_

#ifdef	IPC_RENDEZV_MAIN
#define	extern
#endif	/* IPCRENDEZV_MAIN */

#include	"ipcConf.h"
#include	"ipcType.h"
#include	"ipcSyscall.h"

#define	IPC_RENDEZV_ID_UNKNOWN					(0)
#define	IPC_RENDEZV_ID_MAX					(0xFFFFFFFF)

#define	IPC_RENDEZV_WAIT_FOREVER				(0xFFFFFFFF)

typedef struct {
	RpcMutexID_t mutexId;
	RpcMutexAttribute_t mutexAttr;
	RpcList_t *rendezvList;
#ifdef	IPC_USE_HASH_FUNC_FOR_RENDEZV
	RpcHashEntry_t *rendezvHashTable;
#endif	/* IPC_USE_HASH_FUNC_FOR_RENDEZV */
	uint32_t rendezvIdCounter;	/* This variable is only used in shared memory area */
} IpcRendezvControl_t;

extern RpcResult_t IPC_InitRendezv(RpcBool_t masterProcess);
extern RpcResult_t IPC_CreateRendezv(RpcBool_t IpcFlag, uint32_t *rendezvId);
extern RpcResult_t IPC_DestoryRendezv(uint32_t rendezvId);
extern RpcResult_t IPC_RendezvSend(uint32_t rendezvId, RpcTaskID_t recvTask,void *sendData, uint32_t sendSize,void **replyData, uint32_t *replySize, uint32_t timeOut);
extern RpcResult_t IPC_RendezvSendByTask(RpcBool_t IPCFlag, RpcTaskID_t recvTask,void *sendData, uint32_t sendSize,void **replyData, uint32_t *replySize, uint32_t timeOut);
extern RpcResult_t IPC_RendezvSendByRendezvId(uint32_t rendezvId, void *sendData, uint32_t sendSize,void **replyData, uint32_t *replySize, uint32_t timeOut);
extern RpcResult_t IPC_RendezvRecv(uint32_t rendezvId, RpcTaskID_t sendTask, void **recvData, uint32_t *recvSize, uint32_t timeOut);
extern RpcResult_t IPC_RendezvRecvByTask(RpcBool_t IPCFlag,RpcTaskID_t sendTask, uint32_t *rendezvId, void **recvData, uint32_t *recvSize, uint32_t timeOut);
extern RpcResult_t IPC_RendezvRecvByRendezvId(uint32_t rendezvId, void **recvData, uint32_t *recvSize, uint32_t timeOut);
extern RpcResult_t IPC_RendezvReply(uint32_t rendezvId, void *replyData, uint32_t replySize);

#endif	/* IPCRENDEZV_H_ */

#endif	/* USE_RENDEZVOUS */
