/*
 * Decompiled with CFR 0.152.
 */
package countstatement.handlers;

import countstatement.handlers.CounterJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountStatementHandler
extends AbstractHandler {
    CounterJob job = new CounterJob("Count Statement");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<ICompilationUnit> list = this.getSelectJavaAll(event);
        if (list == null) {
            return null;
        }
        this.job.setList(list);
        this.job.setUser(true);
        this.job.schedule();
        return null;
    }

    public ArrayList<ICompilationUnit> getSelectJavaAll(ExecutionEvent event) {
        IWorkbenchPart view = HandlerUtil.getActivePart((ExecutionEvent)event);
        ArrayList<Object> retList = null;
        if (view instanceof JavaEditor) {
            JavaEditor j = (JavaEditor)view;
            FileEditorInput e = (FileEditorInput)j.getEditorInput();
            IJavaElement myJavaFile = JavaCore.create((IFile)e.getFile());
            ICompilationUnit javaunit = (ICompilationUnit)myJavaFile;
            retList = new ArrayList();
            retList.add(javaunit);
            System.out.println("JavaEditor");
        } else if (view instanceof IPackagesViewPart) {
            IPackagesViewPart p = (IPackagesViewPart)view;
            TreeViewer tr = p.getTreeViewer();
            ISelection sel = tr.getSelection();
            retList = this.getAll(sel);
            System.out.println("PackageExplorer");
        } else if (view instanceof CommonNavigator) {
            CommonNavigator c = (CommonNavigator)view;
            CommonViewer com = c.getCommonViewer();
            ISelection sel = com.getSelection();
            retList = this.getAll(sel);
            System.out.println("ProjectExplorer");
        }
        return retList;
    }

    private ArrayList<ICompilationUnit> getAll(ISelection sel) {
        ArrayList<ICompilationUnit> retList = new ArrayList<ICompilationUnit>();
        TreeSelection tree = (TreeSelection)sel;
        for (Object obj : tree) {
            if (obj instanceof IJavaProject) {
                try {
                    JavaProject jp = (JavaProject)obj;
                    IProject pj = jp.getProject();
                    IJavaProject iPrj = JavaCore.create((IProject)pj);
                    IJavaElement[] a = iPrj.getChildren();
                    int i = 0;
                    while (i < a.length) {
                        if (a[i] instanceof IPackageFragmentRoot) {
                            IPackageFragmentRoot ipr = (IPackageFragmentRoot)a[i];
                            retList.addAll(this.getICompilationUnitFromPkgRoot(ipr));
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                System.out.println("JavaProject");
                continue;
            }
            if (obj instanceof IProject) {
                try {
                    IProject pj = (IProject)obj;
                    IJavaProject iPrj = JavaCore.create((IProject)pj);
                    IJavaElement[] a = iPrj.getChildren();
                    int i = 0;
                    while (i < a.length) {
                        if (a[i] instanceof IPackageFragmentRoot) {
                            IPackageFragmentRoot ipr = (IPackageFragmentRoot)a[i];
                            retList.addAll(this.getICompilationUnitFromPkgRoot(ipr));
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                System.out.println("IProject");
                continue;
            }
            if (obj instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot ipr = (IPackageFragmentRoot)obj;
                retList.addAll(this.getICompilationUnitFromPkgRoot(ipr));
                System.out.println("IPackageFragmentRoot");
                continue;
            }
            if (obj instanceof IPackageFragment) {
                retList.addAll(this.getICompilationUnitFromPkg((IPackageFragment)obj));
                System.out.println("IPackageFragment");
                continue;
            }
            if (!(obj instanceof ICompilationUnit)) continue;
            retList.add((ICompilationUnit)obj);
            System.out.println("ICompilationUnit");
        }
        return retList;
    }

    private List<ICompilationUnit> getICompilationUnitFromPkgRoot(IPackageFragmentRoot ipr) {
        ArrayList<ICompilationUnit> retList = new ArrayList<ICompilationUnit>();
        try {
            if (!ipr.isArchive()) {
                IJavaElement[] ch = ipr.getChildren();
                int i = 0;
                while (i < ch.length) {
                    if (ch[i] instanceof IPackageFragment) {
                        retList.addAll(this.getICompilationUnitFromPkg((IPackageFragment)ch[i]));
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return retList;
    }

    private List<ICompilationUnit> getICompilationUnitFromPkg(IPackageFragment ip) {
        try {
            ICompilationUnit[] cm = ip.getCompilationUnits();
            return Arrays.asList(cm);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }
}

