/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.cayenne.om.account;

import org.apache.cayenne.ObjectId;

import com.aimluck.eip.cayenne.om.account.auto._EipTAclRole;

public class EipTAclRole extends _EipTAclRole {

  public static final String ACL_TYPE_COLUMN = "ACL_TYPE";

  public static final String ROLE_ID_COLUMN = "ROLE_ID";

  public static final String DEFAULT_FLAG_COLUMN = "DEFAULT_FLAG";

  public Integer getRoleId() {
    if (getObjectId() != null && !getObjectId().isTemporary()) {
      Object obj = getObjectId().getIdSnapshot().get(ROLE_ID_PK_COLUMN);
      if (obj instanceof Long) {
        Long value = (Long) obj;
        return Integer.valueOf(value.intValue());
      } else {
        return (Integer) obj;
      }
    } else {
      return null;
    }
  }

  public void setRoleId(int id) {
    setObjectId(new ObjectId("EipTAclRole", ROLE_ID_PK_COLUMN, id));
  }

}
