/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.cayenne.om.portlet;

import org.apache.cayenne.ObjectId;

import com.aimluck.eip.cayenne.om.portlet.auto._OriTImproveopeTopic;

public class OriTImproveopeTopic extends _OriTImproveopeTopic {

  public static final String TOPIC_NAME_COLUMN = "topic_name";

  public static final String CREATE_DATE_COLUMN = "create_date";

  public static final String OWNER_ID_COLUMN = "owner_id";

  public static final String PARENT_ID_COLUMN = "parent_id";

  public Integer getTopicId() {
    if (getObjectId() != null && !getObjectId().isTemporary()) {
      Object obj = getObjectId().getIdSnapshot().get(TOPIC_ID_PK_COLUMN);
      if (obj instanceof Long) {
        Long value = (Long) obj;
        return Integer.valueOf(value.intValue());
      } else {
        return (Integer) obj;
      }
    } else {
      return null;
    }
  }

  public void setTopicId(String id) {
    setObjectId(new ObjectId("OriTImproveopeTopic", TOPIC_ID_PK_COLUMN, Integer
        .valueOf(id)));
  }

}



