/*
 * Copyright(C) 2012 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.account;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.portlet.EipTPostEmployment;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;

/**
 * 部署のフォームデータを管理するクラスです。 <BR>
 *
 */
public class AccountPostEmploymentSettingFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(AccountPostEmploymentSettingFormData.class.getName());

  /** 部署名 */
  private ALStringField post_name;

  /** 部署ID */
  private int post_id;

  /** モード */
  private String mode;

  /** EipMPostオブジェクト */
  private EipMPost epiMPost;

  /** 年 **/
  private ALNumberField year;

  /** 就労時間 **/
  private ALStringField worktime_1;

  private ALStringField worktime_2;

  private ALStringField worktime_3;

  private ALStringField worktime_4;

  private ALStringField worktime_5;

  private ALStringField worktime_6;

  private ALStringField worktime_7;

  private ALStringField worktime_8;

  private ALStringField worktime_9;

  private ALStringField worktime_10;

  private ALStringField worktime_11;

  private ALStringField worktime_12;

  /** 休日時間 **/
  private ALNumberField holiday_1;

  private ALNumberField holiday_2;

  private ALNumberField holiday_3;

  private ALNumberField holiday_4;

  private ALNumberField holiday_5;

  private ALNumberField holiday_6;

  private ALNumberField holiday_7;

  private ALNumberField holiday_8;

  private ALNumberField holiday_9;

  private ALNumberField holiday_10;

  private ALNumberField holiday_11;

  private ALNumberField holiday_12;

  /**
   * 初期化します。
   *
   * @param action
   * @param rundata
   * @param context
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);

    epiMPost = AccountUtils.getEipMPost(rundata, context);

    // 年を取得
    String y = rundata.getParameters().getString("year");
    year.setValue(y);

  }

  /**
   * 各フィールドを初期化します。 <BR>
   *
   *
   */
  @Override
  public void initField() {

    // 部署名
    post_name = new ALStringField();
    post_name.setFieldName("部署名");
    post_name.setTrim(true);
    // 年
    year = new ALNumberField();
    // 時間
    worktime_1 = new ALStringField();
    worktime_1.setFieldName("1月の規定就労時間");
    worktime_1.setTrim(true);

    worktime_2 = new ALStringField();
    worktime_2.setFieldName("2月の規定就労時間");
    worktime_2.setTrim(true);

    worktime_3 = new ALStringField();
    worktime_3.setFieldName("3月の規定就労時間");
    worktime_3.setTrim(true);

    worktime_4 = new ALStringField();
    worktime_4.setFieldName("4月の規定就労時間");
    worktime_4.setTrim(true);

    worktime_5 = new ALStringField();
    worktime_5.setFieldName("5月の規定就労時間");
    worktime_5.setTrim(true);

    worktime_6 = new ALStringField();
    worktime_6.setFieldName("6月の規定就労時間");
    worktime_6.setTrim(true);

    worktime_7 = new ALStringField();
    worktime_7.setFieldName("7月の規定就労時間");
    worktime_7.setTrim(true);

    worktime_8 = new ALStringField();
    worktime_8.setFieldName("8月の規定就労時間");
    worktime_8.setTrim(true);

    worktime_9 = new ALStringField();
    worktime_9.setFieldName("9月の規定就労時間");
    worktime_9.setTrim(true);

    worktime_10 = new ALStringField();
    worktime_10.setFieldName("10月の規定就労時間");
    worktime_10.setTrim(true);

    worktime_11 = new ALStringField();
    worktime_11.setFieldName("11月の規定就労時間");
    worktime_11.setTrim(true);

    worktime_12 = new ALStringField();
    worktime_12.setFieldName("12月の規定就労時間");
    worktime_12.setTrim(true);

    // 休日
    holiday_1 = new ALNumberField();
    holiday_1.setFieldName("1月の休日");
    holiday_2 = new ALNumberField();
    holiday_2.setFieldName("2月の休日");
    holiday_3 = new ALNumberField();
    holiday_3.setFieldName("3月の休日");
    holiday_4 = new ALNumberField();
    holiday_4.setFieldName("4月の休日");
    holiday_5 = new ALNumberField();
    holiday_5.setFieldName("5月の休日");
    holiday_6 = new ALNumberField();
    holiday_6.setFieldName("6月の休日");
    holiday_7 = new ALNumberField();
    holiday_7.setFieldName("7月の休日");
    holiday_8 = new ALNumberField();
    holiday_8.setFieldName("8月の休日");
    holiday_9 = new ALNumberField();
    holiday_9.setFieldName("9月の休日");
    holiday_10 = new ALNumberField();
    holiday_10.setFieldName("10月の休日");
    holiday_11 = new ALNumberField();
    holiday_11.setFieldName("11月の休日");
    holiday_12 = new ALNumberField();
    holiday_12.setFieldName("12月の休日");

  }

  /**
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean setFormData(RunData rundata, Context context,
      List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    boolean res = super.setFormData(rundata, context, msgList);
    return res;
  }

  /**
   * 各フィールドに対する制約条件を設定します。 <BR>
   *
   *
   */
  @Override
  protected void setValidator() {

  }

  /**
   * フォームに入力されたデータの妥当性検証を行います。 <BR>
   *
   * @param msgList
   * @return
   *
   */
  @Override
  protected boolean validate(List<String> msgList) {


     if ((!worktime_1.getValue().equals("") && holiday_1.getValue() == 0) ||
     (worktime_1.getValue().equals("") && holiday_1.getValue() > 0)) {
     msgList.add(worktime_1.getFieldName() + "か" + holiday_1.getFieldName() +
     "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_2.getValue().equals("") && holiday_2.getValue() == 0) ||
     (worktime_2.getValue().equals("") && holiday_2.getValue() > 0)) {
     msgList.add(worktime_2.getFieldName() + "か" + holiday_2.getFieldName() +
     "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_3.getValue().equals("") && holiday_3.getValue() == 0) ||
     (worktime_3.getValue().equals("") && holiday_3.getValue() > 0)) {
     msgList.add(worktime_3.getFieldName() + "か" + holiday_3.getFieldName() +
     "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_4.getValue().equals("") && holiday_4.getValue() == 0) ||
     (worktime_4.getValue().equals("") && holiday_4.getValue() > 0)) {
     msgList.add(worktime_4.getFieldName() + "か" + holiday_4.getFieldName() +
     "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_5.getValue().equals("") && holiday_5.getValue() == 0) ||
     (worktime_5.getValue().equals("") && holiday_5.getValue() > 0)) {
     msgList.add(worktime_5.getFieldName() + "か" + holiday_5.getFieldName() +
     "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_6.getValue().equals("") && holiday_6.getValue() == 0) ||
     (worktime_6.getValue().equals("") && holiday_6.getValue() > 0)) {
     msgList.add(worktime_6.getFieldName() + "か" + holiday_6.getFieldName() +
     "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_7.getValue().equals("") && holiday_7.getValue() == 0) ||
     (worktime_7.getValue().equals("") && holiday_7.getValue() > 0)) {
     msgList.add(worktime_7.getFieldName() + "か" + holiday_7.getFieldName() +
     "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_8.getValue().equals("") && holiday_8.getValue() == 0) ||
     (worktime_8.getValue().equals("") && holiday_8.getValue() > 0)) {
     msgList.add(worktime_8.getFieldName() + "か" + holiday_8.getFieldName() +
     "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_9.getValue().equals("") && holiday_9.getValue() == 0) ||
     (worktime_9.getValue().equals("") && holiday_9.getValue() > 0)) {
     msgList.add(worktime_9.getFieldName() + "か" + holiday_9.getFieldName() +
     "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_10.getValue().equals("") && holiday_10.getValue() == 0) ||
     (worktime_10.getValue().equals("") && holiday_10.getValue() > 0)) {
     msgList.add(worktime_10.getFieldName() + "か" + holiday_10.getFieldName()
     + "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_11.getValue().equals("") && holiday_11.getValue() == 0) ||
     (worktime_11.getValue().equals("") && holiday_11.getValue() > 0)) {
     msgList.add(worktime_11.getFieldName() + "か" + holiday_11.getFieldName()
     + "の入力がないか、半角数値で正しいく入力されていません。");
     }

     if ((!worktime_12.getValue().equals("") && holiday_12.getValue() == 0) ||
     (worktime_12.getValue().equals("") && holiday_12.getValue() > 0)) {
     msgList.add(worktime_12.getFieldName() + "か" + holiday_12.getFieldName()
     + "の入力がないか、半角数値で正しいく入力されていません。");
     }

    return (msgList.size() == 0);
  }

  /**
   * 『部署』を読み込みます。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean loadFormData(RunData rundata, Context context,
      List<String> msgList) {
    try {
      if (epiMPost == null) {
        return false;
      }
      // 部署名
      post_name.setValue(epiMPost.getPostName());
      post_id = epiMPost.getPostId().intValue();

      // 就労設定を取得
      SelectQuery<EipTPostEmployment> query =
        Database.query(EipTPostEmployment.class);
      Expression exp0 =
        ExpressionFactory.matchDbExp(EipTPostEmployment.EIP_MPOST_PROPERTY
          + "."
          + EipMPost.POST_ID_PK_COLUMN, epiMPost.getPostId());
      Expression exp1 =
        ExpressionFactory.matchExp(EipTPostEmployment.YEAR_PROPERTY, year
          .getValue());

      query.setQualifier(exp0.andExp(exp1));

      if (query.getCount() == 0) {
        mode = "insert";
        return false;
      } else {
        mode = "update";
      }

      EipTPostEmployment postEmployment = query.fetchList().get(0);

      // フィールドにセット
      // 年
      year.setValue(year.getValue());
      // 時間
      worktime_1.setValue(postEmployment.getWorktime1().toString());
      worktime_2.setValue(postEmployment.getWorktime2().toString());
      worktime_3.setValue(postEmployment.getWorktime3().toString());
      worktime_4.setValue(postEmployment.getWorktime4().toString());
      worktime_5.setValue(postEmployment.getWorktime5().toString());
      worktime_6.setValue(postEmployment.getWorktime6().toString());
      worktime_7.setValue(postEmployment.getWorktime7().toString());
      worktime_8.setValue(postEmployment.getWorktime8().toString());
      worktime_9.setValue(postEmployment.getWorktime9().toString());
      worktime_10.setValue(postEmployment.getWorktime10().toString());
      worktime_11.setValue(postEmployment.getWorktime11().toString());
      worktime_12.setValue(postEmployment.getWorktime12().toString());
      // 休日
      holiday_1.setValue(postEmployment.getHoliday1());
      holiday_2.setValue(postEmployment.getHoliday2());
      holiday_3.setValue(postEmployment.getHoliday3());
      holiday_4.setValue(postEmployment.getHoliday4());
      holiday_5.setValue(postEmployment.getHoliday5());
      holiday_6.setValue(postEmployment.getHoliday6());
      holiday_7.setValue(postEmployment.getHoliday7());
      holiday_8.setValue(postEmployment.getHoliday8());
      holiday_9.setValue(postEmployment.getHoliday9());
      holiday_10.setValue(postEmployment.getHoliday10());
      holiday_11.setValue(postEmployment.getHoliday11());
      holiday_12.setValue(postEmployment.getHoliday12());

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  /**
   * 『部署』を追加します。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean insertFormData(RunData rundata, Context context,
      List<String> msgList) {
    try {
      // オブジェクト作成
      EipTPostEmployment postEmp = Database.create(EipTPostEmployment.class);
      postEmp.setEipMPost(epiMPost);

      // 年をセット
      postEmp.setYear((int) year.getValue());
      // 時間をセット
      postEmp.setWorktime1(!worktime_1.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_1.getValue())) : 0);
      postEmp.setWorktime2(!worktime_2.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_2.getValue())) : 0);
      postEmp.setWorktime3(!worktime_3.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_3.getValue())) : 0);
      postEmp.setWorktime4(!worktime_4.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_4.getValue())) : 0);
      postEmp.setWorktime5(!worktime_5.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_5.getValue())) : 0);
      postEmp.setWorktime6(!worktime_6.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_6.getValue())) : 0);
      postEmp.setWorktime7(!worktime_7.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_7.getValue())) : 0);
      postEmp.setWorktime8(!worktime_8.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_8.getValue())) : 0);
      postEmp.setWorktime9(!worktime_9.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_9.getValue())) : 0);
      postEmp.setWorktime10(!worktime_10.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_10.getValue())) : 0);
      postEmp.setWorktime11(!worktime_11.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_11.getValue())) : 0);
      postEmp.setWorktime12(!worktime_12.getValue().equals("") ? Float
        .valueOf(toHankakuNum(worktime_12.getValue())) : 0);
      // 休日
      postEmp.setHoliday1((int) holiday_1.getValue());
      postEmp.setHoliday2((int) holiday_2.getValue());
      postEmp.setHoliday3((int) holiday_3.getValue());
      postEmp.setHoliday4((int) holiday_4.getValue());
      postEmp.setHoliday5((int) holiday_5.getValue());
      postEmp.setHoliday6((int) holiday_6.getValue());
      postEmp.setHoliday7((int) holiday_7.getValue());
      postEmp.setHoliday8((int) holiday_8.getValue());
      postEmp.setHoliday9((int) holiday_9.getValue());
      postEmp.setHoliday10((int) holiday_10.getValue());
      postEmp.setHoliday11((int) holiday_11.getValue());
      postEmp.setHoliday12((int) holiday_12.getValue());

      // 時間
      Date now = Calendar.getInstance().getTime();
      postEmp.setCreateDate(now);
      postEmp.setUpdateDate(now);

      // コミット
      Database.commit();

    } catch (Exception ex) {
      Database.rollback();
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  /**
   * 『部署』を更新します。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context,
      List<String> msgList) {
    try {

      // オブジェクトを取得
      // 就労設定を取得
      SelectQuery<EipTPostEmployment> query =
        Database.query(EipTPostEmployment.class);
      Expression exp0 =
        ExpressionFactory.matchDbExp(EipTPostEmployment.EIP_MPOST_PROPERTY
          + "."
          + EipMPost.POST_ID_PK_COLUMN, epiMPost.getPostId());
      Expression exp1 =
        ExpressionFactory.matchExp(EipTPostEmployment.YEAR_PROPERTY, year
          .getValue());

      query.setQualifier(exp0.andExp(exp1));

      if (query.getCount() == 0) {
        return false;
      }

      EipTPostEmployment postEmp = query.fetchList().get(0);

      // 時間
      postEmp.setWorktime1(!worktime_1.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_1.getValue())) : 0);
      postEmp.setWorktime2(!worktime_2.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_2.getValue())) : 0);
      postEmp.setWorktime3(!worktime_3.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_3.getValue())) : 0);
      postEmp.setWorktime4(!worktime_4.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_4.getValue())) : 0);
      postEmp.setWorktime5(!worktime_5.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_5.getValue())) : 0);
      postEmp.setWorktime6(!worktime_6.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_6.getValue())) : 0);
      postEmp.setWorktime7(!worktime_7.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_7.getValue())) : 0);
      postEmp.setWorktime8(!worktime_8.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_8.getValue())) : 0);
      postEmp.setWorktime9(!worktime_9.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_9.getValue())) : 0);
      postEmp.setWorktime10(!worktime_10.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_10.getValue())) : 0);
      postEmp.setWorktime11(!worktime_11.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_11.getValue())) : 0);
      postEmp.setWorktime12(!worktime_12.getValue().equals("") ? Float.valueOf(toHankakuNum(worktime_12.getValue())) : 0);
      // 休日
      postEmp.setHoliday1((int) holiday_1.getValue());
      postEmp.setHoliday2((int) holiday_2.getValue());
      postEmp.setHoliday3((int) holiday_3.getValue());
      postEmp.setHoliday4((int) holiday_4.getValue());
      postEmp.setHoliday5((int) holiday_5.getValue());
      postEmp.setHoliday6((int) holiday_6.getValue());
      postEmp.setHoliday7((int) holiday_7.getValue());
      postEmp.setHoliday8((int) holiday_8.getValue());
      postEmp.setHoliday9((int) holiday_9.getValue());
      postEmp.setHoliday10((int) holiday_10.getValue());
      postEmp.setHoliday11((int) holiday_11.getValue());
      postEmp.setHoliday12((int) holiday_12.getValue());

      // 更新時間
      Date now = Calendar.getInstance().getTime();
      postEmp.setUpdateDate(now);

      Database.commit();

    } catch (Exception ex) {
      Database.rollback();
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  /**
   * 『部署』を削除します。 <BR>
   * このとき部署に関連づけられているグループも削除します。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean deleteFormData(RunData rundata, Context context,
      List<String> msgList) {
    return true;
  }

  /**
   * 部署名を取得します。 <BR>
   *
   * @return
   */
  public ALStringField getPostName() {
    return post_name;
  }

  /**
   *
   * @return
   */
  public int getPostId() {
    return post_id;
  }

  /**
   * @return mode
   */
  @Override
  public String getMode() {
    return mode;
  }

  /**
   * @return year
   */
  public ALNumberField getYear() {
    return year;
  }

  /**
   * @return worktime_1
   */
  public ALStringField getWorktime1() {
    return worktime_1;
  }

  /**
   * @return worktime_2
   */
  public ALStringField getWorktime2() {
    return worktime_2;
  }

  /**
   * @return worktime_3
   */
  public ALStringField getWorktime3() {
    return worktime_3;
  }

  /**
   * @return worktime_4
   */
  public ALStringField getWorktime4() {
    return worktime_4;
  }

  /**
   * @return worktime_5
   */
  public ALStringField getWorktime5() {
    return worktime_5;
  }

  /**
   * @return worktime_6
   */
  public ALStringField getWorktime6() {
    return worktime_6;
  }

  /**
   * @return worktime_7
   */
  public ALStringField getWorktime7() {
    return worktime_7;
  }

  /**
   * @return worktime_8
   */
  public ALStringField getWorktime8() {
    return worktime_8;
  }

  /**
   * @return worktime_9
   */
  public ALStringField getWorktime9() {
    return worktime_9;
  }

  /**
   * @return worktime_10
   */
  public ALStringField getWorktime10() {
    return worktime_10;
  }

  /**
   * @return worktime_11
   */
  public ALStringField getWorktime11() {
    return worktime_11;
  }

  /**
   * @return worktime_12
   */
  public ALStringField getWorktime12() {
    return worktime_12;
  }

  /**
   * @return holiday_1
   */
  public ALNumberField getHoliday1() {
    return holiday_1;
  }

  /**
   * @return holiday_2
   */
  public ALNumberField getHoliday2() {
    return holiday_2;
  }

  /**
   * @return holiday_3
   */
  public ALNumberField getHoliday3() {
    return holiday_3;
  }

  /**
   * @return holiday_4
   */
  public ALNumberField getHoliday4() {
    return holiday_4;
  }

  /**
   * @return holiday_5
   */
  public ALNumberField getHoliday5() {
    return holiday_5;
  }

  /**
   * @return holiday_6
   */
  public ALNumberField getHoliday6() {
    return holiday_6;
  }

  /**
   * @return holiday_7
   */
  public ALNumberField getHoliday7() {
    return holiday_7;
  }

  /**
   * @return holiday_8
   */
  public ALNumberField getHoliday8() {
    return holiday_8;
  }

  /**
   * @return holiday_9
   */
  public ALNumberField getHoliday9() {
    return holiday_9;
  }

  /**
   * @return holiday_10
   */
  public ALNumberField getHoliday10() {
    return holiday_10;
  }

  /**
   * @return holiday_11
   */
  public ALNumberField getHoliday11() {
    return holiday_11;
  }

  /**
   * @return holiday_12
   */
  public ALNumberField getHoliday12() {
    return holiday_12;
  }

  /***
   * 全角数値を半角数値に変換（.ー）を含んでいてもいい
   * @param text
   * @return
   */
  private static String toHankakuNum(String text) {
	  StringBuilder res = new StringBuilder();
	  final String listZens = "０１２３４５６７８９．－";
	  final String listHans = "0123456789.-";

	  for (int textIdx = 0; textIdx < text.length(); textIdx++) {
	    char ch = text.charAt(textIdx);
	    int listIdx = listZens.indexOf(ch);
	    if (listIdx >= 0) {
	      res.append(listHans.charAt(listIdx));
	    } else {
	      res.append(ch);
	    }
	  }
	  return res.toString();
	}

}
