/*
 * Copyright(C) 2012 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.account;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.tools.ant.ExitException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.portlet.EipTPostEmployment;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 就労設定の検索データを管理するためのクラスです。 <br />
 */
public class AccountPostEmploymentSettingSelectData extends
    ALAbstractSelectData<EipMPost, EipMPost> {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(AccountPostEmploymentSettingSelectData.class.getName());

  /** tab情報 add 2012/12/13 morimoto */
  protected String viewtype;

  /** 現在の年 **/
  private ALDateTimeField viewYear;

  /** 前の年 */
  private ALDateTimeField prevYear;

  /** 次の年 */
  private ALDateTimeField nextYear;

  /** <code>currentMonth</code> 今年 */
  private ALDateTimeField currentYear;

  /**
   *
   * @param action
   * @param rundata
   * @param context
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    if (sort == null || sort.equals("")) {
      ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, ALEipUtils
        .getPortlet(rundata, context)
        .getPortletConfig()
        .getInitParameter("p1a-sort"));
    }

    // POST/GET から yyyy-MM の形式で受け渡される。
    // 現在の年
    viewYear = new ALDateTimeField("yyyy");
    viewYear.setNotNull(true);
    // 前の年
    prevYear = new ALDateTimeField("yyyy");
    // 次の年
    nextYear = new ALDateTimeField("yyyy");
    // 今年
    currentYear = new ALDateTimeField("yyyy");


    // 自ポートレットからのリクエストであれば、パラメータを展開しセッションに保存する。
    if (ALEipUtils.isMatch(rundata, context)) {
      if (rundata.getParameters().containsKey("view_year")) {
        ALEipUtils.setTemp(rundata, context, "view_year", rundata
          .getParameters()
          .getString("view_year"));
      }
    }


    // 現在の年
    String tmpViewYear = ALEipUtils.getTemp(rundata, context, "view_year");
    if (tmpViewYear == null || tmpViewYear.equals("")) {
      Calendar cal = Calendar.getInstance();
      viewYear.setValue(String.valueOf(cal.get(cal.YEAR)));
    } else {
    	viewYear.setValue(tmpViewYear);
      if (!viewYear.validate(new ArrayList<String>())) {
        ALEipUtils.removeTemp(rundata, context, "view_year");
        throw new ALPageNotFoundException();
      }
    }

    // 今年
    Calendar cal1 = Calendar.getInstance();
    currentYear.setValue(String.valueOf(cal1.get(cal1.YEAR)));


    // 次の年,前の年
    Calendar cal2 = Calendar.getInstance();
    cal2.setTime(viewYear.getValue());
    cal2.add(Calendar.YEAR, 1);
    nextYear.setValue(cal2.getTime());
    cal2.add(Calendar.YEAR, -2);
    prevYear.setValue(cal2.getTime());


    super.init(action, rundata, context);

    viewtype = "setting";
  }

  /**
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected ResultList<EipMPost> selectList(RunData rundata, Context context) {
    try {
      SelectQuery<EipMPost> query = getSelectQuery(rundata, context);
      buildSelectQueryForListView(query);
      buildSelectQueryForListViewSort(query, rundata, context);

      return query.getResultList();
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  private SelectQuery<EipMPost> getSelectQuery(RunData rundata, Context context) {
    return Database.query(EipMPost.class);
  }

  /**
   * 詳細情報を取得します。
   *
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected EipMPost selectDetail(RunData rundata, Context context) {
    return AccountUtils.getEipMPost(rundata, context);
  }

  /**
   * @param obj
   * @return
   */
  @Override
  protected Object getResultData(EipMPost record) {

    AccountPostEmploymentSettingResultData rd =
      new AccountPostEmploymentSettingResultData();
    rd.initField();
    rd.setPostId(record.getPostId().intValue());
    rd.setPostName(record.getPostName());

    // 就労設定を取得
    EipTPostEmployment EipTPostEmploymentList = getEipTPostEmployment(record.getPostId().intValue());

    if (EipTPostEmploymentList != null){
    	// 年
    	rd.setYear(EipTPostEmploymentList.getYear());
    	// 就労時間
    	rd.setWorktime1(EipTPostEmploymentList.getWorktime1().toString());
    	rd.setWorktime2(EipTPostEmploymentList.getWorktime2().toString());
    	rd.setWorktime3(EipTPostEmploymentList.getWorktime3().toString());
    	rd.setWorktime4(EipTPostEmploymentList.getWorktime4().toString());
    	rd.setWorktime5(EipTPostEmploymentList.getWorktime5().toString());
    	rd.setWorktime6(EipTPostEmploymentList.getWorktime6().toString());
    	rd.setWorktime7(EipTPostEmploymentList.getWorktime7().toString());
    	rd.setWorktime8(EipTPostEmploymentList.getWorktime8().toString());
    	rd.setWorktime9(EipTPostEmploymentList.getWorktime9().toString());
    	rd.setWorktime10(EipTPostEmploymentList.getWorktime10().toString());
    	rd.setWorktime11(EipTPostEmploymentList.getWorktime11().toString());
    	rd.setWorktime12(EipTPostEmploymentList.getWorktime12().toString());
    	// 休日
    	rd.setHoliday1(EipTPostEmploymentList.getHoliday1().intValue());
    	rd.setHoliday2(EipTPostEmploymentList.getHoliday2().intValue());
    	rd.setHoliday3(EipTPostEmploymentList.getHoliday3().intValue());
    	rd.setHoliday4(EipTPostEmploymentList.getHoliday4().intValue());
    	rd.setHoliday5(EipTPostEmploymentList.getHoliday5().intValue());
    	rd.setHoliday6(EipTPostEmploymentList.getHoliday6().intValue());
    	rd.setHoliday7(EipTPostEmploymentList.getHoliday7().intValue());
    	rd.setHoliday8(EipTPostEmploymentList.getHoliday8().intValue());
    	rd.setHoliday9(EipTPostEmploymentList.getHoliday9().intValue());
    	rd.setHoliday10(EipTPostEmploymentList.getHoliday10().intValue());
    	rd.setHoliday11(EipTPostEmploymentList.getHoliday11().intValue());
    	rd.setHoliday12(EipTPostEmploymentList.getHoliday12().intValue());
    }

    return rd;
  }


  /**
   * @param obj
   * @return
   */
  @Override
  protected Object getResultDataDetail(EipMPost record) {
    AccountPostEmploymentSettingResultData rd =
      new AccountPostEmploymentSettingResultData();
    rd.initField();
    rd.setPostId(record.getPostId().intValue());
    rd.setPostName(record.getPostName());
    rd.setZipcode(record.getZipcode());
    rd.setAddress(record.getAddress());
    rd.setOutTelephone(record.getOutTelephone());
    rd.setInTelephone(record.getInTelephone());
    rd.setFaxNumber(record.getFaxNumber());
    rd.setGroupName(record.getGroupName());
    rd.setHeadOfficeFlg(record.getHeadOfficeFlg());

    // 就労設定
    EipTPostEmployment EipTPostEmploymentList = getEipTPostEmployment(record.getPostId().intValue());

    if (EipTPostEmploymentList != null){
    	// 年
    	rd.setYear(EipTPostEmploymentList.getYear());
    	// 就労時間
    	rd.setWorktime1(EipTPostEmploymentList.getWorktime1().toString());
    	rd.setWorktime2(EipTPostEmploymentList.getWorktime2().toString());
    	rd.setWorktime3(EipTPostEmploymentList.getWorktime3().toString());
    	rd.setWorktime4(EipTPostEmploymentList.getWorktime4().toString());
    	rd.setWorktime5(EipTPostEmploymentList.getWorktime5().toString());
    	rd.setWorktime6(EipTPostEmploymentList.getWorktime6().toString());
    	rd.setWorktime7(EipTPostEmploymentList.getWorktime7().toString());
    	rd.setWorktime8(EipTPostEmploymentList.getWorktime8().toString());
    	rd.setWorktime9(EipTPostEmploymentList.getWorktime9().toString());
    	rd.setWorktime10(EipTPostEmploymentList.getWorktime10().toString());
    	rd.setWorktime11(EipTPostEmploymentList.getWorktime11().toString());
    	rd.setWorktime12(EipTPostEmploymentList.getWorktime12().toString());
    	// 休日
    	rd.setHoliday1(EipTPostEmploymentList.getHoliday1().intValue());
    	rd.setHoliday2(EipTPostEmploymentList.getHoliday2().intValue());
    	rd.setHoliday3(EipTPostEmploymentList.getHoliday3().intValue());
    	rd.setHoliday4(EipTPostEmploymentList.getHoliday4().intValue());
    	rd.setHoliday5(EipTPostEmploymentList.getHoliday5().intValue());
    	rd.setHoliday6(EipTPostEmploymentList.getHoliday6().intValue());
    	rd.setHoliday7(EipTPostEmploymentList.getHoliday7().intValue());
    	rd.setHoliday8(EipTPostEmploymentList.getHoliday8().intValue());
    	rd.setHoliday9(EipTPostEmploymentList.getHoliday9().intValue());
    	rd.setHoliday10(EipTPostEmploymentList.getHoliday10().intValue());
    	rd.setHoliday11(EipTPostEmploymentList.getHoliday11().intValue());
    	rd.setHoliday12(EipTPostEmploymentList.getHoliday12().intValue());
    }

    return rd;
  }

  /**
   * @return
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    map.putValue("post_name", EipMPost.POST_NAME_PROPERTY);
    return map;
  }

  /**
   *
   * @param postid
   * @return
   */
  public List<ALEipUser> getMemberList(long postid) {
    return ALEipUtils.getUsersFromPost((int) postid);
  }

  /**
   * あるグループに所属するメンバーのリストを取得します
   *
   * @param postid
   * @return
   */
  public List<ALEipUser> getMemberListByGroup(String groupname) {
    return ALEipUtils.getUsers(groupname);
  }

  /**
   * @return viewtype
   */
  public String getViewtype() {
    return viewtype;
  }

  private EipTPostEmployment getEipTPostEmployment(int postId) {
		//Calendar now = Calendar.getInstance();
	    EipTPostEmployment EipTPostEmploymentList = null;
	    try {
	    SelectQuery<EipTPostEmployment> query = Database.query(EipTPostEmployment.class);
	    Expression exp0 =
	    		ExpressionFactory.matchDbExp(EipTPostEmployment.EIP_MPOST_PROPERTY
	    									+ "."
	    									+ EipMPost.POST_ID_PK_COLUMN, postId);
	    Expression exp1 =
	    		ExpressionFactory.matchExp(EipTPostEmployment.YEAR_PROPERTY, viewYear.getYear());

	    query.setQualifier(exp0.andExp(exp1));

	    EipTPostEmploymentList = query.fetchList().get(0);

	    } catch (Exception e){
	    	logger.debug(e);
	    }
		return EipTPostEmploymentList;
	}

  /**
   * 前の年を取得します。
   *
   * @return
   */
  public ALDateTimeField getPrevYear() {
    return prevYear;
  }

  /**
   * 次の年を取得します。
   *
   * @return
   */
  public ALDateTimeField getNextYear() {
    return nextYear;
  }

  /**
   * 現在の年を取得します。
   *
   * @return
   */
  public ALDateTimeField getViewYear() {
    return viewYear;
  }

  /**
   * 現在の年を取得します。
   *
   * @return
   */
  public ALDateTimeField getCurrentYear() {
    return currentYear;
  }


}
