/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.event;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

//import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
//import com.aimluck.eip.cayenne.om.portlet.AvzTEnqueteItem;
import com.aimluck.eip.cayenne.om.portlet.OriTEvent;
import com.aimluck.eip.cayenne.om.portlet.OriTEventMap;
//import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
//import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.event.util.EventUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogConstants;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;

/**
 * いのフォームデータを管理するクラスです。 <BR>
 *
 */
public class EventAnswerFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(EventAnswerFormData.class.getName());

  /** イベントID */
  private ALNumberField event_id;
  /** イベント名 */
  private ALStringField event_name;
  /** イベント内容 */
  private ALStringField event_comment;
  /** イベント作成者 */
  private ALStringField create_user_name;
  /** ユーザコメント */
  private ALStringField user_comment;

  /** 参加者 */
  private List<EventMapResultData> memberList;

  /** ステータス */
  private ALStringField status;



  /**
   *
   * @param action
   * @param rundata
   * @param context
   *
   *
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);
  }

  /**
   * 各フィールドを初期化します。 <BR>
   *
   *
   */
  @Override
  public void initField() {

	// イベントID
	event_id = new ALNumberField();
	// イベント名
	event_name = new ALStringField();
	// イベント内容
	event_comment = new ALStringField();
	// イベント作成者
	create_user_name = new ALStringField();
    // ユーザーコメント
    user_comment = new ALStringField();
    user_comment.setFieldName("コメント");
    // 参加者
    memberList = new ArrayList<EventMapResultData>();
    // ステータス
    status = new ALStringField();


  }


  /**
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean setFormData(RunData rundata, Context context,
      List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {

    boolean res = super.setFormData(rundata, context, msgList);
    return res;
  }


  /**
   * イベントの各フィールドに対する制約条件を設定します。 <BR>
   *
   *
   */
  @Override
  protected void setValidator() {

  }

  /**
   * イベントのフォームに入力されたデータの妥当性検証を行います。 <BR>
   *
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   *
   */
  @Override
  protected boolean validate(List<String> msgList) {
    return (msgList.size() == 0);
  }

  /**
   * イベントをデータベースから読み出します。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   */

  @Override
  protected boolean loadFormData(RunData rundata, Context context,
      List<String> msgList) {
    try {
      // オブジェクトモデルを取得
      OriTEvent event = EventUtils.getOriTEvent(rundata, context);

      if (event == null) {
    	  return false;
      }

      // イベントID
      event_id.setValue(event.getOriTEventId());
      // イベント名
      event_name.setValue(event.getEventName());
      // イベント内容
      event_comment.setValue(event.getComment());
      // 作成者
      create_user_name.setValue(ALEipUtils.getUserFullName(event.getCreateId()));

      // 参加者
//      SelectQuery<OriTEventMap> itemquery = Database.query(OriTEventMap.class);
//      Expression exp =
//    		  ExpressionFactory.matchDbExp(OriTEvent.EVENT_ID_PK_COLUMN, event.getOriTEventId());
//      Expression exp2 =
//    		  ExpressionFactory.matchExp(OriTEventMap.STATUS_PROPERTY, EventUtils.STATUS_PARTICIPATION);
//      itemquery.setQualifier(exp.andExp(exp2));

      // オブジェクトモデルを取得
      List<OriTEventMap> itemlist = EventUtils.getOriTEventMap(rundata, context);

      for (int i = 0; i < itemlist.size(); i++) {
    	  OriTEventMap eventMap = itemlist.get(i);
    	  EventMapResultData d = new EventMapResultData();
    	  d.initField();

    	  //d.setEventId(eventMap.getEventId());
    	  //d.setUserId(eventMap.getUserId());
    	  d.setUserName(ALEipUtils.getUserFullName(eventMap.getUserId()));
    	  ALStringField com = new ALStringField();
    	  com.setValue(eventMap.getComment());
    	  d.setUserComment(com);
    	  d.setStatus(eventMap.getStatus());

    	  memberList.add(d);
      }

     // ユーザコメント
     OriTEventMap eMap = EventUtils.getOriTEventMap(rundata, context, ALEipUtils.getUserId(rundata));
     user_comment.setValue(eMap.getComment());

     // ステータス
     status.setValue(eMap.getStatus());


    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }



  /**
   * データベースに格納されているイベントを更新します。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context,
      List<String> msgList) {

	  try {
	   // オブジェクトモデルを取得
	   OriTEvent event = EventUtils.getOriTEvent(rundata, context);

	   if (event == null) {
		   return false;
	   }

	   // オブジェクトモデルを取得 間違ってるかも知れない
	   OriTEventMap eventMap = EventUtils.getOriTEventMap(rundata, context,ALEipUtils.getUserId(rundata));

	   String status = rundata.getParameters().getString("status");
	   // ステータスを設定
	   eventMap.setStatus(status);
	   // コメントを設定
	   eventMap.setComment(user_comment.getValue());

	   // 現在の時刻を設定
	   Date now = Calendar.getInstance().getTime();
	   // 更新時間を設定
	   eventMap.setUpdateDate(now);

	   // 更新
	   Database.commit();


	  } catch (Exception ex) {
	      logger.error("Exception", ex);
	      return false;
	  }

	  return true;

  }




@Override
protected boolean deleteFormData(RunData arg0, Context arg1, List<String> arg2) {
	// TODO 自動生成されたメソッド・スタブ
	return true;
}


@Override
protected boolean insertFormData(RunData arg0, Context arg1, List<String> arg2) {
	// TODO 自動生成されたメソッド・スタブ
	return true;
}

/**
 * @return user_comment
 */
public ALStringField getUserComment() {
	return user_comment;
}

/**
 * @param user_comment セットする user_comment
 */
public void setUserComment(ALStringField user_comment) {
	this.user_comment = user_comment;
}

/**
 * @return event_name
 */
public ALStringField getEventName() {
	return event_name;
}

/**
 * @param event_name セットする event_name
 */
public void setEventName(ALStringField event_name) {
	this.event_name = event_name;
}

/**
 * @return event_comment
 */
public String getEventComment() {
	return ALEipUtils.getMessageList(event_comment.toString());
}

/**
 * @param event_comment セットする event_comment
 */
public void setEventComment(ALStringField event_comment) {
	this.event_comment = event_comment;
}

/**
 * @return create_user_name
 */
public ALStringField getCreateUserName() {
	return create_user_name;
}

/**
 * @param create_user_name セットする create_user_name
 */
public void setCreateUserName(ALStringField create_user_name) {
	this.create_user_name = create_user_name;
}

/**
 * @return memberList
 */
public List<EventMapResultData> getMemberList() {
	return memberList;
}

/**
 * @param memberList セットする memberList
 */
public void setMemberList(List<EventMapResultData> memberList) {
	this.memberList = memberList;
}

/**
 * @return status
 */
public ALStringField getStatus() {
	return status;
}

/**
 * @return event_id
 */
public ALNumberField getEventId() {
	return event_id;
}

/**
 * @param event_id セットする event_id
 */
public void setEventId(ALNumberField event_id) {
	this.event_id = event_id;
}





}
