/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.event;

import java.util.Date;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.common.ALData;

/**
 * イベントマップのResultDataです。 <BR>
 *
 */
public class EventMapResultData implements ALData {

  /** ID  */
  private ALNumberField id;
  /** イベントID */
  private ALNumberField event_id;
  /** USER ID  */
  private ALNumberField user_id;
  /** Status */
  private ALStringField status;
  /** USER NAME */
  private ALStringField user_name;
  /** コメント */
  private ALStringField user_comment;

  /** イベント名 **/
  private ALStringField event_name;
  /** 内容 */
  private ALStringField event_comment;
  /** 締切時間 */
  private ALDateTimeField closing_date;

  /**
   *
   *
   */
  @Override
  public void initField() {
	id = new ALNumberField();
    event_id = new ALNumberField();
    user_id = new ALNumberField();
    status = new ALStringField();
    user_name = new ALStringField();
    user_comment = new ALStringField();

    event_name = new ALStringField();
    event_comment = new ALStringField();
    closing_date = new ALDateTimeField("yyyy-MM-dd hh:mm");



  }

/**
 * @return id
 */
public ALNumberField getId() {
	return id;
}

/**
 * @param id セットする id
 */
public void setId(long id) {
	this.id.setValue(id);
}

/**
 * @return event_id
 */
public ALNumberField getEventId() {
	return event_id;
}

/**
 * @param event_id セットする event_id
 */
public void setEventId(long eventId) {
	this.event_id.setValue(eventId);
}

/**
 * @return user_id
 */
public ALNumberField getUserId() {
	return user_id;
}

/**
 * @param user_id セットする user_id
 */
public void setUserId(long userId) {
	this.user_id.setValue(userId);
}

/**
 * @return status
 */
public ALStringField getStatus() {
	return status;
}

/**
 * @param status セットする status
 */
public void setStatus(String status) {
	this.status.setValue(status);
}

/**
 * @return user_name
 */
public ALStringField getUserName() {
	return user_name;
}

/**
 * @param user_name セットする user_name
 */
public void setUserName(String userName) {
	this.user_name.setValue(userName);
}

/**
 * @return user_comment
 */
public String getUserComment() {
	return ALEipUtils.getMessageList(user_comment.toString());
}

/**
 * @param user_comment セットする user_comment
 */
public void setUserComment(ALStringField user_comment) {
	this.user_comment = user_comment;
}

/**
 * @return event_name
 */
public ALStringField getEventName() {
	return event_name;
}

/**
 * @param event_name セットする event_name
 */
public void setEventName(ALStringField event_name) {
	this.event_name = event_name;
}

/**
 * @return event_comment
 */
public String getEventComment() {
	return ALEipUtils.getMessageList(event_comment.toString());
}

/**
 * @param event_comment セットする event_comment
 */
public void setEventComment(ALStringField event_comment) {
	this.event_comment = event_comment;
}

/**
 * @return closing_date
 */
public ALDateTimeField getClosingDate() {
	return closing_date;
}

/**
 * @param closing_date セットする closing_date
 */
public void setClosingDate(ALDateTimeField closing_date) {
	this.closing_date = closing_date;
}



}
