/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.event.util;

import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.OriTEvent;
import com.aimluck.eip.cayenne.om.portlet.OriTEventMap;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;

/**
 * Memoのユーティリティクラスです。 <BR>
 *
 */
public class EventUtils {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(EventUtils.class.getName());

  // ポートレット名
  public static final String EVENT_PORTLET_NAME = "Event";

  // イベントの選択状態
  // 未選択
  public static final String STATUS_UNSELECTED = "0";
  // 参加
  public static final String STATUS_PARTICIPATION = "1";
  // 不参加
  public static final String STATUS_NONPARTICIPATION = "2";
  // 保留
  public static final String STATUS_HOLD = "3";

  /** 検索キーワード変数の識別子 */
  //public static final String TARGET_KEYWORD = "keyword";

  /** セッション内の検索キーワード名 */
  //public static final String SESSION_KEYWORD = "memo_keyword";

  /** セッション内のメモの新規(追加,更新)キーワード名 */
  public static final String NEW_FLAG = "new_flag";

  /** パラメータリセットの識別子 */
  private static final String RESET_FLAG = "reset_params";


  /**
   * 表示切り替えのリセットフラグがあるかを返す．
   *
   * @param rundata
   * @param context
   * @return
   */
  public static boolean hasResetFlag(RunData rundata, Context context) {
    String resetflag = rundata.getParameters().getString(RESET_FLAG);
    return resetflag != null;
  }


  /**
   * イベント オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */

  public static OriTEvent getOriTEvent(RunData rundata, Context context)
		  throws ALPageNotFoundException {
    //String uid = ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
	String uid = rundata.getParameters().getString("eventid");
    try {
      if (uid == null || uid == "") {
        // Event IDが空の場合
        logger.debug("[EventUtils] Empty ID...");
        return null;
      }

      SelectQuery<OriTEvent> query = Database.query(OriTEvent.class);
      Expression exp =
        ExpressionFactory.matchDbExp(OriTEvent.EVENT_ID_PK_COLUMN, Integer.valueOf(uid));
      query.setQualifier(exp);

      List<OriTEvent> events = query.fetchList();

      if (events == null || events.size() == 0) {
        // 指定したイベント IDのレコードが見つからない場合
        logger.debug("[EventUtils] Not found ID...");
        return null;
      }

      return events.get(0);

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * イベントマップ オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */

  public static List<OriTEventMap> getOriTEventMap(RunData rundata, Context context) throws ALPageNotFoundException {
    //int userId = ALEipUtils.getUserId(rundata);
    String uid = rundata.getParameters().getString("eventid");
    try {
      if (uid == null || uid == "" ) {
        // Event IDが空の場合
        logger.debug("[EventUtils] Empty ID...");
        return null;
      }

      SelectQuery<OriTEventMap> query = Database.query(OriTEventMap.class);
      Expression exp =
        ExpressionFactory.matchDbExp(OriTEvent.EVENT_ID_PK_COLUMN, Integer.valueOf(uid));
     // Expression exp2 =
     //		  ExpressionFactory.matchExp(OriTEventMap.USER_ID_PROPERTY, userId);

      query.setQualifier(exp);

      List<OriTEventMap> eventMaps = query.fetchList();

      if (eventMaps == null || eventMaps.size() == 0) {
        // 指定したイベント IDのレコードが見つからない場合
        logger.debug("[EventUtils] Not found ID...");
        return null;
      }

      return eventMaps;

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * イベントマップ オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */

  public static OriTEventMap getOriTEventMap(RunData rundata, Context context, int userId) throws ALPageNotFoundException {
    //int userId = ALEipUtils.getUserId(rundata);
    String uid = rundata.getParameters().getString("eventid");
    try {
      if (uid == null || uid == "" ) {
        // Event IDが空の場合
        logger.debug("[EventUtils] Empty ID...");
        return null;
      }

      SelectQuery<OriTEventMap> query = Database.query(OriTEventMap.class);
      Expression exp =
        ExpressionFactory.matchDbExp(OriTEvent.EVENT_ID_PK_COLUMN, Integer.valueOf(uid));
      Expression exp2 =
     		  ExpressionFactory.matchExp(OriTEventMap.USER_ID_PROPERTY, userId);

      query.setQualifier(exp.andExp(exp2));

      List<OriTEventMap> eventMaps = query.fetchList();

      if (eventMaps == null || eventMaps.size() == 0) {
        // 指定したイベント IDのレコードが見つからない場合
        logger.debug("[EventUtils] Not found ID...");
        return null;
      }

      return eventMaps.get(0);

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }


}
