/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


dojo.provide("aipo.event");
dojo.require("aipo.widget.MemberNormalSelectList");
dojo.require("aipo.widget.GroupNormalSelectList");

aipo.event.onLoadEventDialog = function(portlet_id){

    dojo.byId("event_name").focus();

    var mpicker = dijit.byId("membernormalselect");
    if(mpicker){
    	var select = dojo.byId('init_memberlist');
 	    var i;
 	    var s_o = select.options;
 	    if (s_o.length == 1 && s_o[0].value == "") return;
 	    for(i = 0 ; i < s_o.length; i ++ ) {
 	        mpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
 	    }
    }

}

aipo.event.formSwitchCategoryInput = function(button) {
    if(button.form.is_new_category.value == 'TRUE' || button.form.is_new_category.value == 'true') {
        button.value = '新しく入力する';
        aipo.event.formCategoryInputOff(button.form);
    } else {
        button.value = '一覧から選択する';
        aipo.event.formCategoryInputOn(button.form);
    }
}

aipo.event.formCategoryInputOn = function(form) {
    dojo.byId('eventCategorySelectField').style.display = "none";
    dojo.byId('eventCategoryInputField').style.display = "";

    form.is_new_category.value = 'TRUE';
}

aipo.event.formCategoryInputOff = function(form) {
    dojo.byId('eventCategoryInputField').style.display = "none";
    dojo.byId('eventCategorySelectField').style.display = "";

    form.is_new_category.value = 'FALSE';
}

aipo.event.onReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(!!arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('event');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

aipo.event.onReceiveMessageUpdate = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(!!arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('event');
    }

    var node = dojo.query('.messageDiv_event.enabled');
    if (node.length >= 1) {
        node[0].innerHTML = msg;
    }
}


aipo.event.enableMessageDiv = function(portlet_id) {
    dojo.query('.messageDiv_event').forEach(function(node, index, arr){
        dojo.removeClass(node, 'enabled');
    });
    dojo.addClass('event_'+portlet_id, 'enabled');
}

