/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.exttimecard;

import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.OriTPayrollSystem;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 給与体系の検索用データクラスです。
 *
 */
public class ExtTimecardSystemPayrollSystemSelectData extends
    ALAbstractSelectData<OriTPayrollSystem, OriTPayrollSystem> {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ExtTimecardSystemPayrollSystemSelectData.class.getName());


  /** <code>viewtype</code> 表示タイプ */
  protected String viewtype = "payroll";


  /**
   *
   * @param action
   * @param rundata
   * @param context
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    if (sort == null || sort.equals("")) {
      ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, "payroll_system_name");
    }

    super.init(action, rundata, context);
  }

  /**
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected ResultList<OriTPayrollSystem> selectList(RunData rundata, Context context) {
    try {
      SelectQuery<OriTPayrollSystem> query = getSelectQuery(rundata, context);
      buildSelectQueryForListView(query);
      buildSelectQueryForListViewSort(query, rundata, context);

      ResultList<OriTPayrollSystem> list = query.getResultList();

      return list;

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  private SelectQuery<OriTPayrollSystem> getSelectQuery(RunData rundata,
      Context context) {
    return Database.query(OriTPayrollSystem.class);
  }

  /**
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected OriTPayrollSystem selectDetail(RunData rundata, Context context) {
    return ExtTimecardUtils.getOriTPayrollSystem(rundata, context);
  }

  /**
   * @param obj
   * @return
   */
  @Override
  protected Object getResultData(OriTPayrollSystem record) {
    ExtTimecardSystemPayrollSystemResultData rd = new ExtTimecardSystemPayrollSystemResultData();
    rd.initField();
    rd.setId(record.getId());
    rd.setPayrollSystemCd(record.getPayrollSystemCd());
    rd.setPayrollSystemName(record.getPayrollSystemName());
    rd.setPayrollSystemType(record.getPayrollSystemType());

    return rd;
  }

  /**
   * @param obj
   * @return
   */
  @Override
  protected Object getResultDataDetail(OriTPayrollSystem record) {
    ExtTimecardSystemPayrollSystemResultData rd = new ExtTimecardSystemPayrollSystemResultData();
    rd.initField();
    rd.setId(record.getId());
    rd.setPayrollSystemCd(record.getPayrollSystemCd());
    rd.setPayrollSystemName(record.getPayrollSystemName());
    rd.setPayrollSystemType(record.getPayrollSystemType());

    return rd;
  }

  /**
   * @return
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    map.putValue("payroll_system_name", OriTPayrollSystem.PAYROLL_SYSTEM_NAME_PROPERTY);
    return map;
  }

  /**
   * 表示タイプを取得します。
   *
   * @return
   */
  public String getViewtype() {
    return viewtype;
  }


}
