/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.exttimecard.ExtTimecardApprovalListSelectData;
import com.aimluck.eip.exttimecard.ExtTimecardSelectData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * タイムカードの一覧を処理するクラスです。 <br />
 * morimoto-junichi add 2012/10/10
 */
public class ExtTimecardApprovalListScreen extends ExtTimecardScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ExtTimecardApprovalListScreen.class.getName());

  /**
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {
      ExtTimecardApprovalListSelectData listData = new ExtTimecardApprovalListSelectData();
      listData.initField();
      listData.setRowsNum(100);
      listData.doViewList(this, rundata, context);

      String layout_template = "portlets/html/ja/ajax-exttimecard-approval-list.vm";
      setTemplate(rundata, context, layout_template);

    } catch (Exception ex) {
      logger.error("[ExtTimecardApprovalListScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }
}
