/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.improveope;

import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.account.EipMUserPosition;
import com.aimluck.eip.cayenne.om.portlet.OriTPointHistory;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
//import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
//import com.aimluck.eip.account.AccountResultData;
//import com.aimluck.eip.userlist.utils.UserListUtils;

/**
 * ユーザーアカウントの検索データを管理するためのクラスです。 <br />
 *
 */
public class ImproveopeGrantSelectData extends
    ALAbstractSelectData<TurbineUser, TurbineUser> {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ImproveopeGrantSelectData.class.getName());

  /** <code>target_group_name</code> 表示対象の部署名 */
  private String target_group_name;

  /** <code>target_user_id</code> 表示対象のユーザ ID */
  private String target_user_id;

  /** <code>target_start_year</code> 表示対象の開始年 */
  private String target_start_year;
  /** <code>target_start_month</code> 表示対象の開始月 */
  private String target_start_month;
  /** <code>target_end_year</code> 表示対象の終了年 */
  private String target_end_year;
  /** <code>target_end_month</code> 表示対象の終了月 */
  private String target_end_month;

//  /** <code>myGroupList</code> グループリスト（My グループと部署） */
//  private List<ALEipGroup> myGroupList = null;

  /** <code>userList</code> 表示切り替え用のユーザリスト */
  private List<ALEipUser> userList = null;

  /** <code>TARGET_GROUP_NAME</code> グループによる表示切り替え用変数の識別子 */
  private final String TARGET_GROUP_NAME = "target_group_name";

  /** <code>TARGET_USER_ID</code> ユーザによる表示切り替え用変数の識別子 */
  public static final String TARGET_USER_ID = "target_user_id";

  /** <code>TARGET_START_YEAR</code> 集計期間による表示切り替え用変数の識別子 */
  private final String TARGET_START_YEAR = "target_start_year";
  /** <code>TARGET_START_MONTH</code> 集計期間による表示切り替え用変数の識別子 */
  private final String TARGET_START_MONTH = "target_start_month";
  /** <code>TARGET_END_YEAR</code> 集計期間による表示切り替え用変数の識別子 */
  private final String TARGET_END_YEAR = "target_end_year";
  /** <code>TARGET_END_MONTH</code> 集計期間による表示切り替え用変数の識別子 */
  private final String TARGET_END_MONTH = "target_end_month";


  /** <code>userid</code> ユーザーID */
  private String userid;

  /** 本部権限の有無*/
  private boolean hasAclAdmin;


  /** 現在表示している部署 */
  private String currentPost;

  /** 検索キーワード */
  //private ALStringField searchWord;

  private int registeredUserNum = 0;

  private boolean adminFilter;

  private ALStringField tab;

  /** 一覧データ */
  private List<Object> list;

  // モード
  public String mode = "grant";

  private boolean hasAclMenuAdmin;
  private boolean hasAclMenuView;

  /**
   * 初期化します。
   *
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    tab = new ALStringField(ALEipUtils.getTemp(rundata, context, "tab"));

    //searchWord = new ALStringField();
    ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, "userposition");

    // ログインユーザの ID を設定する．
    userid = Integer.toString(ALEipUtils.getUserId(rundata));

    // My グループの一覧を取得する．
//    List<ALEipGroup> myGroups = ALEipUtils.getMyGroups(rundata);
//    myGroupList = new ArrayList<ALEipGroup>();
//    int length = myGroups.size();
//    for (int i = 0; i < length; i++) {
//      myGroupList.add(myGroups.get(i));
//    }

    // 指定グループや指定ユーザをセッションに設定する．
    setupLists(rundata, context);

    // アクセス権
    ALAccessControlFactoryService aclservice =
      (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
        .getInstance()).getService(ALAccessControlFactoryService.SERVICE_NAME);
    ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
    hasAclAdmin =
    	      aclhandler.hasAuthority(
    	        ALEipUtils.getUserId(rundata),
    	        ALAccessControlConstants.POERTLET_FEATURE_IMPROVEOPE_ADMIN,
    	        ALAccessControlConstants.VALUE_ACL_LIST);

    hasAclMenuAdmin =
  	      aclhandler.hasAuthority(
  	        ALEipUtils.getUserId(rundata),
  	        ALAccessControlConstants.POERTLET_FEATURE_IMPROVEOPE_ADMIN,
  	        ALAccessControlConstants.VALUE_ACL_UPDATE);

      hasAclMenuView =
    	      aclhandler.hasAuthority(
    	        ALEipUtils.getUserId(rundata),
    	        ALAccessControlConstants.POERTLET_FEATURE_IMPROVEOPE_ADMIN,
    	        ALAccessControlConstants.VALUE_ACL_LIST);

    super.init(action, rundata, context);
  }

  /**
   * アカウント一覧を取得します。 ただし、論理削除されているアカウントは取得しません。
   *
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected ResultList<TurbineUser> selectList(RunData rundata, Context context) {
    try {
      // 登録済みのユーザ数をデータベースから取得

      SelectQuery<TurbineUser> query = getSelectQuery(rundata, context);
      buildSelectQueryForListView(query);
      buildSelectQueryForListViewSort(query, rundata, context);
      ResultList<TurbineUser> list = query.getResultList();

      registeredUserNum = list.getTotalCount();
      return list;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  protected SelectQuery<TurbineUser> getSelectQuery(RunData rundata,
      Context context) {

    ObjectId oid =
      new ObjectId("TurbineUser", TurbineUser.USER_ID_PK_COLUMN, 3);
    Expression exp1 =
      ExpressionFactory.matchAllDbExp(
        oid.getIdSnapshot(),
        Expression.GREATER_THAN);
    Expression exp2 =
      ExpressionFactory.matchExp(TurbineUser.DISABLED_PROPERTY, "F");

    SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
    query.setQualifier(exp1.andExp(exp2));

    adminFilter = rundata.getParameters().getBoolean("adminfiltered");
    if (adminFilter) {
      try {
        Group group = JetspeedSecurity.getGroup("LoginUser");
        Role adminrole = JetspeedSecurity.getRole("admin");
        List<TurbineUserGroupRole> admins =
          Database
            .query(TurbineUserGroupRole.class)
            .where(
              Operations.eq(
                TurbineUserGroupRole.TURBINE_ROLE_PROPERTY,
                adminrole.getId()),
              Operations.eq(TurbineUserGroupRole.TURBINE_GROUP_PROPERTY, group
                .getId()),
              Operations.ne(TurbineUserGroupRole.TURBINE_USER_PROPERTY, 1))
            .distinct(true)
            .fetchList();
        List<Integer> admin_ids = new ArrayList<Integer>();
        admin_ids.add(Integer.valueOf(1));
        for (TurbineUserGroupRole tugr : admins) {
          admin_ids.add(tugr.getTurbineUser().getUserId());
        }
        query.andQualifier(ExpressionFactory.inDbExp(
          TurbineUser.USER_ID_PK_COLUMN,
          admin_ids));
      } catch (Exception ex) {
        logger.error("Exception", ex);
      }
    }

//    String filter = ALEipUtils.getTemp(rundata, context, LIST_FILTER_STR);
//    current_filter = filter;
//
//    Map<Integer, ALEipPost> gMap = ALEipManager.getInstance().getPostMap();
//    if (!(filter == null || "".equals(filter) || !gMap.containsKey(Integer
//      .valueOf(filter)))) {
//      String groupName =
//        (ALEipManager.getInstance().getPostMap().get(Integer.valueOf(filter)))
//          .getGroupName()
//          .getValue();
//
//      query.where(Operations.eq(TurbineUser.TURBINE_USER_GROUP_ROLE_PROPERTY
//        + "."
//        + TurbineUserGroupRole.TURBINE_GROUP_PROPERTY
//        + "."
//        + TurbineGroup.GROUP_NAME_PROPERTY, groupName));
//    }


    if (getTargetGroupName() != null && !getTargetGroupName().equals("all")) {
        query.where(Operations.eq(TurbineUser.TURBINE_USER_GROUP_ROLE_PROPERTY
                + "."
                + TurbineUserGroupRole.TURBINE_GROUP_PROPERTY
                + "."
                + TurbineGroup.GROUP_NAME_PROPERTY, getTargetGroupName()));

    }

    // ソート
    String sort = rundata.getParameters().getString("sort");

    if (sort == null) {
      // morimoto
      query.orderAscending(TurbineUser.TURBINE_USER_GROUP_ROLE_PROPERTY
      		+ "."
      		+ TurbineUserGroupRole.TURBINE_GROUP_PROPERTY
      		+ "."
      		+ TurbineGroup.EIP_MPOST_PROPERTY
      		+ "."
      		+ EipMPost.POST_CD_PROPERTY
      		);
      query.orderAscending(TurbineUser.EIP_MUSER_POSITION_PROPERTY
      		+ "."
      		+ EipMUserPosition.POSITION_PROPERTY);

    }

//    // morimoto
//    query.orderAscending(TurbineUser.TURBINE_USER_GROUP_ROLE_PROPERTY
//    		+ "."
//    		+ TurbineUserGroupRole.TURBINE_GROUP_PROPERTY
//    		+ "."
//    		+ TurbineGroup.EIP_MPOST_PROPERTY
//    		+ "."
//    		+ EipMPost.POST_CD_PROPERTY
//    		);
//
//    query.orderAscending(TurbineUser.EIP_MUSER_POSITION_PROPERTY
//    		+ "."
//    		+ EipMUserPosition.POSITION_PROPERTY);

    return query;
  }

//  /**
//   * フィルタ用の <code>Criteria</code> を構築します。
//   *
//   * @param crt
//   * @param rundata
//   * @param context
//   * @return
//   */
//  @Override
//  protected SelectQuery<TurbineUser> buildSelectQueryForFilter(
//      SelectQuery<TurbineUser> query, RunData rundata, Context context) {
//    // 指定部署IDの取得
//    String filter = ALEipUtils.getTemp(rundata, context, LIST_FILTER_STR);
//
//    // 指定部署が存在しているかを確認し、存在していなければ値を削除する
//    Map<Integer, ALEipPost> gMap = ALEipManager.getInstance().getPostMap();
//    if (filter != null
//      && filter.trim().length() != 0
//      && !gMap.containsKey(Integer.valueOf(filter))) {
//      filter = null;
//    }
//
//    String filter_type =
//      ALEipUtils.getTemp(rundata, context, LIST_FILTER_TYPE_STR);
//    String crt_key = null;
//    Attributes map = getColumnMap();
//    if (filter == null || filter_type == null || filter.equals("")) {
//    	// morimoto
//        query.orderAscending(TurbineUser.TURBINE_USER_GROUP_ROLE_PROPERTY
//        		+ "."
//        		+ TurbineUserGroupRole.TURBINE_GROUP_PROPERTY
//        		+ "."
//        		+ TurbineGroup.EIP_MPOST_PROPERTY
//        		+ "."
//        		+ EipMPost.POST_CD_PROPERTY
//        		);
//
//        query.orderAscending(TurbineUser.EIP_MUSER_POSITION_PROPERTY
//        		+ "."
//        		+ EipMUserPosition.POSITION_PROPERTY);
//
//      return query;
//    }
//    crt_key = map.getValue(filter_type);
//    if (crt_key == null) {
//      return query;
//    }
//
//    Expression exp = ExpressionFactory.matchDbExp(crt_key, filter);
//    query.andQualifier(exp);
//    current_filter = filter;
//    current_filter_type = filter_type;
//    return query;
//  }

  /**
   *
   * @param id
   * @return
   */
  @SuppressWarnings("unused")
  private String getPostName(int id) {
    if (ALEipManager
      .getInstance()
      .getPostMap()
      .containsKey(Integer.valueOf(id))) {
      return (ALEipManager.getInstance().getPostMap().get(Integer.valueOf(id)))
        .getPostName()
        .getValue();
    }
    return null;
  }

  /**
   *
   * @param id
   * @return
   */
  @SuppressWarnings("unused")
  private String getPositionName(int id) {
    if (ALEipManager.getInstance().getPositionMap().containsKey(
      Integer.valueOf(id))) {
      return (ALEipManager.getInstance().getPositionMap().get(Integer
        .valueOf(id))).getPositionName().getValue();
    }
    return null;
  }

  /**
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected TurbineUser selectDetail(RunData rundata, Context context) {
    String userid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    if (userid == null) {
      return null;
    }
    return Database.get(TurbineUser.class, Integer.parseInt(userid));
  }

  /**
   * @param obj
   * @return
   *
   */
  @Override
  protected Object getResultData(TurbineUser record) {
    ImproveopeGrantResultData rd = new ImproveopeGrantResultData();
    rd.initField();
    setResultData(record, rd);
    return rd;
  }

  /**
   * @param obj
   * @return
   */
  @Override
  protected Object getResultDataDetail(TurbineUser record) {
    try {
    	ImproveopeGrantResultData rd = new ImproveopeGrantResultData();
      rd.initField();
      setResultData(record, rd);
      //rd.setIsAdmin(ALEipUtils.isAdmin(Integer.valueOf(record.getUserId())));
      return rd;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  private void setResultData(TurbineUser model, ImproveopeGrantResultData data) {
    data.setUserId(model.getUserId());
    data.setUserName(getAliasName(model.getFirstName(), model.getLastName()));
    EipMPost post = ALEipUtils.getPostInfo(model.getUserId());
    if (post != null) {
    	data.setPostName(post.getPostName());
    }

    // ポイントのサマリー値を取得
    StringBuffer sb = new StringBuffer();
    sb.append("select ");
    sb.append("  user_id as user_id, ");
    sb.append("  cast(sum(point) as integer) as point ");
    sb.append("from ");
    sb.append("  ori_t_point_history  ");
    sb.append("where 1 = 1 " );
    if (this.target_start_year != null && !"".equals(this.target_start_year) && !"none".equals(this.target_start_year)
        && this.target_start_month != null && !"".equals(this.target_start_month) && !"none".equals(this.target_start_month)) {
      SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
      Calendar start_date = Calendar.getInstance();
      start_date.set(Calendar.YEAR, Integer.valueOf(this.target_start_year));
      start_date.set(Calendar.MONTH, Integer.valueOf(this.target_start_month)-1);
      start_date.set(Calendar.DAY_OF_MONTH, 1);
      sb.append("and TO_CHAR(create_date, 'yyyy-MM') >= '" + sf.format(start_date.getTime()) + "' " );
    }
    if (this.target_end_year != null && !"".equals(this.target_end_year) && !"none".equals(this.target_end_year)
        && this.target_end_month != null && !"".equals(this.target_end_month) && !"none".equals(this.target_end_month)) {
      SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
      Calendar end_date = Calendar.getInstance();
      end_date.set(Calendar.YEAR, Integer.valueOf(this.target_end_year));
      end_date.set(Calendar.MONTH, Integer.valueOf(this.target_end_month)-1);
      end_date.set(Calendar.DAY_OF_MONTH, 1);
      sb.append("and TO_CHAR(create_date, 'yyyy-MM') <= '" + sf.format(end_date.getTime()) + "' " );
    }
    sb.append("group by ");
    sb.append("  user_id ");

    SQLTemplate<OriTPointHistory> sumPointquery = Database.sql(OriTPointHistory.class, sb.toString());

    List<OriTPointHistory> sumPointList = sumPointquery.fetchList();
    String point = "0 P";
    for (int i = 0; i < sumPointList.size(); i++) {
    	OriTPointHistory rd = sumPointList.get(i);
    	if (model.getUserId().equals(rd.getUserId())) {
    		point = rd.getPoint().toString() + " P";
    	}
    }

    data.setPoint(point);

  }

  private String getAliasName(String firstName, String lastName) {
    return new StringBuffer()
      .append(lastName)
      .append(" ")
      .append(firstName)
      .toString();
  }

  /**
   * 一覧表示します。
   *
   * @param action
   * @param rundata
   * @param context
   * @return TRUE 成功 FASLE 失敗
   */
  @Override
  public boolean doSelectList(ALAction action, RunData rundata, Context context) {
    try {
      init(action, rundata, context);
      doCheckAclPermission(
        rundata,
        context,
        ALAccessControlConstants.VALUE_ACL_LIST);
      ResultList<TurbineUser> resultList = selectList(rundata, context);
      if (resultList != null) {
        if (resultList.getTotalCount() > 0) {
          setPageParam(resultList.getTotalCount());
        }

        Map<Integer, Boolean> map = getAdminInfo(resultList);
        list = new ArrayList<Object>();
        for (TurbineUser model : resultList) {
          Object object = getResultData(model);
          //setAdminInfo(object, map);
          if (object != null) {
            list.add(object);
          }
        }
      }
      return (list != null);
    } catch (ALPermissionException e) {
      ALEipUtils.redirectPermissionError(rundata);
      return false;
    } catch (ALPageNotFoundException e) {
      ALEipUtils.redirectPageNotFound(rundata);
      return false;
    } catch (ALDBErrorException e) {
      ALEipUtils.redirectDBError(rundata);
      return false;
    }

  }

  private Map<Integer, Boolean> getAdminInfo(ResultList<TurbineUser> list) {
    if (list == null) {
      return new HashMap<Integer, Boolean>();
    }

    List<Integer> userIds = new ArrayList<Integer>();
    for (TurbineUser user : list) {
      userIds.add(user.getUserId());
    }

    Role adminrole = null;
    try {
      adminrole = JetspeedSecurity.getRole("admin");
    } catch (JetspeedSecurityException e) {
      logger.error("[UserSelectData]", e);
      return new HashMap<Integer, Boolean>();
    }
    List<TurbineUserGroupRole> roleList =
      Database
        .query(TurbineUserGroupRole.class)
        .where(
          Operations.eq(TurbineUserGroupRole.TURBINE_ROLE_PROPERTY, adminrole
            .getId()),
          Operations.in(TurbineUserGroupRole.TURBINE_USER_PROPERTY, userIds))
        .fetchList();

    if (roleList == null) {
      return new HashMap<Integer, Boolean>();
    }

    Map<Integer, Boolean> map = new HashMap<Integer, Boolean>();
    for (TurbineUserGroupRole role : roleList) {
      map.put(role.getTurbineUser().getUserId(), Boolean.valueOf(true));
    }

    return map;
  }

//  private void setAdminInfo(Object obj, Map<Integer, Boolean> map) {
//	ImproveopeGrantResultData data = (ImproveopeGrantResultData) obj;
//    Boolean bool = map.get(Integer.valueOf((int) data.getUserId().getValue()));
//    data.setIsAdmin(bool == null ? false : bool);
//  }

  /**
   * @return
   *
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    map.putValue("post", TurbineUser.TURBINE_USER_GROUP_ROLE_PROPERTY
    		+ "."
    		+ TurbineUserGroupRole.TURBINE_GROUP_PROPERTY
    		+ "."
    		+ TurbineGroup.EIP_MPOST_PROPERTY
    		+ "."
    		+ EipMPost.POST_CD_PROPERTY);
    map.putValue("user_name", TurbineUser.LAST_NAME_COLUMN);
    map.putValue("name_kana", TurbineUser.LAST_NAME_KANA_PROPERTY);
    map.putValue("userposition", TurbineUser.EIP_MUSER_POSITION_PROPERTY
      + "."
      + EipMUserPosition.POSITION_PROPERTY); // ユーザの順番
    return map;
  }


  /**
   * 部署の一覧を取得する．
   *
   * @return
   */
  public Map<Integer, ALEipPost> getPostMap() {
    if (hasAclAdmin) {
      return ALEipManager.getInstance().getPostMap();
    } else {
      // 自分が所属する部署のIDリスト
      List<Integer> list =
        ALEipUtils.getPostIdList(Integer.valueOf(this.userid));
      // すべての部署リスト
      Map<Integer, ALEipPost> map = ALEipManager.getInstance().getPostMap();
      Map<Integer, ALEipPost> tmp = new LinkedHashMap<Integer, ALEipPost>();
      for (Integer i : list) {
        tmp.put(i, map.get(i));
      }
      return tmp;
      // return ALEipManager.getInstance().getPostMap();
    }
  }

  /**
   * 指定グループに属するユーザの一覧を取得する．
   *
   * @param groupname
   * @return
   */
  public List<ALEipUser> getUsers() {
    if (hasAclAdmin) {
      return userList;
    } else {
      try {
        List<ALEipUser> users = new ArrayList<ALEipUser>();
        users.add(ALEipUtils.getALEipUser(Integer.parseInt(userid)));
        return users;
      } catch (Exception e) {
        return null;
      }
    }
  }

  /**
   * 指定グループや指定ユーザをセッションに設定する．
   *
   * @param rundata
   * @param context
   * @throws ALDBErrorException
   */
  private void setupLists(RunData rundata, Context context) {

    setTargetYear(rundata, context);

	  this.target_group_name = getTargetGroupName(rundata, context);
    if ((target_group_name != null)
      && (!target_group_name.equals(""))
      && (!target_group_name.equals("all"))
      && (!target_group_name.equals("only"))) {
      userList = ALEipUtils.getUsers(target_group_name);
    } else if (target_group_name.equals("only")) {

      userList = getUserList(Integer.parseInt(userid));
    } else {
      userList = ALEipUtils.getUsers("LoginUser");
    }

    if (userList == null || userList.size() == 0) {
      target_user_id = "";
      ALEipUtils.removeTemp(rundata, context, TARGET_USER_ID);
      // ユーザー
      //this.target_user_id = getTargetUserId(rundata, context);
      return;
    }

  }

  /**
   * ログイン中のユーザー情報を取得
   *
   */

  private List<ALEipUser> getUserList(int userid) {
    List<ALEipUser> list = new ArrayList<ALEipUser>();
    ALEipUser user = new ALEipUser();
    try {
      user = ALEipUtils.getALEipUser(userid);
    } catch (NumberFormatException e1) {
    } catch (ALDBErrorException e1) {
    }
    list.add(user);
    return list;
  }

  /**
   * 表示切り替えで指定したグループ ID を取得する．
   *
   * @param rundata
   * @param context
   * @return
   */
  private String getTargetGroupName(RunData rundata, Context context) {
    String target_group_name = null;
    String idParam = null;
    if (ALEipUtils.isMatch(rundata, context)) {
      // 自ポートレットへのリクエストの場合に，グループ名を取得する．
      idParam = rundata.getParameters().getString(TARGET_GROUP_NAME);
    }
    target_group_name = ALEipUtils.getTemp(rundata, context, TARGET_GROUP_NAME);

    if (idParam == null && target_group_name == null) {
      ALEipUtils.setTemp(rundata, context, TARGET_GROUP_NAME, "only");
      target_group_name = "only";
    } else if (idParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_GROUP_NAME, idParam);
      target_group_name = idParam;
    }

//    if ((target_group_name == null)
//      || (target_group_name.equals(""))
//      || (target_group_name.equals("all"))
//      || (target_group_name.equals("only"))) {
//      Map<Integer, ALEipPost> map = getPostMap();
//      if (map != null && map.size() > 0) {
//        for (Integer key : map.keySet()) {
//          target_group_name = map.get(key).getGroupName().toString();
//        }
//      }
//    }

    return target_group_name;
  }
  /**
   * 表示切り替えで指定した集計期間をセッションに格納
   *
   * @param rundata
   * @param context
   * @return
   */
  private void setTargetYear(RunData rundata, Context context) {
    String target_start_year = null;
    String target_start_month = null;
    String target_end_year = null;
    String target_end_month = null;
    String syParam = null;
    String smParam = null;
    String eyParam = null;
    String emParam = null;
    if (ALEipUtils.isMatch(rundata, context)) {
      // 自ポートレットへのリクエストの場合に，グループ名を取得する．
      syParam = rundata.getParameters().getString(TARGET_START_YEAR);
      smParam = rundata.getParameters().getString(TARGET_START_MONTH);
      eyParam = rundata.getParameters().getString(TARGET_END_YEAR);
      emParam = rundata.getParameters().getString(TARGET_END_MONTH);
    }
    target_start_year = ALEipUtils.getTemp(rundata, context, TARGET_START_YEAR);
    target_start_month = ALEipUtils.getTemp(rundata, context, TARGET_START_MONTH);
    target_end_year = ALEipUtils.getTemp(rundata, context, TARGET_END_YEAR);
    target_end_month = ALEipUtils.getTemp(rundata, context, TARGET_END_MONTH);

    if (syParam == null && target_start_year == null) {
      ALEipUtils.setTemp(rundata, context, TARGET_START_YEAR, "none");
      target_start_year = "none";
    } else if (syParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_START_YEAR, syParam);
      target_start_year = syParam;
    }
    if (smParam == null && target_start_month == null) {
      ALEipUtils.setTemp(rundata, context, TARGET_START_MONTH, "none");
      target_start_month = "none";
    } else if (smParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_START_MONTH, smParam);
      target_start_month = smParam;
    }
    if (eyParam == null && target_end_year == null) {
      ALEipUtils.setTemp(rundata, context, TARGET_END_YEAR, "none");
      target_end_year = "none";
    } else if (eyParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_END_YEAR, eyParam);
      target_end_year = eyParam;
    }
    if (emParam == null && target_end_month == null) {
      ALEipUtils.setTemp(rundata, context, TARGET_END_MONTH, "none");
      target_end_month = "none";
    } else if (emParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_END_MONTH, emParam);
      target_end_month = emParam;
    }

    this.target_start_year = target_start_year;
    this.target_start_month = target_start_month;
    this.target_end_year = target_end_year;
    this.target_end_month = target_end_month;
  }
//	  /**
//	   * 表示切り替えで指定したグループ ID を取得する．
//	   *
//	   * @param rundata
//	   * @param context
//	   * @return
//	   */
//	  private String getTargetGroupName(RunData rundata, Context context) {
//	    String target_group_name = null;
//	    String idParam = null;
//	    if (ALEipUtils.isMatch(rundata, context)) {
//	      // 自ポートレットへのリクエストの場合に，グループ名を取得する．
//	      idParam =
//	        rundata.getParameters().getString(TARGET_GROUP_NAME);
//	    }
//	    target_group_name =
//	      ALEipUtils.getTemp(rundata, context, TARGET_GROUP_NAME);
//
//	    if (idParam == null && target_group_name == null) {
//	      ALEipUtils.setTemp(
//	        rundata,
//	        context,
//	        TARGET_GROUP_NAME,
//	        "all");
//	      target_group_name = "all";
//	    } else if (idParam != null) {
//	      ALEipUtils.setTemp(
//	        rundata,
//	        context,
//	        TARGET_GROUP_NAME,
//	        idParam);
//	      target_group_name = idParam;
//	    }
//
//	    return target_group_name;
//	  }

	  /**
	   * 表示切り替え時に指定するグループ名
	   *
	   * @return
	   */
	  public String getTargetGroupName() {
	    return target_group_name;
	  }
    /**
     * 表示切り替え時に指定する集計期間
     *
     * @return
     */
    public String getTargetStartYear() {
      return target_start_year;
    }
    /**
     * 表示切り替え時に指定する集計期間
     *
     * @return
     */
    public String getTargetStartMonth() {
      return target_start_month;
    }
    /**
     * 表示切り替え時に指定する集計期間
     *
     * @return
     */
    public String getTargetEndYear() {
      return target_end_year;
    }
    /**
     * 表示切り替え時に指定する集計期間
     *
     * @return
     */
    public String getTargetEndMonth() {
      return target_end_month;
    }

	  /**
	   * 表示切り替えで指定したユーザ ID を取得する．
	   *
	   * @param rundata
	   * @param context
	   * @return
	   */
	  private String getTargetUserId(RunData rundata, Context context) {
	    String target_user_id = null;
	    String idParam = null;
	    if (ALEipUtils.isMatch(rundata, context)) {
	      // 自ポートレットへのリクエストの場合に，ユーザ ID を取得する．
	      idParam = rundata.getParameters().getString(TARGET_USER_ID);
	    }
	    target_user_id = ALEipUtils.getTemp(rundata, context, TARGET_USER_ID);

	    if (idParam == null && (target_user_id == null)) {
	      // ログインユーザのスケジュールを表示するため，ログイン ID を設定する．
	      ALEipUtils.setTemp(rundata, context, TARGET_USER_ID, userid);
	      target_user_id = userid;
	    } else if (idParam != null) {
	      if (idParam.equals("none")) {
	        // グループで表示を切り替えた場合，
	        // ログインユーザもしくはユーザリストの一番初めのユーザを
	        // 表示するため，ユーザ ID を設定する．
	        ALEipUser eipUser = null;
	        boolean found = false;
	        int length = userList.size();
	        for (int i = 0; i < length; i++) {
	          eipUser = userList.get(i);
	          String eipUserId = eipUser.getUserId().getValueAsString();
	          if (userid.equals(eipUserId)) {
	            ALEipUtils.setTemp(rundata, context, TARGET_USER_ID, userid);
	            target_user_id = userid;
	            found = true;
	            break;
	          }
	        }
	        if (!found) {
	          eipUser = userList.get(0);
	          String userId = eipUser.getUserId().getValueAsString();
	          ALEipUtils.setTemp(rundata, context, TARGET_USER_ID, userId);
	          target_user_id = userId;
	        }
	      } else {
	        // ユーザで表示を切り替えた場合，指定したユーザの ID を設定する．
	        ALEipUtils.setTemp(rundata, context, TARGET_USER_ID, idParam);
	        target_user_id = idParam;
	      }
	    }
	    return target_user_id;
	  }

	  /**
	   * 表示切り替え時に指定するユーザ ID
	   *
	   * @return
	   */
	  public String getTargetUserId() {
	    return target_user_id;
	  }

  /**
   * 登録ユーザー数を取得する．
   *
   * @return
   */
  public int getRegisteredUserNum() {
    return registeredUserNum;
  }

  public int getRandomNum() {
    SecureRandom random = new SecureRandom();
    return (random.nextInt() * 100);
  }

  public boolean isAdminFiltered() {
    return adminFilter;
  }

  /**
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return ALAccessControlConstants.POERTLET_FEATURE_ADDRESSBOOK_ADDRESS_INSIDE;
  }

  /**
   * 管理者用のメニュー表示権限
   *
   * @return
   */
  public boolean hasAclMenuAdmin() {
    return hasAclMenuAdmin;
  }

  public ALStringField getCurrentTab() {
    return tab;
  }

/**
 * @return mode
 */
public String getMode() {
	return mode;
}

/**
 * @param mode セットする mode
 */
public void setMode(String mode) {
	this.mode = mode;
}

/**
 * 管理者用のメニュー表示権限
 *
 * @return
 */
public boolean hasAclMenuView() {
  return hasAclMenuView;
}

public int getYear() {
  Calendar now = Calendar.getInstance();
  return now.get(Calendar.YEAR);
}
}
