/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.improveope;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.OriMPoint;
import com.aimluck.eip.cayenne.om.portlet.OriTPointHistory;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;

/**
 * タイムカード検索データを管理するクラスです。 <BR>
 *
 */
public class ImproveopePointSelectData extends
	ALAbstractSelectData<OriTPointHistory, OriTPointHistory> implements ALData {


  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ImproveopePointSelectData.class.getName());

  /** <code>target_group_name</code> 表示対象の部署名 */
  private String target_group_name;

  /** <code>target_user_id</code> 表示対象のユーザ ID */
  private String target_user_id;

  /** <code>target_start_year</code> 表示対象の開始年 */
  private String target_start_year;
  /** <code>target_start_month</code> 表示対象の開始月 */
  private String target_start_month;
  /** <code>target_end_year</code> 表示対象の終了年 */
  private String target_end_year;
  /** <code>target_end_month</code> 表示対象の終了月 */
  private String target_end_month;


  /** <code>myGroupList</code> グループリスト（My グループと部署） */
  private List<ALEipGroup> myGroupList = null;

  /** <code>userList</code> 表示切り替え用のユーザリスト */
  private List<ALEipUser> userList = null;

  /** <code>userid</code> ユーザーID */
  private String userid;

  /** 集計日付 */
  // private ALDateTimeField viewMonth;
  private String nowtime;

  /** アクセス権限の機能名 */
  private String aclPortletFeature = null;

  /** 閲覧権限の有無（集計画面） */
  private boolean hasAclSummaryOther;

  /** 全社員の承認権限の有無（集計画面） */
  private boolean hasAclSummaryAdmin;

  /** 閲覧権限の有無（タイムカード外部出力） */
  private boolean hasAclXlsExport;

  private boolean hasAclMenuAdmin;
  private boolean hasAclMenuView;

  /** <code>viewMonth</code> 現在の月 */
  private ALDateTimeField viewMonth;

  /** <code>viewMonth</code> 現在の月 */
  private ALDateTimeField tmpViewMonth;// test

  /** <code>prevMonth</code> 前の月 */
  private ALDateTimeField prevMonth;

  /** <code>nextMonth</code> 次の月 */
  private ALDateTimeField nextMonth;

  /** <code>currentMonth</code> 今月 */
  private ALDateTimeField currentMonth;

  /** <code>today</code> 今日 */
  private ALDateTimeField today;

  /** <code>viewStart</code> 表示開始日時 */
  private ALDateTimeField viewStart;

  /** <code>viewEnd</code> 表示終了日時 */
  private ALDateTimeField viewEnd;

  /** <code>viewEndCrt</code> 表示終了日時 (Criteria) */
  private ALDateTimeField viewEndCrt;

  /** <code>viewTodo</code> ToDo 表示設定 */
  protected int viewTodo;

  public String mode = "point";

  /** <code>TARGET_START_YEAR</code> 集計期間による表示切り替え用変数の識別子 */
  private final String TARGET_START_YEAR = "target_start_year";
  /** <code>TARGET_START_MONTH</code> 集計期間による表示切り替え用変数の識別子 */
  private final String TARGET_START_MONTH = "target_start_month";
  /** <code>TARGET_END_YEAR</code> 集計期間による表示切り替え用変数の識別子 */
  private final String TARGET_END_YEAR = "target_end_year";
  /** <code>TARGET_END_MONTH</code> 集計期間による表示切り替え用変数の識別子 */
  private final String TARGET_END_MONTH = "target_end_month";


  /** 開始日 */
  private int startDay;

  /**
   *
   * @param action
   * @param rundata
   * @param context
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    // POST/GET から yyyy-MM の形式で受け渡される。
    // 現在の月
    tmpViewMonth = new ALDateTimeField("yyyy-MM");
    tmpViewMonth.setNotNull(true);
    // 現在の月
    viewMonth = new ALDateTimeField("yyyy-MM");
    viewMonth.setNotNull(true);
    // 前の月
    prevMonth = new ALDateTimeField("yyyy-MM");
    // 次の月
    nextMonth = new ALDateTimeField("yyyy-MM");
    // 今月
    currentMonth = new ALDateTimeField("yyyy-MM");
    // 表示開始日時
    viewStart = new ALDateTimeField("yyyy-MM-dd");
    // 表示終了日時
    viewEnd = new ALDateTimeField("yyyy-MM-dd");
    // 表示終了日時 (Criteria)
    viewEndCrt = new ALDateTimeField("yyyy-MM-dd");
    // 今日
    today = new ALDateTimeField("yyyy-MM-dd");

    startDay = 1;

    // 自ポートレットからのリクエストであれば、パラメータを展開しセッションに保存する。
    if (ALEipUtils.isMatch(rundata, context)) {
      // スケジュールの表示開始日時
      // e.g. 2004-3-14
      if (rundata.getParameters().containsKey("view_month")) {
        ALEipUtils.setTemp(rundata, context, "view_month", rundata
          .getParameters()
          .getString("view_month"));
      }
    }

    // ログインユーザの ID を設定する．
    userid = Integer.toString(ALEipUtils.getUserId(rundata));

    // My グループの一覧を取得する．
    List<ALEipGroup> myGroups = ALEipUtils.getMyGroups(rundata);
    myGroupList = new ArrayList<ALEipGroup>();
    int length = myGroups.size();
    for (int i = 0; i < length; i++) {
      myGroupList.add(myGroups.get(i));
    }

    // 表示期間をセッションにセット
    setTargetYear(rundata, context);
    // 指定グループや指定ユーザをセッションに設定する．
    //setupLists(rundata, context);

    // アクセス権
    ALAccessControlFactoryService aclservice =
      (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
        .getInstance()).getService(ALAccessControlFactoryService.SERVICE_NAME);
    ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();

    hasAclMenuAdmin =
  	      aclhandler.hasAuthority(
  	        ALEipUtils.getUserId(rundata),
  	        ALAccessControlConstants.POERTLET_FEATURE_IMPROVEOPE_ADMIN,
  	        ALAccessControlConstants.VALUE_ACL_UPDATE);

      hasAclMenuView =
    	      aclhandler.hasAuthority(
    	        ALEipUtils.getUserId(rundata),
    	        ALAccessControlConstants.POERTLET_FEATURE_IMPROVEOPE_ADMIN,
    	        ALAccessControlConstants.VALUE_ACL_LIST);

    // アクセス権
//    ALAccessControlFactoryService aclservice =
//      (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
//        .getInstance()).getService(ALAccessControlFactoryService.SERVICE_NAME);
//    ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
//    hasAclSummaryAdmin =
//    	      aclhandler.hasAuthority(
//    	        ALEipUtils.getUserId(rundata),
//    	        ALAccessControlConstants.POERTLET_FEATURE_TIMECARD_TIMECARD_ADMIN,
//    	        ALAccessControlConstants.VALUE_ACL_LIST);
//    hasAclSummaryOther =
//    	      aclhandler.hasAuthority(
//    	        ALEipUtils.getUserId(rundata),
//    	        ALAccessControlConstants.POERTLET_FEATURE_TIMECARD_TIMECARD_OTHER,
//    	        ALAccessControlConstants.VALUE_ACL_LIST);
//    if (target_user_id == null
//    	      || "".equals(target_user_id)
//    	      || userid.equals(target_user_id)) {
//      aclPortletFeature =
//        ALAccessControlConstants.POERTLET_FEATURE_TIMECARD_TIMECARD_SELF;
//    } else {
//    	if (hasAclSummaryAdmin) {
//	      aclPortletFeature =
//    	        ALAccessControlConstants.POERTLET_FEATURE_TIMECARD_TIMECARD_ADMIN;
//    	} else {
//  	      aclPortletFeature =
//    	        ALAccessControlConstants.POERTLET_FEATURE_TIMECARD_TIMECARD_OTHER;
//    	}
//    }
//    if (!hasAclSummaryOther && !hasAclSummaryAdmin) {
//      // 他ユーザーの閲覧権限がないときには、ログインユーザーのIDに変更する。
//      target_user_id = userid;
//      aclPortletFeature =
//        ALAccessControlConstants.POERTLET_FEATURE_TIMECARD_TIMECARD_SELF;
//    }
//
//    hasAclXlsExport =
//      aclhandler.hasAuthority(
//        ALEipUtils.getUserId(rundata),
//        aclPortletFeature,
//        ALAccessControlConstants.VALUE_ACL_EXPORT);

    // 今日の日付
    Calendar to = Calendar.getInstance();
    to.set(Calendar.HOUR_OF_DAY, 0);
    to.set(Calendar.MINUTE, 0);
    today.setValue(to.getTime());
    // 現在の月
    String tmpViewMonth = ALEipUtils.getTemp(rundata, context, "view_month");
    if (tmpViewMonth == null || tmpViewMonth.equals("")) {
      Calendar cal = Calendar.getInstance();
      cal.set(Calendar.DATE, 1);
      cal.set(Calendar.HOUR_OF_DAY, 0);
      cal.set(Calendar.MINUTE, 0);
      if (Integer.parseInt(today.getDay().toString()) < startDay) {
        cal.add(Calendar.MONTH, -1);
      }
      viewMonth.setValue(cal.getTime());
    } else {
      viewMonth.setValue(tmpViewMonth);
      if (!viewMonth.validate(new ArrayList<String>())) {
        ALEipUtils.removeTemp(rundata, context, "view_month");
        throw new ALPageNotFoundException();
      }
    }

    if (Integer.parseInt(today.getMonth()) == Integer.parseInt(viewMonth
      .getMonth()
      .toString()) - 1) {
      currentMonth.setValue(to.getTime());
    } else {
      Calendar tmp_cal = Calendar.getInstance();
      tmp_cal.set(Calendar.DATE, 1);
      tmp_cal.set(Calendar.HOUR_OF_DAY, 0);
      tmp_cal.set(Calendar.MINUTE, 0);
      if (Integer.parseInt(today.getDay().toString()) < startDay) {
        tmp_cal.add(Calendar.MONTH, -1);
      }
      currentMonth.setValue(tmp_cal.getTime());
    }

    // 表示開始日時
    Calendar cal = Calendar.getInstance();
    cal.set(Calendar.MONTH, Integer.parseInt(viewMonth.getMonth()) - 1);
    cal.set(Calendar.DATE, startDay);
    Date startDate = cal.getTime();
    viewStart.setValue(startDate);

    // 表示終了日時
    cal.add(Calendar.MONTH, 1);
    cal.add(Calendar.DATE, -1);
    Date endDate = cal.getTime();
    viewEnd.setValue(endDate);
    viewEndCrt.setValue(endDate);

    // 次の月、前の月
    Calendar cal2 = Calendar.getInstance();
    cal2.setTime(viewMonth.getValue());
    cal2.add(Calendar.MONTH, 1);
    nextMonth.setValue(cal2.getTime());
    cal2.add(Calendar.MONTH, -2);
    prevMonth.setValue(cal2.getTime());

    ALEipUtils.setTemp(rundata, context, "tmpStart", viewStart.toString()
      + "-00-00");
    ALEipUtils.setTemp(rundata, context, "tmpEnd", viewStart.toString()
      + "-00-00");

    super.init(action, rundata, context);
  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  private SelectQuery<OriTPointHistory> getSelectQuery(RunData rundata,
      Context context) {
    SelectQuery<OriTPointHistory> query = Database.query(OriTPointHistory.class);

    Expression exp =
    		ExpressionFactory.matchExp(OriTPointHistory.USER_ID_PROPERTY, userid);
    query.setQualifier(exp);



    Calendar cal1 = Calendar.getInstance();
    cal1.set(Calendar.YEAR, Integer.valueOf(target_start_year));
    cal1.set(Calendar.MONTH, Integer.valueOf(target_start_month)-1);
    cal1.set(Calendar.DATE, startDay);
    cal1.set(Calendar.HOUR_OF_DAY, 0);
    cal1.set(Calendar.MINUTE, 0);
    ALDateTimeField viewMonth_month = new ALDateTimeField("yyyy-MM-dd");
    viewMonth_month.setValue(cal1.getTime());

    // Calendar cal2 = Calendar.getInstance();
    Expression exp11 =
      ExpressionFactory.greaterOrEqualExp(
        OriTPointHistory.CREATE_DATE_PROPERTY,
        viewMonth_month.getValue());


    Calendar cal2 = Calendar.getInstance();
    cal2.set(Calendar.YEAR, Integer.valueOf(target_end_year));
    cal2.set(Calendar.MONTH, Integer.valueOf(target_end_month)-1);
    cal2.set(Calendar.DATE, startDay);
    cal2.set(Calendar.HOUR_OF_DAY, 0);
    cal2.set(Calendar.MINUTE, 0);
    cal2.add(Calendar.MONTH, +1);
    cal2.add(Calendar.MINUTE, -1);

    ALDateTimeField viewMonth_add_month = new ALDateTimeField("yyyy-MM-dd");
    viewMonth_add_month.setValue(cal2.getTime());

    Expression exp12 =
      ExpressionFactory.lessOrEqualExp(
        OriTPointHistory.CREATE_DATE_PROPERTY,
        viewMonth_add_month.getValue());
    query.andQualifier(exp11.andExp(exp12));

//    Calendar cal1 = Calendar.getInstance();
//    cal1.setTime(viewMonth.getValue());
//    cal1.set(Calendar.DATE, startDay);
//    cal1.set(Calendar.HOUR_OF_DAY, 0);
//    cal1.set(Calendar.MINUTE, 0);
//    ALDateTimeField viewMonth_month = new ALDateTimeField("yyyy-MM-dd");
//    viewMonth_month.setValue(cal1.getTime());
//
//    // Calendar cal2 = Calendar.getInstance();
//    Expression exp11 =
//      ExpressionFactory.greaterOrEqualExp(
//        OriTPointHistory.CREATE_DATE_PROPERTY,
//        viewMonth_month.getValue());
//
//    cal1.add(Calendar.MONTH, +1);
//    cal1.add(Calendar.MILLISECOND, -1);
//
//    ALDateTimeField viewMonth_add_month = new ALDateTimeField("yyyy-MM-dd");
//    viewMonth_add_month.setValue(cal1.getTime());
//
//    Expression exp12 =
//      ExpressionFactory.lessOrEqualExp(
//        OriTPointHistory.CREATE_DATE_PROPERTY,
//        viewMonth_add_month.getValue());
//    query.andQualifier(exp11.andExp(exp12));

    return buildSelectQueryForFilter(query, rundata, context);
  }

  /**
   * 一覧データを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  @Override
  public ResultList<OriTPointHistory> selectList(RunData rundata, Context context) {
    try {

        SelectQuery<OriTPointHistory> query = getSelectQuery(rundata, context);
        buildSelectQueryForListView(query);
        query.orderAscending(OriTPointHistory.CREATE_DATE_PROPERTY);

        return query.getResultList();

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * ResultData に値を格納して返します。（一覧データ） <BR>
   *
   * @param obj
   * @return
   */
  @Override
  protected Object getResultData(OriTPointHistory record) {
    try {

    	ImproveopeGrantResultData rd = new ImproveopeGrantResultData();
    	rd.initField();
    	// ID
    	rd.setId(record.getId());
    	// ユーザーID
    	rd.setUserId(record.getUserId());
    	// ポイントID
    	rd.setPointId(record.getPointId());
    	// ポイント数
    	rd.setPoint(record.getPoint().toString());
    	// ポイント名
    	rd.setPostName(getpointName(record.getPointId().intValue()));
    	// ポイント付与者ID
    	rd.setCreateUserId(record.getCreateUserId());
    	// ポイント付与者名
    	rd.setCreateUserName(ALEipUtils.getUserFullName(record.getCreateUserId()).toString());
    	// 付与日時
    	rd.setCreateDate(record.getCreateDate());

    	return rd;

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  private String getpointName(Integer pointId) {
	  try {

		  SelectQuery<OriMPoint> query = Database.query(OriMPoint.class);

		  Expression exp =
				  ExpressionFactory.matchDbExp(OriMPoint.POINT_ID_PK_COLUMN, pointId);
		  query.setQualifier(exp);

		  List<OriMPoint> pointMst = query.fetchList();

		  if (pointMst == null || pointMst.size() <= 0) {
			  return null;
		  }

		  return pointMst.get(0).getPointName().toString();

	  } catch (Exception ex) {
	      logger.error("Exception", ex);
	      return null;
	  }
  }

  /**
   * 指定した2つの日付を比較する．
   *
   * @param date1
   * @param date2
   * @param checkTime
   *          時間まで比較する場合，true．
   * @return 等しい場合，0. date1>date2の場合, 1. date1 <date2の場合, 2.
   */
  @SuppressWarnings("unused")
  private boolean sameDay(Date date1, Date date2) {
    Calendar cal1 = Calendar.getInstance();
    Calendar cal2 = Calendar.getInstance();
    cal1.setTime(date1);
    cal2.setTime(date2);

    int date1Year = cal1.get(Calendar.YEAR);
    int date1Month = cal1.get(Calendar.MONTH) + 1;
    int date1Day = cal1.get(Calendar.DATE);
    int date2Year = cal2.get(Calendar.YEAR);
    int date2Month = cal2.get(Calendar.MONTH) + 1;
    int date2Day = cal2.get(Calendar.DATE);

    if (date1Year == date2Year
      && date1Month == date2Month
      && date1Day == date2Day) {
      return true;
    }
    return false;
  }

  /**
   * 検索条件を設定した Criteria を返します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  private SelectQuery<OriTPointHistory> getSelectQueryDetail(RunData rundata,
      Context context) {
	  return null;
  }



  /**
   * 詳細データを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  @Override
  public OriTPointHistory selectDetail(RunData rundata, Context context) {
      return null;
  }

  /**
   * ResultData に値を格納して返します。（詳細データ） <BR>
   *
   * @param obj
   * @return
   */
  @Override
  protected Object getResultDataDetail(OriTPointHistory record) {
      return null;
  }


  /**
   * 表示切り替えで指定した集計期間をセッションに格納
   *
   * @param rundata
   * @param context
   * @return
   */
  private void setTargetYear(RunData rundata, Context context) {
    String target_start_year = null;
    String target_start_month = null;
    String target_end_year = null;
    String target_end_month = null;
    String syParam = null;
    String smParam = null;
    String eyParam = null;
    String emParam = null;
    if (ALEipUtils.isMatch(rundata, context)) {
      // 自ポートレットへのリクエストの場合に，グループ名を取得する．
      syParam = rundata.getParameters().getString(TARGET_START_YEAR);
      smParam = rundata.getParameters().getString(TARGET_START_MONTH);
      eyParam = rundata.getParameters().getString(TARGET_END_YEAR);
      emParam = rundata.getParameters().getString(TARGET_END_MONTH);
    }
    target_start_year = ALEipUtils.getTemp(rundata, context, TARGET_START_YEAR);
    target_start_month = ALEipUtils.getTemp(rundata, context, TARGET_START_MONTH);
    target_end_year = ALEipUtils.getTemp(rundata, context, TARGET_END_YEAR);
    target_end_month = ALEipUtils.getTemp(rundata, context, TARGET_END_MONTH);

    if (syParam == null && target_start_year == null) {
      ALEipUtils.setTemp(rundata, context, TARGET_START_YEAR, String.valueOf(getYear()));
      target_start_year = String.valueOf(getYear());
    } else if (syParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_START_YEAR, syParam);
      target_start_year = syParam;
    }
    if (smParam == null && target_start_month == null) {
      ALEipUtils.setTemp(rundata, context, TARGET_START_MONTH, String.valueOf(getMonth()));
      target_start_month = String.valueOf(getMonth());
    } else if (smParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_START_MONTH, smParam);
      target_start_month = smParam;
    }
    if (eyParam == null && target_end_year == null) {
      ALEipUtils.setTemp(rundata, context, TARGET_END_YEAR, String.valueOf(getYear()));
      target_end_year = String.valueOf(getYear());
    } else if (eyParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_END_YEAR, eyParam);
      target_end_year = eyParam;
    }
    if (emParam == null && target_end_month == null) {
      ALEipUtils.setTemp(rundata, context, TARGET_END_MONTH, String.valueOf(getMonth()));
      target_end_month = String.valueOf(getMonth());
    } else if (emParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_END_MONTH, emParam);
      target_end_month = emParam;
    }

    this.target_start_year = target_start_year;
    this.target_start_month = target_start_month;
    this.target_end_year = target_end_year;
    this.target_end_month = target_end_month;
  }
  /**
   * 表示切り替え時に指定するグループ名
   *
   * @return
   */
  public String getTargetGroupName() {
    return target_group_name;
  }

  /**
   * 表示切り替え時に指定するユーザ ID
   *
   * @return
   */
  public String getTargetUserId() {
    return target_user_id;
  }

  /**
   * 指定グループに属するユーザの一覧を取得する．
   *
   * @param groupname
   * @return
   */
  public List<ALEipUser> getUsers() {
	if (hasAclSummaryAdmin) {
		// すべてのユーザー
      return userList;
	} else if (hasAclSummaryOther) {
		// 自分の所属する部署のユーザーのみ
	      List<Integer> list =
	    	        ALEipUtils.getPostIdList(Integer.valueOf(this.userid));
	      Map<Integer, ALEipPost> map = ALEipManager.getInstance().getPostMap();
	      for (Integer i : list) {
	          String groupName = map.get(i).getGroupName().toString();
	          userList = ALEipUtils.getUsers(groupName);
          }

      return userList;
    } else {
      try {
        List<ALEipUser> users = new ArrayList<ALEipUser>();
        users.add(ALEipUtils.getALEipUser(Integer.parseInt(userid)));
        return users;
      } catch (Exception e) {
        return null;
      }
    }
  }

  /**
   * 部署の一覧を取得する．
   *
   * @return
   */
  public Map<Integer, ALEipPost> getPostMap() {
	if (hasAclSummaryAdmin) {
      Map<Integer, ALEipPost> map = ALEipManager.getInstance().getPostMap();
      return map;
	} else if (hasAclSummaryOther) {
      // 自分が所属する部署のIDリスト
      List<Integer> list =
        ALEipUtils.getPostIdList(Integer.valueOf(this.userid));
      // すべての部署リスト
      Map<Integer, ALEipPost> map = ALEipManager.getInstance().getPostMap();
      Map<Integer, ALEipPost> tmp = new LinkedHashMap<Integer, ALEipPost>();
      for (Integer i : list) {
        tmp.put(i, map.get(i));
      }
      return tmp;
    } else {
      return null;
    }
  }

  /**
   * My グループの一覧を取得する．
   *
   * @return
   */
  public List<ALEipGroup> getMyGroupList() {
    if (hasAclSummaryOther || hasAclSummaryAdmin) {
      return myGroupList;
    } else {
      return null;
    }
  }

  /**
   * ログインユーザの ID を取得する．
   *
   * @return
   */
  public String getUserId() {
    return userid;
  }

  /**
   * @return
   *
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    return map;
  }

  /**
   *
   * @param id
   * @return
   */
  public boolean isMatch(int id1, long id2) {
    return id1 == (int) id2;
  }

  /**
   * @return
   */
  public ALDateTimeField getViewDate() {
    return viewMonth;
  }

  public String getNowTime() {
    return nowtime;
  }


  /**
   * 表示開始日時を取得します。
   *
   * @return
   */
  public ALDateTimeField getViewStart() {
    return viewStart;
  }

  /**
   * 表示終了日時を取得します。
   *
   * @return
   */
  public ALDateTimeField getViewEnd() {
    return viewEnd;
  }

  /**
   * 表示終了日時 (Criteria) を取得します。
   *
   * @return
   */
  public ALDateTimeField getViewEndCrt() {
    return viewEndCrt;
  }

  /**
   * 前の月を取得します。
   *
   * @return
   */
  public ALDateTimeField getPrevMonth() {
    return prevMonth;
  }

  /**
   * 次の月を取得します。
   *
   * @return
   */
  public ALDateTimeField getNextMonth() {
    return nextMonth;
  }

  /**
   * 今月を取得します。
   *
   * @return
   */
  public ALDateTimeField getCurrentMonth() {
    return currentMonth;
  }

  /**
   * 現在の月を取得します。
   *
   * @return
   */
  public ALDateTimeField getViewMonth() {
    return viewMonth;
  }

  /**
   * 今日を取得します。
   *
   * @return
   */
  public ALDateTimeField getToday() {
    return today;
  }


  public String getMode() {
    return mode;
  }

  /**
 * @param mode セットする mode
 */
public void setMode(String mode) {
	this.mode = mode;
}

/**
   * @param tmpViewMonth
   *          セットする tmpViewMonth
   */
  public void setTmpViewMonth(ALDateTimeField tmpViewMonth) {
    this.tmpViewMonth = tmpViewMonth;
  }

  /**
   * @return tmpViewMonth
   */
  public ALDateTimeField getTmpViewMonth() {
    return tmpViewMonth;
  }

  /**
   * 表示切り替え時に指定する集計期間
   *
   * @return
   */
  public String getTargetStartYear() {
    return target_start_year;
  }
  /**
   * 表示切り替え時に指定する集計期間
   *
   * @return
   */
  public String getTargetStartMonth() {
    return target_start_month;
  }
  /**
   * 表示切り替え時に指定する集計期間
   *
   * @return
   */
  public String getTargetEndYear() {
    return target_end_year;
  }
  /**
   * 表示切り替え時に指定する集計期間
   *
   * @return
   */
  public String getTargetEndMonth() {
    return target_end_month;
  }

  /**
   * タイムカードの承認権限があるか
   *
   * @return
   */
  public boolean getHasAclSummaryOther() {
    return this.hasAclSummaryOther;
  }

  /**
   * タイムカードの全社員の承認権限があるか
   *
   * @return
   */
  public boolean getHasAclSummaryAdmin() {
    return this.hasAclSummaryAdmin;
  }

/**
 * @return sumPoint
 */
public Integer getSumPoint() {
	Integer sumPoint = 0;
	try {
		SelectQuery<OriTPointHistory> query = Database.query(OriTPointHistory.class);
		Expression exp =
				ExpressionFactory.matchExp(OriTPointHistory.USER_ID_PROPERTY, Integer.valueOf(userid));
		query.setQualifier(exp);

		List<OriTPointHistory> pointList = query.fetchList();

		if (pointList == null || pointList.size() <= 0) {
			return 0;
		}

		for (int i = 0; i < pointList.size(); i++) {
			sumPoint += pointList.get(i).getPoint().intValue();
		}
		return sumPoint;

	} catch (Exception ex) {
	   logger.error("Exception", ex);
	   return 0;
	}
}
/**
 * @return sumPoint
 */
public Integer getSumViewPoint() {
  Integer sumPoint = 0;
  try {
    SelectQuery<OriTPointHistory> query = Database.query(OriTPointHistory.class);
    Expression exp =
        ExpressionFactory.matchExp(OriTPointHistory.USER_ID_PROPERTY, Integer.valueOf(userid));
    query.setQualifier(exp);

    Calendar cal1 = Calendar.getInstance();
    cal1.set(Calendar.YEAR, Integer.valueOf(target_start_year));
    cal1.set(Calendar.MONTH, Integer.valueOf(target_start_month)-1);
    cal1.set(Calendar.DATE, startDay);
    cal1.set(Calendar.HOUR_OF_DAY, 0);
    cal1.set(Calendar.MINUTE, 0);
    ALDateTimeField viewMonth_month = new ALDateTimeField("yyyy-MM-dd");
    viewMonth_month.setValue(cal1.getTime());

    // Calendar cal2 = Calendar.getInstance();
    Expression exp11 =
      ExpressionFactory.greaterOrEqualExp(
        OriTPointHistory.CREATE_DATE_PROPERTY,
        viewMonth_month.getValue());


    Calendar cal2 = Calendar.getInstance();
    cal2.set(Calendar.YEAR, Integer.valueOf(target_end_year));
    cal2.set(Calendar.MONTH, Integer.valueOf(target_end_month)-1);
    cal2.set(Calendar.DATE, startDay);
    cal2.set(Calendar.HOUR_OF_DAY, 0);
    cal2.set(Calendar.MINUTE, 0);
    cal2.add(Calendar.MONTH, +1);
    cal2.add(Calendar.MINUTE, -1);

    ALDateTimeField viewMonth_add_month = new ALDateTimeField("yyyy-MM-dd");
    viewMonth_add_month.setValue(cal2.getTime());

    Expression exp12 =
      ExpressionFactory.lessOrEqualExp(
        OriTPointHistory.CREATE_DATE_PROPERTY,
        viewMonth_add_month.getValue());
    query.andQualifier(exp11.andExp(exp12));


    List<OriTPointHistory> pointList = query.fetchList();

    if (pointList == null || pointList.size() <= 0) {
      return 0;
    }

    for (int i = 0; i < pointList.size(); i++) {
      sumPoint += pointList.get(i).getPoint().intValue();
    }
    return sumPoint;

  } catch (Exception ex) {
     logger.error("Exception", ex);
     return 0;
  }
}
/**
 * 管理者用のメニュー表示権限
 *
 * @return
 */
public boolean hasAclMenuAdmin() {
  return hasAclMenuAdmin;
}
/**
 * 管理者用のメニュー表示権限
 *
 * @return
 */
public boolean hasAclMenuView() {
  return hasAclMenuView;
}

public int getYear() {
  Calendar now = Calendar.getInstance();
  return now.get(Calendar.YEAR);
}
public int getMonth() {
  Calendar now = Calendar.getInstance();
  return now.get(Calendar.MONTH) + 1;
}
}
