/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.improveope.ImproveopeActionSelectData;
import com.aimluck.eip.improveope.ImproveopeReportFormData;

/**
 * 実施要項作成を処理するクラスです。
 *
 */

public class ImproveopeReportDetailScreen extends ImproveopeReportFormScreen {

  protected void doImproveope_form(RunData rundata, Context context) {
	ImproveopeActionSelectData detailData = new ImproveopeActionSelectData();
	detailData.initField();
	detailData.doViewDetail(this, rundata, context);

	ImproveopeReportFormData formData = new ImproveopeReportFormData();
    formData.initField();
    formData.doViewForm(this, rundata, context);


    String layout_template = "portlets/html/ja/ajax-improveope-report-detail.vm";
    setTemplate(rundata, context, layout_template);
  }
}
