/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.List;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeTopic;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeFile;


import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.improveope.util.ImproveopeUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 掲示板トピックの添付ファイルの一覧を処理するクラスです。
 */
public class ImproveopeTopicFileRawScreen extends FileuploadRawScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ImproveopeTopicFileRawScreen.class.getName());

  /**
   *
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata) throws Exception {
    try {
      doCheckAclPermission(
        rundata,
        ALAccessControlConstants.POERTLET_FEATURE_MSGBOARD_TOPIC_OTHER,
        ALAccessControlConstants.VALUE_ACL_LIST);
    } catch (ALPermissionException e) {
      try {
        doCheckAclPermission(
          rundata,
          ALAccessControlConstants.POERTLET_FEATURE_MSGBOARD_TOPIC,
          ALAccessControlConstants.VALUE_ACL_LIST);
      } catch (ALPermissionException ex) {
        throw new Exception();
      }
    }
    try {
      doCheckAclPermission(
        rundata,
        ALAccessControlConstants.POERTLET_FEATURE_MSGBOARD_CATEGORY_OTHER,
        ALAccessControlConstants.VALUE_ACL_LIST);
    } catch (ALPermissionException e) {
      try {
        doCheckAclPermission(
          rundata,
          ALAccessControlConstants.POERTLET_FEATURE_MSGBOARD_CATEGORY,
          ALAccessControlConstants.VALUE_ACL_LIST);
      } catch (ALPermissionException ex) {
        throw new Exception();
      }
    }
    try {
    	OriTImproveopeFile improveopefile =
        ImproveopeUtils.getOriTImproveopeFile(rundata);

      //doFileCheckView(rundata, improveopefile);

      super.setFilePath(ImproveopeUtils.getSaveDirPath(
        Database.getDomainName(),
        improveopefile.getOwnerId().intValue())
        + improveopefile.getFilePath());
      super.setFileName(improveopefile.getFileName());
      super.doOutput(rundata);
    } catch (ALPermissionException e) {
      throw new Exception();
    } catch (Exception e) {
      logger.error("[ERROR]", e);
    }
  }

//  private boolean doFileCheckView(RunData rundata, OriTImproveopeFile improveopefile)
//      throws ALPermissionException {
//    int userid = ALEipUtils.getUserId(rundata);
//    OriTImproveopeTopic improveopetopic = improveopefile.OriTImproveopeTopic();
//    EipTMsgboardCategory improveopecategory =
//      improveopetopic.getEipTMsgboardCategory();
//
//    if ("T".equals(improveopecategory.getPublicFlag())) {
//      return true;
//    } else {
//      @SuppressWarnings("unchecked")
//      List<EipTMsgboardCategoryMap> categoryMap =
//        improveopecategory.getEipTMsgboardCategoryMaps();
//      for (EipTMsgboardCategoryMap map : categoryMap) {
//        if (map.getUserId().intValue() == userid) {
//          return true;
//        }
//      }
//      throw new ALPermissionException();
//    }
//
//  }

}
