/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.lunchorder;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;


public class LunchOrderMapInputFormResultData {
  
  /**弁当ＩＤ*/
  private ALNumberField itemId;
  
  /** 商品（弁当）名 */
  private ALStringField itemName;

  /** 価格 */
   private ALNumberField itemPrice;

  /** コメント */
  private ALStringField itemComment;

  /**最低注文数に含めるか含めないかの判断用フラグ*/
  private ALNumberField itemMinOrderFlag;

  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    itemId = new ALNumberField();
    itemName = new ALStringField();
    itemPrice = new ALNumberField();
    itemComment = new ALStringField();
    itemMinOrderFlag = new ALNumberField();
  }
  
  /**
   * @return
   */
  public ALNumberField getItemId() {
    return itemId;
  }

  /**
   * @param i
   */
  public void setItemId(int i) {
    itemId.setValue(i);
  }

  public ALStringField getItemName() {
    return itemName;
  }

  public void setItemName(String string) {
    itemName.setValue(string);
  }

  /**
   * @return
   */
  public ALNumberField getItemPrice() {
    return itemPrice;
  }

  /**
   * @param i
   */
  public void setItemPrice(int i) {
    itemPrice.setValue(i);
  }

  /**
   * @return
   */
  public ALStringField getItemComment() {
    return itemComment;
  }

  /**
   * @param string
   */
  public void setItemComment(String string) {
    itemComment.setValue(string);
  }

  /**
   * @return
   */
  public ALNumberField getItemMinOrderFlag() {
    return itemMinOrderFlag;
  }

  /**
   * @param i
   */
  public void setItemMinOrderFlag(int i) {
    itemMinOrderFlag.setValue(i);
  }

}