/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.opinionbox;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 目安箱のResultDataです。 <BR>
 *
 */
public class OpinionBoxResultData implements ALData {

  /** OpinionBox ID */
  protected ALNumberField opinionbox_id;

  /** 報告書名 */
  protected ALStringField opinionbox_name;

  /** 親 報告書 ID */
  private ALNumberField parent_id;

  /** 登録日 */
  private ALDateTimeField create_date;

  /** 登録日 */
  protected ALDateTimeField createDate;

  /** 更新日時 */
  private ALDateTimeField updateDate;

  /** 登録者Id */
  protected ALNumberField client_id;

  /** 登録者名 */
  protected ALStringField client_name;

  /** 通知先 */
  private List<ALEipUser> mapList = null;

  /** 匿名フラグ */
  private ALNumberField tokumei_flg;

  private boolean is_self_opinionbox;

  /** <code>statusList</code> メンバーの状態 */
  private Map<Integer, String> statusList;

  /**
   *
   *
   */
  @Override
  public void initField() {
    opinionbox_id = new ALNumberField();
    tokumei_flg = new ALNumberField();
    opinionbox_name = new ALStringField();
    create_date = new ALDateTimeField();
    parent_id = new ALNumberField();

    updateDate = new ALDateTimeField();
    createDate = new ALDateTimeField();
    client_name = new ALStringField();
    client_id = new ALNumberField();

    mapList = new ArrayList<ALEipUser>();
    is_self_opinionbox = false;
    statusList = new HashMap<Integer, String>();
  }

  /**
   * @return
   */
  public ALNumberField getOpinionId() {
    return opinionbox_id;
  }

  /**
   * @return
   */
  public String getOpinionBoxName() {
    return ALCommonUtils.replaceToAutoCR(opinionbox_name.toString());
  }

  /**
   * @param i
   */
  public void setOpinionId(long i) {
    opinionbox_id.setValue(i);
  }

  /**
   * @param string
   */
  public void setOpinionBoxName(String string) {
    opinionbox_name.setValue(string);
  }

  /**
   * @param i
   */
  public void setParentId(long i) {
    parent_id.setValue(i);
  }

  /**
   * @param i
   */
  public ALNumberField getParentId() {
    return parent_id;
  }

  /**
   * @return
   */
  public ALDateTimeField getCreateDate() {
    return ALEipUtils.getFormattedTime(create_date);
  }

  /**
   * @return
   */
  public ALStringField getClientName() {
    return client_name;
  }

  /**
   * @param string
   */
  public void setClientName(String string) {
    client_name.setValue(string);
  }

  /**
   * @return
   */
  public ALNumberField getClientId() {
    return client_id;
  }

  /**
   * @param i
   */
  public void setClientId(long i) {
    client_id.setValue(i);
  }

  /**
   * @return list
   */
  public List<ALEipUser> getMapList() {
    return mapList;
  }

  /**
   * @param list
   */
  public void setMapList(List<ALEipUser> list) {
    mapList = list;
  }

  public ALDateTimeField getUpdateDateTime() {
    return ALEipUtils.getFormattedTime(updateDate);
  }

  public void setCreateDate(Date date) {
    if (date == null) {
      return;
    }
    this.createDate.setValue(date);
  }

  public ALDateTimeField getCreateDateTime() {
    return ALEipUtils.getFormattedTime(createDate);
  }

  public boolean isSelfOpinionBox() {
    return is_self_opinionbox;
  }

  public void setIsSelfOpinionBox(boolean is_self_opinionbox) {
    this.is_self_opinionbox = is_self_opinionbox;
  }

  /**
   * @param list
   */
  public void setStatusList(HashMap<Integer, String> map) {
    statusList = map;
  }

  public String getStatus(long id) {
    return statusList.get(Integer.valueOf((int) id));
  }

  /**
   * @return
   */
  public ALNumberField getTokumeiFlg() {
    return tokumei_flg;
  }

  /**
   * @param i
   */
  public void setTokumeiFlg(long i) {
    tokumei_flg.setValue(i);
  }

}
