/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.XmlDataSetWriter;
import org.dbunit.dataset.xml.XmlProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XmlDataSet
extends CachedDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)XmlDataSet.class);

    public XmlDataSet(Reader reader) throws DataSetException {
        super(new XmlProducer(new InputSource(reader)));
    }

    public XmlDataSet(InputStream in) throws DataSetException {
        super(new XmlProducer(new InputSource(in)));
    }

    public static void write(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        logger.debug("write(dataSet={}, out={}) - start", (Object)dataSet, (Object)out);
        XmlDataSet.write(dataSet, out, null);
    }

    public static void write(IDataSet dataSet, OutputStream out, String encoding) throws IOException, DataSetException {
        logger.debug("write(dataSet={}, out={}, encoding={}) - start", new Object[]{dataSet, out, encoding});
        XmlDataSetWriter datasetWriter = new XmlDataSetWriter(out, encoding);
        datasetWriter.write(dataSet);
    }

    public static void write(IDataSet dataSet, Writer writer) throws IOException, DataSetException {
        logger.debug("write(dataSet={}, writer={}) - start", (Object)dataSet, (Object)writer);
        XmlDataSet.write(dataSet, writer, null);
    }

    public static void write(IDataSet dataSet, Writer writer, String encoding) throws IOException, DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("write(dataSet={}, writer={}, encoding={}) - start", new Object[]{dataSet, writer, encoding});
        }
        XmlDataSetWriter datasetWriter = new XmlDataSetWriter(writer, encoding);
        datasetWriter.write(dataSet);
    }
}

