#!/bin/sh
# the next line restarts using wish \
exec wish "$0" "$@"

# testƂāF
#   PCł̎s
#   󔒂܂ރtH_ł̎s
# yCcύX͖ڐł̂݉\ɂƂB
# DIÕXs[hIvVςɂ
# ͈͎w̃AhDH
# ͈͎wN܂ŎcH
# maint@Cɍproc𐮗
# Ԏ̏kڂȒPɕύX
# F0c\@̕ύX
# ̃t@CĎƕ\B̌{ƍ̔rȂǁB̍ێԎ␳UIKvB
# e|ύXɑΉԎBʓ|B
# Nutau.exeT̍ۂɃWXg.ustɊ֘AtꂽAvutauƌȂB
# p
# ̎ڂƂ
#
# UTAUȊO
# - {JΉF
#   @^Cg̉XVȂB
#   @F0minAmaxust璊ołȂB
#   @{J̏kڂɍ킹@\Ho[WႢɑΉłȂBނ}EXhbOŎyɏkڂł悤ɂǂB
#
# setParamւ̗AoFF0Apow̃XbhBDIOAhbO̔S

#---------------------------------------------------
# Tu[`

#---------------------------------------------------
# Cʕ\Zbg
#
proc resetDisplay {{fname ""}} {
  global v t

  set v(recLab)  "temp"
  readWavFile $fname
  Redraw all
  setEPWTitle
}

#---------------------------------------------------
# ĎΏۂwavt@C擾
#
proc getWavFileName {} {
  global v t
 
  set fn [tk_getOpenFile -initialdir [file dirname $v(inWav)] -initialfile [file tail $v(inWav)] \
          -title $t(getWavFileName,title) -defaultextension "wav" \
          -filetypes { {{wav file} {.wav}} {{All Files} {*}} }]
  return $fn
}

#---------------------------------------------------
# [hŊĎΏwavt@CJ悤ɂ
#
proc openWavFile {fname} {
  global v t

  after cancel [after info]
  set v(inWav) $fname
  updateFileHistory
  set v(inWavMtimeSec) 0
  if {$v(reload) > 0} {
    autoReload
  } else {
    autoReload 1
  }
}

#---------------------------------------------------
# v(reload)bƂwavt@C̍XV`FbN
#
proc autoReload {{byhand 0}} {
  global v t power f0 snd fTool

  if {!$byhand && $v(reload) <= 0} return

  ;# XVtVȂĂȂ烊[h
  set mtime -1
  if {[file readable $v(inWav)]} {
    if {! [catch {set mtime [file mtime $v(inWav)]}]} {
      if {$mtime > $v(inWavMtimeSec) || $byhand} {
        set v(inWavMtimeSec) $mtime
        set v(inWavMtime) [clock format $mtime -format "%H:%M:%S"]
        set power(fid) ""  ;# p[Iɍĕ`悳
        set f0(fid)    ""  ;# F0Iɍĕ`悳
        if {!$byhand} {
          $fTool.mtimeU configure -fg #ff0000 -bg #f0f0f0
          $fTool.mtime  configure -fg #ff0000 -bg #f0f0f0
        }
        readTempBat
        resetDisplay
        update
      } else {
        $fTool.mtimeU configure -fg $v(fg) -bg $v(bg)
        $fTool.mtime  configure -fg $v(fg) -bg $v(bg)
      }
    } else {
      snd flush
    }
  } else {
    snd flush
    resetDisplay
  }

  if {!$byhand} {
    after [expr int($v(reload) * 1000)] autoReload
  }
}

#---------------------------------------------------
# UTAỦʂLv`1̉fA
# ƓkڂɂȂ悤v(wavepps)ݒ肷
#
proc autoSetTimeScale {} {
  global v topdir
  if {! [file executable "$topdir/tools/getBarLength.exe"]} return
  set barLengthPixel [exec "$topdir/tools/getBarLength.exe"]
  if {$barLengthPixel <= 0} return

  # UTAỦʂɍ킹ĕ␳
  switch $barLengthPixel {
    18 { set barLengthPixel 18.2666666666667 }
    21 { set barLengthPixel 21.3269230769231 }
    26 { set barLengthPixel 25.5909090909091 }
    43 { set barLengthPixel 42.6666666666667 }
  }

  changeWidth [expr - ($barLengthPixel * $v(bpm) / 60.0)] 0
  Redraw scale
}

#---------------------------------------------------
# temp.batǂŕKvȏo
#
proc readTempBat {} {
  global sv v f0 t

  set power(fid) ""  ;# p[Iɍĕ`悳
  set f0(fid)    ""  ;# F0Iɍĕ`悳

  ;# batt@C̏ꍇ̏l
  set f0(min) 80
  set f0(max) 1000
  set f0(fixShowRange) 0

  set tempBat [format "%s/temp.bat" [file dirname $v(inWav)]]
  if {! [file readable $tempBat]} return
  if [catch {open $tempBat r} in] return

  set f0(fixShowRange) 1
  set v(wavPre) 0
  set v(voice) ""
  set first 1
  set f0MaxSeq -1
  set f0MinSeq  100000
  set pbHighSeq 0
  set pbLowSeq  0
  while {![eof $in]} {
    set l [gets $in]

    if {[regexp {^(@|)set tempo=([0-9.]*)$} $l tmp tmp2 bpm]} {
      set v(bpm) $bpm
    } elseif {[regexp {^(@|)set oto=(.*)$} $l tmp tmp2 _voice]} {
      set data [split $l "\\"]
      set v(voice) [lindex $data end]
    } elseif {[regexp {%oto%\\R.wav} $l]} {
      # xȂ
      set first 0
    } elseif {[regexp {^(@|)set params=(.*)$} $l tmp tmp2 _params]} {
      # sb`xh̐ݒȂA̍őlEŏl߂
      set data [split $_params " "]
      if {[llength $data] < 4} {
        set pbHighSeq 0
        set pbLowSeq  0
      } else {
        set pbList [decodePitchBend [lindex $data 3]]
        set pbMin [getMin $pbList]   ;# P=cent
        set pbMax [getMax $pbList]   ;# P=cent
        if {[expr $pbMin % 100] == 0} {
          set pbLowSeq [expr int($pbMin / 100)]      ;# P=
        } elseif {$pbMin < 0} {
          set pbLowSeq [expr int($pbMin / 100)]      ;# P=
        } else {
          set pbLowSeq [expr int($pbMin / 100 + 1)]  ;# P=
        }
        if {[expr $pbMax % 100] == 0} {
          set pbHighSeq [expr int($pbMax / 100)]       ;# P=
        } elseif {$pbMax < 0} {
          set pbHighSeq [expr int($pbMax / 100)]       ;# P=
        } else {
          set pbHighSeq [expr int($pbMax / 100 + 1)]   ;# P=
        }
      }
    } elseif {[regexp {^(@|)call } $l]} {
      # Ȃ
      set data0 [split $l "\""]
      set data [split [string trim [lindex $data0 2]] " "]
      if {$first} {
        set v(wavPre) [lindex $data 2]
        set first 0
      }
      regexp {^([A-Z#]+)([0-9]+)$} [lindex $data 0] tmp tone octave
      set otoSeq [expr [lsearch $sv(toneList) $tone] + $octave * 12]
      if {[expr $otoSeq + $pbLowSeq] < $f0MinSeq} {
        set f0MinSeq [expr $otoSeq + $pbLowSeq]
      }
      if {[expr $otoSeq + $pbHighSeq] > $f0MaxSeq} {
        set f0MaxSeq [expr $otoSeq + $pbHighSeq]
      }
    }
  }
  close $in

  set changed 0
  if {$f0MaxSeq >= 0} {
    set changed 1
    incr f0MaxSeq 2
    set f0(showMaxTone)   [lindex $sv(toneList) [expr $f0MaxSeq % 12]]
    set f0(showMaxOctave) [expr int($f0MaxSeq / 12)]
    if {$f0(showMaxOctave) > $sv(sinScaleMax)} {
      set f0(showMaxTone)   [lindex $sv(toneList) end]
      set f0(showMaxOctave) $sv(sinScaleMax)
    }
  }
  if {$f0MinSeq < 100000} {
    set changed 1
    incr f0MinSeq -2
    set f0(showMinTone)   [lindex $sv(toneList) [expr $f0MinSeq % 12]]
    set f0(showMinOctave) [expr int($f0MinSeq / 12)]
    if {$f0(showMinOctave) < $sv(sinScaleMin)} {
      set f0(showMinTone)   [lindex $sv(toneList) 0]
      set f0(showMinOctave) $sv(sinScaleMin)
    }
  }
  if {$changed} {
    set f0(showMin) [tone2freq "$f0(showMinTone)$f0(showMinOctave)"]
    set f0(showMax) [tone2freq "$f0(showMaxTone)$f0(showMaxOctave)"]
    set f0(min) [expr int($f0(showMin) * 0.5)]
    set f0(max) [expr int($f0(showMax) * 2.0)]
  }
}

#---------------------------------------------------
#
proc decodePitchBend {str} {
  set pbList {}
  regsub -all -- {#[0-9]+#} $str "" str     ;# OXk̋L폜
  set charList [split $str ""]
  set i 0
  while {$i < [llength $charList]} {
    ;# 2sb`xhl(P:cent)ɃfR[h
    set pb [string first [lindex $charList $i] "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"]
    incr i
    set _f0 [string first [lindex $charList $i] "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"]
    set pb [expr ($pb << 6) + $_f0]
    incr i
    if {[expr $pb >> 11] == 1} {
      set pb [expr -((~$pb & 4095) + 1)]   ;# 2̕␔\ɂ镉ꍇ̏
    }
    lappend pbList $pb
  }
  return $pbList
}

#---------------------------------------------------
#
proc getMin {l} {
  set min [lindex $l 0]
  foreach i $l {
    if {$min > $i} {set min $i}
  }
  return $min
}

#---------------------------------------------------
#
proc getMax {l} {
  set max [lindex $l 0]
  foreach i $l {
    if {$max < $i} {set max $i}
  }
  return $max
}

#---------------------------------------------------
# t@Cw肵ēǂݍ
#
proc readSettings {} {
  global v t startup
 
  set fn [tk_getOpenFile -initialdir [file dirname $startup(initFile)] -initialfile [file tail $startup(initFile)] \
            -title $t(readSettings,title) -defaultextension "tcl" \
            -filetypes { {{tcl file} {.tcl}} {{All Files} {*}} }]
  if {$fn == ""} return

  doReadInitFile $fn
}

#---------------------------------------------------
# bZ[WeLXgt@C⏉t@Cǂݍ
#
proc doReadInitFile {initFile} {
  global topdir t v f0 power startup dev

  if {! [file exists $initFile]} return

  if [catch {open $initFile r} in] { 
    if {[array names t "doReadInitFile,errMsg"] != ""} {
      tk_messageBox -message $t(doReadInitFile,errMsg) \
        -title $t(.confm.fioErr) -icon warning
    } else {
      tk_messageBox -message "can not read the file ($initFile)" \
        -title "File I/O Error" -icon warning
    }
    return
  }

  ;# ȈՃTj^CWO
  while {![eof $in]} {
    set l [gets $in]

    if {[regexp {^[ \t]*$} $l]}                   continue  ;# sOK
    if {[regexp {^[ \t]*(;|)[ \t]*#} $l]}         continue  ;# RgsOK

    regsub -all -- {\\\[} $l "" l                           ;# \[Ł̃`FbNs
    if {[regexp {^[ \t]*set[ \t]+[^;\[]+$} $l]} continue    ;# set ;[ȂOK

    ;# G[ꍇ
    if {[array names t "doReadInitFile,errMsg2"] != ""} {
      tk_messageBox -message $t(doReadInitFile,errMsg2) \
        -title $t(.confm.fioErr) -icon warning
    } else {
      tk_messageBox -message "Syntax error\nLine: $l\nFile: $initFile\nYou can use only \"set variableName {value}\" in that file." \
        -title "File I/O Error" -icon warning
    }
    close $in
    return
  }
  close $in

  source $initFile

  ;# _SETPARAM_TOPDIR_$topdirɒu
  foreach aName $startup(arrayForInitFile) {
    set sList [array get $aName]
    foreach {key value} $sList {
      if {[string first "_SETPARAM_TOPDIR_" $value] == 0} {
        set newValue [string replace $value 0 [expr [string length "_SETPARAM_TOPDIR_"] -1] $topdir]
        set [eval format "%s(%s)" $aName $key] $newValue
      }
    }
  }
}

#---------------------------------------------------
# {tHgݒ肷
#
proc fontSetting {} {
  global v t

  switch $::tcl_platform(platform) {
    unix {
      font create bigkfont -family mincho -size $v(bigFontSize) \
        -weight normal -slant roman
      font create kfont -family mincho -size $v(fontSize) \
        -weight normal -slant roman
      font create smallkfont -family mincho -size $v(smallFontSize) \
        -weight normal -slant roman
    }
    windows {
      font create bigkfont -family $t(fontName) -size $v(bigFontSize) \
        -weight normal -slant roman
      font create kfont    -family $t(fontName) -size $v(fontSize) \
        -weight normal -slant roman
      font create smallkfont -family $t(fontName) -size $v(smallFontSize) \
        -weight normal -slant roman
    }
  }
}

#---------------------------------------------------
# OR}ht@CAURLs
#
proc execExternal {url} {
    global v t

    if {$::tcl_platform(platform) == "windows"} {
        if {[string match $::tcl_platform(os) "Windows NT"]} {
            exec $::env(COMSPEC) /c start "" $url &
        } {
            exec start $url &
        }
    } else {
        # atode, ͂߂firefoxɂȂƁBB
        if [catch {exec sh -c "netscape -remote 'openURL($url)' -raise"} res] {
            if [string match *netscape* $res] {
                exec sh -c "netscape $url" &
            }
        }
    }
}

#---------------------------------------------------
# D&Dꂽ̂
#
proc procDnd {objList} {
  global v t

  set obj [lindex $objList 0]
  set obj [file normalize $obj]
  if [file isfile $obj] {  ;# t@Chbvꂽꍇ
    openWavFile $obj
  }
}

#---------------------------------------------------
# t@Cg`ǂ
# ǂ߂Ȃ1Ԃ
#
proc readWavFile {{_fname ""}} {
  global v snd t c

  if {$_fname == ""} {
    set fname $v(inWav)
  } else {
    set fname $_fname
  }
  if {$v(sndLength) > 0} { set v(sndLength) 0 }
  set v(inWav) $fname
  if {! [file readable $fname]} {
    return 1
  }
  if [catch {snd read $fname}] {
    tk_messageBox -message "error: can not open $fname" \
      -title $t(.confm.fioErr) -icon warning
    return 1
  }
  if {[snd cget -channels] != 1} {
    snd convert -channels Mono
  }

  if {$v(wavPre) > 0} {
    for {set i 1} {[expr 60000.0 / $v(bpm) * $i - $v(wavPre)] < 0} {incr i} {}
    set v(barPre) $i
    set v(wavOffsetSec) [expr 60.0 / $v(bpm) * $v(barPre)- $v(wavPre) / 1000.0]
    set v(bpmOffset) [expr 60.0 / $v(bpm) * $v(barPre)]
  } else {
    set v(wavOffsetSec) 0
    set v(barPre) 0
    set v(bpmOffset) 0
  }

  set v(sndLength) [expr [snd length -unit SECONDS] + $v(wavOffsetSec)]

  set waveppsOld $v(wavepps)
  if {$v(sndLength) <= 0} {
    set v(wavepps) 1
  } elseif $v(showWhole) {
    set v(wavepps) [expr $v(cWidth) / $v(sndLength)]  ;# wavŜ\
  } elseif {[expr int($v(sndLength) * $v(wavepps))] > 48000} {
    set v(wavepps) [expr 48000 / $v(sndLength)]
  }
  $c scale regions 0 0 [expr $v(wavepps) / $waveppsOld] 1

  if {$v(wavPre) > 0} {
    set v(wavOffsetPixel) [expr $v(wavOffsetSec) * $v(wavepps)]
  } else {
    set v(wavOffsetPixel) 0
  }

  if $v(showPow) getPowerThread
  if $v(showF0) getF0Thread

  return 0
}

#---------------------------------------------------
# ϗ̊eK̎g߂
#
proc setSinScale {} {
  global v sv t
  set sv(sinScale) {}
  set sv(sinNote) {}
  for {set oct $sv(sinScaleMin)} {$oct <= $sv(sinScaleMax)} {incr oct} {
    for {set i 0} {$i < 12} {incr i} {
      lappend sv(sinScale) [expr int(27.5 * pow(2, $oct + ($i - 9.0)/12.0) + 0.5)]
      lappend sv(sinNote) "[lindex $sv(toneList) $i]$oct"
    }
  }
}

#---------------------------------------------------
# ߗ̐ݒ葋
#
proc setAlphaWindow {} {
  global alphaWindow v t
  if [isExist $alphaWindow] return

  toplevel $alphaWindow
  wm title $alphaWindow $t(setAlphaWindow,title)
  wm attributes $alphaWindow -topmost 1 -toolwindow 1
  bind $alphaWindow <Escape> "destroy $alphaWindow"
  set topg [split [wm geometry .] "x+"]
  set x [expr ([lindex $topg 0] + [lindex $topg 2]) / 2]
  set y [expr ([lindex $topg 1] + [lindex $topg 3]) / 2]
  wm geometry $alphaWindow "+$x+$y"
  wm resizable $alphaWindow 0 0
  scale $alphaWindow.s -variable v(alpha) -orient horiz -from 0.1 -to 1 -res 0.01 -showvalue 1 -command _changeAlpha
  pack $alphaWindow.s
}
proc _changeAlpha {val} {
  wm attributes . -alpha $val
}

#---------------------------------------------------
# XVԊu̐ݒ葋
#
proc setReloadWindow {} {
  global reloadWindow v t fTool
  if [isExist $reloadWindow] return

  toplevel $reloadWindow
  wm title $reloadWindow $t(setReloadWindow,title)
  wm attributes $reloadWindow -topmost 1 -toolwindow 1
  bind $reloadWindow <Escape> "destroy $reloadWindow"
  set topg [split [wm geometry .] "x+"]
  set relg [split [winfo geometry $fTool.reloadT] "x+"]
  if {[lindex $topg 0] > [lindex $relg 2]} {
    set x [expr [lindex $topg 2] + [lindex $relg 2]]
    set y [expr [lindex $topg 3] + [lindex $relg 3] + 60]
  } else {
    set x [expr ([lindex $topg 0] + [lindex $topg 2]) / 2]
    set y [expr ([lindex $topg 1] + [lindex $topg 3]) / 2]
  }
  wm geometry $reloadWindow "+$x+$y"
  wm resizable $reloadWindow 0 0
  scale $reloadWindow.reloadS -variable v(reload) -orient horiz -from 0 -to 10 -res 1 -showvalue 1 -command _changeReloadS
  pack $reloadWindow.reloadS
}
proc _changeReloadS {val} {
  global reloadWindow fTool v
  if {$val == 0} {
    $reloadWindow.reloadS configure -bg #f0f0c0
    $fTool.reloadV configure -fg red
    after cancel [after info]
  } else {
    $reloadWindow.reloadS configure -bg #f0f0f0
    $fTool.reloadV configure -fg black
    if {$v(reload) > 0 && [after info] == ""} autoReload
  }
}

#---------------------------------------------------
# Pʂ̎Ԏp̐ݒ葋
#
proc setBPMWindow {} {
  global bpmWindow v t
  if [isExist $bpmWindow] return

  toplevel $bpmWindow
  wm title $bpmWindow $t(setBPMWindow,title)
  wm attributes $bpmWindow -topmost 1
  wm attributes $bpmWindow -toolwindow 1
  bind $bpmWindow <Escape> "destroy $bpmWindow"
  set topg [split [wm geometry .] "x+"]
  set x [expr [lindex $topg 2] + [lindex $topg 0] / 2 - 100]
  set y [expr [lindex $topg 3] + [lindex $topg 1] / 2 - 5]
  wm geometry $bpmWindow "+$x+$y"
  wm resizable $bpmWindow 0 0

  set fr [frame $bpmWindow.fr]
  radiobutton $fr.rsec -text $t(show,timeAxisSec) -variable v(timeUnit) -value "Sec."
  radiobutton $fr.rbpm -text $t(show,timeAxisBar) -variable v(timeUnit) -value "Bar"
  pack $fr.rsec $fr.rbpm -side left

  set f [frame $bpmWindow.f]
  label $f.lbpm  -text $t(setBPMWindow,tempo)
  label $f.lbpm2 -text "(BPM)"
  entry $f.ebpm -textvar v(bpmTmp) -wi 10 -validate all -validatecommand {isDouble %P}
  label $f.loff -text $t(setBPMWindow,offset)
  label $f.loff2 -text $t(setBPMWindow,sec)
  entry $f.eoff -textvar v(bpmOffsetTmp) -wi 10 -validate all -validatecommand {isDouble %P}
  grid $f.lbpm  -sticky w -row 0 -column 0
  grid $f.ebpm  -sticky w -row 0 -column 1
  grid $f.lbpm2 -sticky w -row 0 -column 2
  grid $f.loff  -sticky w -row 1 -column 0
  grid $f.eoff  -sticky w -row 1 -column 1
  grid $f.loff2 -sticky w -row 1 -column 2
  button $bpmWindow.bok -text $t(.confm.ok) -command {
    if {[string is double $v(bpmTmp)]  &&
        [string length $v(bpmTmp)] > 0 && $v(bpmTmp) > 0} {
      set v(bpm) $v(bpmTmp)
    } else {
      set v(bpmTmp) $v(bpm)
    }
    if {[string length $v(bpmOffsetTmp)] <= 0} {
      set v(bpmOffsetTmp) 0
    }
    if {[string is double $v(bpmOffsetTmp)]} {
      set v(bpmOffset) $v(bpmOffsetTmp)
    } else {
      set v(bpmOffsetTmp) $v(bpmOffset)
    }
    Redraw scale
    destroy $bpmWindow
  }
  button $bpmWindow.bapply -text $t(.confm.apply) -command {
    if {[string is double $v(bpmTmp)]  &&
        [string length $v(bpmTmp)] > 0 && $v(bpmTmp) > 0} {
      set v(bpm) $v(bpmTmp)
    } else {
      set v(bpmTmp) $v(bpm)
    }
    if {[string length $v(bpmOffsetTmp)] <= 0} {
      set v(bpmOffsetTmp) 0
    }
    if {[string is double $v(bpmOffsetTmp)]} {
      set v(bpmOffset) $v(bpmOffsetTmp)
    } else {
      set v(bpmOffsetTmp) $v(bpmOffset)
    }
    Redraw scale
  }
  button $bpmWindow.bcancel -text $t(.confm.c) -command {
    set v(bpmTmp) $v(bpm)
    set v(bpmOffsetTmp) $v(bpmOffset)
    destroy $bpmWindow
  }

  pack $fr -side top
  pack $f -side top
  pack $bpmWindow.bcancel $bpmWindow.bapply $bpmWindow.bok -side right
}

#---------------------------------------------------
# w肵g[Hz]singĐ
#
proc playSin {freq vol length} {
  global v onsa t
  if [snack::audio active] return
  if $::debug {puts $freq}
  if {$freq > 10 && $vol > 0} { 
#    set f [snack::filter generator $freq $vol 0.0 sine $v(sampleRate)]
    set g  [snack::filter generator $freq $vol 0.01 triangle $length]
    set f1 [snack::filter formant 500 50]
    set f2 [snack::filter formant 1500 75]
    set f3 [snack::filter formant 2500 100]
    set f4 [snack::filter formant 3500 150]
    set f  [snack::filter compose $g $f1 $f2 $f3 $f4]
    onsa play -filter $f -command "$f destroy" 
  }
}

#---------------------------------------------------
# g`Ɋgk(ctrl+}EXzC[)
# mode=1...g, mode=0...kA̒l=̐Βlv(wavepps)ɂ
#
proc changeWidth {mode {x -1}} {
  global v t c wscrl

  if {$v(sndLength) <= 0} return

  if {$x < 0} {
    set x [expr $v(cWidth) / 2]
  }
  set sec [point2sec $x]
  set v(showWhole) 0
  set waveppsOld $v(wavepps)

  if {$mode == 1} {
    set v(wavepps) [expr $v(wavepps) * 1.5]
  } elseif {$mode == 0} {
    set v(wavepps) [expr $v(wavepps) / 1.5]
  } elseif {$mode < 0} {
    set v(wavepps) [expr abs($mode)]
  }

  if {$mode >= 0} {
    # `敝LoX菬ȂȂ悤ɂ
    if {[expr $v(wavepps) * $v(sndLength)] < $v(cWidth)} {
      set v(wavepps) [expr $v(cWidth) / $v(sndLength)]
    }
    # `敝x肨ȂȂ悤ɂ
    if {[expr int($v(sndLength) * $v(wavepps))] > 48000} {
      set v(wavepps) [expr 48000 / $v(sndLength)]
    }
  }
  if {$v(wavPre) > 0} {
    set v(wavOffsetPixel) [expr $v(wavOffsetSec) * $v(wavepps)]
  } else {
    set v(wavOffsetPixel) 0
  }
  $c scale regions 0 0 [expr double($v(wavepps)) / $waveppsOld] 1
  Redraw scale

  $c xview moveto [expr double($sec - double($x) / $v(wavepps)) / $v(sndLength)]

#  if $mode {
#    incr v(cWidth) +40
#  } elseif {$v(cWidth) <= $v(cWidthMin)} {
#    set v(cWidth) $v(cWidthMin)
#  } else {
#    incr v(cWidth) -40
#  }
#  Redraw scale
}

#---------------------------------------------------
# ԃXP[̊g嗦[Uw肷鑋
#
proc changeZoomX {} {
  global v changeZoomWindow t

  if [isExist $changeZoomWindow] return ;# dNh~
  toplevel $changeZoomWindow
  wm title $changeZoomWindow $t(changeZoomX,title)
  bind $changeZoomWindow <Escape> "destroy $changeZoomWindow"

  entry  $changeZoomWindow.erate   -textvar v(zoomRate) -wi 6 -validate key -vcmd {isDouble %P}
  label  $changeZoomWindow.lunit   -text "$t(changeZoomX,unit)"
  button $changeZoomWindow.bchange -text "$t(changeZoomX,change)" -command {
    if {$v(zoomRate) < 100}   {set v(zoomRate) 100}
    if {$v(zoomRate) > 10000} {set v(zoomRate) 10000}
    zoomX $v(zoomRate) 0
    destroy $changeZoomWindow
  }
  bind $changeZoomWindow <Return> {
    if {$v(zoomRate) < 100}   {set v(zoomRate) 100}
    if {$v(zoomRate) > 10000} {set v(zoomRate) 10000}
    zoomX $v(zoomRate) 0
    destroy $changeZoomWindow
  }

  grid $changeZoomWindow.erate   -row 0 -column 0
  grid $changeZoomWindow.lunit   -row 0 -column 1
  grid $changeZoomWindow.bchange -row 1 -column 0 -sticky nsew
}

#---------------------------------------------------
# ԃXP[gk
# zoom...g嗦B100=wavS̕\A0=wavS̕\A=őg嗦
#
proc zoomX {zoom x} {
  global v t c wscrl

  if {$v(sndLength) <= 0} return
  set sec [point2sec $x]
  set waveppsOld $v(wavepps)

  if {$zoom < 0} {
    set v(wavepps) [expr 48000 / $v(sndLength)]       ;# őg嗦ɂ
    set v(showWhole) 0
  } elseif {$zoom == 0} {
    set v(wavepps) [expr $v(cWidth) / $v(sndLength)]  ;# wavŜ\
    set v(showWhole) 1                       ;# wavŜ\
  } elseif {$zoom <= 100} {
    set v(wavepps) [expr $v(cWidth) / $v(sndLength)]  ;# wavŜ\
    set v(showWhole) 0
  } else {
    set v(wavepps) [expr $v(cWidth) / $v(sndLength) * $zoom / 100]
    set v(showWhole) 0
  }
  
  if {$zoom < 0} {
    set v(zoomRate) [expr 100 * 48000 / $v(cWidth)]
  } elseif {$zoom < 100} {
    set v(zoomRate) 100
  } else {
    set v(zoomRate) $zoom
  }

  if {[expr int($v(sndLength) * $v(wavepps))] > 48000} {
    set v(wavepps) [expr 48000 / $v(sndLength)]       ;# őg嗦ɂ
  }

  if {$v(wavPre) > 0} {
    set v(wavOffsetPixel) [expr $v(wavOffsetSec) * $v(wavepps)]
  } else {
    set v(wavOffsetPixel) 0
  }
  $c scale regions 0 0 [expr $v(wavepps) / $waveppsOld] 1
  Redraw scale
  $c xview moveto [expr double($sec - double($x) / $v(wavepps)) / $v(sndLength)]
}

#---------------------------------------------------
# Ŏw肵Pʂ̒lTvPʂɕϊ
#
proc val2samp {val from sr} {
  switch $from {
    MSEC -
    msec { ;# msec  TvPʂɕϊ
      return [expr int($val / 1000.0 * $sr)]
    }
    SEC  -
    sec  { ;# sec  TvPʂɕϊ
      return [expr int($val * $sr)]
    }
    default { ;# ̂܂ܕԂ(Ôߐ)
      return int($val);
    }
  }
}

#---------------------------------------------------
# Đ/~̐ؑ
#
proc toggleOnsaPlay {} {
  global v f0 onsa t

  if $v(playOnsaStatus) {
    onsa stop
    set v(playOnsaStatus) 0
  } else {
    set v(playOnsaStatus) 1
    playSin [tone2freq $f0(guideTone)$f0(guideOctave)] \
      $f0(guideVol) -1
  }
}

#---------------------------------------------------
# Đʒu̕\
#
proc showPlayMark {{init 0}} {
  global c v
  if {$v(playStatus)} {
    set ylow [expr $v(waveh) + $v(spech) + $v(powh) + $v(f0h) + $v(timeh)]
    set eTime [snack::audio elapsedTime]
    if $init {
      ;# ĐJn̏ꍇ
      after cancel showPlayMark
      $c delete playMark
      set v(pmPlayStart) [expr $v(pmPlayStart) - $eTime] ;#{͕sv̂͂ĐelapsedTime0łȂꍇւ̑΍
      if {$v(pmStartDelay) > 0} {
        set x -100  ;# \Ȃʒuɂ
      } else {
        set x [expr $v(wavepps) * ($v(pmPlayStart) + $v(wavOffsetSec) + $eTime)]
      }
      $c create line $x 0 $x $ylow -fill #ffa030 -tags playMark
      $c raise playMark
    } else {
      ;# Đ̏ꍇ
      if {$eTime >= $v(pmStartDelay)} {
        set x [expr $v(wavepps) * ($v(pmPlayStart) + $v(wavOffsetSec) + $eTime - $v(pmStartDelay))]
        $c coords playMark $x 0 $x $ylow
      }
    }
    update
    after 30 showPlayMark
    return
  }

  ;# Đ~̏ꍇ
  $c delete playMark
}

#---------------------------------------------------
# Đ~
#
proc playStop {} {
  global v snd t

  if {$v(playStatus)} {
    snd stop
    set v(playStatus) 0
  }
}

#---------------------------------------------------
# Đ/~̐ؑ
#
proc togglePlay {{start 0} {end -1}} {
  global v snd t

  if {$v(playStatus)} {
    playStop
  } else {
    set v(playStatus) 1
    snd play -start $start -end $end -command {
      set v(playStatus) 0       ;# ĐIƂ̏
    }
    if {$start >= 0} {
      set v(pmPlayStart) [expr double($start) / $v(sampleRate)]
    } else {
      set v(pmPlayStart) 0
    }
    set v(pmStartDelay) 0
    showPlayMark 1
  }
}

#---------------------------------------------------
# g`\/\̐ؑ
#
proc toggleWave {} {
  global v t c

  ;#if [snack::audio active] return
  if $v(showWave) {
      set v(waveh) $v(wavehbackup)
  } else {
      set v(wavehbackup) $v(waveh)
      set v(waveh) 0
  }
  Redraw wave
  update
  set v(winHeight) [expr [winfo y $c] + $v(waveh) + $v(spech) + $v(powh) + $v(f0h) + $v(timeh) + 4]
  wm geometry . "$v(winWidth)x$v(winHeight)"
}

#---------------------------------------------------
# XyNg\/\̐ؑ
#
proc toggleSpec {} {
  global v t c

  ;#if [snack::audio active] return
  if $v(showSpec) {
      set v(spech) $v(spechbackup)
  } else {
      set v(spechbackup) $v(spech)
      set v(spech) 0
  }
  Redraw spec
  update
  set v(winHeight) [expr [winfo y $c] + $v(waveh) + $v(spech) + $v(powh) + $v(f0h) + $v(timeh) + 4]
  wm geometry . "$v(winWidth)x$v(winHeight)"
}

#---------------------------------------------------
# p[\/\̐ؑ
#
proc togglePow {} {
  global v t c

  ;#if [snack::audio active] return
  if $v(showPow) {
      set v(powh) $v(powhbackup)
      getPowerThread
  } else {
      set v(powhbackup) $v(powh)
      set v(powh) 0
  }
  Redraw pow
  update
  set v(winHeight) [expr [winfo y $c] + $v(waveh) + $v(spech) + $v(powh) + $v(f0h) + $v(timeh) + 4]
  wm geometry . "$v(winWidth)x$v(winHeight)"
}

#---------------------------------------------------
# F0\/\̐ؑ
#
proc toggleF0 {} {
  global v t c

  ;#if [snack::audio active] return
  if $v(showF0) {
      set v(f0h) $v(f0hbackup)
      getF0Thread
  } else {
      set v(f0hbackup) $v(f0h)
      set v(f0h) 0
  }
  Redraw f0
  update
  set v(winHeight) [expr [winfo y $c] + $v(waveh) + $v(spech) + $v(powh) + $v(f0h) + $v(timeh) + 4]
  wm geometry . "$v(winWidth)x$v(winHeight)"
}

#---------------------------------------------------
# F0pl̏c\
# snack  unix/snack.tcl  frequencyAxis 
proc myAxis {canvas x y width height args} {
  global sv
  # 
  array set a [list \
    -tags snack_y_axis -font {Helvetica 8} -max 1000 \
    -fill black -draw0 0 -min 0 -unit Hz]
  array set a $args

  if {$height <= 0} return
  if {$a(-max) <= $a(-min)} return

  # sAm[\
  set max_min [expr $a(-max) - $a(-min)]
  if {$a(-unit) == "semitone"} {
    set ylow [expr $height + $y]
    set ppd [expr double($height) / $max_min]
    set kokken  [expr int($ppd / 2)]
    set kokkenW [expr $width / 2]
    for {set i 0} {$i < [llength $sv(sinScale)]} {incr i} {
      set tgt [hz2semitone [lindex $sv(sinScale) $i]]
      set y1 [expr $ylow - ($tgt - $a(-min)) * $ppd]
      if {$y1 <= [expr $ylow - $height]} break
      if {$y1 < $ylow} {
        set tt  [expr $i % 12]
        if {$tt == 1 || $tt == 3 || $tt == 6 || $tt == 8 || $tt == 10} {
          set yt [expr $y1 - $kokken]
          set yb [expr $y1 + $kokken + 1]
          $canvas create line $kokkenW $y1 $width $y1 -tags $a(-tags) -fill black
          $canvas create rectangle 0 $yt $kokkenW $yb -tags $a(-tags) -fill #d0d0d0
        } elseif {$tt == 4 || $tt == 11} {
          set yw [expr $y1 - $kokken]
          $canvas create line 0 $yw $width $yw -tags $a(-tags) -fill black
        } elseif {$tt == 0} {
          set keyName [format "C%d" [expr int($i / 12 + 1)]]
          $canvas create text $kokkenW $y1 -text $keyName \
            -fill $a(-fill) -font $a(-font) -anchor w -tags $a(-tags)
        }
      }
    }

    return
  }

  ;# ticklist...ڐ̊Ԋǔ
  set ticklist [list 0.2 0.5 1 2 5 10 20 50 100 200 500]

  foreach elem $ticklist {
    set npt $elem  ;# npt...ڐ̒l̊Ԋu
    ;# dy...ڐ`悷Ԋu(yW)
    set dy [expr {double($height * $npt) / $max_min}]
    if {$dy >= [font metrics $a(-font) -linespace]} break
  }
  set hztext $a(-unit)
  if {$hztext == "semitone"} {set hztext st} ;# \Zk

  if $a(-draw0) {
    set i0 0
    set j0 0
  } else {
    set i0 $dy
    set j0 1
  }

  if {$a(-min) != 0} {
    set j0 [expr int($a(-min) / $npt) + 1]
  }

  ;# j=`悷ڐ̔ԍ
  set yzure [expr {double($a(-min) - ($j0 - 1) * $npt) * $height / $max_min}]

  set yc [expr {$height + $y + $yzure - $i0}]  ;# ڐ`悷yW
  set j $j0
  for {} {$yc > $y} {set yc [expr {$yc-$dy}]; incr j} {

    if {$npt < 1000} {
      set tm [expr {$j * $npt}]
    } else {
      set tm [expr {$j * $npt / 1000}]
    }
    if {$yc > [expr {8 + $y}]} {
      if {[expr {$yc - [font metrics $a(-font) -ascent]}] > \
          [expr {$y + [font metrics $a(-font) -linespace]}] ||
          [font measure $a(-font) $hztext]  < \
          [expr {$width - 8 - [font measure $a(-font) $tm]}]} {
        $canvas create text [expr {$x +$width - 8}] [expr {$yc-2}]\
          -text $tm -fill $a(-fill)\
          -font $a(-font) -anchor e -tags $a(-tags)
      }
      $canvas create line [expr {$x + $width - 5}] $yc \
        [expr {$x + $width}]\
        $yc -tags $a(-tags) -fill $a(-fill)
    }
  }
  $canvas create text [expr {$x + 2}] [expr {$y + 1}] -text $hztext \
    -font $a(-font) -anchor nw -tags $a(-tags) -fill $a(-fill)

  return $npt
}

#---------------------------------------------------
# FI
#
proc chooseColor {w key initcolor} {
  global v t
  set ctmp [tk_chooseColor -initialcolor $initcolor -title $t(chooseColor,title)]
  if {$ctmp != ""} {
    set v($key) $ctmp
    $w configure -bg $v($key)
  }
}

#---------------------------------------------------
# ɑΉgԂ
#
proc tone2freq {tone} {
  global v sv t
  for {set i 0} {$i < [llength $sv(sinNote)]} {incr i} {
    if {$tone == [lindex $sv(sinNote) $i]} break
  }
  return [lindex $sv(sinScale) $i]
}

#---------------------------------------------------
# g`Fݒ
#
proc setColor {w key msg} {
  global v t

  set ic $v($key)
  pack [frame $w.$key] -anchor nw
  label  $w.$key.l  -text $msg -width 20 -anchor nw
  label  $w.$key.l2 -textvar v($key) -width 7 -anchor nw -bg $v($key)
  button $w.$key.b  -text $t(setColor,selColor) -command "chooseColor $w.$key.l2 $key $ic"
  pack $w.$key.l $w.$key.l2 $w.$key.b -side left
}

#---------------------------------------------------
# 1Hzɑ΂gZ~g[ɂ
#
proc hz2semitone {hz} {
  if {$hz <= 0} {return $hz}
  return [expr log($hz) / log(2) * 12.0]
}

#---------------------------------------------------
# ږF[Gg[]̃t[Ĕzu(powerp)
#
proc packEntryPower {wname text key} {
  global power t
  pack [frame $wname] -anchor w
  label $wname.lfl -text $text -width 20 -anchor w
  entry $wname.efl -textvar power($key) -wi 6 -validate key -vcmd {isDouble %P}
  pack $wname.lfl $wname.efl -side left
}

#---------------------------------------------------
# ږF[Gg[]̃t[Ĕzu(f0p)
#
proc packEntryF0 {wname text key} {
  global f0 t
  pack [frame $wname] -anchor w
  label $wname.lfl -text $text -width 20 -anchor w
  entry $wname.efl -textvar f0($key) -wi 6 -validate key -vcmd {isDouble %P}
  pack $wname.lfl $wname.efl -side left
}

#---------------------------------------------------
#   o̓foCXobt@TCY
#
proc audioSettings {} {
  global dev snd t

#  set dev(in)   [encoding convertfrom [lindex [snack::audio inputDevices]  0]]
  set dev(out)  [encoding convertfrom [lindex [snack::audio outputDevices] 0]]
;#puts "" ;# 茳wish86snack::audio record_gainƌł܂AȂputsƐɐiތۂ
#  set dev(ingain)    [snack::audio record_gain]
  set dev(outgain)   [snack::audio play_gain]
#  set dev(latency)   [snack::audio playLatency]
#  set dev(sndBuffer) [snd cget -buffersize]
  # snack::audio selectInput $dev(in) ;# R[hΉ
}

#---------------------------------------------------
#   o̓foCX̐ݒ葋̒lfoCXɔf
#
proc setIODevice {} {
  global dev snd t
  ;# dev(in),dev(out)ɂ̓j[\̂ߊR[hsjisutf-8
  ;# ϊĂBfoCXݒ莞ɂ͌̊R[h
  ;# w肵ȂƃG[ɂȂlqȂ̂ňȉ̂悤ȃR[hőΉĂ
#  foreach dname [snack::audio inputDevices] {
#    if {$dev(in) == [encoding convertfrom $dname]} {
#      snack::audio selectInput  $dname
#      break
#    }
#  }
  foreach dname [snack::audio outputDevices] {
    if {$dev(out) == [encoding convertfrom $dname]} {
      snack::audio selectOutput $dname
      break
    }
  }
;#  snack::audio record_gain  $dev(ingain)
  snack::audio play_gain    $dev(outgain)
#  snack::audio playLatency  $dev(latency)
#  snd configure -buffersize $dev(sndBuffer)
}

#---------------------------------------------------
#   ݂̐ݒۑ
#
proc saveSettings {{fn ""}} {
  global topdir t v f0 power startup dev 
  # ۑz𑝂₵AɒǉƋdoReadInitFileglobalɂǉ

  if {$fn == ""} {
    set fn [tk_getSaveFile -initialfile $startup(initFile) \
            -title $t(saveSettings,title) -defaultextension "tcl" ]
  }
  if {$fn == ""} return

  ;# ۑt@CJ
  if [catch {open $fn w} fp] { 
    tk_messageBox -message "error: can not open $fn" \
      -title $t(.confm.fioErr) -icon warning
    return
  }

  foreach aName $startup(arrayForInitFile) {
    set sList [array get $aName]
    foreach {key value} $sList {
      ;# [܂܂Ă΃GXP[vV[PX}
      regsub -all -- {\[} $value "\\\[" value

      ;# $topdir̃t@Cwf[^Ȃ_SETPARAM_TOPDIR_Ƃɒu
      ;# PCɈړȂtopdir̈ႤɂΉ邽
      if {[string first $topdir $value] == 0} {
        set value [string replace $value 0 [expr [string length $topdir] - 1] "_SETPARAM_TOPDIR_"]
      }

      if {[lsearch $startup(exclusionKeysForInitFile,aName) $aName] < 0 ||
          [lsearch $startup(exclusionKeysForInitFile,$aName) $key]  < 0} {
        ;# ۑΏۂ̃f[^
        puts $fp [format "set %s(%s)\t\t{%s}" $aName $key $value]
      }
    }
  }
  close $fp
}

#---------------------------------------------------
#   w肵Nς݂`FbNBNς݂ȂtH[JXB
#
proc isExist {w} {
  if [winfo exists $w] {
    raise $w
    focus $w
    return 1
  } else {
    return 0
  }
}

#---------------------------------------------------
#   o̓foCXobt@TCYݒ肷鑋
#
proc ioSettings {} {
  global ioswindow dev dev_bk snd t

  if [isExist $ioswindow] return ;# dNh~
  toplevel $ioswindow
  wm title $ioswindow $t(ioSettings,title)
  bind $ioswindow <Escape> "destroy $ioswindow"

  ;# QCACeV̍ŐV󋵂擾
;#  set dev(ingain)  [snack::audio record_gain]
  set dev(outgain) [snack::audio play_gain]
#  set dev(latency) [snack::audio playLatency]
#  set dev(sndBuffer) [snd cget -buffersize]

  array set dev_bk [array get dev]     ;# p[^obNAbv

  ;# ̓foCX̑I
  set devList {}
  foreach d [snack::audio inputDevices] {
    set d [encoding convertfrom $d]
    lappend devList "$d"
    # if {[string length $d] == [string bytelength $d]} {  ;# pfoCX̂ݓo^
    #  lappend devList "$d"
    # }
  }
#  set f1 [frame $ioswindow.f1]
#  label $f1.l -text $t(ioSettings,inDev) -width 12 -anchor w
#  eval tk_optionMenu $f1.in dev(in) $devList
#  pack $f1.l $f1.in -side left
#  pack $f1 -anchor w

  ;# o̓foCX̑I
  set devList {}
  foreach d [snack::audio outputDevices] {
    set d [encoding convertfrom $d]
    lappend devList "$d"
    #if {[string length $d] == [string bytelength $d]} {  ;# pfoCX̂ݓo^
    #  lappend devList "$d"
    #}
  }
  set f2 [frame $ioswindow.f2]
  label $f2.l -text $t(ioSettings,outDev) -width 12 -anchor w
  eval tk_optionMenu $f2.out dev(out) $devList
  pack $f2.l $f2.out -side left
  pack $f2 -anchor w

#  ;# ̓QC̎w
#  set f3 [frame $ioswindow.f3]
#  label $f3.l -text $t(ioSettings,inGain) -width 28 -anchor w
#  entry $f3.e -textvar dev(ingain) -wi 6 -validate key -vcmd {isDouble %P}
#  scale $f3.s -variable dev(ingain) -orient horiz \
#    -from 0 -to 100 -res 1 -showvalue 0
#  pack $f3.l $f3.e $f3.s -side left
#  pack $f3 -anchor w

  ;# o̓QC̎w
  set f4 [frame $ioswindow.f4]
  label $f4.l -text $t(ioSettings,outGain) -width 28 -anchor w
  entry $f4.e -textvar dev(outgain) -wi 6 -validate key -vcmd {isDouble %P}
  scale $f4.s -variable dev(outgain) -orient horiz \
    -from 0 -to 100 -res 1 -showvalue 0
  pack $f4.l $f4.e $f4.s -side left
  pack $f4 -anchor w

#  ;# CeV̎w
#  set f5 [frame $ioswindow.f5]
#  label $f5.l -text $t(ioSettings,latency) -width 28 -anchor w
#  entry $f5.e -textvar dev(latency) -wi 6 -validate key -vcmd {isDouble %P}
#  label $f5.u -text "(msec)"
#  pack $f5.l $f5.e $f5.u -side left
#  pack $f5 -anchor w

#  ;# ^̃obt@TCY̎w
#  set f6 [frame $ioswindow.f6]
#  label $f6.l -text $t(ioSettings,sndBuffer) -width 28 -anchor w
#  entry $f6.e -textvar dev(sndBuffer) -wi 6 -validate key -vcmd {isDouble %P}
#  label $f6.u -text "(sample)"
#  pack $f6.l $f6.e $f6.u -side left
#  pack $f6 -anchor w

#  ;# KChBGM̃obt@TCY̎w
#  set f7 [frame $ioswindow.f7]
#  label $f7.l -text $t(ioSettings,bgmBuffer) -width 28 -anchor w
#  entry $f7.e -textvar dev(bgmBuffer) -wi 6 -validate key -vcmd {isDouble %P}
#  label $f7.u -text "(sample)"
#  pack $f7.l $f7.e $f7.u -side left
#  pack $f7 -anchor w

  ;# {^
  set fb [frame $ioswindow.fb]
  button $fb.ok -text $t(.confm.ok) -command {
    setIODevice
    destroy $ioswindow
  }
  button $fb.ap -text $t(.confm.apply) -command {
    setIODevice
    array set dev_bk [array get dev]     ;# p[^obNAbv
  }
  button $fb.cn -text $t(.confm.c) -command {
    array set dev [array get dev_bk]     ;# p[^ȑȌԂɖ߂
    setIODevice
    destroy $ioswindow
  }
  pack $fb.ok $fb.ap $fb.cn -side left -padx 2
  pack $fb -anchor w

  ;# 
  set fm [frame $ioswindow.fm]
  label $fm.lm0  -fg red -text $t(ioSettings,comment0)
  label $fm.lm0b -fg red -text $t(ioSettings,comment0b)
  label $fm.lm1  -fg red -text $t(ioSettings,comment1)
  label $fm.lm2  -fg red -text $t(ioSettings,comment2)
  pack $fm.lm0 $fm.lm0b $fm.lm1 $fm.lm2 -anchor w -side top
  pack $fm -anchor w

  raise $ioswindow
  focus $ioswindow
}

# ͂Ȃ1Ԃ
proc isDouble {str} {
  if {[string is double $str] && [regexp { } $str] == 0} {
    return 1
  } else {
    return 0
  }
}

#---------------------------------------------------
# vOXo[ĕ\
#
proc initProgressWindow {{title "now processing..."}} {
  global prgWindow v

  if {$::tcl_platform(os) == "Darwin"} {
    if [isExist $prgWindow] {  ;# macłprogressbarsƗ̂
      set v(progress) 0 
      wm deiconify $prgWindow
      return
    }
  } else {
    if [isExist $prgWindow] return
  }

  toplevel $prgWindow
  wm title $prgWindow $title
  if {$::tcl_platform(os) != "Darwin"} {
    wm attributes $prgWindow -toolwindow 1
    wm attributes $prgWindow -topmost 1
  }
  bind $prgWindow <Escape> "destroy $prgWindow"
  set topg [split [wm geometry .] "x+"]
  set x [expr [lindex $topg 2] + [lindex $topg 0] / 2 - 100]
  set y [expr [lindex $topg 3] + [lindex $topg 1] / 2 - 5]
  wm geometry $prgWindow "+$x+$y"

  set v(progress) 0
  ttk::progressbar $prgWindow.p -length 200 -variable v(progress) -mode determinate
  pack $prgWindow.p

  raise $prgWindow
  focus $prgWindow
  if {$::tcl_platform(os) != "Darwin"} { grab set $prgWindow }
  update
}

#---------------------------------------------------
# vOXo[XVBi󋵂$progress(0`100)Ŏw肷)
#
proc updateProgressWindow {progress {title ""}} {
  global v prgWindow

  if {! [isExist $prgWindow]} return
  if {$title != ""} { wm title $prgWindow $title }
  set v(progress) $progress
  raise $prgWindow
  focus $prgWindow
  if {$::tcl_platform(os) != "Darwin"} { grab set $prgWindow }
  update
}

#---------------------------------------------------
# vOXo[
#
proc deleteProgressWindow {} {
  global prgWindow
  if [isExist $prgWindow] {
    if {$::tcl_platform(os) != "Darwin"} { grab release $prgWindow }
    destroy $prgWindow
  }
}

#---------------------------------------------------
# GNXv[ŕۑtH_J
#
proc runExplorer {} {
  global v t

  if {$::tcl_platform(platform) == "windows"} {
    if {[string match $::tcl_platform(os) "Windows NT"]} {
      exec $::env(COMSPEC) /c start "" "$v(saveDir)" &
    } {
      exec start $v(saveDir) &
    }
  }
}



#---------------------------------------------------
# ڍאݒ
#
proc settings {} {
  global swindow v sv power f0 v_bk power_bk f0_bk snd t topdir
    # *_bk͑ϐɂȂƃLZɃobNAbvAłȂ

  ;# dNh~
  if [isExist $swindow] return
  toplevel $swindow
  wm title $swindow $t(settings,title)
  wm resizable $swindow 0 0
  bind $swindow <Escape> "destroy $swindow"

  array set v_bk     [array get v]     ;# p[^obNAbv
  array set power_bk [array get power] ;# p[^obNAbv
  array set f0_bk    [array get f0]    ;# p[^obNAbv
  set v(reloadSetting) $v(reload)   ;# ݂̍XVԊuRs[

  ;# 1Jڂ̃t[
  set frame1 [frame $swindow.l]
  pack $frame1 -side left -anchor n -fill y -padx 2 -pady 2

  ;#---------------------------
  ;# g`
  set lf1 [labelframe $frame1.lf1 -text $t(settings,wave) \
    -relief groove -padx 5 -pady 5]
  pack $lf1 -anchor w -fill x

  ;# g`F̐ݒ
  set cw [frame $lf1.f4w]
  setColor $cw "wavColor" $t(settings,waveColor)
  pack $cw -anchor nw

  ;# g`c̍ől
  pack [frame $lf1.fs] -anchor w
  label $lf1.fs.l -text $t(settings,waveScale) -wi 35 -anchor w
  entry $lf1.fs.e -textvar v(waveScale) -wi 6 -validate key -validatecommand {
    if {![isDouble %P] || ![string is integer %P]} {return 0}
    if {%P < 0 || %P > 32768} {return 0}
    return 1
  }
  pack $lf1.fs.l $lf1.fs.e  -side left

  #;# TvOg̐ݒ
  #pack [frame $lf1.f20] -anchor w
  #label $lf1.f20.l -text $t(settings,sampleRate) -wi 35 -anchor w
  #entry $lf1.f20.e -textvar v(sampleRate) -wi 6 -validate key -validatecommand {
  #  if {![isDouble %P] || ![string is integer %P]} {return 0}
  #  if {%P < 0} {return 0}
  #  return 1
  #}
  #pack $lf1.f20.l $lf1.f20.e  -side left

  ;#---------------------------
  ;# XyNgp[^
  set lf2 [labelframe $frame1.lf2 -text $t(settings,spec) \
    -relief groove -padx 5 -pady 5]
  pack $lf2 -anchor w -fill x

  ;# XyNg̔zF
  pack [frame $lf2.f45] -anchor w
  label $lf2.f45.l -text $t(settings,specColor) -width 20 -anchor w
  tk_optionMenu $lf2.f45.cm v(cmap) grey color1 color2
  pack $lf2.f45.l $lf2.f45.cm -side left

  ;# XyNgg̍ōl
  pack [frame $lf2.f20] -anchor w
  label $lf2.f20.l -text $t(settings,maxFreq) -width 20 -anchor w
  entry $lf2.f20.e -textvar v(topfr) -wi 6 -validate all -validatecommand {isDouble %P}
  scale $lf2.f20.s -variable v(topfr) -orient horiz \
    -from 0 -to [expr $v(sampleRate)/2] -showvalue 0
  pack $lf2.f20.l $lf2.f20.e $lf2.f20.s -side left

  ;# 邳
  pack [frame $lf2.f30] -anchor w
  label $lf2.f30.l -text $t(settings,brightness) -width 20 -anchor w
  entry $lf2.f30.e -textvar v(brightness) -wi 6 -validate all -validatecommand {isDouble %P}
  scale $lf2.f30.s -variable v(brightness) -orient horiz \
    -from -100 -to 100 -res 0.1 -showvalue 0
  pack $lf2.f30.l $lf2.f30.e $lf2.f30.s -side left

  ;# RgXg
  pack [frame $lf2.f31] -anchor w
  label $lf2.f31.l -text $t(settings,contrast) -width 20 -anchor w
  entry $lf2.f31.e -textvar v(contrast) -wi 6 -validate all -validatecommand {isDouble %P}
  scale $lf2.f31.s -variable v(contrast) -orient horiz \
    -from -100 -to 100 -res 0.1 -showvalue 0
  pack $lf2.f31.l $lf2.f31.e $lf2.f31.s -side left

  ;# FFT(K2ׂ̂ɂ邱)
  pack [frame $lf2.f32] -anchor w
  label $lf2.f32.l -text $t(settings,fftLength) -width 20 -anchor w
  tk_optionMenu $lf2.f32.om v(fftlen) 8 16 32 64 128 256 512 1024 2048 4096
  pack $lf2.f32.l $lf2.f32.om -side left

  ;# (KFFTȉɂ邱)
  pack [frame $lf2.f33] -anchor w
  label $lf2.f33.l -text $t(settings,fftWinLength) -width 20 -anchor w
  entry $lf2.f33.e -textvar v(winlen) -wi 6 -validate all -validatecommand {isDouble %P}
  scale $lf2.f33.s -variable v(winlen) -orient horiz \
    -from 8 -to 4096 -showvalue 0
  pack $lf2.f33.l $lf2.f33.e $lf2.f33.s -side left

  ;# vGt@VX
  pack [frame $lf2.f34] -anchor w
  label $lf2.f34.l -text $t(settings,fftPreemph) -width 20 -anchor w
  entry $lf2.f34.e -textvar v(preemph) -wi 6 -validate all -validatecommand {isDouble %P}
  pack $lf2.f34.l $lf2.f34.e -side left

  ;# ̑I
  pack [frame $lf2.f35] -anchor w
  label $lf2.f35.lwn -text $t(settings,fftWinKind) -width 20 -anchor w
  tk_optionMenu $lf2.f35.mwn v(window) \
    Hamming Hanning Bartlett Blackman Rectangle
  pack $lf2.f35.lwn $lf2.f35.mwn -side left

  ;#---------------------------
  ;# p[̐ݒ
  set lf3 [labelframe $frame1.lf3 -text $t(settings,pow) \
    -relief groove -padx 5 -pady 5]
  pack $lf3 -anchor w -fill x

  ;# p[F̐ݒ
  set cp [frame $lf3.f4p]
  setColor $cp "powcolor" $t(settings,powColor)
  pack $cp -anchor nw

  ;# p[o݂̐ݒ
  packEntryPower $lf3.ffl $t(settings,powLength) frameLength

  ;# vGt@VX̐ݒ
  packEntryPower $lf3.fem $t(settings,powPreemph) preemphasis

  ;# ̐ݒ
  packEntryPower $lf3.fwl $t(settings,winLength) windowLength

  ;# ̑I
  pack [frame $lf3.fwn] -anchor w
  label $lf3.fwn.lwn -text $t(settings,powWinKind) -width 20 -anchor w
  tk_optionMenu $lf3.fwn.mwn power(window) \
    Hamming Hanning Bartlett Blackman Rectangle
  pack $lf3.fwn.lwn $lf3.fwn.mwn -side left

  ;#---------------------------
  ;#---------------------------
  ;# 2Jڂ̃t[
  set frame2 [frame $swindow.r]
  pack $frame2 -side left -anchor n -fill both -expand true -padx 2 -pady 2

  ;#---------------------------
  ;# F0̐ݒ
  set lf4 [labelframe $frame2.lf4 -text $t(settings,f0) \
    -relief groove -padx 5 -pady 5]
  pack $lf4 -anchor w -fill x

  ;# F0F̐ݒ
  set cf [frame $lf4.f4f]
  setColor $cf "f0color" $t(settings,f0Color)
  pack $cf -anchor nw

  ;# oASY̑I
  pack [frame $lf4.p1] -anchor w
  label $lf4.p1.l -text $t(settings,f0Argo) -width 20 -anchor w
  tk_optionMenu $lf4.p1.mt f0(method) DIO+StoneMask SPTK-SWIPE pYIN ESPS AMDF
  pack $lf4.p1.l $lf4.p1.mt -side left

  ;# entry^̐ݒ肢낢
  packEntryF0 $lf4.p2 $t(settings,f0Length)    frameLength
  packEntryF0 $lf4.p3 $t(settings,f0WinLength) windowLength
  #packEntryF0 $lf4.p4 $t(settings,f0Max)       max
  #packEntryF0 $lf4.p5 $t(settings,f0Min)       min

  ;# \Pʂ̑I
  pack [frame $lf4.p6] -anchor w
  label $lf4.p6.l -text $t(settings,f0Unit) -width 20 -anchor w
  tk_optionMenu $lf4.p6.mt f0(unit) Hz semitone
  pack $lf4.p6.l $lf4.p6.mt -side left

  ;# e̐\
  checkbutton  $lf4.p8cb -text $t(settings,grid) \
    -variable f0(showToneLine) -onvalue 1 -offvalue 0 -anchor w
  pack $lf4.p8cb -anchor w -fill x

  ;#---------------------------
  ;# ̑̐ݒ
  set lf5 [labelframe $frame2.lf5 -text $t(settings,etc) \
    -relief groove -padx 5 -pady 5]
  pack $lf5 -anchor w -fill x

  #;# ĎԊu
  #pack [frame $lf5.f1] -anchor w
  #label $lf5.f1.l -text $t(settings,reload) -width 20 -anchor w
  #label $lf5.f1.l2 -textvar v(reloadSetting)  -anchor e
  #scale $lf5.f1.s -variable v(reloadSetting) -orient horiz \
  #  -from 0 -to 10 -res 1 -showvalue 0
  #pack $lf5.f1.l $lf5.f1.l2 $lf5.f1.s -side left

  ;# ݒ̎ۑ
  pack [frame $lf5.f2] -anchor w
  checkbutton $lf5.f2.cb -text $t(settings,autoSaveInitFile) \
    -variable v(autoSaveInitFile) -onvalue 1 -offvalue 0 -anchor w
  pack $lf5.f2.cb -side left

  ;# UTAU.exȅꏊw
  pack [frame $lf5.f3] -anchor w
  label $lf5.f3.l -text $t(settings,utau) -anchor w
  label $lf5.f3.l2 -textvar v(utauExe) -anchor e
  button $lf5.f3.bu -text $t(settings,ref) -command {
    set fn ""
    set fn [tk_getOpenFile -initialdir [file dirname $v(utauExe)] -initialfile [file tail $v(utauExe)] \
          -title $t(settings,chooseUtau) -defaultextension "exe" \
          -filetypes { {{exe file} {.exe}} {{All Files} {*}} }]
    if {$fn != "" && [file executable $fn]} {
      set v(utauExe) $fn
    } else {
      tk_messageBox -title $t(.confm.errTitle) -message $t(settings,err)
    }
    raise $swindow
  }
  pack $lf5.f3.l $lf5.f3.l2 $lf5.f3.bu -side left

  ;# ̑̊Og`GfB^̏ꏊݒ
  pack [frame $lf5.f4] -anchor w
  label $lf5.f4.l -text $t(settings,editor) -anchor w
  label $lf5.f4.l2 -textvar v(extEditor) -anchor e
  button $lf5.f4.bu -text $t(settings,ref) -command {
    set fn ""
    set fn [tk_getOpenFile -initialdir [file dirname $v(extEditor)] -initialfile [file tail $v(extEditor)] \
          -title $t(settings,chooseEditor) -defaultextension "exe" \
          -filetypes { {{exe file} {.exe}} {{All Files} {*}} }]
    if {$fn != "" && [file executable $fn]} {
      set v(extEditor) $fn
    } else {
      tk_messageBox -title $t(.confm.errTitle) -message $t(settings,err)
    }
    raise $swindow
  }
  pack $lf5.f4.l $lf5.f4.l2 $lf5.f4.bu -side left


  ;#---------------------------
  ;# OK, Apply, LZ{^
  pack [frame $frame2.f] -anchor e -side bottom -padx 2 -pady 2
  button $frame2.f.exit -text $t(.confm.c) -command {
    array set v     [array get v_bk]     ;# p[^ȑȌԂɖ߂
    array set power [array get power_bk] ;# p[^ȑȌԂɖ߂
    array set f0    [array get f0_bk]    ;# p[^ȑȌԂɖ߂
    setteingsReflection
    set v(reload) $v(reloadSetting)
    if {$v(reload) > 0 && [after info] == ""} autoReload
    destroy $swindow
  }
  button $frame2.f.app -text $t(.confm.apply) -command {
    setteingsReflection
    ;# p[^obNAbv̍XV
    array set v_bk     [array get v]     ;# p[^obNAbv
    array set power_bk [array get power] ;# p[^obNAbv
    array set f0_bk    [array get f0]    ;# p[^obNAbv
  }
  button $frame2.f.ok -text $t(.confm.ok) -wi 6 -command {
    setteingsReflection
    set v(reload) $v(reloadSetting)
    if {$v(reload) > 0 && [after info] == ""} autoReload
    destroy $swindow
  }
  pack $frame2.f.exit $frame2.f.app $frame2.f.ok -side right
}

#---------------------------------------------------
# ڍאݒOK̃{^Ƃ
#
proc setteingsReflection {} {
  global power f0 v
  set power(fid) ""  ;# p[Iɍĕ`悳
  set f0(fid)    ""  ;# F0Iɍĕ`悳
  if $v(showPow) {getPowerThread 1}
  if $v(showF0) {getF0Thread 1}
  Redraw all
}

#---------------------------------------------------
# fPʂɕϊ
#
proc beat2pixel {beat} {
  global v

  return [expr $beat * $v(wavepps) / ($v(bpm) / 60.0) + $v(bpmOffset) * $v(wavepps)]
}

#---------------------------------------------------
# LoXĕ`
#
proc Redraw {opt} {
  global v sv c cYaxis wscrl snd power f0 t

  # `撆͑̑삪łȂ悤ɂ
  # grab set $c
  # ꂪƑ̋hbOăTCYύXłȂȂ̂Ń{c

  ;# LoX̂̂폜čĒ
  set v(cHeight) [expr $v(waveh) + $v(spech) + $v(powh) + $v(f0h) + $v(timeh)]
  set cWholeWidth [expr int($v(sndLength) * $v(wavepps))]
  $c delete obj
  $c delete axis
  place configure $c -width [expr $v(cWidth) + 4] -height $v(cHeight)
  place configure $cYaxis -height $v(cHeight)
  place configure $wscrl -width $v(cWidth)
  $c configure -height $v(cHeight) -width $v(cWidth)
  $c configure -scrollregion [list 0 0 $cWholeWidth $v(cHeight)]
  $c configure -bg #ffffff
  $c create line 0 0 $cWholeWidth 0 -tags axis -fill $v(fg)
  set cYaxisOF 2  ;# $c$cYaxisgridŔzuƂɈʒûł̕ϐŕ␳
  $cYaxis delete axis
  $cYaxis configure -height $v(cHeight)
  $cYaxis create line 0 $cYaxisOF $v(yaxisw) $cYaxisOF -tags axis -fill $v(fg)
  $cYaxis create line $v(yaxisw) 0 $v(yaxisw) $v(cHeight) -tags axis -fill $v(fg)

  set ytop 0

  ;# wavt@CƂ̏
  if {$v(sndLength) <= 0} {
    $c create text [expr $v(cWidth) / 2 + $cWholeWidth * [lindex [$wscrl get] 0]] [expr $v(cHeight) / 2] \
        -text "wave file not found" -font v(sfont) -fill #0000a0 -anchor center -tags obj
    if {$v(reload) <= 0} {
      $c create text [expr $v(cWidth) / 2 + $cWholeWidth * [lindex [$wscrl get] 0]] [expr $v(cHeight) / 2 + 20] \
          -text "Auto reload is currently disabled." -font v(sfont) -fill #0000a0 -anchor center -tags obj
    }
    return
  }

  ;# Ԏ\
  if {$v(sndLength) > 0} {
    set ylow [expr $ytop + $v(timeh)]
    $c create rectangle 0 $ytop $cWholeWidth $ylow -fill #d0d0d0 -tags axis
    $c create rectangle 0 $ytop [beat2pixel 0] $ylow -fill #a0b0a0 -tags axis
    if {$v(timeUnit) == "Sec."} {
      ;# Ԏ(P=b)
      snack::timeAxis $c [beat2pixel 0] $ytop $cWholeWidth $v(timeh) $v(wavepps) \
        -tags axis -starttime 0 -fill $v(fg)
      $c create line 0 $ylow $cWholeWidth $ylow -tags axis
    } else {
      # ߒPʂ̎Ԏ\
      set b  [expr - $v(barPre)]  ;# ݂̔[P=]
      set bp [beat2pixel $b] ;# ݂̔[P=pixel]
      set onebp [expr [beat2pixel 1]    - [beat2pixel 0]] ;# 4̒[P=pixel]
      set bp4   [expr $onebp * 4]                         ;# 1߂̒[P=pixel]
      set bp16  [expr $bp4 * 4]                           ;# 4߂̒[P=pixel]
      set hbp   [expr [beat2pixel 0.5]  - [beat2pixel 0]] ;# 8̒[P=pixel]
      set hhbp  [expr [beat2pixel 0.25] - [beat2pixel 0]] ;# 16̒[P=pixel]
      set vlbtmShrt [expr $ylow - $v(timeh) / 4]
      set vlbtm     [expr $ylow - $v(timeh) / 2]
      while {$bp < $cWholeWidth} {
        if {$bp16 >= 16 && [expr $b % 16] == 0} {
          ;# 4ߖ̋؂
          $c create line $bp $v(cHeight) $bp 0     -tags axis -fill #ff7d7d
          $c create text [expr $bp + 6] $vlbtm -text [expr $b / 4]  -tags axis -fill $v(fg) \
            -font $v(sfont) -anchor center
        } elseif {$bp4 >= 16 && [expr $b % 4] == 0} {
          ;# 1ߖ̏c
          $c create line $bp $v(cHeight) $bp 0     -tags axis -fill #ff7dfc
          $c create text [expr $bp + 6] $vlbtm -text [expr $b / 4]  -tags axis -fill $v(fg) \
            -font $v(sfont) -anchor center
        } elseif {$onebp >= 16} {
          ;# 1̏c
          $c create line $bp $v(cHeight) $bp $vlbtm     -tags axis -fill #a095ff
        }
        if {$hbp >= 16} {
          ;# 8̏c
          set bph [expr $bp + $hbp]
          $c create line $bph $ylow $bph $vlbtmShrt -tags axis -fill blue

          ;# 16̏c
          if {$hhbp >= 16} {
            set bphh [expr $bp + $hhbp]
            $c create line $bphh $ylow $bphh $vlbtmShrt -tags axis -fill #a000a0
            set bphh [expr $bp + $hhbp + $hbp]
            $c create line $bphh $ylow $bphh $vlbtmShrt -tags axis -fill #a000a0
          }
        }
        incr b
        set bp [beat2pixel $b]
      }
      incr y $v(timeh)
      $c create line 0 $ytop $cWholeWidth $ytop -tags axis -fill $v(fg)
      $c create line 0 $ylow $cWholeWidth $ylow -tags axis -fill $v(fg)
      $c raise param
    }

    ;# Ԏx
    $cYaxis create rectangle 0 [expr $ytop + $cYaxisOF] $v(yaxisw) [expr $ylow + $cYaxisOF] -fill #d0d0d0 -tags axis
    $cYaxis create text 4 [expr $ytop + $cYaxisOF + 2] -text $v(timeUnit) \
      -font $v(sfont) -anchor nw -tags axis -fill $v(fg)
  }
  set ytop [expr $ytop + $v(timeh)]

  ;# g`\
  if {$v(showWave)} {
    $c create waveform $v(wavOffsetPixel) $ytop -sound snd -height $v(waveh) -width $cWholeWidth \
      -tags [list obj wave] -debug $::debug -fill $v(wavColor) \
      -pixelspersecond $v(wavepps) -limit $v(waveScale)
    $c lower wave
    if {$v(waveScale) > 0} {
      $cYaxis create text $v(yaxisw) [expr $ytop + 4] -text $v(waveScale) \
        -font $v(sfont) -anchor ne -tags axis -fill #0000b0
      $cYaxis create text $v(yaxisw) [expr $ytop + $v(waveh) * 0.5] -text [snd max] \
        -font $v(sfont) -anchor se -tags axis -fill $v(fg)
      $cYaxis create text $v(yaxisw) [expr $ytop + $v(waveh) * 0.5 + 14] -text [snd min] \
        -font $v(sfont) -anchor se -tags axis -fill $v(fg)
    } else {
      $cYaxis create text $v(yaxisw) [expr $ytop + 4] -text [snd max] \
        -font $v(sfont) -anchor ne -tags axis -fill $v(fg)
      $cYaxis create text $v(yaxisw) [expr $ytop + $v(waveh)] -text [snd min] \
        -font $v(sfont) -anchor se -tags axis -fill $v(fg)
    }

    set ylow [expr $ytop + $v(waveh)]
    $c create line 0 $ylow $cWholeWidth $ylow -tags axis -fill $v(fg)
    set yAxisLow [expr $ytop + $v(waveh) + $cYaxisOF]
    $cYaxis create line 0 $yAxisLow $v(yaxisw) $yAxisLow -tags axis -fill $v(fg)
#    $c create line $v(yaxisw) 0 $v(yaxisw) $v(waveh) -tags axis -fill $v(fg)
  }
  set ytop [expr $ytop + $v(waveh)]

  ;# XyNg\
  if {$v(showSpec)} {
    set ylow [expr $ytop + $v(spech)]
    if {$v(winlen) > $v(fftlen)} {
      set v(winlen) $v(fftlen)
    }
    if {$cWholeWidth < 30000} {
      $c create spectrogram $v(wavOffsetPixel) $ytop -sound snd -height $v(spech) \
        -width $cWholeWidth -tags [list obj spec] -debug $::debug \
        -fftlength $v(fftlen) -winlength $v(winlen) -windowtype $v(window) \
        -topfr $v(topfr) -contrast $v(contrast) -brightness $v(brightness) \
        -preemph $v(preemph) -colormap $sv($v(cmap)) -topfrequency $v(topfr) \
        -pixelspersecond $v(wavepps)
    } else {
      ;# \bȏwaṽXyNgg\ꍇAt[Gϊ̉񐔂𕡐ɕĕ\
      set sl [expr $v(sndLength) - $v(wavOffsetSec)]
      for {set sLen [expr $sl / 2.0]} {[expr $sLen * $v(wavepps)] >= 30000} {set sLen [expr $sLen / 2.0]} {}
      set sWidth [expr int($sLen * $v(wavepps) + 0.5)]
      for {set wt 0} {$wt < $sl} {set wt [expr $wt + $sLen]} {
        set wavX [expr int($v(wavepps) * $wt + $v(wavOffsetPixel) + 0.5)]
        set wavS [expr int($v(sampleRate) * $wt)]
        set wavE [expr int($v(sampleRate) * ($wt + $sLen))]
        $c create spectrogram $wavX $ytop -sound snd -height $v(spech) \
          -start $wavS -end $wavE -width $sWidth \
          -tags [list obj spec] -debug $::debug \
          -fftlength $v(fftlen) -winlength $v(winlen) -windowtype $v(window) \
          -topfr $v(topfr) -contrast $v(contrast) -brightness $v(brightness) \
          -preemph $v(preemph) -colormap $sv($v(cmap)) -topfrequency $v(topfr) \
          -pixelspersecond $v(wavepps)
      }
    }
    $c lower spec
    snack::frequencyAxis $cYaxis 0 [expr $ytop + $cYaxisOF] $v(yaxisw) $v(spech) \
          -topfr $v(topfr) -tags axis -font $v(sfont)
    $c create line 0 $ylow $cWholeWidth $ylow -tags axis
    set yAxisLow [expr $ylow + $cYaxisOF]
    $cYaxis create line 0 $yAxisLow $v(yaxisw) $yAxisLow -tags axis -fill $v(fg)
#    $c create line $v(yaxisw) $v(waveh) $v(yaxisw) $ylow -tags axis -fill $v(fg)
  }
  set ytop [expr $ytop + $v(spech)]

  ;# p[\
  if {$v(showPow)} {
    set ylow [expr $ytop + $v(powh)]
    ;# p[𓾂
    if {[tsv::get power status] != 0} {
      set power(power) {}   ;# o or oG[̂Ƃ
    } else {
      foreach key {power powerMax powerMin} {
        if {[tsv::exists power $key]} {
          set power($key) [tsv::get power $key]
        }
      }
      ;# p[𒊏oȂFIDL^
      ;# koko, $power(fname)  $power(mtimeSec)Ɉڍsǂ
      if {$power(fid) != $v(recLab)} {
        set power(fid) $v(recLab)
      }
    }

    set pwN [llength $power(power)]
    if {$pwN > 0} {
      # ppd= 1dB̃sNZB
      if {[expr $power(powerMax) - $power(powerMin)] > 0} {
        set ppd [expr double($v(powh)) / ($power(powerMax) - $power(powerMin))]
      } else {
        set ppd 0
      }

      set pwXold $v(wavOffsetPixel)
      set pwYold [expr $ylow - ([lindex $power(power) 0] - $power(powerMin)) * $ppd]
      set a [expr $power(frameLength) * $v(wavepps)]
      for {set i 0} {$i < $pwN} {incr i} {
        set pwX [expr $i * $a + $v(wavOffsetPixel)]
        set pw  [lindex $power(power) $i]
        if {$pw > 0} {
          set pwY [expr $ylow - ($pw - $power(powerMin)) * $ppd]
        } else {
          set pwY $ylow
        }
        $c create line $pwXold $pwYold $pwX $pwY -tags {obj pow} -fill $v(powcolor)
        set pwXold $pwX
        set pwYold $pwY
      }

      # \
      myAxis $cYaxis 0 [expr $ytop + $cYaxisOF] $v(yaxisw) $v(powh) \
        -max $power(powerMax) -tags axis -fill $v(fg) \
        -font $v(sfont) -min $power(powerMin) -unit dB
    }

    $c create line 0 $ylow $cWholeWidth $ylow -tags axis
#    $c create line $v(yaxisw) $ytop $v(yaxisw) $ylow -tags axis -fill $v(fg)
    set yAxisLow [expr $ylow + $cYaxisOF]
    $cYaxis create line 0 $yAxisLow $v(yaxisw) $yAxisLow -tags axis -fill $v(fg)

    ;# ݃p[ȍꍇ
    if {[tsv::get power status] == 1} {
      $c create rectangle 0 $ytop $cWholeWidth $ylow -fill #d0d0d0 -tags obj
      $c create text [expr $v(cWidth) / 2 + $cWholeWidth * [lindex [$wscrl get] 0]] [expr ($ytop + $ylow) / 2] \
          -text "now extracting..." -font v(sfont) -fill #0000a0 -anchor center -tags obj
    ;# oG[̂Ƃ
    } elseif {[tsv::get power status] == 2} {
      $c create text [expr $v(cWidth) / 2 + $cWholeWidth * [lindex [$wscrl get] 0]] [expr ($ytop + $ylow) / 2] \
          -text "ERROR" -font v(sfont) -fill #0000a0 -anchor center -tags obj
    }
  }
  set ytop [expr $ytop + $v(powh)]

  ;# F0\
  if $v(showF0) {
    set ylow [expr $ytop + $v(f0h)]
    ;# F0𓾂
    array set f0plot [array get f0]     ;# ݂F0̐ݒlRs[
    if {[tsv::get f0 status] != 0} {
      set f0plot(f0) {}   ;# o or oG[̂Ƃ
    } else {
      foreach key {f0 extractedMax extractedMin showMax showMin} {
        set f0plot($key) [tsv::get f0 $key]
      }
      if {$f0plot(unit) == "semitone"} {
        set seriestmp {}
        foreach i $f0plot(f0) {
          lappend seriestmp [hz2semitone $i]
        }
        set f0plot(f0) $seriestmp
        foreach key {extractedMax extractedMin showMax showMin} {
          set f0plot($key) [hz2semitone $f0plot($key)]
        }
      }

      ;# F0𒊏oȂFIDL^
      ;# koko, $f0(fname)  $f0(mtimeSec)Ɉڍsǂ
      if {$f0(fid) != $v(recLab)} {
        set f0(fid) $v(recLab)
      }
    }

    if {$f0plot(extractedMax) > $f0plot(extractedMin) && $f0plot(extractedMin) >= 0} {
      # ppd= 1Hz̃sNZB4͏㉺e2sNZ̃}[W
      if {$f0plot(fixShowRange)} {
        set ppd [expr double($v(f0h)) / ($f0plot(showMax) - $f0plot(showMin))]
      } else {
        if {$f0plot(unit) == "semitone"} {
          set f0plot(extractedMax) [expr $f0plot(extractedMax) + 1]
          set f0plot(extractedMin) [expr $f0plot(extractedMin) - 1]
        } else {
          set f0plot(extractedMax) [expr $f0plot(extractedMax) * (13.0 / 12.0)]
          set f0plot(extractedMin) [expr $f0plot(extractedMin) / (13.0 / 12.0)]
        }
        set ppd [expr double($v(f0h)) / ($f0plot(extractedMax) - $f0plot(extractedMin))]
      }

      # eɑΉgŉ
      if $f0plot(showToneLine) {
        for {set i 0} {$i < [llength $sv(sinScale)]} {incr i} {
          if {$f0plot(unit) == "semitone"} {
            set tgt [hz2semitone [lindex $sv(sinScale) $i]]
          } else {
            set tgt [lindex $sv(sinScale) $i]
          }
          set y1 [expr $ylow - ($tgt - $f0plot(extractedMin)) * $ppd]
          if {$y1 <= [expr $ylow - $v(f0h)]} break
          if {$y1 < $ylow} {
            set tt  [expr $i % 12]
            if {$tt == 1 || $tt == 3 || $tt == 6 || $tt == 8 || $tt == 10} {
              $c create line 0 $y1 $cWholeWidth $y1 -tags axis -fill #50c0f0 -stipple gray50
            } else {
              $c create line 0 $y1 $cWholeWidth $y1 -tags axis -fill #f0c0a0
            }
          }
        }
      }

      # F0f[^vbg
      # set coord {} ;# F0ȐW(x,y)
      set f0tags {obj f0}
      for {set i 0} {$i < [llength $f0plot(f0)]} {incr i} {
        # lappend coord \
        #   [expr $i * $f0plot(frameLength) * $v(wavepps)] \
        #   [expr $ylow - ([lindex $f0plot(f0) $i] - $f0plot(f0Min)) * $ppd]
        if {[lindex $f0plot(f0) $i] > 0} {
          set x1 [expr $i * $f0plot(frameLength) * $v(wavepps) - 1 + $v(wavOffsetPixel)]
          set y1 [expr $ylow - ([lindex $f0plot(f0) $i] - $f0plot(extractedMin)) * $ppd - 1]
          set x2 [expr $x1 + 2]
          set y2 [expr $y1 + 2]
          if {$y1 <= $ylow && $y1 >= [expr $ylow - $v(f0h)]} {
            $c create oval $x1 $y1 $x2 $y2 -tags $f0tags -fill $v(f0color) -outline $v(f0color)
          }
        }
      }
    }
#      eval {$c create line} $coord -tags {$f0tags} -fill $v(f0color)
    # \
    myAxis $cYaxis 0 [expr $ytop + $cYaxisOF] $v(yaxisw) $v(f0h) \
      -tags axis -fill $v(fg) -font $v(sfont) \
      -max $f0plot(extractedMax) -min $f0plot(extractedMin) -unit $f0plot(unit)

    # 
    $c create line 0 $ylow $cWholeWidth $ylow -tags axis
#    $c create line $v(yaxisw) $ytop $v(yaxisw) $ylow -tags axis -fill $v(fg)
    set yAxisLow [expr $ylow + $cYaxisOF]
    $cYaxis create line 0 $yAxisLow $v(yaxisw) $yAxisLow -tags axis -fill $v(fg)

    ;# F0ȍꍇ
    if {[tsv::get f0 status] == 1} {
      $c create rectangle 0 $ytop $cWholeWidth $ylow -fill #d0d0d0 -tags obj
      $c create text [expr $v(cWidth) / 2 + $cWholeWidth * [lindex [$wscrl get] 0]] [expr ($ytop + $ylow) / 2] \
          -text "now extracting..." -font v(sfont) -fill #0000a0 -anchor center -tags obj
    ;# oG[̏ꍇ
    } elseif {[tsv::get f0 status] == 2} {
      $c create text [expr $v(cWidth) / 2 + $cWholeWidth * [lindex [$wscrl get] 0]] [expr ($ytop + $ylow) / 2] \
          -text "ERROR" -font v(sfont) -fill #0000a0 -anchor center -tags obj
    }
  }
  set ytop [expr $ytop + $v(f0h)]

  $c raise regions
  ;# grab
  ;#  grab release $c
}

#---------------------------------------------------
# p[̒o(ʃXbh)
#
proc getPowerThread {{force 0}} {
  global v power

  foreach key {frameLength window preemphasis windowLength} {
    tsv::set power $key $power($key)
  }
  tsv::set power sampleRate $v(sampleRate)
  ::thread::send -async [tsv::get tid power] "getPower $v(inWav) $v(inWavMtimeSec) $force"
}

#---------------------------------------------------
# F0̒o(ʃXbh)
#
proc getF0Thread {{force 0}} {
  global v f0 topdir

  foreach key {method frameLength windowLength max min fixShowRange showMax showMin} {
    tsv::set f0 $key $f0($key)
  }
  tsv::set f0 sampleRate $v(sampleRate)
  ::thread::send -async [tsv::get tid f0] "getF0 $v(inWav) $v(inWavMtimeSec) $topdir $force"
}

#---------------------------------------------------
# }EXxWg`̉sec̏ɑ邩Ԃ
#
proc point2micro {x} {
  global v t
  ;# x_ȉ3܂łɂ(44.1kHẑƂ1sample0.000023b)
  return [ \
    expr int(1000000 * $v(sndLength) * ($x - [winfo width .s]) / double($v(cWidth))) \
  ]
}

#---------------------------------------------------
# }EXxWg`̉sec̏ɑ邩Ԃ
#
proc point2sec {x} {
  global v t wscrl

  set cLeft  [lindex [$wscrl get] 0]
  set cLeftPoint [expr $v(sndLength) * $cLeft * $v(wavepps)]

  return [ expr double($cLeftPoint + $x) / double($v(wavepps)) ]
}

#---------------------------------------------------
# _ȉ6őł؂
#
proc cut6 {val} {
  return [expr int($val * 1000000) / 1000000.0 ]
}

#---------------------------------------------------
# _ȉ3őł؂
#
proc cut3 {val} {
  return [expr int($val * 1000) / 1000.0 ]
}

#---------------------------------------------------
# t@CۑďI
#
proc Exit {} {
  global v t startup
  saveSysIniFile               ;# init@Cۑ
  if {$v(autoSaveInitFile)} {
    saveSettings $startup(initFile)
  }
  catch {::thread::send -async [tsv::get tid power] "::thread::unwind"}
  catch {::thread::send -async [tsv::get tid f0] "::thread::unwind"}
  destroy .
  exit
}

#---------------------------------------------------
# Iׂ͈͂č폜
#
proc clearRegion {} {
  global c
  $c delete regions
}

#---------------------------------------------------
# ENbNj[
#
proc PopUpMenu {X Y x y} {
  global v rclickMenu rclickMenuZ rclickMenuP rclickMenuG t

  $rclickMenu delete 0 end
  $rclickMenu add cascade -label $t(PopUpMenu,zoomTitle) -menu $rclickMenuZ
  $rclickMenu add separator
  $rclickMenu add cascade -label $t(PopUpMenu,gridTitle) -menu $rclickMenuG
  $rclickMenu add command -label $t(PopUpMenu,clearRegion) -command clearRegion
  $rclickMenu add separator
  $rclickMenu add cascade -label $t(PopUpMenu,paneTitle) -menu $rclickMenuP
  $rclickMenu add separator
  $rclickMenu add command -label $t(PopUpMenu,settings)   -command settings

  $rclickMenuP delete 0 end
  $rclickMenuP add checkbutton -variable v(showWave) -label $t(PopUpMenu,showWave) -command toggleWave
  $rclickMenuP add checkbutton -variable v(showSpec) -label $t(PopUpMenu,showSpec) -command toggleSpec
  $rclickMenuP add checkbutton -variable v(showPow)  -label $t(PopUpMenu,showPow) -command togglePow
  $rclickMenuP add checkbutton -variable v(showF0)   -label $t(PopUpMenu,showF0) -command toggleF0

  $rclickMenuZ delete 0 end
  $rclickMenuZ add command -label $t(PopUpMenu,zoomUTAU)  -command "autoSetTimeScale"
  $rclickMenuZ add command -label $t(PopUpMenu,zoom0)     -command "zoomX 0     $x"
  $rclickMenuZ add command -label $t(PopUpMenu,zoom100)   -command "zoomX 100   $x"
  $rclickMenuZ add command -label $t(PopUpMenu,zoom1000)  -command "zoomX 1000  $x"
  $rclickMenuZ add command -label $t(PopUpMenu,zoom5000)  -command "zoomX 5000  $x"
  $rclickMenuZ add command -label $t(PopUpMenu,zoom10000) -command "zoomX 10000 $x"
  $rclickMenuZ add command -label $t(PopUpMenu,zoomMax)   -command "zoomX -1    $x"
  $rclickMenuZ add command -label $t(PopUpMenu,changeZoomX) -command {changeZoomX}

  $rclickMenuG delete 0 end
  $rclickMenuG add radiobutton -variable v(gridNote) -value  1 -label $t(PopUpMenu,grid1)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  2 -label $t(PopUpMenu,grid2)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  4 -label $t(PopUpMenu,grid4)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  6 -label $t(PopUpMenu,grid6)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  8 -label $t(PopUpMenu,grid8)
  $rclickMenuG add radiobutton -variable v(gridNote) -value 12 -label $t(PopUpMenu,grid12)
  $rclickMenuG add radiobutton -variable v(gridNote) -value 16 -label $t(PopUpMenu,grid16)
  $rclickMenuG add radiobutton -variable v(gridNote) -value 24 -label $t(PopUpMenu,grid24)
  $rclickMenuG add radiobutton -variable v(gridNote) -value 32 -label $t(PopUpMenu,grid32)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  0 -label $t(PopUpMenu,grid0)

  catch {tk_popup $rclickMenu $X $Y}
}

#---------------------------------------------------
# o[W\
#
proc Version {} {
  global v sv t
  tk_messageBox -title $t(Version,msg) \
    -message "$sv(appname) version $sv(version)"
}

#---------------------------------------------------
# Pʕϊ
#
proc sec2samp {sec length} {
  if {[string length $sec] == 0 || [string length $length] == 0} {
    return 0
  }
  if {[string is double $sec] && [string is double $length]} {
    return [expr int(double($sec) / $length)]
  } else {
    return -1
  }
}

#---------------------------------------------------
# ꗗ\A{̑̃^CgXV
#
proc setEPWTitle {} {
  global v sv t

  if {[regexp {^.*/(utau[1-9]+)/} $v(inWav) dummy utaudir]} {
    regsub {^.*/utau[1-9]+/} $v(inWav) "$utaudir/" inWav
  } else {
    regsub {[a-z]:/Users/} $v(inWav) "~" inWav
  }
  set inWav "$inWav ($v(inWavMtime), $v(voice))"

  set maxlen 50
  if {[string length $inWav] <= $maxlen} {
    set fname $inWav
  } else {
    set fname [string range $inWav \
               [expr [string length $inWav] - $maxlen] end]
    set fname "...$fname"
  }
  wm title . "$sv(appname) $sv(version) - $fname"
}

#---------------------------------------------------
# t@Cgp̃XgXV
#
proc _updateFileHistory {_fileHistory inWav} {
  upvar $_fileHistory fileHistory
  global v startup

  # j[̗\XV
  set seq [lsearch -exact $fileHistory $inWav] 
  if {$seq == 0} {
    ;# ɕύXȂȂI
    return
  } elseif {$seq < 0} {
    ;# ɂȂt@CȂǉ
    set fileHistory [linsert $fileHistory 0 $inWav]
    if {[llength $fileHistory] > $v(fileHistoryMax)} {
      set fileHistory [lrange $fileHistory 0 end-1]
    }
  } else {
    ;# ɂt@CȂ珇Ԃς
    set fileHistory [lreplace $fileHistory $seq $seq]
    set fileHistory [linsert  $fileHistory 0 $inWav]
  }
}

#---------------------------------------------------
# t@CgpXV
#
proc updateFileHistory {} {
  global v startup

  _updateFileHistory v(fileHistory) $v(inWav)
  if {[regexp {^(.+)/} $v(inWav) dummy pDir]} {
    _updateFileHistory v(pDirHistory) $pDir
  }
  renewMenu
}

#---------------------------------------------------
# $v(appname)-settings.init@Cۑ
#
proc saveSysIniFile {} {
  global v startup

  if [catch {open $startup(sysIniFile) w} fp] {
    return
  }
  puts $fp "utauExe=$v(utauExe)  ; UTAUexet@C"
  puts $fp "inWav=$v(inWav)  ; ĎΏwavt@C"
  puts $fp "reload=$v(reload)  ; ĎԊuiPʂ͕bj"
  puts $fp "autoSaveInitFile=$v(autoSaveInitFile)  ; NɑOȈԂ𕜌"
  # t@Cɕۑ
  for {set i 0} {$i < [llength $v(fileHistory)]} {incr i} {
    puts $fp "fileHistory$i=[lindex $v(fileHistory) $i]"
  }
  for {set i 0} {$i < [llength $v(pDirHistory)]} {incr i} {
    puts $fp "pDirHistory$i=[lindex $v(pDirHistory) $i]"
  }
  close $fp
}

#---------------------------------------------------
# settingss.init@Cǂ
#
proc readSysIniFile {} {
  global v startup

  set v(fileHistory) {}
  set v(pDirHistory) {}
  if [catch {open $startup(sysIniFile) r} fp] { 
    return
  }
  while {![eof $fp]} {
    set l [gets $fp]
    regexp {^([^;]*);.*$} $l dummy l  ;# Rg폜
    set l [string trim $l]
    if {[regexp {^utauExe *= *(.+)$} $l dummy utauExe]} {
      set v(utauExe) $utauExe
    } elseif {[regexp {^inWav *= *(.+)$} $l dummy inWav]} {
      set v(inWav) $inWav
    } elseif {[regexp {^reload *= *(.+)$} $l dummy reload]} {
      set v(reload) $reload
    } elseif {[regexp {^autoSaveInitFile *= *(.+)$} $l dummy autoSaveInitFile]} {
      set v(autoSaveInitFile) $autoSaveInitFile
    } elseif {[regexp {^fileHistory([0-9]+) *= *(.+)$} $l dummy seq rfile]} { ;# t@Cǂݍ
      set v(fileHistory) [linsert $v(fileHistory) $seq $rfile]
    } elseif {[regexp {^pDirHistory([0-9]+) *= *(.+)$} $l dummy seq dir]} { ;# etH_ǂݍ
      set v(pDirHistory) [linsert $v(pDirHistory) $seq $dir]
    }
  }
  close $fp
}

#---------------------------------------------------
# ŋߊJt@CJ
#
proc openRecentFile {fname} {
  global v t

  if [file isdirectory $fname] {
    ;# $fnameɃfBNgĂꍇ
    set initdir $fname
    set initfile "temp.wav"
    set fn [tk_getOpenFile -initialdir $initdir -initialfile $initfile \
            -title $t(file,getWavFileName) -defaultextension "wav" \
            -filetypes { {{WAV file} {.wav}} {{All Files} {*}} }]
    if {$fn == ""} return
    set fname $fn
  }
  openWavFile $fname
}

#---------------------------------------------------
# j[\eXV
#
proc renewMenu {} {
  global t v clickMenuFileC clickMenuFileC2

  $clickMenuFileC delete 0 end
  for {set i 0} {$i < [llength $v(fileHistory)]} {incr i} {
    set d [lindex $v(fileHistory) $i]
    $clickMenuFileC add command -label "$i: $d" -command "openRecentFile \"$d\""
  }
  $clickMenuFileC2 delete 0 end
  for {set i 0} {$i < [llength $v(pDirHistory)]} {incr i} {
    set d [lindex $v(pDirHistory) $i]
    $clickMenuFileC2 add command -label "$i: $d" -command "openRecentFile \"$d\""
  }
}

#---------------------------------------------------
# t@Cj[
#
proc PopUpMenuFile {X Y} {
  global v clickMenuFile clickMenuFileC clickMenuFileC2 t

  $clickMenuFile delete 0 end
  $clickMenuFile add command -label $t(file,getWavFileName) -command {
    set fname [getWavFileName]
    if {$fname != ""} {
      openWavFile $fname
    }
  }
  $clickMenuFile add cascade -label $t(file,fileHistory) -menu $clickMenuFileC
  $clickMenuFile add cascade -label $t(file,pDirHistory) -menu $clickMenuFileC2
  $clickMenuFile add separator
  $clickMenuFile add command -label $t(file,readSettings) -command readSettings
  $clickMenuFile add command -label $t(file,saveSettings) -command saveSettings
  $clickMenuFile add separator
  $clickMenuFile add command -label $t(file,Exit)         -command Exit

  $clickMenuFileC delete 0 end
  for {set i 0} {$i < [llength $v(fileHistory)]} {incr i} {
    set d [lindex $v(fileHistory) $i]
    $clickMenuFileC add command -label "$i: $d" -command "openRecentFile \"$d\""
  }

  $clickMenuFileC2 delete 0 end
  for {set i 0} {$i < [llength $v(pDirHistory)]} {incr i} {
    set d [lindex $v(pDirHistory) $i]
    $clickMenuFileC2 add command -label "$i: $d" -command "openRecentFile \"$d\""
  }

  catch {tk_popup $clickMenuFile $X $Y}
}

#---------------------------------------------------
# \j[
#
proc PopUpMenuShow {X Y} {
  global v clickMenuShow clickMenuShowC clickMenuShowC2 t

  $clickMenuShow delete 0 end
  $clickMenuShow add cascade -label $t(show,zoomTitle) -menu $clickMenuShowC
  $clickMenuShow add cascade -label $t(show,timeAxis)  -menu $clickMenuShowC2
  $clickMenuShow add separator
  $clickMenuShow add checkbutton -label $t(PopUpMenu,showWave) -variable v(showWave) -command toggleWave
  $clickMenuShow add checkbutton -label $t(PopUpMenu,showSpec) -variable v(showSpec) -command toggleSpec
  $clickMenuShow add checkbutton -label $t(PopUpMenu,showPow)  -variable v(showPow)  -command togglePow
  $clickMenuShow add checkbutton -label $t(PopUpMenu,showF0)   -variable v(showF0)   -command toggleF0
  $clickMenuShow add separator
  $clickMenuShow add checkbutton -label $t(PopUpMenu,alwaysOnTop) -variable v(alwaysOnTop) -command {
    if {$v(alwaysOnTop)} {
      wm attributes . -topmost 1
    } else {
      wm attributes . -topmost 0
    }
  }
  $clickMenuShow add command -label $t(PopUpMenu,setAlpha) -command setAlphaWindow

  $clickMenuShowC delete 0 end
  $clickMenuShowC add command -label $t(PopUpMenu,zoomUTAU)  -command "autoSetTimeScale"
  $clickMenuShowC add command -label $t(PopUpMenu,zoom0)     -command {zoomX     0 0}
  $clickMenuShowC add command -label $t(PopUpMenu,zoom100)   -command {zoomX   100 0}
  $clickMenuShowC add command -label $t(PopUpMenu,zoom1000)  -command {zoomX  1000 0}
  $clickMenuShowC add command -label $t(PopUpMenu,zoom5000)  -command {zoomX  5000 0}
  $clickMenuShowC add command -label $t(PopUpMenu,zoom10000) -command {zoomX 10000 0}
  $clickMenuShowC add command -label $t(PopUpMenu,zoomMax)   -command {zoomX    -1 0}
  $clickMenuShowC add command -label $t(PopUpMenu,changeZoomX) -command {changeZoomX}

  $clickMenuShowC2 delete 0 end
  $clickMenuShowC2 add radiobutton -label $t(show,timeAxisSec) -variable v(timeUnit) -value "Sec." -command { Redraw scale }
  $clickMenuShowC2 add radiobutton -label $t(show,timeAxisBar) -variable v(timeUnit) -value "Bar"  -command { Redraw scale ; setBPMWindow }
  $clickMenuShowC2 add separator
  $clickMenuShowC2 add command -label $t(setBPMWindow,title) -command setBPMWindow

  catch {tk_popup $clickMenuShow $X $Y}
}

#---------------------------------------------------
# IvVj[
#
proc PopUpMenuOptn {X Y} {
  global v clickMenuOptn rclickMenuG t

  $clickMenuOptn delete 0 end
  $clickMenuOptn add cascade -label $t(PopUpMenu,gridTitle) -menu $rclickMenuG
  $clickMenuOptn add command -label $t(PopUpMenu,reload)    -command setReloadWindow
  $clickMenuOptn add command -label $t(option,ioSettings)   -command ioSettings
  $clickMenuOptn add command -label $t(option,settings)     -command settings

  $rclickMenuG delete 0 end
  $rclickMenuG add radiobutton -variable v(gridNote) -value  1 -label $t(PopUpMenu,grid1)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  2 -label $t(PopUpMenu,grid2)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  4 -label $t(PopUpMenu,grid4)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  6 -label $t(PopUpMenu,grid6)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  8 -label $t(PopUpMenu,grid8)
  $rclickMenuG add radiobutton -variable v(gridNote) -value 12 -label $t(PopUpMenu,grid12)
  $rclickMenuG add radiobutton -variable v(gridNote) -value 16 -label $t(PopUpMenu,grid16)
  $rclickMenuG add radiobutton -variable v(gridNote) -value 24 -label $t(PopUpMenu,grid24)
  $rclickMenuG add radiobutton -variable v(gridNote) -value 32 -label $t(PopUpMenu,grid32)
  $rclickMenuG add radiobutton -variable v(gridNote) -value  0 -label $t(PopUpMenu,grid0)

  catch {tk_popup $clickMenuOptn $X $Y}
}

#---------------------------------------------------
# wvj[
#
proc PopUpMenuHelp {X Y} {
  global v clickMenuHelp t

  $clickMenuHelp delete 0 end
  $clickMenuHelp add command -label $t(help,Version)   -command Version
  $clickMenuHelp add command -label $t(help,official1) -command {execExternal http://freett.com/nwp8861/soft/utawaview/}
  $clickMenuHelp add command -label $t(help,official2) -command {execExternal http://sourceforge.jp/users/nwp8861/pf/utawaview/files/}

  catch {tk_popup $clickMenuHelp $X $Y}
}

#---------------------------------------------------
# usage
#
proc usage {} {
  global argv0 t
  puts "usage: $argv0 "
}

