#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>

#include "cmp.h"

static bool file_reader(cmp_ctx_t *ctx, void *data, size_t count) {
	return std::fread(data, sizeof(uint8_t), count, static_cast<FILE *>(ctx->buf)) == (count * sizeof(uint8_t));
}

static size_t file_writer(cmp_ctx_t *ctx, const void *data, size_t count) {
	return std::fwrite(data, sizeof(uint8_t), count, static_cast<FILE *>(ctx->buf));
}

struct cmp_buffer{
	std::vector<std::pair<cmp_object_s, int> > buf;
	std::vector<std::vector<uint8_t> > data_buf;

	bool read_object(cmp_ctx_t &ctx){
		buf.push_back(std::pair<cmp_object_s, int>());
		std::pair<cmp_object_s, int> &itm = buf.back();
		if (!::cmp_read_object(&ctx, &itm.first)){
			buf.pop_back();
			return false;
		}
		uint32_t sz;
		if (::cmp_object_is_str(&itm.first)){
			sz = itm.first.as.str_size;
		}else if (::cmp_object_is_bin(&itm.first)){
			sz = itm.first.as.bin_size;
		}else if (::cmp_object_is_ext(&itm.first)){
			sz = itm.first.as.ext.size;
		}else{
			itm.second = -1;
			return true;
		}
		itm.second = static_cast<int>(data_buf.size());
		std::vector<uint8_t> &cur = (data_buf.push_back(std::vector<uint8_t>()), data_buf.back());
		cur.resize(sz);
		ctx.read(&ctx, &cur[0], cur.size());
		return true;
	}
	std::pair<cmp_object_s, int> &back(){
		return buf.back();
	}
};

int main(void) {
	FILE *fp = fopen("cmp_data.dat", "w+b");
    if (!fp) return 1;

	// MessagePackf[^
    cmp_ctx_t cmp;
	::cmp_init(&cmp, fp, file_reader, file_writer);

    if (!cmp_write_array(&cmp, 3))               return 1;
    if (!cmp_write_str(&cmp, "Hello", 5))        return 1;
    if (!cmp_write_str(&cmp, "MessagePack", 11)) return 1;
    if (!cmp_write_bin(&cmp, "BinaryHoge", 10))  return 1;

	std::rewind(fp);
	// MessagePackf[^܂

	do{
		cmp_buffer cbuf;
		while (cbuf.read_object(cmp)){
			// B
		}
	}while(0);

	std::fclose(fp);

    return 0;
}

