/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceIdentityLinkResource
extends BaseProcessInstanceResource {
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/identitylinks/users/{identityId}/{type}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RestIdentityLink getIdentityLink(@PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="identityId") String identityId, @PathVariable(value="type") String type, HttpServletRequest request) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        this.validateIdentityLinkArguments(identityId, type);
        IdentityLink link = this.getIdentityLink(identityId, type, processInstance.getId());
        return this.restResponseFactory.createRestIdentityLink(link);
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/identitylinks/users/{identityId}/{type}"}, method={RequestMethod.DELETE})
    public void deleteIdentityLink(@PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="identityId") String identityId, @PathVariable(value="type") String type, HttpServletResponse response) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        this.validateIdentityLinkArguments(identityId, type);
        this.getIdentityLink(identityId, type, processInstance.getId());
        this.runtimeService.deleteUserIdentityLink(processInstance.getId(), identityId, type);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void validateIdentityLinkArguments(String identityId, String type) {
        if (identityId == null) {
            throw new ActivitiIllegalArgumentException("IdentityId is required.");
        }
        if (type == null) {
            throw new ActivitiIllegalArgumentException("Type is required.");
        }
    }

    protected IdentityLink getIdentityLink(String identityId, String type, String processInstanceId) {
        List allLinks = this.runtimeService.getIdentityLinksForProcessInstance(processInstanceId);
        for (IdentityLink link : allLinks) {
            if (!identityId.equals(link.getUserId()) || !link.getType().equals(type)) continue;
            return link;
        }
        throw new ActivitiObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

