/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.mule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.scripting.ScriptingEngines;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.util.IOUtils;

public class MuleSendActivitiBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    private MuleContext muleContext;
    private Expression endpointUrl;
    private Expression language;
    private Expression payloadExpression;
    private Expression resultVariable;
    private Expression username;
    private Expression password;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ActivityExecution execution) throws Exception {
        String endpointUrlValue = this.getStringFromField(this.endpointUrl, (DelegateExecution)execution);
        String languageValue = this.getStringFromField(this.language, (DelegateExecution)execution);
        String payloadExpressionValue = this.getStringFromField(this.payloadExpression, (DelegateExecution)execution);
        String resultVariableValue = this.getStringFromField(this.resultVariable, (DelegateExecution)execution);
        String usernameValue = this.getStringFromField(this.username, (DelegateExecution)execution);
        String passwordValue = this.getStringFromField(this.password, (DelegateExecution)execution);
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        Object payload = scriptingEngines.evaluate(payloadExpressionValue, languageValue, (VariableScope)execution);
        if (endpointUrlValue.startsWith("vm:")) {
            LocalMuleClient client = this.getMuleContext().getClient();
            DefaultMuleMessage message = new DefaultMuleMessage(payload, this.getMuleContext());
            MuleMessage resultMessage = client.send(endpointUrlValue, (MuleMessage)message);
            Object result = resultMessage.getPayload();
            if (resultVariableValue != null) {
                execution.setVariable(resultVariableValue, result);
            }
        } else {
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            if (usernameValue != null && passwordValue != null) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(usernameValue, passwordValue);
                provider.setCredentials(new AuthScope("localhost", -1, "mule-realm"), (Credentials)credentials);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            }
            CloseableHttpClient client = clientBuilder.build();
            HttpPost request = new HttpPost(endpointUrlValue);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(payload);
                oos.flush();
                oos.close();
                request.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray()));
            }
            catch (Exception e) {
                throw new ActivitiException("Error setting message payload", (Throwable)e);
            }
            byte[] responseBytes = null;
            try {
                HttpResponse response = client.execute((HttpUriRequest)request);
                responseBytes = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            }
            finally {
                request.releaseConnection();
            }
            if (responseBytes != null) {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(responseBytes);
                    ObjectInputStream is = new ObjectInputStream(in);
                    Object result = is.readObject();
                    if (resultVariableValue != null) {
                        execution.setVariable(resultVariableValue, result);
                    }
                }
                catch (Exception e) {
                    throw new ActivitiException("Failed to read response value", (Throwable)e);
                }
            }
        }
        this.leave(execution);
    }

    protected MuleContext getMuleContext() {
        if (this.muleContext == null) {
            Map beans = Context.getProcessEngineConfiguration().getBeans();
            this.muleContext = (MuleContext)beans.get("muleContext");
        }
        return this.muleContext;
    }

    protected String getStringFromField(Expression expression, DelegateExecution execution) {
        Object value;
        if (expression != null && (value = expression.getValue((VariableScope)execution)) != null) {
            return value.toString();
        }
        return null;
    }

    public Expression getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(Expression endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public Expression getPayloadExpression() {
        return this.payloadExpression;
    }

    public void setPayloadExpression(Expression payloadExpression) {
        this.payloadExpression = payloadExpression;
    }

    public Expression getResultVariable() {
        return this.resultVariable;
    }

    public void setResultVariable(Expression resultVariable) {
        this.resultVariable = resultVariable;
    }

    public Expression getLanguage() {
        return this.language;
    }

    public void setLanguage(Expression language) {
        this.language = language;
    }

    public Expression getUsername() {
        return this.username;
    }

    public void setUsername(Expression username) {
        this.username = username;
    }

    public Expression getPassword() {
        return this.password;
    }

    public void setPassword(Expression password) {
        this.password = password;
    }
}

