/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.camel;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.activiti.camel.ActivitiEndpoint;
import org.activiti.engine.ActivitiException;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.commons.lang3.StringUtils;

public class ExchangeUtils {
    public static final String CAMELBODY = "camelBody";
    protected static final String IGNORE_MESSAGE_PROPERTY = "CamelMessageHistory";
    static Map<String, Pattern> patternsCache = new HashMap<String, Pattern>();

    private static Pattern createPattern(String propertyString, boolean asBoolean) {
        String copyVariablesFromProperties;
        Pattern pattern = null;
        if (!asBoolean && (pattern = patternsCache.get(copyVariablesFromProperties = propertyString)) == null) {
            pattern = Pattern.compile(copyVariablesFromProperties);
            patternsCache.put(copyVariablesFromProperties, pattern);
        }
        return pattern;
    }

    private static boolean isBoolean(String booleanString) {
        if (StringUtils.isEmpty((CharSequence)booleanString)) {
            return false;
        }
        String lower = booleanString.toLowerCase();
        return lower.equals("true") || lower.equals("false");
    }

    public static Map<String, Object> prepareVariables(Exchange exchange, ActivitiEndpoint activitiEndpoint) {
        String copyHeader;
        HashMap<String, Object> camelVarMap = new HashMap<String, Object>();
        String copyProperties = activitiEndpoint.getCopyVariablesFromProperties();
        if (StringUtils.isNotEmpty((CharSequence)copyProperties) && (!ExchangeUtils.isBoolean(copyProperties) || Boolean.parseBoolean(copyProperties))) {
            Pattern pattern = ExchangeUtils.createPattern(copyProperties, Boolean.parseBoolean(copyProperties));
            Map exchangeVarMap = exchange.getProperties();
            for (String s : exchangeVarMap.keySet()) {
                if (IGNORE_MESSAGE_PROPERTY.equalsIgnoreCase(s) || pattern != null && !pattern.matcher(s).matches()) continue;
                camelVarMap.put(s, exchangeVarMap.get(s));
            }
        }
        if (!(StringUtils.isEmpty((CharSequence)(copyHeader = activitiEndpoint.getCopyVariablesFromHeader())) || ExchangeUtils.isBoolean(copyHeader) && !Boolean.parseBoolean(copyHeader))) {
            Pattern pattern = ExchangeUtils.createPattern(copyHeader, Boolean.parseBoolean(copyHeader));
            boolean isSetProcessInitiator = activitiEndpoint.isSetProcessInitiator();
            for (Map.Entry header : exchange.getIn().getHeaders().entrySet()) {
                if (isSetProcessInitiator && !activitiEndpoint.getProcessInitiatorHeaderName().equals(header.getKey()) || pattern != null && !pattern.matcher((CharSequence)header.getKey()).matches()) continue;
                camelVarMap.put((String)header.getKey(), header.getValue());
            }
        }
        Object camelBody = null;
        camelBody = exchange.hasOut() ? exchange.getOut().getBody() : exchange.getIn().getBody();
        if (camelBody instanceof Map) {
            Map camelBodyMap = (Map)camelBody;
            for (Map.Entry e : camelBodyMap.entrySet()) {
                if (!(e.getKey() instanceof String)) continue;
                camelVarMap.put((String)e.getKey(), e.getValue());
            }
        } else {
            if (activitiEndpoint.isCopyCamelBodyToBodyAsString() && !(camelBody instanceof String)) {
                camelBody = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, camelBody);
            }
            if (camelBody != null) {
                camelVarMap.put(CAMELBODY, camelBody);
            }
        }
        return camelVarMap;
    }

    public static String prepareInitiator(Exchange exchange, ActivitiEndpoint activitiEndpoint) {
        String initiator = null;
        if (activitiEndpoint.isSetProcessInitiator()) {
            try {
                initiator = (String)exchange.getIn().getHeader(activitiEndpoint.getProcessInitiatorHeaderName(), String.class);
            }
            catch (TypeConversionException e) {
                throw new ActivitiException("Initiator header '" + activitiEndpoint.getProcessInitiatorHeaderName() + "': Value must be of type String.", (Throwable)e);
            }
            if (StringUtils.isEmpty((CharSequence)initiator)) {
                throw new ActivitiException("Initiator header '" + activitiEndpoint.getProcessInitiatorHeaderName() + "': Value must be provided");
            }
        }
        return initiator;
    }
}

