/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;

public class UserListQuery
extends AbstractLazyLoadingQuery {
    protected transient IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();

    @Override
    public int size() {
        return (int)this.identityService.createUserQuery().count();
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        List users = ((UserQuery)((UserQuery)((UserQuery)this.identityService.createUserQuery().orderByUserFirstName().asc()).orderByUserLastName().asc()).orderByUserId().asc()).listPage(start, count);
        ArrayList<Item> userListItems = new ArrayList<Item>();
        for (User user : users) {
            userListItems.add((Item)new UserListItem(user));
        }
        return userListItems;
    }

    @Override
    public Item loadSingleResult(String id) {
        return new UserListItem((User)this.identityService.createUserQuery().userId(id).singleResult());
    }

    @Override
    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    class UserListItem
    extends PropertysetItem
    implements Comparable<UserListItem> {
        private static final long serialVersionUID = 1L;

        public UserListItem(User user) {
            this.addItemProperty("id", (Property)new ObjectProperty((Object)user.getId(), String.class));
            this.addItemProperty("name", (Property)new ObjectProperty((Object)(user.getFirstName() + " " + user.getLastName() + " (" + user.getId() + ")"), String.class));
        }

        @Override
        public int compareTo(UserListItem other) {
            String otherName;
            String name = (String)this.getItemProperty("name").getValue();
            int comparison = name.compareTo(otherName = (String)other.getItemProperty("name").getValue());
            if (comparison != 0) {
                return comparison;
            }
            String id = (String)this.getItemProperty("id").getValue();
            String otherId = (String)other.getItemProperty("id").getValue();
            return id.compareTo(otherId);
        }
    }
}

