/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.data.LazyLoadingQuery;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.management.ManagementPage;
import org.activiti.explorer.ui.management.identity.UserDetailPanel;
import org.activiti.explorer.ui.management.identity.UserListQuery;
import org.activiti.explorer.ui.util.ThemeImageColumnGenerator;

public class UserPage
extends ManagementPage {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected Table userTable;
    protected LazyLoadingQuery userListQuery;
    protected LazyLoadingContainer userListContainer;

    public UserPage() {
        ExplorerApp.get().setCurrentUriFragment(new UriFragment("user"));
    }

    public UserPage(String userId) {
        this.userId = userId;
    }

    @Override
    protected void initUi() {
        super.initUi();
        if (this.userId == null) {
            this.selectElement(0);
        } else {
            this.selectElement(this.userListContainer.getIndexForObjectId(this.userId));
        }
    }

    @Override
    protected Table createList() {
        this.userTable = new Table();
        this.userListQuery = new UserListQuery();
        this.userListContainer = new LazyLoadingContainer(this.userListQuery, 30);
        this.userTable.setContainerDataSource((Container)this.userListContainer);
        this.userTable.addGeneratedColumn((Object)"icon", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.USER_22));
        this.userTable.setColumnWidth((Object)"icon", 22);
        this.userTable.addContainerProperty((Object)"name", String.class, null);
        this.userTable.setColumnHeaderMode(-1);
        this.userTable.addListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Item item = UserPage.this.userTable.getItem(event.getProperty().getValue());
                if (item != null) {
                    String userId = (String)item.getItemProperty((Object)"id").getValue();
                    UserPage.this.setDetailComponent((Component)new UserDetailPanel(UserPage.this, userId));
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("user", userId));
                } else {
                    UserPage.this.setDetailComponent(null);
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("user"));
                }
            }
        });
        return this.userTable;
    }

    public void notifyUserChanged(String userId) {
        this.userTable.removeAllItems();
        this.userListContainer.removeAllItems();
        this.userTable.select((Object)this.userListContainer.getIndexForObjectId(userId));
    }
}

